/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SpecificNameItemProcessor;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FrameworksRoot
extends HeadersSearchRoot {
    protected FrameworksRoot(@NotNull Project project2) {
        super(project2);
    }

    public final boolean processChildren(@NotNull PsiElementProcessor<PsiFileSystemItem> processor2) {
        return this.processFrameworks(processor2, (Set<String>)new THashSet());
    }

    public final boolean processFrameworks(@NotNull PsiElementProcessor<PsiFileSystemItem> processor2, @NotNull Set<String> processed) {
        return this.processFrameworks(processor2, processed, true);
    }

    public abstract boolean processFrameworks(@NotNull PsiElementProcessor<PsiFileSystemItem> var1, @NotNull Set<String> var2, boolean var3);

    @Nullable
    public VirtualFile resolveHeader(@NotNull String relativePath) {
        FrameworksRoot context2 = this;
        for (String pathElement : StringUtil.tokenize((String)relativePath, (String)"/\\")) {
            TargetFinder finder = new TargetFinder(pathElement);
            context2.processChildren((PsiElementProcessor)finder);
            context2 = finder.getFound();
            if (context2 != null) continue;
            break;
        }
        return context2 instanceof PsiFile ? context2.getVirtualFile() : null;
    }

    private static class TargetFinder
    extends SpecificNameItemProcessor {
        @Nullable
        private PsiFileSystemItem myFound;

        TargetFinder(@NotNull String name) {
            super(SystemInfo.isFileSystemCaseSensitive ? name : StringUtil.toLowerCase((String)name));
        }

        public boolean execute(@NotNull PsiFileSystemItem element) {
            if (this.acceptItem(element.getName(), element.isDirectory())) {
                this.myFound = element;
                return false;
            }
            return true;
        }

        @Nullable
        public PsiFileSystemItem getFound() {
            return this.myFound;
        }
    }
}

