/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.workspace.headerRoots.FrameworksSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRootFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameworkSearchRootFactory
implements HeadersSearchRootFactory {
    @Override
    @Nullable
    public HeadersSearchRoot pathToRoot(@NotNull HeadersSearchPath path, @NotNull Project project2, @NotNull VirtualFilePointer pointer) {
        if (path.isFrameworksSearchPath()) {
            OCLog.LOG.assertTrue(!path.isRecursive(), (Object)("Recursive header search paths are not supported for frameworks. Please unwrap it manually. Path = " + path.getPath()));
            return FrameworksSearchRoot.create(project2, pointer);
        }
        return null;
    }

    @Override
    @Nullable
    public HeadersSearchPath rootToPath(@NotNull HeadersSearchRoot root) {
        if (root instanceof FrameworksSearchRoot) {
            FrameworksSearchRoot f = (FrameworksSearchRoot)root;
            return HeadersSearchPath.frameworks(VfsUtilCore.urlToPath((String)f.getUrl()));
        }
        return null;
    }
}

