/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.OCLanguageStandard;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCompilerFeaturesHelper {
    @NotNull
    public static <T> T getFeatureForFile(@Nullable PsiFile file2, @Nullable OCImmutableInclusionContext fileContext, @NotNull OCCompilerFeatures.Type<T> key) {
        T result2 = OCCompilerFeaturesHelper.getFeatureForFileOrNull(file2, key, fileContext);
        return result2 == null ? key.getDefault() : result2;
    }

    private static <T> T getFeatureForFileOrNull(@Nullable PsiFile file2, @NotNull OCCompilerFeatures.Type<T> key, @Nullable OCImmutableInclusionContext context2) {
        if (file2 == null && context2 == null) {
            return null;
        }
        if (context2 != null && context2.getConfiguration() == null && file2 != null) {
            context2 = null;
        }
        if (context2 == null) {
            if (!OCLanguageUtils.isSupported(file2)) {
                return null;
            }
            context2 = OCInclusionContextUtil.headerContext(file2);
        }
        return OCCompilerFeaturesHelper.getFeatureForContext(key, context2);
    }

    public static <T> T getFeatureForContext(@NotNull OCCompilerFeatures.Type<T> key, OCImmutableInclusionContext context2) {
        return context2.getCompilerFeature(key);
    }

    public static boolean isFeatureEnabled(@Nullable PsiFile file2, @NotNull OCCompilerFeatures.Feature feature) {
        return Boolean.TRUE.equals(OCCompilerFeaturesHelper.getFeatureForFile(file2, null, feature));
    }

    public static boolean isFeatureEnabled(@Nullable OCImmutableInclusionContext context2, @NotNull OCCompilerFeatures.Feature feature) {
        return Boolean.TRUE.equals(OCCompilerFeaturesHelper.getFeatureForFile(null, context2, feature));
    }

    @NotNull
    public static OCCompilerFeatures.DiagnosticLevel getDiagnosticLevel(@Nullable PsiFile file2, @NotNull OCCompilerFeatures.Diagnostic diagnostic) {
        return OCCompilerFeaturesHelper.getFeatureForFile(file2, null, diagnostic);
    }

    public static boolean isArcDisabled(@NotNull PsiFile file2) {
        return Boolean.FALSE.equals(OCCompilerFeaturesHelper.getFeatureForFile(file2, null, OCCompilerFeatures.Feature.OBJC_ARC));
    }

    public static boolean isArcEnabled(@NotNull PsiFile file2) {
        return Boolean.TRUE.equals(OCCompilerFeaturesHelper.getFeatureForFile(file2, null, OCCompilerFeatures.Feature.OBJC_ARC));
    }

    public static boolean supportsIvarsInImplementation() {
        return true;
    }

    public static boolean supportsIvarsInCategories() {
        return true;
    }

    public static boolean supportsLaterMethodDeclaration() {
        return true;
    }

    public static boolean supportsAutosynthesis(@Nullable PsiFile file2) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(file2, OCCompilerFeatures.Feature.OBJC_DEFAULT_SYNTHESIZE_PROPERTIES);
    }

    public static boolean supportsAutosynthesis(@Nullable OCImmutableInclusionContext context2) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(context2, OCCompilerFeatures.Feature.OBJC_DEFAULT_SYNTHESIZE_PROPERTIES);
    }

    public static boolean supportsNullability(@Nullable PsiFile file2) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(file2, OCCompilerFeatures.Feature.NULLABILITY);
    }

    public static boolean supportsNullability(@Nullable OCImmutableInclusionContext context2) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(context2, OCCompilerFeatures.Feature.NULLABILITY);
    }

    public static boolean supportsGccAutoType(@Nullable PsiFile file2) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(file2, OCCompilerFeatures.Feature.GCC_AUTO_TYPE);
    }

    public static boolean supportsGccAutoType(@Nullable OCImmutableInclusionContext context2) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(context2, OCCompilerFeatures.Feature.GCC_AUTO_TYPE);
    }

    public static boolean supportsAvailableExpression(@Nullable PsiFile file2) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(file2, OCCompilerFeatures.Feature.BUILTIN_AVAILABLE);
    }

    public static boolean supportsAvailableExpression(@Nullable OCImmutableInclusionContext context2) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(context2, OCCompilerFeatures.Feature.BUILTIN_AVAILABLE);
    }

    public static boolean supportsClassProperty(@Nullable PsiFile file2) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(file2, OCCompilerFeatures.Feature.OBJC_CLASS_PROPERTY);
    }

    public static boolean supportsClassProperty(@Nullable OCImmutableInclusionContext context2) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(context2, OCCompilerFeatures.Feature.OBJC_CLASS_PROPERTY);
    }

    public static boolean supportsMsvcExtensions(@Nullable PsiFile file2) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(file2, OCCompilerFeatures.Feature.MS_EXTENSIONS);
    }

    public static boolean supportsMsvcExtensions(@Nullable OCImmutableInclusionContext context2) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(context2, OCCompilerFeatures.Feature.MS_EXTENSIONS);
    }

    public static boolean supportsExplicitAtomic(@Nullable PsiFile file2) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(file2, OCCompilerFeatures.Feature.OBJC_PROPERTY_EXPLICIT_ATOMIC);
    }

    public static boolean supportsInstancetype(@Nullable PsiFile file2) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(file2, OCCompilerFeatures.Feature.OBJC_INSTANCETYPE);
    }

    public static boolean supportsSubscripting(@Nullable PsiFile file2) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(file2, OCCompilerFeatures.Feature.OBJC_SUBSCRIPTING);
    }

    public static boolean supportsObjectLiterals(@Nullable PsiFile file2) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(file2, OCCompilerFeatures.Feature.OBJC_ARRAY_LITERALS) && OCCompilerFeaturesHelper.isFeatureEnabled(file2, OCCompilerFeatures.Feature.OBJC_DICTIONARY_LITERALS);
    }

    public static boolean supportsCxxAutoType(@Nullable PsiFile file2) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(file2, OCCompilerFeatures.Feature.CXX_AUTO_TYPE);
    }

    public static boolean supportsCxxReturnTypeDeduction(@Nullable PsiFile file2) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(file2, OCCompilerFeatures.Feature.CXX_RETURN_TYPE_DEDUCTION);
    }

    public static boolean supportsCxxAttributes(@Nullable PsiFile file2) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(file2, OCCompilerFeatures.Feature.CXX_ATTRIBUTES);
    }

    public static boolean supportsCxxMaybeUnusedAttribute(@Nullable PsiFile file2) {
        OCLanguageStandard std = OCCompilerFeaturesHelper.getFeatureForFile(file2, null, OCCompilerFeatures.LANGUAGE_STANDARD);
        return ApplicationManager.getApplication().isUnitTestMode() || std.ordinal() >= OCLanguageStandard.CPP17.ordinal();
    }

    public static boolean supportsCxxGenericLambdas(@Nullable PsiFile file2) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(file2, OCCompilerFeatures.Feature.CXX_GENERIC_LAMBDAS);
    }

    public static boolean supportsOverrideControl(@Nullable PsiFile file2) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(file2, OCCompilerFeatures.Feature.CXX_OVERRIDE_CONTROL);
    }

    public static boolean supportsInitializerLists(@Nullable PsiFile file2) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(file2, OCCompilerFeatures.Feature.CXX_GENERALIZED_INITIALIZERS);
    }

    public static boolean supportsNullptr(@Nullable PsiFile file2) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(file2, OCCompilerFeatures.Feature.CXX_NULLPTR);
    }

    public static boolean supportsInClassInitialization(@Nullable PsiFile file2) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(file2, OCCompilerFeatures.Feature.CXX_NONSTATIC_MEMBER_INIT);
    }

    public static boolean supportsConcepts(@Nullable PsiFile file2) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(file2, OCCompilerFeatures.Feature.CXX_CONCEPTS);
    }
}

