/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ObjectUtils;
import com.jetbrains.cidr.lang.OCLanguageStandard;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesProvider;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCompilerFeatures {
    public static final Type<OCLanguageStandard> LANGUAGE_STANDARD = new Type<OCLanguageStandard>(){

        public String toString() {
            return "LANGUAGE_STANDARD";
        }

        @Override
        @NotNull
        public OCLanguageStandard getDefault() {
            return OCLanguageStandard.CPP98;
        }

        @Override
        @NotNull
        public OCLanguageStandard compute(@NotNull OCCompilerFeaturesProvider provider2) {
            return provider2.getLanguageStandard();
        }
    };
    public static final short BIT_8 = 1;
    public static final short BIT_16 = 2;
    public static final short BIT_32 = 4;
    public static final short BIT_64 = 8;
    public static final short BIT_128 = 16;
    private static final Key<Map<Type, Object>> ENABLED_FEATURES = Key.create((String)"ENABLED_FEATURES");

    @Nullable
    public static <T> T getForTests(@NotNull Project project2, @NotNull Type<T> type) {
        Map features = (Map)ENABLED_FEATURES.get((UserDataHolder)project2);
        return features == null ? null : (T)features.get(type);
    }

    public static <T> void set(@NotNull Project project2, Type<T> feature, T value) {
        ConcurrentHashMap<Type<T>, T> enabledFeatures = (ConcurrentHashMap<Type<T>, T>)ENABLED_FEATURES.get((UserDataHolder)project2);
        if (enabledFeatures == null) {
            enabledFeatures = new ConcurrentHashMap<Type<T>, T>();
            project2.putUserData(ENABLED_FEATURES, enabledFeatures);
        }
        enabledFeatures.put(feature, value);
    }

    public static void resetFeatures(@NotNull Project project2) {
        project2.putUserData(ENABLED_FEATURES, null);
    }

    public static enum Diagnostic implements Type<DiagnosticLevel>
    {
        MISSING_RETURN_FROM_NON_VOID(DiagnosticLevel.WARNING),
        FOLDING_CONSTANT(DiagnosticLevel.ERROR);

        @NotNull
        private final DiagnosticLevel myDefault;

        private Diagnostic(DiagnosticLevel def) {
            this.myDefault = def;
        }

        @Override
        @NotNull
        public DiagnosticLevel getDefault() {
            return this.myDefault;
        }
    }

    public static enum DiagnosticLevel {
        DISABLED,
        WARNING,
        ERROR;


        public boolean isEnabled() {
            return this != DISABLED;
        }
    }

    public static enum TypeSize implements Type<Short>
    {
        BOOL(1),
        CHAR(1),
        CHAR8_T(1),
        CHAR16_T(2),
        CHAR32_T(4),
        WCHAR_T(4),
        SHORT(2),
        INT(4),
        LONG(4),
        SIZE_T(INT),
        PTRDIFF_T(SIZE_T),
        POINTER(SIZE_T),
        LONG_LONG(8),
        INT128_T(16),
        FLOAT(4),
        DOUBLE(8),
        LONG_DOUBLE(8);

        @Nullable
        private final TypeSize myBaseType;
        private final short myDefault;

        private TypeSize(short def) {
            this.myBaseType = null;
            this.myDefault = def;
        }

        private TypeSize(TypeSize baseType) {
            this.myBaseType = baseType;
            this.myDefault = this.myBaseType.getDefault();
        }

        @Override
        @NotNull
        public Short getDefault() {
            return this.myDefault;
        }

        @Override
        @Nullable
        public Short compute(@NotNull OCCompilerFeaturesProvider provider2) {
            if (this.myBaseType != null) {
                return provider2.getCompilerFeature(this.myBaseType);
            }
            return null;
        }
    }

    public static enum Feature implements Type<Boolean>
    {
        C_STATIC_ASSERT(OCLanguageStandard.C11),
        CXX_EXCEPTIONS(OCLanguageStandard.CPP98),
        CXX_AUTO_TYPE(OCLanguageStandard.CPP11),
        CXX_OVERRIDE_CONTROL(OCLanguageStandard.CPP11),
        CXX_GENERALIZED_INITIALIZERS(OCLanguageStandard.CPP11),
        CXX_NULLPTR(OCLanguageStandard.CPP11),
        CXX_NONSTATIC_MEMBER_INIT(OCLanguageStandard.CPP11),
        CXX_CONSTEXPR(OCLanguageStandard.CPP11),
        CXX_RAW_STRING_LITERALS(OCLanguageStandard.CPP11),
        CXX_USER_LITERALS(OCLanguageStandard.CPP11),
        CXX_ATTRIBUTES(OCLanguageStandard.CPP11),
        CXX_BINARY_LITERALS(OCLanguageStandard.CPP14),
        CXX_RETURN_TYPE_DEDUCTION(OCLanguageStandard.CPP14),
        CXX_GENERIC_LAMBDAS(OCLanguageStandard.CPP14),
        CXX_CONCEPTS(OCLanguageStandard.CPP20),
        OBJC_ARC,
        OBJC_BOOL,
        OBJC_DEFAULT_SYNTHESIZE_PROPERTIES,
        OBJC_PROPERTY_EXPLICIT_ATOMIC,
        OBJC_INSTANCETYPE,
        OBJC_SUBSCRIPTING,
        OBJC_ARRAY_LITERALS,
        OBJC_DICTIONARY_LITERALS,
        OBJC_CLASS_PROPERTY,
        UNDERLYING_TYPE,
        IS_BASE_OF,
        NULLABILITY,
        GCC_AUTO_TYPE,
        BUILTIN_AVAILABLE,
        IS_TARGET_ARCH,
        IS_TARGET_VENDOR,
        IS_TARGET_OS,
        IS_TARGET_ENVIRONMENT,
        IS_TARGET_VARIANT_OS,
        IS_TARGET_VARIANT_ENVIRONMENT,
        MS_EXTENSIONS{

            @Override
            @NotNull
            public Boolean compute(@NotNull OCCompilerFeaturesProvider provider2) {
                return provider2.areMSExtensionsEnabled();
            }
        };

        @Nullable
        private final OCLanguageStandard myAvailableInStandard;

        private Feature() {
            this((OCLanguageStandard)null);
        }

        private Feature(OCLanguageStandard availableInStandard) {
            this.myAvailableInStandard = availableInStandard;
        }

        @Override
        @NotNull
        public Boolean getDefault() {
            return this.myAvailableInStandard != null && LANGUAGE_STANDARD.getDefault().supports(this.myAvailableInStandard);
        }

        @Override
        @Nullable
        public Boolean compute(@NotNull OCCompilerFeaturesProvider provider2) {
            if (this.myAvailableInStandard != null) {
                OCLanguageStandard standard = (OCLanguageStandard)((Object)ObjectUtils.notNull((Object)((Object)provider2.getCompilerFeature(LANGUAGE_STANDARD)), (Object)((Object)LANGUAGE_STANDARD.getDefault())));
                return standard.supports(this.myAvailableInStandard);
            }
            return null;
        }

        @Nullable
        public OCLanguageStandard getAvailableInStandard() {
            return this.myAvailableInStandard;
        }
    }

    public static interface Type<T>
    extends Serializable {
        @NotNull
        public T getDefault();

        @Nullable
        default public T compute(@NotNull OCCompilerFeaturesProvider provider2) {
            return null;
        }
    }
}

