/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.cidr.lang.workspace.compiler.ClangClCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.ClangCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.GCCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.MSVCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.NVCCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCBuiltInCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKindProvider;
import com.jetbrains.cidr.lang.workspace.compiler.UnknownCompilerKind;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u0006H\u0016J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/cidr/lang/workspace/compiler/OCBuiltInCompilerKindProvider;", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerKindProvider;", "()V", "compilerByCmakeId", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerKind;", "cmakeId", "", "compilerByExecutable", "executableLocation", "getCompilerKinds", "", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCBuiltInCompilerKind;", "Companion", "intellij.cidr.projectModel"})
public final class OCBuiltInCompilerKindProvider
implements OCCompilerKindProvider {
    @NotNull
    public static final String GNU_ID = "GNU";
    @NotNull
    public static final String CLANG_ID = "Clang";
    @NotNull
    public static final String APPLE_CLANG_ID = "AppleClang";
    @NotNull
    public static final String MSVC_ID = "MSVC";
    @NotNull
    public static final String NVCC_ID = "NVIDIA";
    @NotNull
    public static final String CLANG_CL_ID = "clang-cl";
    private static final Map<String, OCCompilerKind> compilerCache;
    public static final Companion Companion;

    @NotNull
    public List<OCBuiltInCompilerKind> getCompilerKinds() {
        return CollectionsKt.listOf((Object[])new OCBuiltInCompilerKind[]{GCCCompilerKind.INSTANCE, ClangCompilerKind.INSTANCE, MSVCCompilerKind.INSTANCE, NVCCCompilerKind.INSTANCE, ClangClCompilerKind.INSTANCE, UnknownCompilerKind.INSTANCE});
    }

    @Override
    @Nullable
    public OCCompilerKind compilerByExecutable(@NotNull String executableLocation) {
        Object v0;
        block1: {
            String independent = FileUtil.toSystemIndependentName((String)executableLocation);
            String name = FileUtil.getNameWithoutExtension((String)((String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)independent, (char[])new char[]{'/'}, (boolean)false, (int)0, (int)6, null))));
            Iterable iterable = compilerCache.entrySet();
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                Map.Entry it = (Map.Entry)t;
                boolean bl3 = false;
                String string = "(.*?(\\W|\\d))?" + Regex.Companion.escape((String)it.getKey()) + "((\\W|\\d).*)?";
                RegexOption regexOption = RegexOption.IGNORE_CASE;
                boolean bl4 = false;
                if (!new Regex(string, regexOption).matches((CharSequence)name)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Map.Entry entry = v0;
        return entry != null ? (OCCompilerKind)entry.getValue() : null;
    }

    @Override
    @Nullable
    public OCCompilerKind compilerByCmakeId(@Nullable String cmakeId) {
        if (StringsKt.equals((String)GNU_ID, (String)cmakeId, (boolean)true)) {
            return GCCCompilerKind.INSTANCE;
        }
        if (StringsKt.equals((String)CLANG_ID, (String)cmakeId, (boolean)true) || StringsKt.equals((String)APPLE_CLANG_ID, (String)cmakeId, (boolean)true)) {
            return ClangCompilerKind.INSTANCE;
        }
        if (StringsKt.equals((String)MSVC_ID, (String)cmakeId, (boolean)true)) {
            return MSVCCompilerKind.INSTANCE;
        }
        if (StringsKt.equals((String)NVCC_ID, (String)cmakeId, (boolean)true)) {
            return NVCCCompilerKind.INSTANCE;
        }
        if (StringsKt.equals((String)CLANG_CL_ID, (String)cmakeId, (boolean)true)) {
            return ClangClCompilerKind.INSTANCE;
        }
        return UnknownCompilerKind.INSTANCE;
    }

    static {
        Companion = new Companion(null);
        compilerCache = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"cl", (Object)MSVCCompilerKind.INSTANCE), TuplesKt.to((Object)"gcc", (Object)GCCCompilerKind.INSTANCE), TuplesKt.to((Object)"g++", (Object)GCCCompilerKind.INSTANCE), TuplesKt.to((Object)"xgcc", (Object)GCCCompilerKind.INSTANCE), TuplesKt.to((Object)"xg++", (Object)GCCCompilerKind.INSTANCE), TuplesKt.to((Object)"colorgcc", (Object)GCCCompilerKind.INSTANCE), TuplesKt.to((Object)"cc", (Object)GCCCompilerKind.INSTANCE), TuplesKt.to((Object)"c++", (Object)GCCCompilerKind.INSTANCE), TuplesKt.to((Object)"cpp", (Object)GCCCompilerKind.INSTANCE), TuplesKt.to((Object)"clang", (Object)ClangCompilerKind.INSTANCE), TuplesKt.to((Object)"clang++", (Object)ClangCompilerKind.INSTANCE), TuplesKt.to((Object)"emcc", (Object)ClangCompilerKind.INSTANCE), TuplesKt.to((Object)"em++", (Object)ClangCompilerKind.INSTANCE), TuplesKt.to((Object)"nvcc", (Object)NVCCCompilerKind.INSTANCE), TuplesKt.to((Object)CLANG_CL_ID, (Object)ClangClCompilerKind.INSTANCE)});
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/cidr/lang/workspace/compiler/OCBuiltInCompilerKindProvider$Companion;", "", "()V", "APPLE_CLANG_ID", "", "CLANG_CL_ID", "CLANG_ID", "GNU_ID", "MSVC_ID", "NVCC_ID", "compilerCache", "", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerKind;", "intellij.cidr.projectModel"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

