/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.EscapeUtil;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.CUDALanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.compiler.ClangFeatures;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerInfo;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerSpecificSwitchBuilder;
import com.jetbrains.cidr.lang.workspace.compiler.GCCSwitchBuilder;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerBase;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import com.jetbrains.cidr.lang.workspace.compiler.TempFilesPool;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.toolchains.OSType;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GCCCompiler
extends OCCompilerBase {
    private static final String COMMAND_PREFIX = "____CIDR_command_";
    private static final Pattern COMMAND_PATTERN = Pattern.compile("^____CIDR_command_(\\w+)->([^=]+)=(.+)$");
    public static final String QUOTES = "[\u2018\u2019`'\"]";
    private static final Pattern[] BAD_SWITCH_FILTER_RULES = new Pattern[]{Pattern.compile(".*error:.*?(-+\\S+) is not supported.*"), Pattern.compile(".*error:.*?[\u2018\u2019`'\"](-.+?)[\u2018\u2019`'\"].*"), Pattern.compile(".*error:\\s(.+):\\sNo such file or directory"), Pattern.compile(".*error: [\u2018\u2019`'\"](.+?)[\u2018\u2019`'\"].* not found"), Pattern.compile(".*\\berror\\s+parsing.*(-fpch-preprocess)\\b.*", 2), Pattern.compile(".*clang-cl: error: no such file or directory: [\u2018\u2019`'\"](.+?)[\u2018\u2019`'\"].*")};
    private static final Pattern INCLUDE_FILE_PATTERN = Pattern.compile("# 1 \"(.*)\" 1\\s*[\\r\\n]");
    private static final Pattern DEPENDENCY_PATTERN = Pattern.compile(".*:(?:\\s|(?:\\\\[\\r\\n]))+((?:[\\S&&[^\\\\]]+(?:\\\\[ ]?)*)*)");
    static final String CIDR_DEFINITIONS_END = "___CIDR_DEFINITIONS_END";
    static final String CIDR_FEATURES_START = "___CIDR_FEATURES_START";
    private static final String UNSUPPORTED_COMPILER = "This compiler might be unsupported.\nIf you are using GCC/Clang, please report the bug in https://youtrack.jetbrains.com/issues/CPP.";
    private static final Map<String, OCCompilerFeatures.Feature> featureFlags = new LinkedHashMap<String, OCCompilerFeatures.Feature>();
    private static final Set<String> skipSwitches;
    private static final Set<String> skipEnvironment;

    public GCCCompiler(@NotNull File executable, @NotNull File workingDirectory, @NotNull CidrToolEnvironment env, @NotNull TempFilesPool tempFilesPool) {
        super(executable, workingDirectory, env, tempFilesPool);
    }

    @Nullable
    public String readVersion(@NotNull Pattern versionPattern) {
        return this.doReadVersion(Collections.singletonList("--version"), (Function<ProcessOutput, String>)((Function)output -> {
            List lines = output.getStdoutLines();
            for (String line : lines) {
                Matcher matcher;
                if (StringUtil.isEmptyOrSpaces((String)line) || !(matcher = versionPattern.matcher(line)).matches()) continue;
                return line;
            }
            return null;
        }));
    }

    @NotNull
    public static String getLanguageOption(@NotNull OCLanguageKind kind) {
        if (kind instanceof CLanguageKind) {
            switch ((CLanguageKind)kind) {
                case C: {
                    return "-xc";
                }
                case OBJ_C: {
                    return "-xobjective-c";
                }
                case CPP: {
                    return "-xc++";
                }
                case OBJ_CPP: {
                    return "-xobjective-c++";
                }
            }
        }
        return "";
    }

    @Nullable
    public static OCLanguageKind resolveLanguage(@NotNull List<String> switches) {
        for (int i2 = 0; i2 < switches.size(); ++i2) {
            String currentSwitch = switches.get(i2);
            if (!currentSwitch.startsWith("-x")) continue;
            OCLanguageKind kind = GCCCompiler.resolveOptionLanguage(currentSwitch = currentSwitch.substring(2));
            if (kind != null) {
                return kind;
            }
            if (StringUtil.isEmptyOrSpaces((String)currentSwitch) && i2 < switches.size() - 1) {
                kind = GCCCompiler.resolveOptionLanguage(switches.get(i2 + 1));
            }
            return kind;
        }
        return null;
    }

    @Nullable
    public static OCLanguageKind resolveOptionLanguage(@NotNull String option) {
        String langName = option.trim();
        if ("objective-c".equals(langName)) {
            return CLanguageKind.OBJ_C;
        }
        if ("objective-c++".equals(langName)) {
            return CLanguageKind.OBJ_CPP;
        }
        if ("c".equals(langName)) {
            return CLanguageKind.C;
        }
        if ("c++".equals(langName)) {
            return CLanguageKind.CPP;
        }
        if ("cu".equals(langName)) {
            return CUDALanguageKind.CUDA;
        }
        if ("cuda".equals(langName)) {
            return CUDALanguageKind.CUDA;
        }
        return null;
    }

    @NotNull
    protected CompilerSpecificSwitchBuilder getSwitchBuilder() {
        return new GCCSwitchBuilder();
    }

    @NotNull
    private static List<String> extractNonBuiltinSearchPaths(@NotNull @NotNull List<@NotNull String> rawSwitches, @NotNull CidrToolEnvironment environment, @NotNull File workingDirectory) {
        ArrayList<String> searchPaths = new ArrayList<String>();
        boolean includeIsNext = false;
        for (String element : rawSwitches) {
            if (includeIsNext) {
                element = environment.getHostMachine().toCanonicalPath(environment.toLocalPath(workingDirectory, element), true);
                searchPaths.add(element);
                includeIsNext = false;
                continue;
            }
            if (element.equals("-I")) {
                includeIsNext = true;
                continue;
            }
            if (!element.startsWith("-I")) continue;
            element = environment.getHostMachine().toCanonicalPath(environment.toLocalPath(workingDirectory, element.substring(2)), true);
            searchPaths.add(element);
        }
        return searchPaths;
    }

    @Override
    @NotNull
    public CompilerInfo collectInfo(@NotNull OCLanguageKind languageKind, @NotNull CidrCompilerSwitches switches) throws ExecutionException {
        ArrayList<String> warnLog = new ArrayList<String>();
        try {
            switches = switches.expandResponseFiles(this.myWorkingDirectory, this.myEnvironment, CidrCompilerSwitches.Format.GCC_RESPONSE_FILE);
        }
        catch (IOException e) {
            throw new ExecutionException("Cannot expand response files in " + switches.getCommandLineString(CidrCompilerSwitches.Format.RAW), (Throwable)e);
        }
        List<String> nonBuiltinSearchPaths = GCCCompiler.extractNonBuiltinSearchPaths(switches.getList(CidrCompilerSwitches.Format.RAW), this.myEnvironment, this.myWorkingDirectory);
        CompilerSpecificSwitchBuilder switchBuilder = this.getSwitchBuilder().withLanguageKind(languageKind).withSwitches(switches);
        if (Registry.is((String)"cidr.compiler.gcc.fpch.preprocess", (boolean)true)) {
            switchBuilder.withWritePchPreprocess();
        }
        switchBuilder.withSwitch("-v").withWritePreprocessorDefines().withSwitch("-E").withMacro(CIDR_DEFINITIONS_END);
        CidrCompilerSwitches requestSwitches = switchBuilder.build();
        ProcessOutput output = this.runGCC(this.myEnvironment, requestSwitches, GCCCompiler.buildFeaturesCheckText(), warnLog);
        OutputSections sections = GCCCompiler.splitOutput(output.getStdout(), warnLog);
        Pair<String, Map<OCCompilerFeatures.Type<?>, Object>> definesAndFeatures = GCCCompiler.collectDefinitionsAndFeatures(sections, warnLog);
        String defines = (String)definesAndFeatures.first;
        Map features = (Map)definesAndFeatures.second;
        boolean isClang = GCCCompiler.isClang(defines);
        GCCCompiler.collectDiagnostics(switches, isClang, features);
        GCCCompiler.collectFeatureFlags(switches, features);
        boolean shouldEnableFrameworksWorkaround = this.myEnvironment.getHostMachine().getOSType() == OSType.MAC && !isClang;
        List<HeadersSearchPath> headersSearchPaths = GCCCompiler.collectHeaderSearchPaths(output, shouldEnableFrameworksWorkaround, this.myEnvironment, this.myWorkingDirectory, true, nonBuiltinSearchPaths);
        List<File> precompiledHeaders = this.getPrecompiledHeaders(switches, this.myEnvironment, sections.preprocessed, warnLog);
        GCCCompiler.addEmulatedWarning(warnLog);
        return new CompilerInfo(switches, defines, features, headersSearchPaths, precompiledHeaders, Collections.emptyList(), warnLog, output.getExitCode());
    }

    @NotNull
    static OutputSections splitOutput(String output, List<String> warnLog) {
        String defines;
        String preprocessed = "";
        String featureChecks = "";
        int definesEnd = output.indexOf(CIDR_DEFINITIONS_END);
        int featuresStart = output.indexOf(CIDR_FEATURES_START);
        Function lineStart = index -> {
            while (index > 0 && !StringUtil.isLineBreak((char)output.charAt(index - 1))) {
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index - 1);
            }
            return index;
        };
        if (definesEnd >= 0 && featuresStart >= 0) {
            defines = output.substring(0, (Integer)lineStart.fun((Object)definesEnd));
            preprocessed = output.substring(definesEnd + CIDR_DEFINITIONS_END.length() + 1, (Integer)lineStart.fun((Object)featuresStart));
            featureChecks = output.substring(featuresStart + CIDR_FEATURES_START.length() + 1);
        } else {
            warnLog.add("Unexpected compiler output. This compiler might be unsupported.\nIf you are using GCC/Clang, please report the bug in https://youtrack.jetbrains.com/issues/CPP.");
            LOG.warn("Unexpected compiler output: CIDR_DEFINITIONS_END=" + definesEnd + " CIDR_FEATURES_START=" + featuresStart);
            defines = output;
        }
        return new OutputSections(defines, preprocessed, featureChecks);
    }

    private static boolean isClang(CharSequence defines) {
        return StringUtil.contains((CharSequence)defines, (CharSequence)"__clang_version__");
    }

    @NotNull
    private List<File> getPrecompiledHeaders(@NotNull CidrCompilerSwitches switches, @NotNull CidrToolEnvironment environment, @NotNull String preprocessed, @NotNull List<String> warnLog) {
        LinkedHashSet<File> result2 = new LinkedHashSet<File>(1);
        List<String> args = switches.getList(CidrCompilerSwitches.Format.RAW);
        boolean isFirst = true;
        for (int i2 = 0; i2 < args.size(); ++i2) {
            String pathPCH;
            String arg = this.adjustArgument(args.get(i2));
            if (!arg.startsWith("-include")) continue;
            if (arg.equals("-include")) {
                if (++i2 >= args.size()) break;
                pathPCH = this.preparePath(environment, this.adjustArgument(args.get(i2)));
            } else {
                pathPCH = this.preparePath(environment, this.adjustArgument(arg.substring("-include".length())));
            }
            File pch = new File(pathPCH);
            if (!pch.exists() || pch.isDirectory()) {
                File file2 = pch = isFirst ? this.extractOriginalPrecompiledHeaderFile(preprocessed, environment, pch, warnLog) : null;
            }
            if (pch != null) {
                result2.add(pch);
            }
            isFirst = false;
        }
        return new SmartList(result2);
    }

    @Nullable
    private File extractOriginalPrecompiledHeaderFile(@NotNull String preprocessed, @NotNull CidrToolEnvironment env, @NotNull File pch, @NotNull List<String> warnLog) {
        Matcher matcher;
        boolean isGCC = preprocessed.contains("#pragma GCC pch_preprocess");
        if (!isGCC && (matcher = GCCCompiler.matchSafely(INCLUDE_FILE_PATTERN, preprocessed)).find()) {
            String unescaped = EscapeUtil.unescapeAnsiStringCharacters(matcher.group(1));
            String path = this.preparePath(env, unescaped);
            return new File(path);
        }
        File dependencyFile = null;
        if (!pch.isDirectory()) {
            dependencyFile = new File(pch.getAbsolutePath() + ".d");
        } else {
            File[] files = pch.listFiles();
            if (files != null) {
                for (File file2 : files) {
                    if (!file2.getName().endsWith(".d")) continue;
                    dependencyFile = file2;
                    break;
                }
            }
        }
        if (dependencyFile != null && dependencyFile.exists()) {
            try {
                String data = FileUtil.loadFile((File)dependencyFile);
                Matcher dependency = GCCCompiler.matchSafely(DEPENDENCY_PATTERN, data);
                if (dependency.find()) {
                    String path = dependency.group(1).replaceAll("\\\\[ ]", " ");
                    File result2 = new File(this.preparePath(env, path));
                    return result2.exists() ? result2 : null;
                }
            }
            catch (IOException e) {
                String warn = "Dependency file (which is used to get the original file name of a precompiled header)\nis corrupted or has invalid permissions: " + dependencyFile + "\nplease run PCH compilation with -MD (or -MMD) flag.";
                warnLog.add(warn);
                return null;
            }
        }
        if (isGCC) {
            String warn = "Cannot get the original file name of the precompiled header: " + pch + "\nplease run PCH compilation with -MD (or -MMD) flag.";
            warnLog.add(warn);
        }
        return null;
    }

    static List<HeadersSearchPath> collectHeaderSearchPaths(@NotNull ProcessOutput output, boolean enableFrameworksWorkaround, @NotNull CidrToolEnvironment environment, @NotNull File workingDirectory) {
        return GCCCompiler.collectHeaderSearchPaths(output, enableFrameworksWorkaround, environment, workingDirectory, false, Collections.emptyList());
    }

    static List<HeadersSearchPath> collectHeaderSearchPaths(@NotNull ProcessOutput output, boolean enableFrameworksWorkaround, @NotNull CidrToolEnvironment environment, @NotNull File workingDirectory, boolean hasBuiltInSearchPaths, @NotNull @NotNull List<@NotNull String> nonBuiltinSearchPaths) {
        ArrayList<HeadersSearchPath> headersSearchPaths = new ArrayList<HeadersSearchPath>();
        ArrayList<HeadersSearchPath> additionalFrameworks = enableFrameworksWorkaround ? new ArrayList<HeadersSearchPath>() : null;
        HeadersSearchPath.Kind kind = null;
        for (String each : output.getStderrLines()) {
            String file2;
            if ("#include \"...\" search starts here:".equals(each = each.trim())) {
                kind = HeadersSearchPath.Kind.USER;
                continue;
            }
            if ("#include <...> search starts here:".equals(each)) {
                kind = HeadersSearchPath.Kind.SYSTEM;
                continue;
            }
            if ("End of search list.".equals(each)) break;
            if (kind == null) continue;
            String trimmed = StringUtil.trimEnd((String)each, (String)" (framework directory)");
            boolean isFramework = false;
            if (!each.equals(trimmed)) {
                each = trimmed;
                isFramework = true;
                enableFrameworksWorkaround = false;
            } else {
                each = StringUtil.trimEnd((String)each, (String)" (headermap)");
            }
            if ((file2 = environment.toLocalPath(workingDirectory, each = StringUtil.nullize((String)each.trim(), (boolean)true))) == null) continue;
            String canonicalPath = environment.getHostMachine().toCanonicalPath(file2, true);
            try {
                canonicalPath = FileUtil.resolveShortWindowsName((String)canonicalPath);
            }
            catch (IOException ignored) {
                continue;
            }
            boolean isBuiltIn = hasBuiltInSearchPaths && kind.isSystem() && !isFramework && !nonBuiltinSearchPaths.contains(canonicalPath);
            headersSearchPaths.add(new HeadersSearchPath(canonicalPath, false, kind, isFramework, isBuiltIn));
            if (!enableFrameworksWorkaround) continue;
            additionalFrameworks.add(new HeadersSearchPath(canonicalPath, false, kind, true));
        }
        if (enableFrameworksWorkaround && additionalFrameworks != null) {
            headersSearchPaths.addAll(additionalFrameworks);
        }
        return headersSearchPaths;
    }

    @NotNull
    static Pair<String, Map<OCCompilerFeatures.Type<?>, Object>> collectDefinitionsAndFeatures(@NotNull OutputSections output, List<String> warnLog) {
        StringBuilder defines = new StringBuilder();
        LinkedHashMap<Enum, Comparable<Short>> cidrFeatures = new LinkedHashMap<Enum, Comparable<Short>>();
        for (String eachLine : StringUtil.splitByLines((String)output.defines)) {
            if ((eachLine = eachLine.trim()).isEmpty() || !eachLine.startsWith("#define ")) continue;
            defines.append(eachLine).append("\n");
        }
        boolean isClang = GCCCompiler.isClang(defines);
        if (isClang) {
            defines.append(GCCCompiler.getClangTestMacros());
        }
        for (String eachLine : StringUtil.splitByLines((String)output.featureChecks)) {
            Command command;
            Matcher matcher = GCCCompiler.matchSafely(COMMAND_PATTERN, eachLine);
            if (!matcher.find()) continue;
            try {
                command = Command.valueOf(matcher.group(1));
            }
            catch (IllegalArgumentException e) {
                LOG.error("Unexpected command: " + matcher.group(1));
                continue;
            }
            String key = matcher.group(2);
            String value = matcher.group(3);
            try {
                switch (command) {
                    case SET_TYPE_SIZE: {
                        try {
                            cidrFeatures.put(OCCompilerFeatures.TypeSize.valueOf(key), Short.valueOf(Short.parseShort(value)));
                        }
                        catch (NumberFormatException e) {
                            warnLog.add("Cannot determine type size for " + key + ":" + value + "\n" + UNSUPPORTED_COMPILER);
                        }
                        break;
                    }
                    case SET_FEATURE: {
                        cidrFeatures.put(OCCompilerFeatures.Feature.valueOf(key), Boolean.valueOf(value.equals("1")));
                        break;
                    }
                    case ADD_DEFINITION: {
                        defines.append("#define ").append(key).append(" ").append(value).append("\n");
                    }
                }
            }
            catch (IllegalArgumentException e) {
                warnLog.add("Invalid query: \"" + eachLine + "\"");
            }
        }
        defines.append("#define __extension__\n");
        defines.append(GCCCompiler.getGCCBuiltInFunctionMacros());
        return new Pair((Object)defines.toString(), cidrFeatures);
    }

    private static String buildFeaturesCheckText() {
        StringBuilder result2 = new StringBuilder("#define ___CIDR_FEATURES_START\n");
        class QueryBuilder {
            final /* synthetic */ StringBuilder val$result;

            QueryBuilder(StringBuilder stringBuilder) {
                this.val$result = stringBuilder;
            }

            void appendTypeSizeQuery(@NotNull String macro, @NotNull OCCompilerFeatures.TypeSize type) {
                this.val$result.append("#if defined(").append(macro).append(")\n");
                this.appendCommand(Command.SET_TYPE_SIZE, type.name(), macro);
                this.val$result.append("#endif\n");
            }

            void appendBuiltinQuery(@NotNull String condition, @NotNull String emulationMacroName, boolean supported) {
                if (supported) {
                    this.val$result.append("#if ").append(condition).append("\n");
                    this.appendEmulationMacroCommand(emulationMacroName, "1");
                    this.val$result.append("#else\n");
                }
                this.appendEmulationMacroCommand(emulationMacroName, "0");
                if (supported) {
                    this.val$result.append("#endif\n");
                }
            }

            void appendSetFeatureCommand(@NotNull String condition, @NotNull OCCompilerFeatures.Feature cidrFeature) {
                this.val$result.append("#if ").append(condition).append("\n");
                this.appendCommand(Command.SET_FEATURE, cidrFeature.name(), "1");
                if (cidrFeature == OCCompilerFeatures.Feature.OBJC_BOOL) {
                    this.appendCommand(Command.ADD_DEFINITION, "__objc_no", "((BOOL)0)");
                    this.appendCommand(Command.ADD_DEFINITION, "__objc_yes", "((BOOL)1)");
                }
                this.val$result.append("#else\n");
                this.appendCommand(Command.SET_FEATURE, cidrFeature.name(), "0");
                this.val$result.append("#endif\n");
            }

            private void appendCommand(Command type, String key, String value) {
                this.val$result.append(GCCCompiler.COMMAND_PREFIX).append((Object)type).append("->").append(key).append("=").append(value).append("\n");
            }

            private void appendEmulationMacroCommand(@Nullable String emulationMacroName, String value) {
                if (emulationMacroName != null) {
                    this.appendCommand(Command.ADD_DEFINITION, emulationMacroName, value);
                }
            }
        }
        QueryBuilder queryBuilder = new QueryBuilder(result2);
        result2.append("#if __clang__\n");
        result2.append("#if !(defined (__has_extension)) && defined(__has_feature)\n  #define __has_extension __has_feature\n#endif\n#if !defined(__has_attribute)\n  #define __has_attribute(x) 0\n#endif\n#if !defined(__has_builtin)\n  #define __has_builtin(x) 0\n#endif\n#if !defined(__is_identifier)\n  #define __is_identifier(x) 1\n#endif\n#if !__has_builtin(__is_target_arch)\n  #define __is_target_arch(x) 0\n#endif\n#if !__has_builtin(__is_target_vendor)\n  #define __is_target_vendor(x) 0\n#endif\n#if !__has_builtin(__is_target_os)\n  #define __is_target_os(x) 0\n#endif\n#if !__has_builtin(__is_target_variant_os)\n  #define __is_target_variant_os(x) 0\n#endif\n#if !__has_builtin(__is_target_environment)\n  #define __is_target_environment(x) 0\n#endif\n#if !__has_builtin(__is_target_variant_environment)\n  #define __is_target_variant_environment(x) 0\n#endif\n");
        ClangFeatures.getAllFeatures().forEach(each -> {
            boolean supported = !ClangFeatures.getUnsupportedClangFeatures().contains(each);
            String featureCondition = "__has_feature(" + each + ")";
            String extensionCondition = "__has_extension(" + each + ")";
            queryBuilder.appendBuiltinQuery(featureCondition, GCCCompiler.clangFeatureMacro(each), supported);
            queryBuilder.appendBuiltinQuery(extensionCondition, GCCCompiler.clangExtensionMacro(each), supported);
            OCCompilerFeatures.Feature cidrFeature = ClangFeatures.getFeatureForClangId(each);
            if (cidrFeature != null) {
                queryBuilder.appendSetFeatureCommand(featureCondition + " || " + extensionCondition, cidrFeature);
            }
        });
        ClangFeatures.getAllBuiltins().forEach(each -> {
            String condition = "__has_builtin(" + each + ")";
            queryBuilder.appendBuiltinQuery(condition, GCCCompiler.clangBuiltinMacro(each), true);
            OCCompilerFeatures.Feature cidrFeature = ClangFeatures.getFeatureForClangId(each);
            if (cidrFeature != null) {
                queryBuilder.appendSetFeatureCommand(condition, cidrFeature);
            }
        });
        ClangFeatures.getAllAttributes().forEach(each -> queryBuilder.appendBuiltinQuery("__has_attribute(" + each + ")", GCCCompiler.clangAttributeMacro(each), true));
        ClangFeatures.getAllTargetArchs().forEach(arch -> queryBuilder.appendBuiltinQuery("__is_target_arch(" + arch + ")", GCCCompiler.clangTargetArchMacro(arch), true));
        ClangFeatures.getAllTargetVendors().forEach(vendor -> queryBuilder.appendBuiltinQuery("__is_target_vendor(" + vendor + ")", GCCCompiler.clangTargetVendorMacro(vendor), true));
        ClangFeatures.getAllTargetOss().forEach(os -> {
            queryBuilder.appendBuiltinQuery("__is_target_os(" + os + ")", GCCCompiler.clangTargetOsMacro(os), true);
            queryBuilder.appendBuiltinQuery("__is_target_variant_os(" + os + ")", GCCCompiler.clangTargetVariantOsMacro(os), true);
        });
        ClangFeatures.getAllTargetEnvironemts().forEach(environment -> {
            queryBuilder.appendBuiltinQuery("__is_target_environment(" + environment + ")", GCCCompiler.clangTargetEnvironmentMacro(environment), true);
            queryBuilder.appendBuiltinQuery("__is_target_variant_environment(" + environment + ")", GCCCompiler.clangTargetVariantEnvironmentMacro(environment), true);
        });
        queryBuilder.appendSetFeatureCommand("!__is_identifier(__auto_type)", OCCompilerFeatures.Feature.GCC_AUTO_TYPE);
        result2.append("#else\n");
        result2.append("#define __CIDR_GCC_VERSION (__GNUC__ * 10000 + __GNUC_MINOR__ * 100 + __GNUC_PATCHLEVEL__)\n");
        LinkedHashMap<OCCompilerFeatures.Feature, String> checks = new LinkedHashMap<OCCompilerFeatures.Feature, String>();
        checks.put(OCCompilerFeatures.Feature.GCC_AUTO_TYPE, "!defined(__cplusplus) && __CIDR_GCC_VERSION >= 40900");
        checks.put(OCCompilerFeatures.Feature.C_STATIC_ASSERT, "!defined(__cplusplus) && __STDC_VERSION__ >= 201112L && __CIDR_GCC_VERSION >= 40600");
        checks.put(OCCompilerFeatures.Feature.CXX_AUTO_TYPE, "__cplusplus >= 201103 && __CIDR_GCC_VERSION >= 40400");
        checks.put(OCCompilerFeatures.Feature.CXX_OVERRIDE_CONTROL, "__cplusplus >= 201103 && __CIDR_GCC_VERSION >= 40700");
        checks.put(OCCompilerFeatures.Feature.CXX_GENERALIZED_INITIALIZERS, "__cplusplus >= 201103 && __CIDR_GCC_VERSION >= 40400");
        checks.put(OCCompilerFeatures.Feature.CXX_NULLPTR, "__cplusplus >= 201103 && __CIDR_GCC_VERSION >= 40600");
        checks.put(OCCompilerFeatures.Feature.CXX_NONSTATIC_MEMBER_INIT, "__cplusplus >= 201103 && __CIDR_GCC_VERSION >= 40700");
        checks.put(OCCompilerFeatures.Feature.CXX_EXCEPTIONS, "defined(__cplusplus) && __EXCEPTIONS");
        checks.put(OCCompilerFeatures.Feature.CXX_CONSTEXPR, "__cplusplus >= 201103 && __CIDR_GCC_VERSION >= 40600");
        checks.put(OCCompilerFeatures.Feature.CXX_RAW_STRING_LITERALS, "__cplusplus >= 201103 && __CIDR_GCC_VERSION >= 40500");
        checks.put(OCCompilerFeatures.Feature.CXX_USER_LITERALS, "__cplusplus >= 201103 && __CIDR_GCC_VERSION >= 40700");
        checks.put(OCCompilerFeatures.Feature.CXX_ATTRIBUTES, "__cplusplus >= 201103 && __CIDR_GCC_VERSION >= 40700");
        checks.put(OCCompilerFeatures.Feature.CXX_BINARY_LITERALS, "__cplusplus >= 201402 && __CIDR_GCC_VERSION >= 40900");
        checks.put(OCCompilerFeatures.Feature.CXX_RETURN_TYPE_DEDUCTION, "__cplusplus >= 201402 && __CIDR_GCC_VERSION >= 40900");
        checks.put(OCCompilerFeatures.Feature.CXX_GENERIC_LAMBDAS, "__cplusplus >= 201402 && __CIDR_GCC_VERSION >= 40900");
        checks.forEach((feature, check) -> queryBuilder.appendSetFeatureCommand((String)check, (OCCompilerFeatures.Feature)feature));
        result2.append("#endif\n");
        GCCCompiler.getTypeSizesMacros().forEach((type, macro) -> queryBuilder.appendTypeSizeQuery((String)macro, (OCCompilerFeatures.TypeSize)type));
        return result2.toString();
    }

    @NotNull
    public static LinkedHashMap<OCCompilerFeatures.TypeSize, String> getTypeSizesMacros() {
        LinkedHashMap<OCCompilerFeatures.TypeSize, String> sizes = new LinkedHashMap<OCCompilerFeatures.TypeSize, String>();
        sizes.put(OCCompilerFeatures.TypeSize.WCHAR_T, "__SIZEOF_WCHAR_T__");
        sizes.put(OCCompilerFeatures.TypeSize.SHORT, "__SIZEOF_SHORT__");
        sizes.put(OCCompilerFeatures.TypeSize.INT, "__SIZEOF_INT__");
        sizes.put(OCCompilerFeatures.TypeSize.LONG, "__SIZEOF_LONG__");
        sizes.put(OCCompilerFeatures.TypeSize.POINTER, "__SIZEOF_POINTER__");
        sizes.put(OCCompilerFeatures.TypeSize.LONG_LONG, "__SIZEOF_LONG_LONG__");
        sizes.put(OCCompilerFeatures.TypeSize.INT128_T, "__SIZEOF_INT128__");
        sizes.put(OCCompilerFeatures.TypeSize.FLOAT, "__SIZEOF_FLOAT__");
        sizes.put(OCCompilerFeatures.TypeSize.DOUBLE, "__SIZEOF_DOUBLE__");
        sizes.put(OCCompilerFeatures.TypeSize.LONG_DOUBLE, "__SIZEOF_LONG_DOUBLE__");
        sizes.put(OCCompilerFeatures.TypeSize.SIZE_T, "__SIZEOF_SIZE_T__");
        sizes.put(OCCompilerFeatures.TypeSize.PTRDIFF_T, "__SIZEOF_PTRDIFF_T__");
        return sizes;
    }

    private static void collectDiagnostics(@NotNull CidrCompilerSwitches switches, boolean isClang, final Map<OCCompilerFeatures.Type<?>, Object> result2) {
        THashSet set = new THashSet(switches.getList(CidrCompilerSwitches.Format.RAW));
        if (set.contains("-w")) {
            return;
        }
        boolean everythingEnabled = set.contains("-Weverything");
        boolean allWarningsEnabled = everythingEnabled || set.contains("-Wall");
        boolean pedanticAsErrors = set.contains("-pedantic-errors");
        boolean pedanticEnabled = everythingEnabled || pedanticAsErrors || set.contains("-pedantic") || set.contains("-Wpedantic");
        boolean warningsAsErrors = set.contains("-Werror");
        class Checker {
            final /* synthetic */ Set val$set;

            Checker() {
                this.val$set = set;
            }

            void add(OCCompilerFeatures.Diagnostic diagnostic, boolean globallyEnabled, boolean globallyEnabledAsError, String id) {
                OCCompilerFeatures.DiagnosticLevel level = this.getLevel(globallyEnabled, globallyEnabledAsError, id);
                result2.put(diagnostic, level != null ? level : OCCompilerFeatures.DiagnosticLevel.DISABLED);
            }

            @Nullable
            private OCCompilerFeatures.DiagnosticLevel getLevel(boolean globallyEnabled, boolean globallyEnabledAsError, String id) {
                if (globallyEnabled && globallyEnabledAsError || this.val$set.contains("-Werror=" + id)) {
                    return OCCompilerFeatures.DiagnosticLevel.ERROR;
                }
                if (globallyEnabled || this.val$set.contains("-W" + id)) {
                    return OCCompilerFeatures.DiagnosticLevel.WARNING;
                }
                return null;
            }
        }
        Checker checker = new Checker();
        checker.add(OCCompilerFeatures.Diagnostic.MISSING_RETURN_FROM_NON_VOID, isClang || allWarningsEnabled, warningsAsErrors, "return-type");
        if (isClang) {
            checker.add(OCCompilerFeatures.Diagnostic.FOLDING_CONSTANT, pedanticEnabled, pedanticAsErrors, "gnu-folding-constant");
        }
    }

    private static void collectFeatureFlags(@NotNull CidrCompilerSwitches switches, Map<OCCompilerFeatures.Type<?>, Object> result2) {
        THashSet set = new THashSet(switches.getList(CidrCompilerSwitches.Format.RAW));
        featureFlags.forEach((arg_0, arg_1) -> GCCCompiler.lambda$collectFeatureFlags$11((Set)set, result2, arg_0, arg_1));
    }

    @NotNull
    ProcessOutput runGCC(@NotNull CidrToolEnvironment environment, @NotNull CidrCompilerSwitches options2, @NotNull String fileText, @NotNull List<String> warnLog) throws ExecutionException {
        Set skipOptions = ContainerUtil.set((Object[])new String[]{"-fdiagnostics-format", "-imacros", "-"});
        return this.tryRunGCC(environment, options2, skipOptions, 0, 0, false, fileText, warnLog);
    }

    protected String getCommandLineString(CidrCompilerSwitches options2) {
        return options2.getCommandLineString(CidrCompilerSwitches.Format.GCC_RESPONSE_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private ProcessOutput tryRunGCC(@NotNull CidrToolEnvironment environment, @NotNull CidrCompilerSwitches options2, @NotNull Set<String> skipOptions, int optionsRetriesNumber, int timeoutsNumber, boolean skipResponseFile, @NotNull String fileText, @NotNull List<String> warnLog) throws ExecutionException {
        ProcessOutput output;
        String clCommandLineString;
        String responseFileText;
        CidrCompilerSwitches filteredOptions = this.filterOptions(options2, skipOptions);
        Path responseFile = null;
        String responseFileArg = null;
        Path bodyFile = null;
        String gccPath = this.myExecutable.getPath();
        HostMachine host = environment.getHostMachine();
        Path tmpDir = host.getTempDirectory();
        try {
            try {
                responseFileText = this.getCommandLineString(filteredOptions);
                if (!skipResponseFile) {
                    responseFile = this.myTempFilesPool.writeToTempFile(host, responseFileText, tmpDir, "response-file", ".txt");
                    responseFileArg = "@" + environment.toEnvPath(responseFile.toAbsolutePath().toString());
                }
                bodyFile = this.myTempFilesPool.writeToTempFile(host, fileText, tmpDir, "compiler-file", "");
            }
            catch (IOException e) {
                throw new ExecutionException("Unable to create temporary file", (Throwable)e);
            }
            GeneralCommandLine cl = new GeneralCommandLine();
            environment.prepare(cl, CidrToolEnvironment.PrepareFor.BUILD);
            cl.setExePath(gccPath);
            cl.withWorkDirectory(this.myWorkingDirectory);
            Map clEnvironment = cl.getEnvironment();
            clEnvironment.put("LC_ALL", "C");
            for (String skipVariables : skipEnvironment) {
                clEnvironment.remove(skipVariables);
            }
            if (!skipResponseFile) {
                cl.addParameters(new String[]{responseFileArg});
            } else {
                cl.addParameters(filteredOptions.getList(CidrCompilerSwitches.Format.RAW));
            }
            cl.addParameters(new String[]{environment.toEnvPath(bodyFile.toAbsolutePath().toString())});
            clCommandLineString = cl.getCommandLineString();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Running compiler: " + clCommandLineString + "\nArguments file contents: " + filteredOptions);
            }
            output = outCompilerRunner.run(cl, environment);
            if (bodyFile != null) {
                this.myTempFilesPool.delete(bodyFile);
            }
            if (responseFile != null) {
                this.myTempFilesPool.delete(responseFile);
            }
        }
        catch (Throwable throwable) {
            if (bodyFile != null) {
                this.myTempFilesPool.delete(bodyFile);
            }
            if (responseFile != null) {
                this.myTempFilesPool.delete(responseFile);
            }
            throw throwable;
        }
        String userFriendlyCommandLine = gccPath + " " + responseFileText.replaceFirst(Matcher.quoteReplacement(" -D___CIDR_DEFINITIONS_END"), "");
        if (output.isTimeout()) {
            if (timeoutsNumber < 1) {
                LOG.debug("Trying to run compiler after timeout");
                return this.tryRunGCC(environment, options2, skipOptions, optionsRetriesNumber, timeoutsNumber + 1, skipResponseFile, fileText, warnLog);
            }
            throw GCCCompiler.throwCompilerTimeout(userFriendlyCommandLine);
        }
        if (output.getExitCode() != 0) {
            if (!skipResponseFile && output.getStderr().contains(responseFileArg)) {
                LOG.debug("Trying to run compiler without a @response file");
                return this.tryRunGCC(environment, options2, skipOptions, optionsRetriesNumber, timeoutsNumber, true, fileText, warnLog);
            }
            if (optionsRetriesNumber < 2 && GCCCompiler.collectSkipOptionsGcc(output.getStderrLines(), skipOptions, warnLog)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Trying to run compiler with skipped options: " + StringUtil.join(skipOptions, (String)" "));
                }
                return this.tryRunGCC(environment, options2, skipOptions, optionsRetriesNumber + 1, timeoutsNumber, skipResponseFile, fileText, warnLog);
            }
            if (!GCCCompiler.allowResultsWithError(output)) {
                throw GCCCompiler.throwCompilerError(output, userFriendlyCommandLine);
            }
        }
        if (LOG.isDebugEnabled()) {
            String dbg = "Compiler finished `" + clCommandLineString + "` with " + output.getExitCode();
            if (LOG.isTraceEnabled()) {
                dbg = dbg + ":\n>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\nStdout:\n " + output.getStdout() + "\nStderr:\n " + output.getStderr() + "\n<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n";
            }
            LOG.debug(dbg);
        }
        return output;
    }

    private static boolean allowResultsWithError(@NotNull ProcessOutput output) {
        return PlatformUtils.isAppCode() && output.getExitCode() == 1;
    }

    @Override
    @NotNull
    public CidrCompilerSwitches filterOptions(@NotNull CidrCompilerSwitches switches, final @NotNull Set<String> skipOptions) {
        BiFunction<String, String, Boolean> argumentsFilter2 = new BiFunction<String, String, Boolean>(){
            boolean archAdded = false;
            boolean skipOptionValue = false;

            @Override
            public Boolean apply(String parameter, String nextParameter) {
                parameter = GCCCompiler.this.adjustArgument(parameter.trim());
                boolean tokenIsSwitch = GCCCompiler.isOptionSwitch(parameter);
                if (this.skipOptionValue) {
                    this.skipOptionValue = false;
                    if (!tokenIsSwitch) {
                        return false;
                    }
                }
                if (!skipOptions.contains(parameter)) {
                    if (skipSwitches.contains(parameter)) {
                        this.skipOptionValue = true;
                        return false;
                    }
                    String finalParameter = parameter;
                    if (skipSwitches.stream().anyMatch(s -> finalParameter.startsWith((String)s))) {
                        return false;
                    }
                    if (parameter.startsWith("-Werror") || parameter.startsWith("-Wno-error")) {
                        return false;
                    }
                    if ("-arch".equals(parameter)) {
                        if (this.archAdded) {
                            this.skipOptionValue = true;
                            return false;
                        }
                        this.archAdded = true;
                    }
                    if (parameter.startsWith("-include")) {
                        if ("-include".equals(parameter) && skipOptions.contains(GCCCompiler.this.adjustArgument(nextParameter))) {
                            return false;
                        }
                        String includeArg = parameter.substring("-include".length());
                        if (skipOptions.contains(includeArg)) {
                            return false;
                        }
                    }
                    return true;
                }
                this.skipOptionValue = tokenIsSwitch;
                return false;
            }
        };
        return switches.filterOptions(argumentsFilter2);
    }

    private static boolean isOptionSwitch(@NotNull String option) {
        return option.startsWith("-");
    }

    static boolean collectSkipOptionsGcc(List<String> lines, Set<String> skipOptions, List<String> warnLog) {
        return GCCCompiler.collectOptionsToSkip(lines, skipOptions, warnLog, BAD_SWITCH_FILTER_RULES);
    }

    @NotNull
    protected String adjustArgument(@NotNull String arg) {
        return arg;
    }

    @NotNull
    protected String preparePath(@NotNull CidrToolEnvironment env, @NotNull String path) {
        return FileUtil.toCanonicalPath((String)env.toLocalPath(this.myWorkingDirectory, path));
    }

    public static String getClangTestMacros() {
        return "#define __has_feature(X) " + GCCCompiler.clangFeatureMacro("##X") + "\n#define __has_extension(X) " + GCCCompiler.clangExtensionMacro("##X") + "\n#define __has_attribute(X) " + GCCCompiler.clangAttributeMacro("##X") + "\n#define __has_builtin(X) " + GCCCompiler.clangBuiltinMacro("##X") + "\n#define __is_target_arch(X) " + GCCCompiler.clangTargetArchMacro("##X") + "\n#define __is_target_vendor(X) " + GCCCompiler.clangTargetVendorMacro("##X") + "\n#define __is_target_os(X) " + GCCCompiler.clangTargetOsMacro("##X") + "\n#define __is_target_environment(X) " + GCCCompiler.clangTargetEnvironmentMacro("##X") + "\n#define __is_target_variant_os(X) " + GCCCompiler.clangTargetVariantOsMacro("##X") + "\n#define __is_target_variant_environment(X) " + GCCCompiler.clangTargetVariantEnvironmentMacro("##X") + "\n";
    }

    @NotNull
    public static String getGCCBuiltInFunctionMacros() {
        return "#define __builtin_va_start(list, paramN) ((void)(list = sizeof(paramN)))\n#define __builtin_va_arg(list, type) ((type)list)\n#define __builtin_va_end(list) ((void)list)\n#define __builtin_va_copy(dest, src) ((void)(dest = src))\n#define __builtin_offsetof(type, member) ((size_t)(&(((type *)0)->member)))\n#define __builtin_types_compatible_p(X,Y) 1\n#define __builtin_choose_expr(C,T,E) T\n";
    }

    @NotNull
    public static String clangFeatureMacro(@NotNull String feature) {
        return "__CIDR_clang__has_feature_" + feature;
    }

    @NotNull
    static String clangExtensionMacro(@NotNull String extension) {
        return "__CIDR_clang__has_extension_" + extension;
    }

    @NotNull
    static String clangAttributeMacro(@NotNull String attribute) {
        return "__CIDR_clang__has_attribute_" + attribute;
    }

    @NotNull
    static String clangBuiltinMacro(@NotNull String extension) {
        return "__CIDR_clang__has_builtin_" + extension;
    }

    @NotNull
    @VisibleForTesting
    public static String clangTargetArchMacro(@NotNull String arch) {
        return "__CIDR_clang__is_target_arch_" + arch;
    }

    @NotNull
    static String clangTargetVendorMacro(@NotNull String vendor) {
        return "__CIDR_clang__is_target_vendor_" + vendor;
    }

    @NotNull
    static String clangTargetOsMacro(@NotNull String os) {
        return "__CIDR_clang__is_target_os_" + os;
    }

    @NotNull
    static String clangTargetEnvironmentMacro(@NotNull String environment) {
        return "__CIDR_clang__is_target_environment_" + environment;
    }

    @NotNull
    static String clangTargetVariantOsMacro(@NotNull String os) {
        return "__CIDR_clang__is_target_variant_os_" + os;
    }

    @NotNull
    static String clangTargetVariantEnvironmentMacro(@NotNull String environment) {
        return "__CIDR_clang__is_target_variant_environment_" + environment;
    }

    private static /* synthetic */ void lambda$collectFeatureFlags$11(Set set, Map result2, String flag, OCCompilerFeatures.Feature feature) {
        if (set.contains(flag)) {
            result2.put(feature, true);
        }
    }

    static {
        featureFlags.put("-fms-extensions", OCCompilerFeatures.Feature.MS_EXTENSIONS);
        featureFlags.put("-fms-compatibility", OCCompilerFeatures.Feature.MS_EXTENSIONS);
        skipSwitches = ContainerUtil.newHashSet((Object[])new String[]{"-o", "--output", "--output=", "-M", "-MM", "-MF", "-MG", "-MP", "-MT", "-MQ", "-MD", "-MMD"});
        skipEnvironment = ContainerUtil.newHashSet((Object[])new String[]{"DEPENDENCIES_OUTPUT", "SUNPRO_DEPENDENCIES"});
    }

    static class OutputSections {
        final String defines;
        final String preprocessed;
        final String featureChecks;

        OutputSections(@NotNull String defines, @NotNull String preprocessed, @NotNull String featureTests) {
            this.defines = defines;
            this.preprocessed = preprocessed;
            this.featureChecks = featureTests;
        }
    }

    private static enum Command {
        SET_TYPE_SIZE,
        SET_FEATURE,
        ADD_DEFINITION;

    }
}

