/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace;

import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.lexer.OCLexer;
import com.jetbrains.cidr.lang.lexer.OCLexerSettings;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculatorHelper;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCLanguageKindCalculator {
    private static final Key<Pair<Long, Boolean>> LOOKS_LIKE_OBJC_KEY = new Key("LOOKS_LIKE_OBJC_KEY");
    private static final FileAttribute LOOKS_LIKE_OBJC_ATTRIBUTE = new FileAttribute("LOOKS_LIKE_OBJC_ATTRIBUTE", 1, true);
    private static final TokenSet OBJC_TOKENS = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.AT, OCTokenTypes.IMPORT_DIRECTIVE}), OCTokenTypes.OBJC_KEYWORDS_NO_AT, OCTokenTypes.ARC_TYPE_QUALIFIERS});

    @NotNull
    public static OCLanguageKind calculateLanguageKindFast(@NotNull PsiFile file2) {
        Project project2 = file2.getProject();
        VirtualFile virtualFile = OCInclusionContextUtil.getVirtualFile(file2);
        if (OCInclusionContextUtil.isLongLived(virtualFile)) {
            return OCLanguageKindCalculator.calculateLanguageKindFast(virtualFile, project2);
        }
        String name = file2.getName();
        OCLanguageKind result2 = OCLanguageKindCalculator.tryFileExtension(project2, name);
        if (result2 != null) {
            return result2;
        }
        return CLanguageKind.maxLanguage();
    }

    @NotNull
    public static OCLanguageKind calculateLanguageKindFast(@NotNull VirtualFile virtualFile, @NotNull Project project2) {
        return OCLanguageKindCalculator.calculateLanguageKind(null, virtualFile, project2, false);
    }

    @Nullable
    public static OCLanguageKind tryFileTypeAndExtension(@Nullable Project project2, @Nullable VirtualFile file2) {
        if (file2 == null) {
            return null;
        }
        OCLanguageKind result2 = OCLanguageKindCalculator.trySpecifiedFileType(project2, file2);
        if (result2 != null) {
            return result2;
        }
        result2 = OCLanguageKindCalculator.tryFileExtension(project2, file2.getName());
        if (result2 != null) {
            return result2;
        }
        return null;
    }

    @Nullable
    private static OCLanguageKind trySpecifiedFileType(@Nullable Project project2, @Nullable VirtualFile file2) {
        if (project2 == null || file2 == null) {
            return null;
        }
        for (OCLanguageKindCalculatorHelper each : OCLanguageKindCalculator.getHelpers()) {
            OCLanguageKind result2 = each.getSpecifiedLanguage(project2, file2);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    @Nullable
    public static OCLanguageKind calculateMinimalKindByExtension(@Nullable Project project2, @NotNull String name) {
        OCLanguageKind result2 = OCLanguageKindCalculator.tryFileExtension(project2, name);
        if (result2 != null) {
            return result2;
        }
        return OCFileTypeHelpers.getLanguageKind(name);
    }

    @Nullable
    private static OCLanguageKind tryFileExtension(@Nullable Project project2, @NotNull String name) {
        if (project2 == null) {
            return null;
        }
        for (OCLanguageKindCalculatorHelper each : OCLanguageKindCalculator.getHelpers()) {
            OCLanguageKind result2 = each.getLanguageByExtension(project2, name);
            if (result2 == null) continue;
            return result2;
        }
        return !OCFileTypeHelpers.isHeaderFile(name) ? OCFileTypeHelpers.getLanguageKindStrict(name) : null;
    }

    @NotNull
    private static List<OCLanguageKindCalculatorHelper> getHelpers() {
        return OCLanguageKindCalculatorHelper.EP_NAME.getExtensionList();
    }

    @NotNull
    public static OCLanguageKind calculateLanguageKind(@NotNull OCPsiFile file2) {
        return OCLanguageKindCalculator.calculateLanguageKind(OCInclusionContextUtil.getActiveConfiguration((PsiElement)file2), file2, true);
    }

    @NotNull
    public static OCLanguageKind calculateLanguageKind(@Nullable OCResolveConfiguration configuration, @NotNull OCPsiFile file2, boolean tryFromRoot) {
        if (file2 instanceof OCCodeFragment) {
            PsiFile containingFile;
            PsiElement context2;
            OCPsiFile curFile = file2;
            while ((context2 = file2.getContext()) != null && (containingFile = context2.getContainingFile()) != null && !curFile.equals(containingFile)) {
                if (containingFile instanceof OCCodeFragment) {
                    curFile = (OCCodeFragment)containingFile;
                    continue;
                }
                if (!OCLanguageUtils.isSupported(containingFile)) break;
                return ((OCPsiFile)containingFile).getKind();
            }
        }
        Project project2 = file2.getProject();
        VirtualFile virtualFile = OCInclusionContextUtil.getVirtualFile(file2);
        if (!OCInclusionContextUtil.isLongLived(virtualFile)) {
            String name = file2.getName();
            OCLanguageKind result2 = OCLanguageKindCalculator.tryFileExtension(project2, name);
            if (result2 != null) {
                return result2;
            }
            return CLanguageKind.maxLanguage();
        }
        return OCLanguageKindCalculator.calculateLanguageKind(configuration, virtualFile, project2, tryFromRoot);
    }

    @NotNull
    public static OCLanguageKind calculateLanguageKind(@Nullable OCResolveConfiguration activeConfig, @NotNull VirtualFile file2, @NotNull Project project2, boolean tryFromRoot) {
        OCLanguageKind result2;
        if (activeConfig != null && (result2 = activeConfig.getDeclaredLanguageKind(file2)) != null) {
            return result2;
        }
        result2 = OCLanguageKindCalculator.tryFileTypeAndExtension(project2, file2);
        if (result2 != null) {
            return result2;
        }
        if (tryFromRoot && OCInclusionContextUtil.isNeedToFindRoot(file2, project2)) {
            OCResolveRootAndConfiguration rootAndConfiguration = OCInclusionContextUtil.getResolveRootAndActiveConfiguration(file2, project2);
            VirtualFile rootFile = rootAndConfiguration.getRootFile();
            OCResolveConfiguration rootConfig = rootAndConfiguration.getConfiguration();
            if (rootFile != null && rootConfig != null && !rootFile.equals(file2)) {
                result2 = OCLanguageKindCalculator.tryLanguageKindFromPchRoot(rootConfig, file2, rootFile);
                if (result2 != null) {
                    return result2;
                }
                return OCLanguageKindCalculator.calculateLanguageKind(rootConfig, rootFile, project2, false);
            }
        }
        boolean isCpp = OCLanguageKindCalculator.isCppPreferred(activeConfig, file2.getName());
        boolean isCuda = OCFileTypeHelpers.isCudaFile(file2.getName());
        boolean isObjC = OCLanguageKindCalculator.looksLikeObjC(file2);
        return CLanguageKind.find(isObjC, isCpp, isCuda);
    }

    public static boolean isCppPreferred(@Nullable OCResolveConfiguration activeConfig, @NotNull String name) {
        if (OCFileTypeHelpers.isCppFile(name)) {
            return true;
        }
        if (activeConfig != null) {
            Set<OCLanguageKind> kinds = activeConfig.getEnabledLanguageKinds();
            return kinds.isEmpty() || kinds.stream().anyMatch(OCLanguageKind::isCpp);
        }
        return true;
    }

    @Nullable
    public static OCLanguageKind tryLanguageKindFromPchRoot(@NotNull OCResolveConfiguration config, @NotNull VirtualFile header, @NotNull VirtualFile pchCandidate) {
        OCImmutableInclusionContext cachedContext = OCInclusionContext.tryFindInCachedPCHPrecompiledContexts(config, header, pchCandidate);
        return cachedContext != null ? cachedContext.getLanguageKind() : null;
    }

    public static boolean looksLikeObjC(@NotNull VirtualFile file2) {
        if (file2.getFileType().isBinary()) {
            return false;
        }
        long currentTimestamp = file2.getModificationStamp();
        Pair info = (Pair)LOOKS_LIKE_OBJC_KEY.get((UserDataHolder)file2);
        if (info != null && (Long)info.first == currentTimestamp) {
            return (Boolean)info.second;
        }
        if (info == null) {
            info = OCLanguageKindCalculator.readDetectionInfo(file2);
        }
        if (info == null || (Long)info.first != currentTimestamp) {
            CharSequence text = LoadTextUtil.loadText((VirtualFile)file2, (int)2048);
            boolean isObjC = OCLanguageKindCalculator.calcLooksLikeObjC(text);
            info = Pair.create((Object)currentTimestamp, (Object)isObjC);
            OCLanguageKindCalculator.writeDetectionInfo(file2, (Pair<Long, Boolean>)info);
        }
        file2.putUserData(LOOKS_LIKE_OBJC_KEY, info);
        return (Boolean)info.second;
    }

    public static void markAsObjC(@NotNull VirtualFile file2) {
        Pair info = Pair.create((Object)file2.getModificationStamp(), (Object)true);
        file2.putUserData(LOOKS_LIKE_OBJC_KEY, (Object)info);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Pair<Long, Boolean> readDetectionInfo(@NotNull VirtualFile file2) {
        if (!(file2 instanceof VirtualFileWithId)) {
            return null;
        }
        try (DataInputStream in = LOOKS_LIKE_OBJC_ATTRIBUTE.readAttribute(file2);){
            if (in == null) return null;
            long timestamp = in.readLong();
            boolean isObjC = in.readBoolean();
            Pair pair = Pair.create((Object)timestamp, (Object)isObjC);
            return pair;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static void writeDetectionInfo(@NotNull VirtualFile file2, @NotNull Pair<Long, Boolean> info) {
        if (!(file2 instanceof VirtualFileWithId)) {
            return;
        }
        try (DataOutputStream out = LOOKS_LIKE_OBJC_ATTRIBUTE.writeAttribute(file2);){
            out.writeLong((Long)info.first);
            out.writeBoolean((Boolean)info.second);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean calcLooksLikeObjC(CharSequence text) {
        OCLexer lexer = new OCLexer(OCLexerSettings.forLanguage(CLanguageKind.OBJ_CPP).build());
        lexer.start(text);
        while (lexer.getTokenType() != null) {
            IElementType tt = lexer.getTokenType();
            if (OBJC_TOKENS.contains(tt)) {
                return true;
            }
            lexer.advance();
        }
        return false;
    }
}

