/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.lexer.OCLexer;
import com.jetbrains.cidr.lang.lexer.OCLexerSettings;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNamesValidator
implements NamesValidator {
    public boolean isKeyword(@NotNull String name, Project project2) {
        return OCNamesValidator.isKeyword(name);
    }

    public static boolean isKeyword(@NotNull String name) {
        return OCNamesValidator.isKeyword(name, CLanguageKind.OBJ_CPP);
    }

    public static boolean isKeyword(@NotNull String name, @NotNull OCLanguageKind kind) {
        IElementType tokenType = OCNamesValidator.getTokenType(name, kind);
        return OCTokenTypes.KEYWORDS.contains(tokenType);
    }

    public boolean isIdentifier(@NotNull String name, Project project2) {
        return OCNamesValidator.isIdentifier(name);
    }

    public static boolean isIdentifier(String name) {
        return OCNamesValidator.isIdentifier(name, CLanguageKind.OBJ_CPP);
    }

    public static boolean isIdentifier(@NotNull String name, @NotNull OCLanguageKind kind) {
        return OCNamesValidator.getTokenType(name, kind) == OCTokenTypes.IDENTIFIER;
    }

    @Nullable
    private static IElementType getTokenType(@NotNull String name, @NotNull OCLanguageKind kind) {
        OCLexer lexer = new OCLexer(OCLexerSettings.forLanguage(kind).build());
        lexer.start(name);
        IElementType tt = lexer.getTokenType();
        lexer.advance();
        return lexer.getTokenType() == null ? tt : null;
    }
}

