/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.editor.colors.OCHighlightingKeys;
import com.jetbrains.cidr.lang.lexer.OCHighlightingLexer;
import com.jetbrains.cidr.lang.lexer.OCLexerSettings;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.types.CTypeId;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCNumericType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCTollFreeBridges;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFormatSpecifiersUtil {
    public static final String POINTER_TYPE_REQUIRED = "<pointer type required>";
    private static final Pattern FORMAT_ATTRIBUTE_PATTERN = Pattern.compile("_{0,2}format_{0,2}#_{0,2}([^_\\s]*)_{0,2}\\s*,\\s*(\\d+)\\s*,\\s*(\\d+)");
    private static final Map<String, FormatSpecifiersInfo> PREDEFINED_FORMAT_FUNCTIONS = ContainerUtil.newHashMap((Pair)Pair.pair((Object)"printf", (Object)new FormatSpecifiersInfo(FormatType.PRINTF, 0, 1)), (Pair[])new Pair[]{Pair.pair((Object)"wprintf", (Object)new FormatSpecifiersInfo(FormatType.PRINTF, 0, 1)), Pair.pair((Object)"fprintf", (Object)new FormatSpecifiersInfo(FormatType.PRINTF, 1, 2)), Pair.pair((Object)"fwprintf", (Object)new FormatSpecifiersInfo(FormatType.PRINTF, 1, 2)), Pair.pair((Object)"sprintf", (Object)new FormatSpecifiersInfo(FormatType.PRINTF, 1, 2)), Pair.pair((Object)"swprintf", (Object)new FormatSpecifiersInfo(FormatType.PRINTF, 1, 2)), Pair.pair((Object)"snprintf", (Object)new FormatSpecifiersInfo(FormatType.PRINTF, 2, 3)), Pair.pair((Object)"asprintf", (Object)new FormatSpecifiersInfo(FormatType.PRINTF, 1, 2)), Pair.pair((Object)"scanf", (Object)new FormatSpecifiersInfo(FormatType.SCANF, 0, 1)), Pair.pair((Object)"fscanf", (Object)new FormatSpecifiersInfo(FormatType.SCANF, 1, 2)), Pair.pair((Object)"sscanf", (Object)new FormatSpecifiersInfo(FormatType.SCANF, 1, 2)), Pair.pair((Object)"strftime", (Object)new FormatSpecifiersInfo(FormatType.STRFTIME, 2, 3)), Pair.pair((Object)"wcsftime", (Object)new FormatSpecifiersInfo(FormatType.STRFTIME, 2, 3)), Pair.pair((Object)"put_time", (Object)new FormatSpecifiersInfo(FormatType.STRFTIME, 1, 0))});

    @NotNull
    private static Pair<OCTypeWrapper, Set<String>> p2s(@NotNull OCType type, String ... spec) {
        return Pair.pair((Object)new OCTypeWrapper(type), (Object)ContainerUtil.newHashSet((Object[])spec));
    }

    @NotNull
    private static Pair<OCTypeWrapper, Set<String>> p2s(@NotNull String typeName, boolean typeIsPointer, String ... spec) {
        return Pair.pair((Object)new OCTypeWrapper(typeName, typeIsPointer), (Object)ContainerUtil.newHashSet((Object[])spec));
    }

    @Nullable
    public static Pair<FormatSpecifiersInfo, List<SpecifierUsage>> getFormatSpecifiersInfo(@NotNull OCSymbol callable, @NotNull List<OCExpression> arguments) {
        OCExpression formatStringArg;
        List<SpecifierUsage> specifiers;
        OCFile file2;
        FormatSpecifiersInfo info = null;
        for (String attribute : callable.getAttributes()) {
            Matcher matcher = FORMAT_ATTRIBUTE_PATTERN.matcher(attribute);
            if (!matcher.matches()) continue;
            FormatType formatType = FormatType.getFormatTypeFromName(matcher.group(1));
            if (formatType == null) {
                return null;
            }
            info = new FormatSpecifiersInfo(formatType, Integer.parseInt(matcher.group(2)) - 1, Integer.parseInt(matcher.group(3)) - 1);
        }
        if (info == null) {
            info = PREDEFINED_FORMAT_FUNCTIONS.get(callable.getName());
        }
        if (info == null) {
            return null;
        }
        if (info.formatStringIndex < 0 || info.formatStringIndex >= info.argumentsIndex || info.formatStringIndex >= arguments.size()) {
            return null;
        }
        if (info.formatType == FormatType.PRINTF && OCCompilerFeaturesHelper.supportsMsvcExtensions(file2 = arguments.get(0).getContainingOCFile())) {
            info.formatType = FormatType.PRINTF_MSVC;
        }
        if ((specifiers = info.formatType.collectFormatSpecifiers(formatStringArg = arguments.get(info.formatStringIndex))) == null) {
            return null;
        }
        return Pair.create((Object)info, specifiers);
    }

    @Nullable
    public static OCType getFormatArgumentType(@NotNull OCSymbol callable, int argumentIndex, @NotNull List<OCExpression> arguments) {
        Pair<FormatSpecifiersInfo, List<SpecifierUsage>> formatInfo = OCFormatSpecifiersUtil.getFormatSpecifiersInfo(callable, arguments);
        if (formatInfo == null || ((FormatSpecifiersInfo)formatInfo.first).argumentsIndex < 0 || argumentIndex < ((FormatSpecifiersInfo)formatInfo.first).argumentsIndex || argumentIndex >= arguments.size() || argumentIndex >= ((FormatSpecifiersInfo)formatInfo.first).argumentsIndex + ((List)formatInfo.second).size()) {
            return null;
        }
        int checkFormatSpecIndex = argumentIndex - ((FormatSpecifiersInfo)formatInfo.first).argumentsIndex;
        int currentFormatSpecIndex = 0;
        for (SpecifierUsage specifier : (List)formatInfo.second) {
            if (specifier.getType() == OCHighlightingKeys.OC_VALID_STRING_ESCAPE) continue;
            if (currentFormatSpecIndex == checkFormatSpecIndex) {
                return ((FormatSpecifiersInfo)formatInfo.first).formatType.resolveType(specifier.getName(), OCResolveContext.forPsi(arguments.get(argumentIndex)));
            }
            ++currentFormatSpecIndex;
        }
        return null;
    }

    static /* synthetic */ Pair access$000(OCType x0, String[] x1) {
        return OCFormatSpecifiersUtil.p2s(x0, x1);
    }

    static /* synthetic */ Pair access$100(String x0, boolean x1, String[] x2) {
        return OCFormatSpecifiersUtil.p2s(x0, x1, x2);
    }

    private static class StrFragmentIterator {
        public static final char END_MARKER = '\u0000';
        private ASTNode child;
        private int pos = -1;
        private int endPos = -1;
        private boolean BOF = true;
        private boolean hasStringLiteral = false;
        private char cur = '\u0000';
        private char prev = '\u0000';
        private char prevPrev = '\u0000';
        OCLexerSettings lexerSettings = OCLexerSettings.forLanguage(CLanguageKind.OBJ_CPP).forHighlighting().build();
        private final OCHighlightingLexer lexer = new OCHighlightingLexer(this.lexerSettings);

        StrFragmentIterator(@NotNull OCExpression expression) {
            this.child = expression.getNode().getFirstChildNode();
        }

        public boolean wasEmpty() {
            return !this.hasStringLiteral;
        }

        private boolean childAdvance() {
            if (this.child != null) {
                if (this.BOF) {
                    this.BOF = false;
                } else {
                    this.child = this.child.getTreeNext();
                }
                while (this.child != null && !OCTokenTypes.ALL_STRINGS.contains(OCElementUtil.getElementType(this.child))) {
                    this.child = this.child.getTreeNext();
                }
                this.hasStringLiteral |= this.child != null;
            }
            return this.child != null;
        }

        private void insideAdvance() {
            this.lexer.start(this.child.getText());
            if (OCTokenTypes.RAW_STRING_LITERALS.contains(OCElementUtil.getElementType(this.child))) {
                this.lexer.advance();
                this.lexer.advance();
                this.lexer.advance();
                this.pos = this.lexer.getTokenStart();
                this.endPos = this.lexer.getTokenEnd();
            } else {
                if (OCHighlightingLexer.PREFIX_TYPE == this.lexer.getTokenType()) {
                    this.lexer.advance();
                }
                this.pos = this.lexer.getTokenStart() + 1;
                this.endPos = this.lexer.getBufferEnd() - 1;
            }
        }

        public int getPos() {
            return this.child == null || this.child instanceof OCMacroForeignLeafElement ? -1 : this.child.getStartOffset() + this.pos;
        }

        public char getPrevChar() {
            return this.prev;
        }

        public char getPrevPrevChar() {
            return this.prevPrev;
        }

        public char getNextChar() {
            this.prevPrev = this.prev;
            this.prev = this.cur;
            if (this.pos == -1 || this.pos + 1 >= this.endPos) {
                while (this.childAdvance()) {
                    this.insideAdvance();
                    if (this.pos >= this.endPos) continue;
                    this.cur = this.lexer.getBufferSequence().charAt(this.pos);
                    return this.cur;
                }
                return '\u0000';
            }
            this.cur = this.lexer.getBufferSequence().charAt(++this.pos);
            return this.cur;
        }
    }

    private static class OCTypeWrapper {
        final String myTypeName;
        final boolean myTypeNameIsPointer;
        final OCType myType;

        OCTypeWrapper(@NotNull OCType type) {
            this.myType = type;
            this.myTypeName = null;
            this.myTypeNameIsPointer = false;
        }

        OCTypeWrapper(@NotNull String typeName, boolean typeNameIsPointer) {
            this.myType = null;
            this.myTypeName = typeName;
            this.myTypeNameIsPointer = typeNameIsPointer;
        }

        public OCType getTypeFromContext(@NotNull OCResolveContext context2) {
            if (this.myType != null) {
                return this.myType;
            }
            OCType type = OCReferenceType.resolvedFromText(this.myTypeName, context2);
            return this.myTypeNameIsPointer ? OCPointerType.to(type) : type;
        }
    }

    public static class SpecifierUsage {
        @NotNull
        private String name;
        private int lengthWithFormat;
        private int offset;
        @NotNull
        private TextAttributesKey specType;

        public SpecifierUsage(@NotNull String name, int offset, int lengthWithFormat, @NotNull TextAttributesKey specType) {
            this.name = name;
            this.lengthWithFormat = lengthWithFormat;
            this.offset = offset;
            this.specType = specType;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public TextAttributesKey getType() {
            return this.specType;
        }

        @Nullable
        public TextRange getRange() {
            return this.offset < 0 ? null : new TextRange(this.offset, this.offset + this.lengthWithFormat);
        }
    }

    public static class FormatSpecifiersInfo {
        public FormatType formatType;
        public int formatStringIndex;
        public int argumentsIndex;

        public FormatSpecifiersInfo(@NotNull FormatType formatType, int formatStringIndex, int argumentsIndex) {
            this.formatType = formatType;
            this.formatStringIndex = formatStringIndex < 0 ? -1 : formatStringIndex;
            this.argumentsIndex = argumentsIndex < 0 ? -1 : argumentsIndex;
        }
    }

    public static enum FormatType {
        PRINTF(Arrays.asList(OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.CHAR), new String[]{"%s", "%hhn"}), OCFormatSpecifiersUtil.access$000(OCIntType.CHAR, new String[]{"%hhd", "%hhi"}), OCFormatSpecifiersUtil.access$000(OCIntType.UCHAR, new String[]{"%c", "%hhu", "%hho", "%hhx", "%hhX"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.WCHAR), new String[]{"%ls"}), OCFormatSpecifiersUtil.access$000(OCIntType.WCHAR, new String[]{"%lc"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.SHORT), new String[]{"%hn"}), OCFormatSpecifiersUtil.access$000(OCIntType.SHORT, new String[]{"%hd", "%hi"}), OCFormatSpecifiersUtil.access$000(OCIntType.USHORT, new String[]{"%hu", "%ho", "%hx", "%hX"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.INT), new String[]{"%n"}), OCFormatSpecifiersUtil.access$000(OCIntType.INT, new String[]{"*", "%d", "%i"}), OCFormatSpecifiersUtil.access$000(OCIntType.UINT, new String[]{"%u", "%o", "%x", "%X"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.LONG), new String[]{"%ln"}), OCFormatSpecifiersUtil.access$000(OCIntType.LONG, new String[]{"%ld", "%li"}), OCFormatSpecifiersUtil.access$000(OCIntType.ULONG, new String[]{"%lu", "%lo", "%lx", "%lX"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.LONGLONG), new String[]{"%lln"}), OCFormatSpecifiersUtil.access$000(OCIntType.LONGLONG, new String[]{"%lld", "%lli"}), OCFormatSpecifiersUtil.access$000(OCIntType.ULONGLONG, new String[]{"%llu", "%llo", "%llx", "%llX"}), OCFormatSpecifiersUtil.access$000(OCRealType.DOUBLE, new String[]{"%a", "%A", "%e", "%E", "%f", "%F", "%g", "%G", "%la", "%lA", "%le", "%lE", "%lf", "%lF", "%lg", "%lG"}), OCFormatSpecifiersUtil.access$000(OCRealType.LONG_DOUBLE, new String[]{"%La", "%LA", "%Le", "%LE", "%Lf", "%LF", "%Lg", "%LG"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCVoidType.instance()), new String[]{"%p"}), OCFormatSpecifiersUtil.access$100("intmax_t", true, new String[]{"%jn"}), OCFormatSpecifiersUtil.access$100("intmax_t", false, new String[]{"%jd", "%ji"}), OCFormatSpecifiersUtil.access$100("uintmax_t", false, new String[]{"%ju", "%jo", "%jx", "%jX"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.SIZE_T), new String[]{"%zn"}), OCFormatSpecifiersUtil.access$000(OCIntType.SSIZE_T, new String[]{"%zd", "%zi"}), OCFormatSpecifiersUtil.access$000(OCIntType.SIZE_T, new String[]{"%zu", "%zo", "%zx", "%zX"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.PTRDIFF_T), new String[]{"%tn"}), OCFormatSpecifiersUtil.access$000(OCIntType.PTRDIFF_T, new String[]{"%td", "%ti", "%tu", "%to", "%tx", "%tX"}), OCFormatSpecifiersUtil.access$100("<errno message, no arg>", false, new String[]{"%m"})), true, "printf"),
        PRINTF_MSVC(ContainerUtil.concat((List)((List)FormatType.PRINTF.myType2spec), Arrays.asList(OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.CHAR), new String[]{"%hs", "%hS"}), OCFormatSpecifiersUtil.access$000(OCIntType.CHAR, new String[]{"%hc", "%hC"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.WCHAR), new String[]{"%S", "%lS", "%ws", "%wS"}), OCFormatSpecifiersUtil.access$000(OCIntType.WCHAR, new String[]{"%C", "%lC", "%wc", "%wC"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.__INT32), new String[]{"%I32n"}), OCFormatSpecifiersUtil.access$000(OCIntType.__INT32, new String[]{"%I32d", "%I32i"}), OCFormatSpecifiersUtil.access$000(OCIntType.__UINT32, new String[]{"%I32u", "%I32o", "%I32x", "%I32X"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.__INT64), new String[]{"%I64n"}), OCFormatSpecifiersUtil.access$000(OCIntType.__INT64, new String[]{"%I64d", "%I64i"}), OCFormatSpecifiersUtil.access$000(OCIntType.__UINT64, new String[]{"%I64u", "%I64o", "%I64x", "%I64X"}), OCFormatSpecifiersUtil.access$100("intmax_t", true, new String[]{"%In"}), OCFormatSpecifiersUtil.access$100("intmax_t", false, new String[]{"%Id", "%Ii"}), OCFormatSpecifiersUtil.access$100("uintmax_t", false, new String[]{"%Iu", "%Io", "%Ix", "%IX"}))), true, "printf"),
        NSSTRING(Arrays.asList(OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.CHAR), new String[]{"%s", "%hhn"}), OCFormatSpecifiersUtil.access$000(OCIntType.CHAR, new String[]{"%hhd", "%hhD", "%hhi"}), OCFormatSpecifiersUtil.access$000(OCIntType.UCHAR, new String[]{"%c", "%hhu", "%hhU", "%hho", "%hhO", "%hhx", "%hhX"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.WCHAR), new String[]{"%ls", "%S"}), OCFormatSpecifiersUtil.access$000(OCIntType.WCHAR, new String[]{"%lc", "%C"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.SHORT), new String[]{"%hn"}), OCFormatSpecifiersUtil.access$000(OCIntType.SHORT, new String[]{"%hd", "%hD", "%hi"}), OCFormatSpecifiersUtil.access$000(OCIntType.USHORT, new String[]{"%hu", "%hU", "%ho", "%hO", "%hx", "%hX"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.INT), new String[]{"%n"}), OCFormatSpecifiersUtil.access$000(OCIntType.INT, new String[]{"*", "%d", "%D", "%i"}), OCFormatSpecifiersUtil.access$000(OCIntType.UINT, new String[]{"%u", "%U", "%o", "%O", "%x", "%X"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.LONG), new String[]{"%ln"}), OCFormatSpecifiersUtil.access$000(OCIntType.LONG, new String[]{"%ld", "%lD", "%li"}), OCFormatSpecifiersUtil.access$000(OCIntType.ULONG, new String[]{"%lu", "%lU", "%lo", "%lO", "%lx", "%lX"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.LONGLONG), new String[]{"%lln", "%qn"}), OCFormatSpecifiersUtil.access$000(OCIntType.LONGLONG, new String[]{"%lld", "%llD", "%lli", "%qd", "%qD", "%qi"}), OCFormatSpecifiersUtil.access$000(OCIntType.ULONGLONG, new String[]{"%llu", "%llU", "%llo", "%llO", "%llx", "%llX", "%qu", "%qU", "%qo", "%qO", "%qx", "%qX"}), OCFormatSpecifiersUtil.access$000(OCRealType.DOUBLE, new String[]{"%a", "%A", "%e", "%E", "%f", "%F", "%g", "%G", "%la", "%lA", "%le", "%lE", "%lf", "%lF", "%lg", "%lG"}), OCFormatSpecifiersUtil.access$000(OCRealType.LONG_DOUBLE, new String[]{"%La", "%LA", "%Le", "%LE", "%Lf", "%LF", "%Lg", "%LG"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCVoidType.instance()), new String[]{"%p"}), OCFormatSpecifiersUtil.access$100("intmax_t", true, new String[]{"%jn"}), OCFormatSpecifiersUtil.access$100("intmax_t", false, new String[]{"%jd", "%jD", "%ji"}), OCFormatSpecifiersUtil.access$100("uintmax_t", false, new String[]{"%ju", "%jU", "%jo", "%jO", "%jx", "%jX"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.SIZE_T), new String[]{"%zn"}), OCFormatSpecifiersUtil.access$000(OCIntType.SSIZE_T, new String[]{"%zd", "%zD", "%zi"}), OCFormatSpecifiersUtil.access$000(OCIntType.SIZE_T, new String[]{"%zu", "%zU", "%zo", "%zO", "%zx", "%zX"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.PTRDIFF_T), new String[]{"%tn"}), OCFormatSpecifiersUtil.access$000(OCIntType.PTRDIFF_T, new String[]{"%td", "%tD", "%ti", "%tu", "%tU", "%to", "%tO", "%tx", "%tX"}), OCFormatSpecifiersUtil.access$100("<errno message, no arg>", false, new String[]{"%m"}), OCFormatSpecifiersUtil.access$100("NSObject", true, new String[]{"%@"})), true, "NSString"),
        SCANF(Arrays.asList(OCFormatSpecifiersUtil.access$100("<skip input>", false, new String[]{"*"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.CHAR), new String[]{"%c", "%hhd", "%hhi", "%hhu", "%hho", "%hhx", "%hhX", "%hhn", "%s", "%["}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.WCHAR), new String[]{"%lc", "%ls", "%l["}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.SHORT), new String[]{"%hd", "%hi", "%hu", "%ho", "%hx", "%hX", "%hn"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.INT), new String[]{"%d", "%i", "%u", "%o", "%x", "%X", "%n"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.LONG), new String[]{"%ld", "%li", "%lu", "%lo", "%lx", "%lX", "%ln"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.LONGLONG), new String[]{"%lld", "%lli", "%llu", "%llo", "%llx", "%llX", "%lln"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.SIZE_T), new String[]{"%zd", "%zi", "%zu", "%zU", "%zo", "%zO", "%zx", "%zX", "%zn"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCIntType.PTRDIFF_T), new String[]{"%td", "%ti", "%tu", "%tU", "%to", "%tO", "%tx", "%tX", "%tn"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCRealType.FLOAT), new String[]{"%a", "%A", "%e", "%E", "%f", "%F", "%g", "%G"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCRealType.DOUBLE), new String[]{"%la", "%lA", "%le", "%lE", "%lf", "%lF", "%lg", "%lG"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCRealType.LONG_DOUBLE), new String[]{"%La", "%LA", "%Le", "%LE", "%Lf", "%LF", "%Lg", "%LG"}), OCFormatSpecifiersUtil.access$000(OCPointerType.to(OCPointerType.to(OCVoidType.instance())), new String[]{"%p"}), OCFormatSpecifiersUtil.access$100("intmax_t", true, new String[]{"%jd", "%ji", "%ju", "%jU", "%jo", "%jO", "%jx", "%jX", "%jn"})), true, "scanf"),
        STRFTIME(Collections.singletonList(OCFormatSpecifiersUtil.access$100("tm", true, new String[]{"%n", "%t", "%Y", "%y", "%C", "%G", "%g", "%b", "%h", "%B", "%m", "%U", "%W", "%V", "%j", "%d", "%e", "%a", "%A", "%w", "%u", "%H", "%I", "%M", "%S", "%c", "%x", "%X", "%D", "%F", "%r", "%R", "%T", "%p", "%Z", "%z"})), false, "strftime");

        @Nullable
        private Collection<Pair<OCTypeWrapper, Set<String>>> myType2spec;
        private String @NotNull [] mySuffixes;
        private boolean myNeedArgumentCheck;

        private FormatType(@NotNull Collection<Pair<OCTypeWrapper, Set<String>>> type2spec, boolean check, String ... suffixes) {
            this.myType2spec = type2spec;
            this.myNeedArgumentCheck = check;
            this.mySuffixes = suffixes;
        }

        @Nullable
        @Contract(value="null->null")
        static FormatType getFormatTypeFromName(@Nullable String functionOrAttributeName) {
            if (functionOrAttributeName == null) {
                return null;
            }
            for (FormatType type : FormatType.values()) {
                for (String suffix : type.mySuffixes) {
                    if (!functionOrAttributeName.endsWith(suffix)) continue;
                    return type;
                }
            }
            return null;
        }

        @Nullable
        public OCType resolveType(@NotNull String spec, @NotNull OCResolveContext context2) {
            if (this.myType2spec == null) {
                return null;
            }
            for (Pair<OCTypeWrapper, Set<String>> rec : this.myType2spec) {
                if (!((Set)rec.second).contains(spec)) continue;
                return ((OCTypeWrapper)rec.first).getTypeFromContext(context2);
            }
            return null;
        }

        @Nullable
        public String getSpecifierForType(@NotNull OCType type, @NotNull PsiElement context2) {
            if (!(this != SCANF || type.isCString() || type instanceof OCPointerType && ((OCPointerType)type).getRefType().isCString())) {
                return type instanceof OCPointerType ? PRINTF.getSpecifierForType(((OCPointerType)type).getRefType(), context2) : OCFormatSpecifiersUtil.POINTER_TYPE_REQUIRED;
            }
            if (FormatType.equalsByAlias(OCIntType.SSIZE_T, type, context2)) {
                return OCIntType.SSIZE_T.getFormatString();
            }
            if (FormatType.equalsByAlias(OCIntType.SIZE_T, type, context2)) {
                return OCIntType.SIZE_T.getFormatString();
            }
            if (FormatType.equalsByAlias(OCIntType.PTRDIFF_T, type, context2)) {
                return OCIntType.PTRDIFF_T.getFormatString();
            }
            return type.getFormatString();
        }

        private static boolean equalsByAlias(@NotNull OCIntType compilerType, @NotNull OCType type, @NotNull PsiElement context2) {
            String aliasName = type.getAliasName();
            Project project2 = context2.getProject();
            return aliasName != null && type instanceof OCIntType && (aliasName.equals(compilerType.getAliasName()) || aliasName.equals(compilerType.getText())) && ((OCIntType)type).isSigned() == compilerType.isSigned() && ((OCIntType)type).getBits(context2, null, project2) == compilerType.getBits(context2, null, project2);
        }

        @Contract(pure=true)
        public boolean needArgumentsCheck() {
            return this.myNeedArgumentCheck;
        }

        private boolean isSpecifierModifier(char cur, char prev) {
            switch (this) {
                case NSSTRING: 
                case SCANF: 
                case PRINTF: 
                case PRINTF_MSVC: {
                    return (prev == '%' || FormatType.isFlag(prev)) && FormatType.isFlag(cur) && cur != prev || "0123456789.*".indexOf(cur) >= 0;
                }
                case STRFTIME: {
                    return "OE".indexOf(cur) >= 0;
                }
            }
            return false;
        }

        @Contract(pure=true)
        private static boolean isFlag(char cur) {
            return " +-#0".indexOf(cur) >= 0;
        }

        private boolean isSpecifierPart(char cur) {
            if (Character.isLetter(cur)) {
                return true;
            }
            switch (this) {
                case NSSTRING: {
                    return cur == '@';
                }
                case SCANF: {
                    return cur == '[';
                }
            }
            return false;
        }

        @Nullable
        public List<SpecifierUsage> collectFormatSpecifiers(@Nullable OCExpression expression) {
            if (!((expression = OCParenthesesUtils.diveIntoParenthesesAndCasts(expression)) instanceof OCLiteralExpression)) {
                return null;
            }
            OCResolveContext context2 = OCResolveContext.forPsi(expression);
            ArrayList<SpecifierUsage> result2 = new ArrayList<SpecifierUsage>();
            StrFragmentIterator iter = new StrFragmentIterator(expression);
            boolean skipNext = false;
            char cur = '\u0000';
            while (true) {
                if (skipNext) {
                    skipNext = false;
                } else {
                    cur = iter.getNextChar();
                }
                if (cur == '\u0000') break;
                if (cur != '%') continue;
                StringBuilder specifier = new StringBuilder();
                boolean wasNonPercent = false;
                boolean wasNonFormat = false;
                boolean wasCrossLiteralJump = false;
                int numOfPercents = 0;
                int lengthWithFormat = 0;
                int offset = iter.getPos();
                int prevPos = offset - 1;
                while (cur == '%' || this.isSpecifierPart(cur) || this.isSpecifierModifier(cur, iter.getPrevChar())) {
                    if (cur == '%') {
                        if (wasNonPercent || ++numOfPercents == 2) {
                            break;
                        }
                    } else {
                        wasNonPercent = true;
                    }
                    if (wasNonFormat || !this.isSpecifierModifier(cur, iter.getPrevChar())) {
                        wasCrossLiteralJump = prevPos + 1 != iter.getPos();
                        specifier.append(cur);
                        if (cur != '%') {
                            wasNonFormat = true;
                        }
                    } else if (cur == '*') {
                        result2.add(new SpecifierUsage("*", iter.getPos(), 1, OCHighlightingKeys.OC_FORMAT_STRING_TOKEN));
                    }
                    ++lengthWithFormat;
                    prevPos = iter.getPos();
                    cur = iter.getNextChar();
                    if (cur != '\u0000') continue;
                }
                if (numOfPercents >= 2) {
                    result2.add(new SpecifierUsage(specifier.toString(), wasCrossLiteralJump ? -1 : offset, numOfPercents, OCHighlightingKeys.OC_VALID_STRING_ESCAPE));
                    cur = iter.getNextChar();
                    if (cur == '\u0000') {
                        break;
                    }
                } else if (specifier.length() > 0) {
                    String specifierName;
                    int length = specifier.length();
                    int lengthWithFormatFull = lengthWithFormat;
                    boolean isValidSpec = false;
                    while (length > 1) {
                        boolean bl = isValidSpec = this.resolveType(specifier.substring(0, length), context2) != null;
                        if (isValidSpec) break;
                        --length;
                        --lengthWithFormat;
                    }
                    if ((specifierName = specifier.substring(0, length)).endsWith("[")) {
                        while (cur != '\u0000') {
                            boolean bl = isValidSpec = cur == ']';
                            if (isValidSpec) break;
                            ++lengthWithFormatFull;
                            prevPos = iter.getPos();
                            cur = iter.getNextChar();
                            wasCrossLiteralJump = prevPos + 1 != iter.getPos();
                        }
                        if (cur != '\u0000') {
                            lengthWithFormat = ++lengthWithFormatFull;
                        }
                    }
                    result2.add(new SpecifierUsage(specifierName, wasCrossLiteralJump ? -1 : offset, lengthWithFormat, isValidSpec ? OCHighlightingKeys.OC_FORMAT_STRING_TOKEN : OCHighlightingKeys.OC_INVALID_STRING_ESCAPE));
                }
                skipNext = true;
            }
            return iter.wasEmpty() ? null : result2;
        }

        public boolean isCompatible(@NotNull OCType requiredType, @NotNull OCType actualType, @NotNull String requiredSpecifierName, @NotNull String actualSpecifierName, @NotNull PsiElement context2) {
            OCResolveContext resolveContext = OCResolveContext.forPsi(context2);
            if (requiredSpecifierName.equals(actualSpecifierName) || requiredType.equals(actualType, resolveContext)) {
                return true;
            }
            if (this == PRINTF || this == PRINTF_MSVC || this == NSSTRING) {
                OCType actualSpecType;
                if (requiredSpecifierName.equals("%@") && actualType.isPointer() && OCTollFreeBridges.getNSCounterpart(actualType.getName()) != null) {
                    return true;
                }
                if (requiredSpecifierName.endsWith("n") && actualType.isPointer()) {
                    actualSpecType = ((OCPointerType)actualType).getRefType();
                    if (actualSpecType.isConst()) {
                        return false;
                    }
                    requiredType = ((OCPointerType)requiredType).getRefType();
                } else {
                    actualSpecType = actualType instanceof OCIntType ? actualType : this.resolveType(actualSpecifierName, resolveContext);
                }
                if (actualSpecType != null) {
                    if (requiredType instanceof OCIntType && actualSpecType instanceof OCIntType) {
                        int requiredRank = FormatType.getRank(((OCIntType)requiredType).getCTypeId());
                        int actualRank = FormatType.getRank(((OCIntType)actualSpecType).getCTypeId());
                        if (requiredRank > 0 && actualRank > 0) {
                            return requiredRank == actualRank;
                        }
                        Project project2 = context2.getProject();
                        return ((OCIntType)requiredType).getBits(context2, null, project2) == ((OCIntType)actualSpecType).getBits(context2, null, project2);
                    }
                    if (requiredType instanceof OCRealType && actualSpecType instanceof OCRealType) {
                        CTypeId typeId1 = ((OCRealType)requiredType).getCTypeId();
                        CTypeId typeId2 = ((OCRealType)actualSpecType).getCTypeId();
                        return CTypeId.LONG_DOUBLE.equals((Object)typeId1) == CTypeId.LONG_DOUBLE.equals((Object)typeId2);
                    }
                    return requiredType.equals(actualSpecType, resolveContext);
                }
            } else if (this == SCANF && requiredType instanceof OCPointerType && actualType instanceof OCPointerType) {
                OCType actualTypeBase = ((OCPointerType)actualType).getRefType();
                if (actualTypeBase.isConst()) {
                    return false;
                }
                OCType requiredTypeBase = ((OCPointerType)requiredType).getRefType();
                if (requiredTypeBase instanceof OCNumericType && actualTypeBase instanceof OCNumericType) {
                    return ((OCNumericType)requiredTypeBase).getCTypeId() == ((OCNumericType)actualTypeBase).getCTypeId();
                }
            }
            return false;
        }

        private static int getRank(CTypeId typeId) {
            switch (typeId) {
                case BOOL: 
                case SIGNED_CHAR: 
                case CHAR: 
                case CHAR8_T: 
                case CHAR16_T: 
                case CHAR32_T: 
                case WCHAR_T: 
                case SHORT: 
                case INT: {
                    return 1;
                }
                case LONG: {
                    return 2;
                }
                case LONG_LONG: {
                    return 3;
                }
            }
            return 0;
        }
    }
}

