/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.ui;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ReferenceEditorWithBrowseButton;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolGroupContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.ui.OCFileChooserDialog;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCReferenceEditor
extends ReferenceEditorWithBrowseButton {
    public OCReferenceEditor(ActionListener browseActionListener, EditorTextField editorTextField, Function<String, Document> factory) {
        super(browseActionListener, editorTextField, factory);
    }

    public static OCReferenceEditor createFileReferencesEditor(final @NotNull OCFile file2) {
        final Ref result2 = Ref.create(null);
        List<OCResolveConfiguration> configurations = OCWorkspace.getInstance(file2.getProject()).getConfigurationsForFile(file2.getVirtualFile());
        List sources2 = ContainerUtil.concat((Iterable)ContainerUtil.map(configurations, OCResolveConfiguration::getSources));
        ClassCompletionProvider completionProvider = new ClassCompletionProvider(sources2);
        TextFieldWithAutoCompletion textField = new TextFieldWithAutoCompletion(file2.getProject(), (TextFieldWithAutoCompletionListProvider)completionProvider, false, null);
        Function documentFactory = arg_0 -> OCReferenceEditor.lambda$createFileReferencesEditor$0((EditorTextField)textField, arg_0);
        result2.set((Object)new OCReferenceEditor(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OCFileChooserDialog dialog = new OCFileChooserDialog("Choose Containing Class", file2.getProject());
                dialog.showDialog();
                if (dialog.isOK()) {
                    OCFile selectedFile = (OCFile)dialog.getSelected();
                    ((OCReferenceEditor)((Object)result2.get())).setText(selectedFile.getName());
                }
            }
        }, (EditorTextField)textField, (Function<String, Document>)documentFactory));
        return (OCReferenceEditor)((Object)result2.get());
    }

    private static Document createNamespaceReferencesDocument(@NotNull OCFile file2, @NotNull String text) {
        OCCodeFragment fragment = OCElementFactory.qualifiedIdCodeFragment(text, PsiTreeUtil.getDeepestLast((PsiElement)file2));
        OCSymbolGroupContext symbolContext = new OCSymbolGroupContext("completion context", new OCSymbolKind[0]){

            @Override
            public boolean isSuitableSymbol(OCSymbol symbol) {
                return super.isSuitableSymbol(symbol) && (!(symbol instanceof OCNamespaceSymbol) || !((OCNamespaceSymbol)symbol).isQualifiedContainer());
            }
        };
        symbolContext.addSymbolContext(OCSymbolKind.NAMESPACE);
        symbolContext.addSymbolContext(OCSymbolKind.NAMESPACE_ALIAS);
        fragment.setCompletionFilter(symbolContext);
        return PsiDocumentManager.getInstance((Project)file2.getProject()).getDocument((PsiFile)fragment);
    }

    public static EditorTextField createNamespaceReferencesEditor(@NotNull OCFile file2, @NotNull String text) {
        return new EditorTextField(OCReferenceEditor.createNamespaceReferencesDocument(file2, text), file2.getProject(), (FileType)OCFileType.INSTANCE);
    }

    public static void setReferencesEditorContext(@NotNull EditorTextField field, @NotNull OCFile file2) {
        field.setDocument(OCReferenceEditor.createNamespaceReferencesDocument(file2, field.getText()));
    }

    @Nullable
    public OCFile getFile(@NotNull Project project2) {
        return (OCFile)ContainerUtil.getFirstItem(OCSearchUtil.getProjectOCFilesByName(project2, this.getText()));
    }

    private static /* synthetic */ Document lambda$createFileReferencesEditor$0(EditorTextField textField, String s) {
        textField.setText(s);
        return textField.getDocument();
    }

    private static class ClassCompletionProvider
    extends TextFieldWithAutoCompletionListProvider<VirtualFile> {
        protected ClassCompletionProvider(@Nullable Collection<VirtualFile> variants) {
            super(variants);
        }

        protected Icon getIcon(@NotNull VirtualFile file2) {
            return null;
        }

        @NotNull
        protected String getLookupString(@NotNull VirtualFile file2) {
            return file2.getName();
        }

        protected String getTailText(@NotNull VirtualFile file2) {
            VirtualFile parent = file2.getParent();
            return parent != null ? parent.getPath() : null;
        }

        protected String getTypeText(@NotNull VirtualFile file2) {
            return null;
        }

        public int compare(VirtualFile file1, VirtualFile file2) {
            return file1.getName().compareTo(file2.getName());
        }
    }
}

