/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors.names;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.impl.symbols.OCFileGlobalSymbolsCache;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithArguments;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceLikeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCBracedInitListType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCExpansionPackType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCReferenceTypeBuilder;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCSimpleTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityAfterResolvingVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.names.OCTypeNameVisitorBase;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTypeNameVisitor
extends OCTypeNameVisitorBase {
    private final OCType.Presentation myPresentation;
    private final boolean myIncludeGlobalQualifier;
    private final boolean myAliased;
    private final boolean myIsInOldC;
    @NotNull
    private final OCResolveContext myContext;

    public static String getFunctionSignature(@NotNull OCResolveContext context2, OCFunctionType type, String signatureWithoutParams) {
        return new OCTypeNameVisitor(OCType.Presentation.BEST, true, true, context2, 0).getFunctionSignature(type, signatureWithoutParams);
    }

    public static String getFunctionSignature(@NotNull OCResolveContext context2, OCFunctionType type, String signatureWithoutParams, boolean withNames, List<OCExpression> arguments) {
        return new OCTypeNameVisitor(OCType.Presentation.BEST, true, true, context2, 0).getFunctionSignature(type, signatureWithoutParams, withNames, arguments);
    }

    public OCTypeNameVisitor(@NotNull OCType.Presentation presentation, boolean aliased, boolean includeGlobalQualifier, @NotNull OCResolveContext context2, int templateDepth) {
        super(templateDepth);
        this.myPresentation = presentation;
        this.myAliased = aliased;
        this.myContext = context2;
        this.myIsInOldC = OCCodeInsightUtil.isInPlainOldC(this.myContext.getElement());
        this.myIncludeGlobalQualifier = includeGlobalQualifier;
    }

    @Override
    @NotNull
    public String getName(OCType type) {
        String aliasName = type.getAliasName();
        if (this.myPresentation == OCType.Presentation.BEST) {
            String name = this.getShortestQualifiedName(type, this.myAliased ? aliasName : null);
            if (name != null) {
                return name;
            }
            return type.accept(this);
        }
        if (this.myAliased && aliasName != null) {
            return aliasName;
        }
        return type.accept(this);
    }

    @Override
    @Nullable
    protected Project getProject() {
        return this.myContext.getProjectOrNull();
    }

    @Nullable
    private String getShortestQualifiedName(OCType type, String qualifiedName) {
        String result2;
        if (qualifiedName == null) {
            return null;
        }
        if ("instancetype".equals(qualifiedName)) {
            OCObjectType inheritorType;
            OCClassDeclaration clazz = (OCClassDeclaration)PsiTreeUtil.getContextOfType((PsiElement)this.myContext.getElement(), (boolean)false, (Class[])new Class[]{OCClassDeclaration.class});
            OCType terminalType = type.getTerminalType();
            OCObjectType oCObjectType = inheritorType = clazz != null ? clazz.getType() : null;
            if (inheritorType != null && terminalType instanceof OCObjectType && ((OCObjectType)terminalType).isAncestorOf(inheritorType)) {
                return qualifiedName;
            }
        }
        String qualifier = "const";
        if (qualifiedName.endsWith(" " + qualifier)) {
            qualifiedName = qualifiedName.substring(0, qualifiedName.length() - qualifier.length() - 1);
        } else {
            qualifier = "";
        }
        ArrayList<String> parts = new ArrayList<String>();
        OCTypeNameVisitor.splitToParts(qualifiedName, parts);
        Ref tagRef = new Ref((Object)"");
        parts.set(0, OCTypeNameVisitor.cutOffTag((String)parts.get(0), (Ref<String>)tagRef));
        if (((String)tagRef.get()).equals("const") || ((String)tagRef.get()).equals("volatile")) {
            qualifier = (String)tagRef.get();
        }
        return (result2 = this.getShortestName(type, parts, 0, null)) != null ? OCTypeNameVisitor.addTypeQualifier(result2, type, this.myContext.getProjectOrNull(), qualifier) : null;
    }

    @Nullable
    private String getShortestName(OCType type, List<String> parts, int index, @Nullable OCQualifiedName candidate) {
        if (parts.size() - 1 == index) {
            candidate = OCTypeNameVisitor.appendPart(candidate, parts.get(index));
            PsiElement localContext = this.myContext.getElement();
            OCSymbolWithQualifiedName globalContext = null;
            if (localContext instanceof OCStructLike) {
                globalContext = (OCSymbolWithQualifiedName)((OCStructLike)localContext).getSymbol();
            } else if (localContext instanceof OCCppNamespace) {
                globalContext = (OCSymbolWithQualifiedName)((OCCppNamespace)localContext).getSymbol();
            }
            OCReferenceType candidateType = new OCReferenceTypeBuilder(OCTypeNameVisitor.removeArguments(candidate), localContext, globalContext, false, OCElementUtil.getVirtualFile(localContext), OCTypeNameVisitor.getContextOffset(localContext, globalContext)).build();
            if (this.equalIgnoringTemplateParameters(type, candidateType)) {
                return candidate.getFullName(this.myContext);
            }
            return null;
        }
        if (parts.get(index).isEmpty()) {
            return this.getShortestName(type, parts, index + 1, candidate);
        }
        String shortName = this.getShortestName(type, parts, index + 1, candidate);
        if (shortName != null) {
            return shortName;
        }
        return this.getShortestName(type, parts, index + 1, OCTypeNameVisitor.appendPart(candidate, parts.get(index)));
    }

    private static long getContextOffset(@Nullable PsiElement localContext, @Nullable OCSymbolWithQualifiedName globalContext) {
        if (localContext != null) {
            return OCSymbolOffsetUtil.getComplexRange(localContext).getEndOffset();
        }
        if (globalContext != null) {
            return globalContext.getComplexOffset();
        }
        return -1L;
    }

    private boolean equalIgnoringTemplateParameters(OCType type, OCReferenceType candidateType) {
        if (type instanceof OCCppReferenceType) {
            type = ((OCCppReferenceType)type).getRefType();
        }
        OCTypeEqualityAfterResolvingVisitor visitor = new OCTypeEqualityAfterResolvingVisitor(candidateType, false, true, true, true, this.myContext);
        visitor.setAssumeDifferentSubstitutionsEquals(true);
        return visitor.equal(type);
    }

    private static OCQualifiedName appendPart(OCQualifiedName candidate, String part) {
        return candidate == null ? OCQualifiedName.interned(part) : OCQualifiedName.interned(candidate, part);
    }

    private static OCQualifiedName removeArguments(OCQualifiedName qualifiedName) {
        OCQualifiedName qualifier = qualifiedName.getQualifier() != null ? OCTypeNameVisitor.removeArguments(qualifiedName.getQualifier()) : null;
        String name = qualifiedName.getName();
        int pos = name != null ? name.indexOf(60) : -1;
        name = pos != -1 ? name.substring(0, pos) : name;
        return qualifier != null ? OCQualifiedName.interned(qualifier, name) : OCQualifiedName.interned(name);
    }

    private static String cutOffTag(String name, Ref<String> tag) {
        int index;
        for (index = 0; index < name.length() && Character.isLetter(name.charAt(index)); ++index) {
        }
        if (index > 0 && index < name.length() && name.charAt(index) == ' ') {
            tag.set((Object)name.substring(0, index));
            return name.substring(index + 1);
        }
        return name;
    }

    private static void splitToParts(String name, List<String> parts) {
        int balance = 0;
        int partStartPos = 0;
        for (int i2 = 0; i2 < name.length(); ++i2) {
            char c = name.charAt(i2);
            if (c == '<') {
                ++balance;
                continue;
            }
            if (c == '>') {
                --balance;
                continue;
            }
            if (balance != 0 || c != ':' || i2 + 1 >= name.length() || name.charAt(i2 + 1) != ':') continue;
            parts.add(name.substring(partStartPos, i2));
            partStartPos = i2 + 2;
        }
        if (partStartPos < name.length()) {
            parts.add(name.substring(partStartPos));
        }
    }

    @Override
    public String visitFunctionType(OCFunctionType type) {
        String name = this.getName(type.getReturnType());
        if (this.myPresentation == OCType.Presentation.BEST) {
            return this.getFunctionSignature(type, name, false, null);
        }
        return this.getFunctionSignature(type, name);
    }

    private String getFunctionSignature(OCFunctionType type, String signatureWithoutParams, boolean withNames, @Nullable List<OCExpression> arguments) {
        HashSet<String> createdNames = new HashSet<String>();
        StringBuilder builder2 = new StringBuilder(signatureWithoutParams);
        builder2.append('(');
        List<OCType> types = type.getParameterTypes(true);
        List<String> argumentNames = type.getParameterNames(true);
        int size = types.size();
        for (int i2 = 0; i2 < size; ++i2) {
            OCType argumentType = types.get(i2);
            if (i2 > 0) {
                builder2.append(',');
            }
            if (withNames) {
                String paramName;
                String string = paramName = argumentNames != null ? argumentNames.get(i2) : "";
                if (paramName.isEmpty() && !argumentType.isVoid()) {
                    paramName = OCNameSuggester.suggestForParameter(createdNames, argumentType, arguments != null && i2 < arguments.size() ? arguments.get(i2) : null, this.myContext);
                }
                createdNames.add(paramName);
                builder2.append(OCElementFactory.declarationText(paramName, argumentType, this.myContext.getElement()));
                continue;
            }
            builder2.append(this.getName(argumentType));
        }
        builder2.append(')');
        return this.appendCVQualifiers(type, builder2.toString());
    }

    @Override
    public String visitMagicType(OCMagicType type) {
        String magicName = type.getMagicName();
        PsiFile file2 = this.myContext.getFile();
        return file2 instanceof OCFile && "<unknown>".equals(magicName) && ((OCFile)file2).getKind().isObjC() ? "id" : magicName;
    }

    @Override
    public String visitArrayType(OCArrayType type) {
        return this.getArrayTypeName(type, null);
    }

    @NotNull
    private String getArrayTypeName(OCArrayType type, @Nullable String modifier) {
        StringBuilder builder2 = new StringBuilder();
        OCType current = type;
        while (current instanceof OCArrayType) {
            OCArrayType arrayType = current;
            builder2.append("[");
            if (arrayType.getLengthSymbol() != null) {
                builder2.append(arrayType.getLengthSymbol().getPresentableName());
            }
            builder2.append("]");
            current = arrayType.getRefType();
        }
        if (modifier != null) {
            builder2.insert(0, modifier);
        }
        builder2.insert(0, this.getName(current));
        return builder2.toString();
    }

    @Override
    public String visitPointerType(OCPointerType type) {
        if (type.getTerminalType() instanceof OCFunctionType) {
            OCFunctionType ft = (OCFunctionType)type.getTerminalType();
            StringBuilder builder2 = new StringBuilder();
            builder2.append(ft.getReturnType().getName()).append(" (");
            StringBuilder asteriskBuilder = new StringBuilder();
            if (type.getClassQualifier() != null) {
                builder2.append(this.getName(type.getClassQualifier())).append("::");
            }
            OCType cur = type;
            while (cur instanceof OCPointerType) {
                asteriskBuilder.append(cur instanceof OCBlockPointerType ? (char)'^' : '*');
                cur = cur.getRefType();
            }
            for (int i2 = asteriskBuilder.length() - 1; i2 >= 0; --i2) {
                builder2.append(asteriskBuilder.charAt(i2));
            }
            builder2.append(')');
            String signature = this.getFunctionSignature(ft, builder2.toString());
            return this.appendCVQualifiers(type, signature);
        }
        String refCanonical = (type.getARCAttribute() != null ? type.getARCAttribute().getTokenName() + " " : "") + this.getName(type.getRefType());
        if (type instanceof OCBlockPointerType) {
            return "invalid_block_pointer: ^(" + refCanonical + ")";
        }
        if (type.getRefType() instanceof OCIdType) {
            return refCanonical;
        }
        String suffix = "*";
        if (type.getClassQualifier() != null) {
            suffix = type.getClassQualifier().getName() + "::" + suffix;
        }
        return this.appendCVQualifiers(type, refCanonical + " " + suffix);
    }

    @Override
    public String visitBlockPointerType(OCBlockPointerType type) {
        return this.visitPointerType(type);
    }

    @Override
    public String visitCppReferenceType(OCCppReferenceType type) {
        String modifier;
        String string = modifier = type.isRvalueRef() ? "&&" : "&";
        if (type.getTerminalType() instanceof OCFunctionType) {
            OCFunctionType ft = (OCFunctionType)type.getTerminalType();
            return this.getFunctionSignature(ft, this.getName(ft.getReturnType()) + " (" + modifier + ")");
        }
        if (type.getRefType() instanceof OCArrayType) {
            return this.getArrayTypeName((OCArrayType)type.getRefType(), " (" + modifier + ")");
        }
        String refCanonical = this.getName(type.getRefType());
        if (type.getRefType() instanceof OCIdType) {
            return refCanonical;
        }
        return this.appendCVQualifiers(type, refCanonical + " " + modifier);
    }

    @Override
    public String visitIdType(OCIdType type) {
        return this.visitObjectType(type);
    }

    @Override
    public String visitIntType(OCIntType type) {
        return this.appendCVQualifiers(type, type.getText());
    }

    @Override
    public String visitRealType(OCRealType type) {
        String result2;
        PsiFile file2 = this.myContext.getFile();
        if (file2 instanceof OCFile && type.isComplex()) {
            result2 = type.getText() + " _Complex";
            OCNamespaceLikeSymbol symbols = OCFileGlobalSymbolsCache.getInstance(file2.getProject()).lightTableForFile((OCFile)file2);
            if (!symbols.processMembers("complex", symbol -> !(symbol instanceof OCMacroSymbol))) {
                result2 = "complex " + type.getText();
            }
        } else {
            result2 = type.getText();
        }
        return this.appendCVQualifiers(type, result2);
    }

    @Override
    @Nullable
    protected String getCanonicalName(OCReferenceType type) {
        OCSymbolReference reference = type.getReference();
        OCQualifiedName qualifiedName = reference.getQualifiedName();
        return qualifiedName.getCanonicalName(this.myPresentation, true, this.myContext, this.myTemplateDepth);
    }

    @Override
    public String visitStructType(OCStructType type) {
        String baseName;
        OCStructSymbol symbol = type.getStructs().get(0);
        boolean addKind = this.myIsInOldC && !symbol.isUnnamed();
        boolean specializationAdded = false;
        if (this.myPresentation == OCType.Presentation.BEST) {
            String canonicalName;
            String name;
            if (this.myAliased && (name = this.getShortestQualifiedName(type, type.getAliasName())) != null) {
                return name;
            }
            OCQualifiedName resolvedName = symbol.getResolvedQualifiedName(this.myContext);
            List<OCTypeArgument> arguments = type.getResolvedArguments(this.myContext);
            if (!(arguments == null || resolvedName == null || resolvedName instanceof OCQualifiedNameWithArguments && ((OCQualifiedNameWithArguments)resolvedName).getArguments().size() <= arguments.size())) {
                resolvedName = new OCQualifiedNameWithArguments(resolvedName, arguments);
            }
            if (!symbol.isUnnamed() && resolvedName != null) {
                canonicalName = resolvedName.getCanonicalName(this.myPresentation, true, this.myContext, this.myTemplateDepth);
            } else {
                canonicalName = type.getCanonicalName(this.myContext);
                addKind = false;
            }
            specializationAdded = true;
            name = this.getShortestQualifiedName(type, canonicalName);
            baseName = name != null ? name : (canonicalName.startsWith("::") ? canonicalName.substring(2) : canonicalName);
        } else {
            String shortName;
            String string = this.myAliased && type.getTypedefName() != null ? type.getTypedefName() : (shortName = symbol.isUnnamed() ? "anonymous " + symbol.getKind().getNameLowercase() : symbol.getName());
            if (this.myPresentation == OCType.Presentation.FULL) {
                OCQualifiedName resolvedName = symbol.getResolvedQualifiedName(this.myContext);
                if (this.myIsInOldC && resolvedName != null) {
                    resolvedName = resolvedName.dropSuperQualifier();
                }
                OCQualifiedName qualifiedName = resolvedName != null ? resolvedName.changeName(shortName) : symbol.getQualifiedName();
                return OCTypeNameVisitor.getNameWithKind(symbol, qualifiedName.getCanonicalName(this.myPresentation, this.myIncludeGlobalQualifier, this.myContext, this.myTemplateDepth), addKind);
            }
            baseName = shortName;
        }
        OCTypeSubstitution substitution2 = symbol.getSubstitution();
        if (!specializationAdded && (substitution2 != OCTypeSubstitution.ID || symbol.isSpecialization())) {
            return this.appendCVQualifiers(type, OCTypeNameVisitor.getNameWithKind(symbol, this.getSubstitutedTypeName(baseName, symbol), false));
        }
        return this.appendCVQualifiers(type, OCTypeNameVisitor.getNameWithKind(symbol, baseName, addKind));
    }

    private static String getNameWithKind(OCStructSymbol symbol, String baseName, boolean addKind) {
        return addKind ? symbol.getKind().getNameLowercase() + " " + baseName : baseName;
    }

    @Override
    @NotNull
    protected List<OCTypeArgument> getTypeArguments(@NotNull OCTemplateSymbol symbol, @NotNull OCTypeNameVisitorBase.DefaultArgumentsRemovalStrategy defaultArgumentsRemovalStrategy) {
        return OCTypeNameVisitor.getTypeArguments(symbol, true, true, defaultArgumentsRemovalStrategy, this.myContext);
    }

    @Override
    protected String getNameForTypeArgument(OCTypeArgument argument) {
        return argument.getNameForPresentation(this.myPresentation, this.myContext, this.myIncludeGlobalQualifier, this.myTemplateDepth + 1);
    }

    @NotNull
    public static List<OCTypeArgument> getTypeArguments(@NotNull OCTemplateSymbol symbol, boolean resolveArguments, boolean appendNullArguments, @NotNull OCTypeNameVisitorBase.DefaultArgumentsRemovalStrategy defaultArgumentsRemovalStrategy, @NotNull OCResolveContext context2) {
        ArrayList<OCTypeArgument> arguments;
        block9: {
            int i2;
            OCTypeSubstitution substitution2;
            block8: {
                substitution2 = symbol.getSubstitution();
                if (resolveArguments) {
                    context2 = context2.substituteFirst(substitution2);
                }
                arguments = new ArrayList<OCTypeArgument>();
                List<OCTypeArgument> specialization = symbol.getTemplateSpecialization();
                if (specialization == null) break block8;
                for (OCTypeArgument argument : specialization) {
                    if (resolveArguments) {
                        arguments.add(OCSimpleTypeSubstitution.resolveTypeArgument(argument, context2));
                        continue;
                    }
                    arguments.add(argument);
                }
                break block9;
            }
            for (OCTypeParameterSymbol argument : symbol.getTemplateParameters()) {
                OCTypeArgument typeArgument = substitution2.getSubstitutionFor(argument);
                if (typeArgument == null && !appendNullArguments) continue;
                arguments.add(typeArgument);
            }
            if (defaultArgumentsRemovalStrategy == OCTypeNameVisitorBase.DefaultArgumentsRemovalStrategy.NONE) break block9;
            int removeArgumentsStartingFrom = defaultArgumentsRemovalStrategy == OCTypeNameVisitorBase.DefaultArgumentsRemovalStrategy.LAST_MATCH ? -1 : 0;
            for (i2 = arguments.size() - 1; i2 >= 0; --i2) {
                OCTypeParameterSymbol argument = symbol.getTemplateParameters().get(i2);
                OCTypeArgument typeArgument = (OCTypeArgument)arguments.get(i2);
                if (!(typeArgument instanceof OCType) || !(argument.getDefaultValue() instanceof OCType)) continue;
                OCType defValue = substitution2.substitute((OCType)argument.getDefaultValue(), context2).resolve(context2);
                OCTypeEqualityAfterResolvingVisitor eq = new OCTypeEqualityAfterResolvingVisitor(defValue, true, context2);
                if (((OCType)typeArgument).accept(eq).booleanValue()) {
                    if (defaultArgumentsRemovalStrategy != OCTypeNameVisitorBase.DefaultArgumentsRemovalStrategy.LAST_MATCH) continue;
                    removeArgumentsStartingFrom = i2;
                    continue;
                }
                if (defaultArgumentsRemovalStrategy != OCTypeNameVisitorBase.DefaultArgumentsRemovalStrategy.ALL_MATCH) break;
                removeArgumentsStartingFrom = -1;
                break;
            }
            if (removeArgumentsStartingFrom >= 0) {
                for (i2 = arguments.size() - 1; i2 >= removeArgumentsStartingFrom; --i2) {
                    arguments.remove(i2);
                }
            }
        }
        return arguments;
    }

    @Override
    public String visitUnknownType(OCUnknownType type) {
        return this.visitMagicType(type);
    }

    @Override
    public String visitVoidType(OCVoidType type) {
        return this.appendCVQualifiers(type, "void");
    }

    @Override
    public String visitTypeParameterType(OCTypeParameterType type) {
        return this.appendCVQualifiers(type, type.getSymbol().getName());
    }

    @Override
    public String visitAutoType(OCAutoType type) {
        return "auto";
    }

    @Override
    public String visitVariadicType(OCVariadicType type) {
        return this.getName(type.getUnderlyingType()) + "...";
    }

    @Override
    public String visitExpansionPackType(OCExpansionPackType type) {
        return StringUtil.join((Collection)ContainerUtil.map(type.getExpansions(), typeArgument -> typeArgument.getNameForPresentation(this.myPresentation, this.myContext, this.myIncludeGlobalQualifier, this.myTemplateDepth)), (String)", ");
    }

    @Override
    public String visitBracedInitListType(OCBracedInitListType type) {
        return "<braced-init-list>";
    }
}

