/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCBracedInitListType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCDeferredType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCExpansionPackType;
import com.jetbrains.cidr.lang.types.OCExpressionTypeArgument;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCStructuredBindingType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeUnificationVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTypeEqualityVisitor
implements OCTypeVisitor<Boolean> {
    protected OCType myType;
    private final boolean myAssumeMagicTypesEquals;
    private boolean myAssumeDifferentSubstitutionsEquals = false;
    protected final boolean myDontCheckCV;
    @NotNull
    protected final OCResolveContext myContext;
    private boolean myAssumeUnknownTypesEqual = false;
    private boolean myIsMagicallyEquals = false;

    public OCTypeEqualityVisitor(OCType type, boolean magicTypesEquals, boolean dontCheckCV, @NotNull OCResolveContext context2) {
        this.myType = type;
        this.myAssumeMagicTypesEquals = magicTypesEquals;
        this.myDontCheckCV = dontCheckCV;
        this.myContext = context2;
    }

    public OCTypeEqualityVisitor(OCType type, boolean assumeMagicTypesEquals, @NotNull OCResolveContext context2) {
        this(type, assumeMagicTypesEquals, false, context2);
    }

    public void setAssumeUnknownTypesEqual(boolean assumeUnknownTypesEqual) {
        this.myAssumeUnknownTypesEqual = assumeUnknownTypesEqual;
    }

    public void setAssumeDifferentSubstitutionsEquals(boolean assumeDifferentSubstitutionsEquals) {
        this.myAssumeDifferentSubstitutionsEquals = assumeDifferentSubstitutionsEquals;
    }

    public boolean equal(OCType type) {
        return this.equal(type, !this.myDontCheckCV);
    }

    public boolean equal(OCType type, boolean checkCV) {
        if (checkCV && this.myType.isConst() != type.isConst()) {
            return false;
        }
        if (this.myAssumeMagicTypesEquals && (OCTypeEqualityVisitor.isMagic(this.myType) || OCTypeEqualityVisitor.isMagic(type))) {
            this.myIsMagicallyEquals = true;
            return true;
        }
        if (this.myAssumeUnknownTypesEqual && this.myType.isUnknown()) {
            return true;
        }
        if (checkCV && this.myType.isVolatile() != type.isVolatile()) {
            return false;
        }
        return type.accept(this);
    }

    private static boolean isMagic(@Nullable OCTypeArgument argument) {
        OCTypeArgument unwrapped = OCTypeEqualityVisitor.unwrapVariadic(argument);
        return unwrapped instanceof OCMagicType || unwrapped instanceof OCAutoType;
    }

    protected boolean equal(@NotNull OCType type1, @NotNull OCType type2) {
        return this.equal(type1, type2, !this.myDontCheckCV);
    }

    protected boolean equal(@NotNull OCType type1, @NotNull OCType type2, boolean checkConst) {
        OCType save2 = this.myType;
        this.myType = type2;
        boolean equal = this.equal(type1, checkConst);
        this.myType = save2;
        return equal;
    }

    @Override
    public Boolean visitEllipsisReferenceType(OCEllipsisType type) {
        return this.myType != null && type.getClass() == this.myType.getClass();
    }

    @Override
    public Boolean visitFunctionType(OCFunctionType type) {
        if (type == this.myType) {
            return true;
        }
        if (this.myType == null || type.getClass() != this.myType.getClass()) {
            return false;
        }
        OCFunctionType that = (OCFunctionType)this.myType;
        if (!this.isFunctionSignatureEqual(type)) {
            return false;
        }
        if (!this.equal(type.getReturnType(), that.getReturnType(), !this.myDontCheckCV)) {
            return false;
        }
        return true;
    }

    public boolean isFunctionSignatureEqual(OCType type) {
        if (!(type instanceof OCFunctionType)) {
            return false;
        }
        if (!(this.myType instanceof OCFunctionType)) {
            return false;
        }
        if (this.myType.isConst() != type.isConst()) {
            return false;
        }
        if (this.myType.isVolatile() != type.isVolatile()) {
            return false;
        }
        OCFunctionType thisFun = (OCFunctionType)type;
        OCFunctionType thatFun = (OCFunctionType)this.myType;
        List<OCType> myArgumentTypes = thisFun.getParameterTypes();
        List<OCType> thatArgumentTypes = thatFun.getParameterTypes();
        if (((OCFunctionType)type).isLValueRef() != ((OCFunctionType)this.myType).isLValueRef()) {
            return false;
        }
        if (((OCFunctionType)type).isRValueRef() != ((OCFunctionType)this.myType).isRValueRef()) {
            return false;
        }
        if (myArgumentTypes.size() != thatArgumentTypes.size()) {
            return false;
        }
        if (thisFun.isVararg() != thatFun.isVararg()) {
            return false;
        }
        for (int i2 = 0; i2 < myArgumentTypes.size(); ++i2) {
            if (this.equal(myArgumentTypes.get(i2), thatArgumentTypes.get(i2), false)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Boolean visitMagicType(OCMagicType type) {
        if (this.myType == null || type.getClass() != this.myType.getClass()) {
            return false;
        }
        return this.myType == type || ((OCMagicType)this.myType).getMagicName().equals(type.getMagicName());
    }

    @Override
    public Boolean visitTypeParameterType(OCTypeParameterType type) {
        if (this.myType == null || type.getClass() != this.myType.getClass()) {
            return false;
        }
        return this.myType == type || ((OCTypeParameterType)this.myType).getSymbol().equals(type.getSymbol()) && type.getSymbol().isSynthetic() == ((OCTypeParameterType)this.myType).getSymbol().isSynthetic() && this.visitMagicType(type) != false;
    }

    @Override
    public Boolean visitAutoType(OCAutoType type) {
        if (type == this.myType) {
            return true;
        }
        if (this.myType == null || type.getClass() != this.myType.getClass()) {
            return false;
        }
        OCAutoType that = (OCAutoType)this.myType;
        if (!Comparing.equal((Object)type.getExpressionSymbol(), (Object)that.getExpressionSymbol())) {
            return false;
        }
        OCType incompleteType1 = type.getIncompleteType();
        OCType incompleteType2 = that.getIncompleteType();
        if (!(incompleteType1 == null && incompleteType2 == null || incompleteType1 != null && incompleteType1.equals(incompleteType2, this.myContext))) {
            return false;
        }
        OCTypeSubstitution substitution1 = type.getSubstitution();
        OCTypeSubstitution substitution2 = that.getSubstitution();
        if (!(type.getExpressionSymbol() == null || substitution1 == null && substitution2 == null || substitution1 != null && substitution1.equals(substitution2))) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visitObjectType(OCObjectType type) {
        if (type == this.myType) {
            return true;
        }
        if (this.myType == null || type.getClass() != this.myType.getClass()) {
            return false;
        }
        OCObjectType that = (OCObjectType)this.myType;
        if (!Comparing.equal((Object)type.getInterface(), (Object)that.getInterface())) {
            return false;
        }
        if (!Comparing.equal((Object)type.getImplementation(), (Object)that.getImplementation())) {
            return false;
        }
        if (!type.getAllProtocols().equals(that.getAllProtocols())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visitArrayType(OCArrayType type) {
        if (this.myType == type) {
            return true;
        }
        if (this.myType == null || type.getClass() != this.myType.getClass()) {
            return false;
        }
        OCArrayType that = (OCArrayType)this.myType;
        if (type.hasLength() && that.hasLength() && type.getLength(this.myContext) != that.getLength(this.myContext)) {
            return false;
        }
        if (type.getARCAttribute() != that.getARCAttribute()) {
            return false;
        }
        if (!this.equal(type.getRefType(), that.getRefType())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visitPointerType(OCPointerType type) {
        if (this.myType == type) {
            return true;
        }
        if (this.myType == null || type.getClass() != this.myType.getClass()) {
            return false;
        }
        OCPointerType that = (OCPointerType)this.myType;
        if (type.getARCAttribute() != that.getARCAttribute()) {
            return false;
        }
        if (!this.equal(type.getRefType(), that.getRefType(), true)) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visitBlockPointerType(OCBlockPointerType type) {
        if (this.myType == null || type.getClass() != this.myType.getClass()) {
            return false;
        }
        return this.visitPointerType(type);
    }

    @Override
    public Boolean visitCppReferenceType(OCCppReferenceType type) {
        if (this.myType == type) {
            return true;
        }
        if (this.myType == null || type.getClass() != this.myType.getClass()) {
            return false;
        }
        OCCppReferenceType that = (OCCppReferenceType)this.myType;
        if (!this.equal(type.getRefType(), that.getRefType(), true)) {
            return false;
        }
        if (type.isRvalueRef() != that.isRvalueRef()) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visitIdType(OCIdType type) {
        if (this.myType == null || type.getClass() != this.myType.getClass()) {
            return false;
        }
        return this.visitObjectType(type);
    }

    @Override
    public Boolean visitIntType(OCIntType type) {
        if (type == this.myType) {
            return true;
        }
        if (this.myType == null || type.getClass() != this.myType.getClass()) {
            return false;
        }
        OCIntType ocIntType = (OCIntType)this.myType;
        if (type.isSigned() != ocIntType.isSigned()) {
            return false;
        }
        if (!type.getCTypeId().equals((Object)ocIntType.getCTypeId())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visitRealType(OCRealType type) {
        if (this.myType == null || type.getClass() != this.myType.getClass()) {
            return false;
        }
        return type.getCTypeId().equals((Object)((OCRealType)this.myType).getCTypeId()) && type.isComplex() == ((OCRealType)this.myType).isComplex();
    }

    @Override
    public Boolean visitReferenceType(OCReferenceType type) {
        if (type == this.myType) {
            return true;
        }
        if (this.myType == null || type.getClass() != this.myType.getClass()) {
            return false;
        }
        OCReferenceType that = (OCReferenceType)this.myType;
        if (!Arrays.equals(type.getProtocolNames(), that.getProtocolNames())) {
            return false;
        }
        if (!type.getReference().equals(that.getReference())) {
            return false;
        }
        if (!type.getSubstitution().equals(that.getSubstitution())) {
            return false;
        }
        if (type.getARCAttribute() != that.getARCAttribute()) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visitStructType(OCStructType type) {
        if (this.myType == null || type.getClass() != this.myType.getClass()) {
            return false;
        }
        ProgressManager.checkCanceled();
        OCStructType myStructType = (OCStructType)this.myType;
        if (type.getTypedefName() != null && myStructType.getTypedefName() != null && !type.getTypedefName().equals(myStructType.getTypedefName())) {
            return false;
        }
        Map map2 = FactoryMap.create(symbol -> symbol.getType().getName());
        Function namer = symbol -> (String)map2.get(symbol);
        HashSet<String> names = new HashSet<String>(ContainerUtil.map(type.getStructs(), (Function)namer));
        names.retainAll(ContainerUtil.map(myStructType.getStructs(), (Function)namer));
        OCStructSymbol thatStruct = OCTypeEqualityVisitor.getTopmostStruct(type.getStructs(), names, (Function<OCStructSymbol, String>)namer, this.myContext);
        OCStructSymbol myStruct = OCTypeEqualityVisitor.getTopmostStruct(myStructType.getStructs(), names, (Function<OCStructSymbol, String>)namer, this.myContext);
        if (thatStruct == myStruct) {
            return true;
        }
        if (thatStruct.isUnnamed() && myStruct.isUnnamed()) {
            return thatStruct.equals(myStruct);
        }
        if (!thatStruct.resolvedNamesEqual(this.myContext.getProject(), myStruct)) {
            return false;
        }
        if (this.myAssumeDifferentSubstitutionsEquals) {
            return true;
        }
        List<OCTypeArgument> thatStructArgs = thatStruct.getTemplateArguments(this.myContext);
        List<OCTypeArgument> myStructArgs = myStruct.getTemplateArguments(this.myContext);
        if (thatStructArgs.size() != myStructArgs.size()) {
            return false;
        }
        Iterator<OCTypeArgument> thatIterator = thatStructArgs.iterator();
        Iterator<OCTypeArgument> myIterator = myStructArgs.iterator();
        while (thatIterator.hasNext() && myIterator.hasNext()) {
            OCTypeArgument thatSubst = thatIterator.next();
            OCTypeArgument mySubst = myIterator.next();
            if (thatSubst == null || thatSubst instanceof OCUnknownType || mySubst == null || mySubst instanceof OCUnknownType) {
                OCSymbolWithQualifiedName functionSymbol;
                OCFunctionDeclaration containingFunction = (OCFunctionDeclaration)PsiTreeUtil.getParentOfType((PsiElement)this.myContext.getElement(), OCFunctionDeclaration.class);
                OCSymbolWithQualifiedName oCSymbolWithQualifiedName = functionSymbol = containingFunction != null ? (OCSymbolWithQualifiedName)containingFunction.getSymbol() : null;
                if (functionSymbol != null && functionSymbol.getResolvedOwner(this.myContext) == myStruct) continue;
            }
            if (this.myAssumeMagicTypesEquals && mySubst instanceof OCType && thatSubst instanceof OCType && (OCTypeEqualityVisitor.isMagic(mySubst) || OCTypeEqualityVisitor.isMagic(thatSubst))) {
                this.myIsMagicallyEquals = true;
                continue;
            }
            if (thatSubst instanceof OCType && mySubst instanceof OCType) {
                if (this.substitutionTypesEqual((OCType)thatSubst, (OCType)mySubst, this.myContext).booleanValue()) continue;
                return false;
            }
            if (thatSubst instanceof OCType || mySubst instanceof OCType) {
                return false;
            }
            if (thatSubst instanceof OCExpressionTypeArgument && mySubst instanceof OCExpressionTypeArgument) {
                Number myValue;
                if (thatSubst.equals(mySubst, this.myContext)) {
                    return true;
                }
                Number thatValue = OCExpressionEvaluator.evaluate(((OCExpressionTypeArgument)thatSubst).getSymbol(), this.myContext);
                if (OCTypeUnificationVisitor.isSameValue(thatValue, myValue = OCExpressionEvaluator.evaluate(((OCExpressionTypeArgument)mySubst).getSymbol(), this.myContext))) continue;
                return false;
            }
            if (Comparing.equal((Object)thatSubst, (Object)mySubst)) continue;
            return false;
        }
        if (thatIterator.hasNext()) {
            return false;
        }
        if (myIterator.hasNext()) {
            return false;
        }
        return true;
    }

    @Nullable
    private static OCTypeArgument unwrapVariadic(@Nullable OCTypeArgument type) {
        return type instanceof OCVariadicType ? ((OCVariadicType)type).getUnderlyingType() : type;
    }

    protected Boolean substitutionTypesEqual(OCType thatSust, OCType mySust, @NotNull OCResolveContext context2) {
        return new OCTypeEqualityVisitor(mySust, this.myAssumeMagicTypesEquals, false, this.myContext).equal(thatSust);
    }

    public boolean isMagicallyEquals() {
        return this.myIsMagicallyEquals;
    }

    private static OCStructSymbol getTopmostStruct(List<OCStructSymbol> structs, Set<String> names, Function<OCStructSymbol, String> namer, @NotNull OCResolveContext context2) {
        if (structs.size() == 1) {
            return structs.get(0);
        }
        for (OCStructSymbol struct : structs) {
            if (struct.isPredeclaration() || !names.contains(namer.fun((Object)struct))) continue;
            return struct;
        }
        int size = Integer.MAX_VALUE;
        OCStructSymbol result2 = null;
        for (OCStructSymbol symbol : structs) {
            OCQualifiedName name = symbol.getResolvedQualifiedName(false, false, context2);
            if (name == null || name.flatten().size() >= size) continue;
            result2 = symbol;
            size = name.flatten().size();
        }
        return result2;
    }

    @Override
    public Boolean visitVariadicType(OCVariadicType type) {
        if (this.myType == type) {
            return true;
        }
        if (this.myType == null || type.getClass() != this.myType.getClass()) {
            return false;
        }
        OCVariadicType that = (OCVariadicType)this.myType;
        return this.equal(type.getUnderlyingType(), that.getUnderlyingType(), true);
    }

    @Override
    public Boolean visitExpansionPackType(OCExpansionPackType type) {
        if (this.myType == type) {
            return true;
        }
        if (this.myType == null || type.getClass() != this.myType.getClass()) {
            return false;
        }
        OCExpansionPackType that = (OCExpansionPackType)this.myType;
        return DeepEqual.equalObjects(type.getExpansions(), that.getExpansions());
    }

    @Override
    public Boolean visitBracedInitListType(OCBracedInitListType type) {
        return this.myType != null && type.getClass() == this.myType.getClass();
    }

    @Override
    public Boolean visitUnknownType(OCUnknownType type) {
        return this.myType != null && type.getClass() == this.myType.getClass();
    }

    @Override
    public Boolean visitVoidType(OCVoidType type) {
        return this.myType != null && type.getClass() == this.myType.getClass();
    }

    @Override
    public Boolean visitStructuredBindingType(OCStructuredBindingType type) {
        if (this.myType == type) {
            return true;
        }
        if (this.myType == null || type.getClass() != this.myType.getClass()) {
            return false;
        }
        OCStructuredBindingType that = (OCStructuredBindingType)this.myType;
        if (type.getDeclaratorIndex() != that.getDeclaratorIndex()) {
            return false;
        }
        if (type.isInForeachStatement() != that.isInForeachStatement()) {
            return false;
        }
        if (!Comparing.equal((Object)type.getInitializerSymbol(), (Object)that.getInitializerSymbol())) {
            return false;
        }
        if (!Comparing.equal((Object)type.getInitializerElement(), (Object)that.getInitializerElement())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visitDeferredType(OCDeferredType type) {
        return this.myType == type || this.myType instanceof OCDeferredType && type.equalsDeferredType((OCDeferredType)this.myType);
    }
}

