/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.intellij.openapi.project.Project;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCLocalFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceLikeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCBracedInitListType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCDeferredType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCExpansionPackType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCStructuredBindingType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCArgumentDepLookupAccumulator
implements OCTypeVisitor<Void> {
    @NotNull
    private final Project myProject;
    private final HashSet<OCSymbolWithQualifiedName> mySymbols = new HashSet();

    public OCArgumentDepLookupAccumulator(@NotNull Project project2) {
        this.myProject = project2;
    }

    public HashSet<OCSymbolWithQualifiedName> getAccumulatedSymbols() {
        return this.mySymbols;
    }

    public void visitTypes(Collection<OCType> arguments) {
        for (OCType argument : arguments) {
            argument.accept(this);
        }
    }

    @Override
    @Nullable
    public Void visitEllipsisReferenceType(OCEllipsisType type) {
        return null;
    }

    @Override
    @Nullable
    public Void visitFunctionType(OCFunctionType type) {
        type.getReturnType().accept(this);
        for (OCType arg : type.getParameterTypes()) {
            arg.accept(this);
        }
        return null;
    }

    @Override
    @Nullable
    public Void visitMagicType(OCMagicType type) {
        return null;
    }

    @Override
    @Nullable
    public Void visitObjectType(OCObjectType type) {
        return null;
    }

    @Override
    @Nullable
    public Void visitArrayType(OCArrayType type) {
        return type.getRefType().accept(this);
    }

    @Override
    @Nullable
    public Void visitPointerType(OCPointerType type) {
        return type.getRefType().accept(this);
    }

    @Override
    @Nullable
    public Void visitBlockPointerType(OCBlockPointerType type) {
        return type.getRefType().accept(this);
    }

    @Override
    @Nullable
    public Void visitCppReferenceType(OCCppReferenceType type) {
        return type.getRefType().accept(this);
    }

    @Override
    public Void visitVariadicType(OCVariadicType type) {
        return type.getUnderlyingType().accept(this);
    }

    @Override
    public Void visitExpansionPackType(OCExpansionPackType type) {
        for (OCTypeArgument argument : type.getExpansions()) {
            if (!(argument instanceof OCType)) continue;
            ((OCType)argument).accept(this);
        }
        return null;
    }

    @Override
    public Void visitBracedInitListType(OCBracedInitListType type) {
        return null;
    }

    @Override
    @Nullable
    public Void visitIdType(OCIdType type) {
        return null;
    }

    @Override
    @Nullable
    public Void visitIntType(OCIntType type) {
        return null;
    }

    @Override
    @Nullable
    public Void visitRealType(OCRealType type) {
        return null;
    }

    @Override
    @Nullable
    public Void visitReferenceType(OCReferenceType type) {
        return null;
    }

    @Override
    @Nullable
    public Void visitStructType(OCStructType type) {
        for (OCStructSymbol struct : type.getStructs()) {
            this.mySymbols.add(struct.getParent());
            OCFile file2 = struct.getContainingOCFile(this.myProject);
            if (file2 != null) {
                struct.processBaseClasses(OCResolveContext.forPsi(file2), (symbol, visibility) -> {
                    if (symbol instanceof OCStructSymbol) {
                        this.mySymbols.add(((OCStructSymbol)symbol).getParent());
                    }
                    return true;
                });
            }
            for (OCTypeParameterSymbol param : struct.getTemplateParameters()) {
                OCTypeArgument subst = struct.getSubstitution().getSubstitutionFor(param);
                if (!(subst instanceof OCType)) continue;
                ((OCType)subst).accept(this);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Void visitUnknownType(OCUnknownType type) {
        return null;
    }

    @Override
    @Nullable
    public Void visitVoidType(OCVoidType type) {
        return null;
    }

    @Override
    @Nullable
    public Void visitTypeParameterType(OCTypeParameterType type) {
        return null;
    }

    @Override
    @Nullable
    public Void visitAutoType(OCAutoType type) {
        return null;
    }

    @Override
    @Nullable
    public Void visitStructuredBindingType(OCStructuredBindingType type) {
        return null;
    }

    @Override
    @Nullable
    public Void visitDeferredType(OCDeferredType type) {
        return null;
    }

    public static Collection<OCSymbol> doArgDepLookup(Collection<OCSymbol> symbols, List<OCType> types, List<? extends OCExpression> args, OCQualifiedName name, OCResolveContext context2) {
        boolean hasLocalFunctions = false;
        boolean noArgDepLookup = false;
        for (OCSymbol symbol : symbols) {
            if (symbol instanceof OCLocalFunctionSymbol) {
                hasLocalFunctions = true;
                noArgDepLookup = true;
                continue;
            }
            if (symbol instanceof OCFunctionSymbol && !((OCFunctionSymbol)symbol).isFriend() && ((OCFunctionSymbol)symbol).getResolvedOwner(context2, false) instanceof OCStructSymbol) {
                noArgDepLookup = true;
                continue;
            }
            if (symbol instanceof OCFunctionSymbol || symbol instanceof OCStructSymbol) continue;
            noArgDepLookup = true;
        }
        OCArgumentDepLookupAccumulator acc = new OCArgumentDepLookupAccumulator(context2.getProject());
        acc.visitTypes(types);
        CommonProcessors.CollectProcessor<OCSymbol> collector = new CommonProcessors.CollectProcessor<OCSymbol>(new LinkedHashSet(hasLocalFunctions ? ContainerUtil.filter((Collection)symbols, s -> s instanceof OCLocalFunctionSymbol) : symbols)){

            protected boolean accept(OCSymbol symbol) {
                return symbol instanceof OCFunctionSymbol;
            }
        };
        for (OCType oCType : types) {
            if (!(oCType.getTerminalType() instanceof OCStructType)) continue;
            OCStructType.processMembersOfNamespace(((OCStructType)oCType.getTerminalType()).getSymbol(), name.getName(), false, false, (Processor<? super OCSymbol>)((Processor)arg_0 -> OCArgumentDepLookupAccumulator.lambda$doArgDepLookup$2((CommonProcessors.CollectProcessor)collector, arg_0)), context2);
        }
        if (noArgDepLookup) {
            return collector.getResults();
        }
        for (OCExpression oCExpression : args) {
            OCReferenceElement ref = null;
            OCExpression oCExpression2 = OCParenthesesUtils.diveIntoParentheses(oCExpression);
            if (oCExpression2 instanceof OCUnaryExpression) {
                OCUnaryExpression unary = (OCUnaryExpression)oCExpression2;
                if (unary.isGetAddress() && unary.getOperand() instanceof OCReferenceExpression) {
                    OCReferenceExpression operand = (OCReferenceExpression)unary.getOperand();
                    ref = operand.getReferenceElement();
                }
            } else if (oCExpression2 instanceof OCReferenceExpression) {
                ref = ((OCReferenceExpression)oCExpression2).getReferenceElement();
            } else if (oCExpression2 instanceof OCReferenceElement) {
                ref = (OCReferenceElement)((Object)oCExpression2);
            }
            if (ref == null) continue;
            for (OCSymbol overload : ref.resolveToOverloadsSymbols()) {
                if (!(overload instanceof OCFunctionSymbol)) continue;
                overload.getResolvedType(context2).accept(acc);
            }
        }
        HashSet processed = new HashSet();
        for (OCSymbolWithQualifiedName parentSymbol : acc.getAccumulatedSymbols()) {
            if (parentSymbol == null) {
                OCStructType.processMembersOfNamespace(((OCFile)context2.getFile()).getMembersContainer(false), name.getName(), false, false, (Processor<? super OCSymbol>)collector, context2);
                continue;
            }
            if (!(parentSymbol instanceof OCNamespaceLikeSymbol) || name.getQualifier() != null) continue;
            parentSymbol.processSameSymbols((Processor<OCSymbol>)((Processor)arg_0 -> OCArgumentDepLookupAccumulator.lambda$doArgDepLookup$3(processed, name, (CommonProcessors.CollectProcessor)collector, context2, arg_0)), context2.getFile(), context2.getProject());
        }
        return collector.getResults();
    }

    private static /* synthetic */ boolean lambda$doArgDepLookup$3(HashSet processed, OCQualifiedName name, CommonProcessors.CollectProcessor collector, OCResolveContext context2, OCSymbol symbol) {
        if (processed.add(symbol) && symbol instanceof OCNamespaceLikeSymbol) {
            OCStructType.processMembersOfNamespace((OCNamespaceLikeSymbol)((Object)symbol), name.getName(), false, false, (Processor<? super OCSymbol>)collector, context2);
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$doArgDepLookup$2(CommonProcessors.CollectProcessor collector, OCSymbol symbol) {
        return !(symbol instanceof OCSymbolWithQualifiedName) || !((OCSymbolWithQualifiedName)symbol).isFriend() || collector.process((Object)symbol);
    }
}

