/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import org.jetbrains.annotations.NotNull;

public class OCCppReferenceType
extends OCType {
    private OCType myRefType;
    private boolean myRvalueRef;

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCCppReferenceType f = (OCCppReferenceType)first;
        OCCppReferenceType s = (OCCppReferenceType)second;
        if (f.myRvalueRef != s.myRvalueRef) {
            return false;
        }
        return c.equalObjects(f.myRefType, s.myRefType);
    }

    public OCCppReferenceType() {
    }

    public static OCCppReferenceType to(@NotNull OCType ref) {
        return OCCppReferenceType.to(ref, false, false, false);
    }

    public static OCCppReferenceType rvalue(@NotNull OCType ref) {
        return OCCppReferenceType.to(ref, true, false, false);
    }

    public static OCCppReferenceType to(@NotNull OCType ref, boolean isRvalueRef, boolean isConst, boolean isVolatile) {
        if (ref instanceof OCCppReferenceType) {
            if (isRvalueRef) {
                isConst = ref.isConst();
                isVolatile = ref.isVolatile();
                isRvalueRef = ((OCCppReferenceType)ref).isRvalueRef();
            } else {
                isVolatile = false;
                isConst = false;
                isRvalueRef = false;
            }
            ref = ((OCCppReferenceType)ref).getRefType();
        }
        return new OCCppReferenceType(ref, isRvalueRef, isConst, isVolatile);
    }

    private OCCppReferenceType(OCType ref, boolean isRvalueRef, boolean isConst, boolean isVolatile) {
        super(isConst, isVolatile);
        this.myRefType = ref;
        this.myRvalueRef = isRvalueRef;
    }

    @Override
    public <T> T accept(OCTypeVisitor<T> visitor) {
        return visitor.visitCppReferenceType(this);
    }

    public boolean isReferenceToConst() {
        return this.myRefType.isConst() || this.myRefType instanceof OCArrayType;
    }

    public boolean isRvalueRef() {
        return this.myRvalueRef;
    }

    @NotNull
    public OCType getRefType() {
        return this.myRefType;
    }

    @NotNull
    public OCType getRefType(PsiElement context2) {
        return this.myRefType.isBetterAliasName(this, this.myAliasName, this.myRefType.getAliasName(), OCResolveContext.forPsi(context2)) ? this.myRefType.cloneWithAliasName(this.myAliasName) : this.myRefType;
    }

    @Override
    @NotNull
    public OCType getTerminalType() {
        return this.myRefType.getTerminalType();
    }

    @Override
    public int pointersDepth() {
        return this.myRefType.pointersDepth();
    }

    @Override
    public boolean isMagicInside(@NotNull OCResolveContext context2) {
        return this.myRefType.isMagicInside(context2);
    }

    @Override
    public boolean isSubclassOfMagic(@NotNull OCResolveContext context2) {
        return this.myRefType.isSubclassOfMagic(context2);
    }

    @Override
    public boolean isUnknown() {
        return this.myRefType.isUnknown();
    }

    @Override
    public boolean isUnresolved(@NotNull OCResolveContext context2) {
        return this.myRefType.isUnresolved(context2);
    }

    @Override
    @NotNull
    public OCType getGuessedUnmagicType() {
        return OCCppReferenceType.to(this.myRefType.getGuessedUnmagicType());
    }

    @Override
    public int hashCode() {
        return this.baseHashCode() * 31 + this.myRefType.hashCode();
    }

    @Override
    public boolean isPointerCompatible(@NotNull OCResolveContext context2, boolean checkCppConvertible) {
        return true;
    }

    @Override
    @NotNull
    protected OCType doGetLeastCommonType(OCType type, @NotNull OCResolveContext context2) {
        if (type == null) {
            return OCUnknownType.INSTANCE;
        }
        if (this.equals(type, context2)) {
            return this;
        }
        if (type instanceof OCMagicType) {
            return type;
        }
        return OCCppReferenceType.to(this.myRefType.getLeastCommonType(type, context2));
    }

    @Override
    public boolean isScalar() {
        return this.myRefType.isScalar();
    }

    @Override
    public boolean isCppStructType(@NotNull OCCompilationContext context2) {
        return this.myRefType.isCppStructType(context2);
    }

    @Override
    public boolean isInstanceable() {
        return true;
    }

    @Override
    public boolean isIntegerCompatible(@NotNull OCResolveContext context2, boolean checkCppConvertible) {
        return this.myRefType.isIntegerCompatible(context2, checkCppConvertible);
    }

    @Override
    public boolean isPointerToObject() {
        return this.myRefType.isPointerToObject();
    }

    @Override
    public boolean isPointerToCppStructType(@NotNull OCCompilationContext context2) {
        return this.myRefType.isPointerToCppStructType(context2);
    }

    @Override
    public boolean isPointerToID(boolean withProtocols) {
        return this.myRefType.isPointerToID(withProtocols);
    }

    @Override
    public boolean isPointerToChar() {
        return this.myRefType.isPointerToChar();
    }

    @Override
    public boolean isCString() {
        return this.myRefType.isCString();
    }

    @Override
    public boolean isPointerToObjectCompatible() {
        return this.myRefType.isPointerToObject() || this.myRefType.isClassType() || this.myRefType instanceof OCBlockPointerType;
    }

    @Override
    public boolean isPointerToPointerToObjectCompatible() {
        return this.myRefType.isPointerToObjectCompatible() || this.myRefType instanceof OCPointerType && ((OCPointerType)this.myRefType).getRefType().isPointerToPointerToObjectCompatible();
    }

    @Override
    public boolean isPointer() {
        return this.myRefType.isPointer();
    }

    @Override
    public boolean isClassType(boolean withProtocols) {
        return this.myRefType.isClassType(withProtocols);
    }

    @Override
    @NotNull
    public String getDefaultValue(@NotNull OCResolveContext context2) {
        return "<#initializer#>";
    }

    @Override
    public String getFormatString() {
        return this.myRefType.getFormatString();
    }
}

