/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.jetbrains.cidr.lang.symbols.OCAttributes;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum MachineModeAttribute {
    QI(1, true),
    HI(2, true),
    SI(4, true),
    DI(8, true),
    TI(16, true),
    SF(4, false),
    DF(8, false),
    TF(16, false);

    private final short mySizeInBytes;
    private final boolean myIsIntegralType;

    private MachineModeAttribute(short sizeInBytes, boolean isIntegralType) {
        this.mySizeInBytes = sizeInBytes;
        this.myIsIntegralType = isIntegralType;
    }

    public short getSizeInBytes() {
        return this.mySizeInBytes;
    }

    public boolean isIntegralType() {
        return this.myIsIntegralType;
    }

    @Nullable
    public static MachineModeAttribute forModeAttributeParameter(@NotNull String mode) {
        mode = OCAttributes.trimUnderscores(mode);
        try {
            return MachineModeAttribute.valueOf(mode);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Nullable
    public static MachineModeAttribute getModeAttribute(@NotNull Collection<String> attributes) {
        String mode = OCAttributes.getAttributeParameter(attributes, "mode");
        return mode == null ? null : MachineModeAttribute.forModeAttributeParameter(mode);
    }
}

