/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable.serialization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.jetbrains.cidr.lang.CustomHeaderProvider;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.FileSymbolTableSerializer;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.MaybeFileOwnerSerializer;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.OCSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCIncludeSerializer
extends MaybeFileOwnerSerializer<OCIncludeSymbol> {
    @NotNull
    private final FileSymbolTableSerializer mySerializer;

    public OCIncludeSerializer(@NotNull FileSymbolTableSerializer serializer2) {
        super(serializer2, OCIncludeSymbol.class);
        this.mySerializer = serializer2;
    }

    @Override
    public void write(@NotNull Kryo kryo, @NotNull Output output, @NotNull OCIncludeSymbol object) {
        super.write(kryo, output, object);
        VirtualFile targetFile = object.getTargetFile();
        OCIncludeSerializer.writeTargetFile(output, targetFile);
    }

    public static void writeTargetFile(@NotNull Output output, @Nullable VirtualFile targetFile) {
        String path;
        int id;
        if (targetFile != null && targetFile.isValid()) {
            if (targetFile instanceof VirtualFileWithId) {
                id = ((VirtualFileWithId)targetFile).getId();
                path = targetFile.getPath();
            } else {
                id = -1;
                path = CustomHeaderProvider.provideSerializationPathForFile(targetFile);
                if (path == null) {
                    OCSerializer.LOG.error("only LocalVirtualFiles are supported: " + targetFile.getClass() + ": " + targetFile);
                }
            }
        } else {
            id = -1;
            path = null;
        }
        output.writeInt(id, true);
        output.writeString(path);
    }

    public OCIncludeSymbol read(@NotNull Kryo kryo, @NotNull Input input, Class<OCIncludeSymbol> type) {
        OCIncludeSymbol include = (OCIncludeSymbol)super.read(kryo, input, type);
        VirtualFile targetFile = OCIncludeSerializer.readTargetFile(input, this.mySerializer);
        include.updateTargetFile(targetFile);
        return include;
    }

    @Nullable
    public static VirtualFile readTargetFile(@NotNull Input input, @NotNull FileSymbolTableSerializer serializer2) {
        int fileId = input.readInt(true);
        String path = input.readString();
        VirtualFile targetFile = null;
        if (fileId != -1) {
            targetFile = PersistentFS.getInstance().findFileById(fileId);
        }
        if (!(path == null || targetFile != null && FileUtil.pathsEqual((String)path, (String)targetFile.getPath()) || (targetFile = LocalFileSystem.getInstance().findFileByPath(path)) != null)) {
            targetFile = CustomHeaderProvider.getCustomHeaderFile(path, serializer2.getProject(), serializer2.getCurrentFile());
        }
        return targetFile;
    }
}

