/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable.serialization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.symbols.MaybeVirtualFileOwner;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.FileSymbolTableSerializer;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.OCSerializer;
import org.jetbrains.annotations.NotNull;

public class MaybeFileOwnerSerializer<T extends MaybeVirtualFileOwner>
extends FieldSerializer<T> {
    private final FileSymbolTableSerializer mySerializer;

    public MaybeFileOwnerSerializer(@NotNull FileSymbolTableSerializer serializer2, @NotNull Class<T> symbolClass) {
        super((Kryo)serializer2.getKryo(), symbolClass);
        this.mySerializer = serializer2;
    }

    public void write(Kryo kryo, Output output, T object) {
        output.writeBoolean(object.getContainingFile() != null);
        super.write(kryo, output, object);
    }

    @NotNull
    protected final T create(Kryo kryo, Input input, Class<T> type) {
        boolean hasFile = input.readBoolean();
        T result2 = this.createInstance(kryo, input, type);
        result2.init(hasFile ? this.mySerializer.getCurrentFile() : null);
        return result2;
    }

    @NotNull
    protected final T createCopy(Kryo kryo, T original) {
        MaybeVirtualFileOwner result2 = (MaybeVirtualFileOwner)super.createCopy(kryo, original);
        VirtualFile file2 = original.getContainingFile();
        OCSerializer.LOG.assertTrue(file2 == null || file2.equals(this.mySerializer.getCurrentFile()));
        result2.init(file2);
        return (T)result2;
    }

    public final T createInstance(Kryo kryo, Input input, Class<T> type) {
        return (T)((MaybeVirtualFileOwner)super.create(kryo, input, type));
    }
}

