/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.symbols.symtable.EmptySymbolTableProvider;
import com.jetbrains.cidr.lang.symbols.symtable.FileContentSnapshot;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.OCSymbolTablesBuildingActivity;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SymbolTableProvider {
    private static final Logger LOG = Logger.getInstance(SymbolTableProvider.class);
    public static final ExtensionPointName<SymbolTableProvider> INSTANCE = ExtensionPointName.create((String)"cidr.lang.symbolTableProvider");

    protected abstract boolean isSource(@NotNull PsiFile var1);

    public abstract boolean isSource(@NotNull Project var1, @NotNull VirtualFile var2, @NotNull OCInclusionContext var3);

    public abstract boolean isSource(@NotNull Project var1, @NotNull VirtualFile var2);

    public boolean shouldPreProcess() {
        return false;
    }

    public abstract boolean isOutOfCodeBlockChange(@NotNull PsiTreeChangeEventImpl var1);

    @NotNull
    public abstract FileSymbolTable calcTableUsingPSI(@NotNull PsiFile var1, @NotNull VirtualFile var2, @NotNull OCInclusionContext var3);

    @NotNull
    public abstract FileSymbolTable calcTable(@NotNull VirtualFile var1, @NotNull OCInclusionContext var2);

    @Nullable
    public OCSymbolTablesBuildingActivity.AdditionalTaskProvider<?> getItemProviderAndWorkerForAdditionalSymbolLoading(@NotNull Project project2, @NotNull ProgressIndicator indicator, @NotNull Collection<VirtualFile> allFiles) {
        return null;
    }

    @NotNull
    public static List<SymbolTableProvider> getProviders() {
        return INSTANCE.getExtensionList();
    }

    public boolean shouldProcessPsiEvents(@NotNull PsiFile file2) {
        return true;
    }

    @NotNull
    public static SymbolTableProvider getProvider(@NotNull PsiFile file2) {
        SymbolTableProvider provider2 = SymbolTableProvider.findProvider(file2);
        if (provider2 != null) {
            return provider2;
        }
        LOG.error(file2.getClass() + "(\"" + file2.getName() + "\")");
        return SymbolTableProvider.emptyTableProvider();
    }

    @Nullable
    public static SymbolTableProvider findProvider(@NotNull PsiFile file2) {
        for (SymbolTableProvider provider2 : SymbolTableProvider.getProviders()) {
            if (!provider2.isSource(file2)) continue;
            return provider2;
        }
        return null;
    }

    @NotNull
    public static SymbolTableProvider getProvider(@NotNull Project project2, @NotNull VirtualFile file2, @NotNull OCInclusionContext context2) {
        for (SymbolTableProvider provider2 : SymbolTableProvider.getProviders()) {
            if (!provider2.isSource(project2, file2, context2)) continue;
            return provider2;
        }
        LOG.error(file2.getClass() + "(\"" + file2.getName() + "\")");
        return SymbolTableProvider.emptyTableProvider();
    }

    @Nullable
    public static SymbolTableProvider findProvider(@NotNull Project project2, @NotNull VirtualFile file2) {
        for (SymbolTableProvider provider2 : SymbolTableProvider.getProviders()) {
            if (!provider2.isSource(project2, file2)) continue;
            return provider2;
        }
        return null;
    }

    @NotNull
    private static SymbolTableProvider emptyTableProvider() {
        return EmptySymbolTableProvider.INSTANCE;
    }

    @Contract(value="_, null -> false")
    public static boolean isSourceFile(@NotNull Project project2, @Nullable VirtualFile virtualFile) {
        return virtualFile != null && SymbolTableProvider.findProvider(project2, virtualFile) != null;
    }

    @Contract(value="null -> false")
    public static boolean isSourceFile(@Nullable PsiFile file2) {
        return file2 != null && SymbolTableProvider.findProvider(file2) != null;
    }

    @NotNull
    public static CharSequence getFileText(@NotNull VirtualFile virtualFile, @NotNull Project project2) {
        return FileContentSnapshot.get(virtualFile, project2).getText();
    }
}

