/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.util.SmartList;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.symbols.symtable.ImpatientDeferredException;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ProcessingDependencyGraph<Item> {
    private final Map<Thread, Item> myThreadToAwaitingItem = new HashMap<Thread, Item>();
    private final Map<Item, Context> myItemToProcessingContext = new Object2ObjectOpenHashMap();

    ProcessingDependencyGraph() {
    }

    @NotNull
    synchronized State startProcessing(@NotNull Item item, @NotNull Thread currentThread, @Nullable Runnable reschedule) throws ImpatientDeferredException {
        Thread currentProcessingThread;
        Context currentProcessingContext = this.myItemToProcessingContext.get(item);
        Thread thread = currentProcessingThread = currentProcessingContext != null ? currentProcessingContext.getThread() : null;
        if (currentProcessingThread == currentThread) {
            return State.RECURSIVE;
        }
        if (currentProcessingThread == null) {
            this.myItemToProcessingContext.put(item, new Context(currentThread));
            return State.ACQUIRED;
        }
        if (reschedule != null) {
            currentProcessingContext.add(reschedule);
            throw new ImpatientDeferredException();
        }
        if (this.checkForDeadlock(currentThread, currentProcessingThread)) {
            return State.DEADLOCK;
        }
        this.myThreadToAwaitingItem.put(currentThread, item);
        return State.WAIT;
    }

    synchronized boolean retryStartProcessing(@NotNull Item item, @NotNull Thread currentThread) {
        Thread currentProcessingThread = this.getCurrentProcessingThread(item);
        if (currentProcessingThread == null) {
            this.myItemToProcessingContext.put(item, new Context(currentThread));
            this.myThreadToAwaitingItem.remove(currentThread);
            return true;
        }
        return false;
    }

    synchronized void stopWaiting(@NotNull Thread currentThread) {
        this.myThreadToAwaitingItem.remove(currentThread);
    }

    synchronized void finishProcessing(@NotNull Item item) {
        Context processingContext = this.myItemToProcessingContext.remove(item);
        if (!OCLog.LOG.assertTrue(processingContext != null, (Object)"Current processing context not found")) {
            return;
        }
        Iterator iterator2 = processingContext.iterator();
        while (iterator2.hasNext()) {
            Runnable reschedule = (Runnable)iterator2.next();
            reschedule.run();
        }
    }

    private boolean checkForDeadlock(@NotNull Thread context2, @NotNull Thread thread) {
        Item lock;
        while ((lock = this.myThreadToAwaitingItem.get(thread)) != null) {
            Thread next = this.getCurrentProcessingThread(lock);
            if (next == null || next == thread) {
                return false;
            }
            if (next == context2) {
                return true;
            }
            thread = next;
        }
        return false;
    }

    @Nullable
    private Thread getCurrentProcessingThread(@NotNull Item item) {
        Context currentProcessingContext = this.myItemToProcessingContext.get(item);
        return currentProcessingContext != null ? currentProcessingContext.getThread() : null;
    }

    private static final class Context
    extends SmartList<Runnable> {
        @NotNull
        private final Thread myThread;

        Context(@NotNull Thread thread) {
            this.myThread = thread;
        }

        @NotNull
        Thread getThread() {
            return this.myThread;
        }

        public boolean equals(@Nullable Object o) {
            throw new AssertionError();
        }

        public int hashCode() {
            throw new AssertionError();
        }

        public String toString() {
            return "ProcessingContext{thread=" + this.myThread + "} " + super.toString();
        }
    }

    static enum State {
        DEADLOCK,
        RECURSIVE,
        ACQUIRED,
        WAIT;

    }
}

