/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.ide.util.DelegatingProgressIndicator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.GuiUtils;
import com.intellij.util.Consumer;
import com.intellij.util.NotNullProducer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.hmap.OCHeaderMapManager;
import com.jetbrains.cidr.lang.modulemap.ModuleMapLog;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapManager;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapSerializationService;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapCache;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapSymbolBuilder;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCConfigurationOwner;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.ImpatientDeferredException;
import com.jetbrains.cidr.lang.symbols.symtable.ModuleMapDescriptor;
import com.jetbrains.cidr.lang.symbols.symtable.OCAdditionalFileSymbolTableBuilder;
import com.jetbrains.cidr.lang.symbols.symtable.RecursiveSymbolBuilding;
import com.jetbrains.cidr.lang.symbols.symtable.RestartableWorker;
import com.jetbrains.cidr.lang.symbols.symtable.SymbolTableProvider;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.SerializationSession;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import com.jetbrains.cidr.util.events.CidrEventSpan;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountedCompleter;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSymbolTablesBuildingActivity {
    public static final String TITLE_SAVING_SYMBOLS = "Saving symbols...";
    @NotNull
    private final FileSymbolTablesCache myCache;
    @Nullable
    private static NotNullProducer<? extends ProgressIndicator> ourIndicatorFactory;
    @NotNull
    private static final Set<Thread> mySymbolBuildingThreads;
    @NonNls
    public static final NotNullLazyKey<List<String>, Project> ACTIVITY_LOG;
    @NotNull
    private final Project project;
    @NotNull
    private final AtomicInteger ourRequestCount = new AtomicInteger();
    @NotNull
    private final Object ourLastBuildLock = new Object();
    @Nullable
    private volatile SymbolBuildingTask ourLastBuildTask;
    private volatile int ourLastBuild;
    public static final AdditionalTaskProvider<?> EMPTY_TASK_PROVIDER;

    public static OCSymbolTablesBuildingActivity getInstance(@NotNull Project project2) {
        return (OCSymbolTablesBuildingActivity)ServiceManager.getService((Project)project2, OCSymbolTablesBuildingActivity.class);
    }

    public OCSymbolTablesBuildingActivity(@NotNull Project project2) {
        this.project = project2;
        this.myCache = FileSymbolTablesCache.getInstance(project2);
    }

    public void assertParsingAndSymbolBuildingAllowed() {
        this.assertParsingAndSymbolBuildingAllowed(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void assertParsingAndSymbolBuildingAllowed(@NotNull Thread thread) {
        boolean allowed;
        boolean bl = allowed = this.myCache.areSymbolsLoaded() || OCSymbolTablesBuildingActivity.isSymbolBuildingThread(thread);
        if (!allowed) {
            String logEntries;
            List log;
            List list = log = (List)ACTIVITY_LOG.getValue((UserDataHolder)this.project);
            synchronized (list) {
                logEntries = StringUtil.join((Collection)log, (String)"\n");
            }
            String message = "Symbol building is not allowed: " + System.currentTimeMillis() + " . \nLoaded: " + this.myCache.areSymbolsLoaded() + "\nDumb: " + DumbService.isDumb((Project)this.project) + "\nPrevious activities: \n" + logEntries;
            OCLog.LOG.error(message);
            throw new ProcessCanceledException(new Throwable(message));
        }
    }

    private static boolean isSymbolBuildingThread(@NotNull Thread thread) {
        return RecursiveSymbolBuilding.isRecursiveSymbolBuildingThread(thread) || mySymbolBuildingThreads.contains(thread);
    }

    public static void setIndicatorFactory(@Nullable NotNullProducer<? extends ProgressIndicator> indicatorFactory) {
        ourIndicatorFactory = indicatorFactory;
    }

    public void rebuildSymbols() {
        this.rebuildSymbols(Mode.FAST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildSymbols(final @NotNull Mode mode) {
        final int requestNumber = this.ourRequestCount.incrementAndGet();
        String activityName = "rebuildSymbols";
        this.runSymbolActivity(new SymbolBuildingTask(activityName){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void process(@NotNull MyProgressIndicator indicator) {
                Object object = OCSymbolTablesBuildingActivity.this.ourLastBuildLock;
                synchronized (object) {
                    if (requestNumber <= OCSymbolTablesBuildingActivity.this.ourLastBuild) {
                        return;
                    }
                    OCSymbolTablesBuildingActivity.this.ourLastBuildTask = this;
                    OCSymbolTablesBuildingActivity.this.ourLastBuild = OCSymbolTablesBuildingActivity.this.ourRequestCount.get();
                }
                OCSymbolTablesBuildingActivity.this.buildSymbolsInternal(indicator, mode);
            }
        });
        Object object = this.ourLastBuildLock;
        synchronized (object) {
            SymbolBuildingTask currentTask = this.ourLastBuildTask;
            if (currentTask != null && this.ourLastBuild < requestNumber) {
                if (currentTask.shouldCancel()) {
                    DumbService.getInstance((Project)this.project).cancelTask((DumbModeTask)currentTask);
                }
                this.ourLastBuildTask = null;
            }
        }
    }

    public void rebuildSwiftModules(final FileType swiftFileType) {
        this.runSymbolActivity(new SymbolBuildingTask("rebuildSwiftModules"){

            @Override
            protected void process(@NotNull MyProgressIndicator indicator) {
                OCSymbolTablesBuildingActivity.this.processAdditionalActivities(ContainerUtil.createMaybeSingletonList((Object)new LightVirtualFile("", swiftFileType, (CharSequence)"")), indicator);
            }
        });
    }

    public void buildSymbolsForFiles(final @NotNull Collection<VirtualFile> files) {
        this.runSymbolActivity(new SymbolBuildingTask("buildSymbolsForFiles"){

            @Override
            protected void process(@NotNull MyProgressIndicator indicator) {
                OCSymbolTablesBuildingActivity.this.buildSymbolsForFilesInternal(indicator, files);
            }
        });
    }

    public void rebuildModuleMaps() {
        if (!ModuleMapCache.shouldBuildCache()) {
            return;
        }
        this.runSymbolActivity(new SymbolBuildingTask("rebuildModuleMaps"){

            @Override
            protected void process(@NotNull MyProgressIndicator indicator) {
                ModuleMapCache.getInstance(OCSymbolTablesBuildingActivity.this.project).reset();
                indicator.setIndeterminate(false);
                Set deserializedRoots = OCSymbolTablesBuildingActivity.this.deserializeModuleMaps(indicator);
                OCSymbolTablesBuildingActivity.this.buildRemainingModuleMaps(indicator, deserializedRoots);
                OCSymbolTablesBuildingActivity.this.serializeModuleMaps(indicator);
            }
        });
    }

    @NotNull
    private Set<HeadersSearchRoot> getAllHeaderRoots(@NotNull MyProgressIndicator indicator, boolean forModuleMapsBuilding) {
        ModuleMapManager moduleMapManager = ModuleMapManager.getInstance(this.project);
        return (Set)OCSymbolTablesBuildingActivity.runCancelableReadAction(this.project, (ProgressIndicator)indicator, () -> {
            if (forModuleMapsBuilding) {
                return new THashSet(moduleMapManager.getGlobalCache().getHeaderSearchRoots());
            }
            List<OCResolveConfiguration> configurations = OCWorkspace.getInstance(this.project).getConfigurations();
            return configurations.stream().flatMap(configuration -> configuration.getAllCompilerSettings()).flatMap(settings -> {
                ProgressManager.checkCanceled();
                return settings.getHeadersSearchRoots().getAllRoots().stream();
            }).collect(Collectors.toCollection(THashSet::new));
        });
    }

    @NotNull
    private Set<HeadersSearchRoot> deserializeModuleMaps(@NotNull MyProgressIndicator indicator) {
        Set<HeadersSearchRoot> roots2;
        if (!ModuleMapCache.shouldBuildCache()) {
            return Collections.emptySet();
        }
        try (CidrEventSpan ignored = new CidrEventSpan("moduleMaps", "getAllHeaderRootsForModuleMapBuilding", null);){
            indicator.setText(OCBundle.message("loading.headers.search.roots", new Object[0]));
            indicator.startTiming(OCBundle.message("loading.headers.search.roots", new Object[0]));
            roots2 = this.getAllHeaderRoots(indicator, true);
            indicator.setText2(null);
            indicator.logTiming();
        }
        ignored = new CidrEventSpan("moduleMaps", "deserialize", roots2.size() + " root(s)");
        var4_3 = null;
        try {
            indicator.setText(OCBundle.message("loading.module.maps", new Object[0]));
            indicator.startTiming("Loading Module Maps");
            indicator.setInterval(0.0, 0.1);
            Set<HeadersSearchRoot> deserializedHeadersSearchRoots = ModuleMapSerializationService.getInstance(this.project).deserializeModuleMaps((ProgressIndicator)indicator, roots2);
            indicator.setText2(null);
            indicator.logTiming();
            Set<HeadersSearchRoot> set = deserializedHeadersSearchRoots;
            return set;
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (ignored != null) {
                if (var4_3 != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable) {
                        var4_3.addSuppressed(throwable);
                    }
                } else {
                    ignored.close();
                }
            }
        }
    }

    private void buildRemainingModuleMaps(final @NotNull MyProgressIndicator indicator, @NotNull Set<HeadersSearchRoot> deserializedRoots) {
        if (!ModuleMapCache.shouldBuildCache()) {
            return;
        }
        try (CidrEventSpan ignored = new CidrEventSpan("moduleMaps", "buildRemaining", null);){
            ImmutableListMultimap.Builder clusterization = ImmutableListMultimap.builder();
            final String[] projectLocationHash = new String[1];
            final ModuleMapManager moduleMapManager = ModuleMapManager.getInstance(this.project);
            OCSymbolTablesBuildingActivity.runCancelableReadAction(this.project, (ProgressIndicator)indicator, () -> {
                projectLocationHash[0] = this.project.getLocationHash();
                List<ModuleMapDescriptor> descriptors = moduleMapManager.getDescriptorsForInitialBuilding();
                for (ModuleMapDescriptor descriptor : descriptors) {
                    if (deserializedRoots.contains((Object)descriptor.getHeadersSearchRoot())) continue;
                    OCResolveConfiguration configuration = descriptor.getConfiguration();
                    Object cluster = OCSymbolTablesBuildingActivity.getClusterization(configuration);
                    clusterization.put(cluster, (Object)descriptor);
                }
            });
            final AtomicInteger processedCount = new AtomicInteger(0);
            ImmutableListMultimap clusterizationMap = clusterization.build();
            final int size = clusterizationMap.values().size();
            ModuleMapLog.LOG.info("Building module maps for " + size + " (root, configuration) pairs");
            double center = 0.7;
            OCSymbolTablesBuildingActivity.processRecursiveTasks(this.project, indicator, 0.1, center, clusterizationMap, (global, read) -> new RecursiveSymbolBuilding<ModuleMapDescriptor>(this.project, global, read, 1){
                private final boolean isImpatient;
                private final ThreadLocal serializationSession;
                {
                    super(x0, x1, x2, x3);
                    this.isImpatient = Registry.is((String)"cidr.modulemaps.building.impatient", (boolean)true);
                    this.serializationSession = ThreadLocal.withInitial(() -> new SerializationSession(projectLocationHash[0]));
                }

                @Override
                @NotNull
                protected RecursiveSymbolBuilding.ReadActionTask createWorkerTask(@NotNull CountedCompleter<?> parent, @NotNull ImmutableList<ModuleMapDescriptor> workset) {
                    return new RecursiveSymbolBuilding.ReadActionTask(parent, workset){

                        protected void computeInReadAction(@NotNull ModuleMapDescriptor item) {
                            HeadersSearchRoot root = item.getHeadersSearchRoot();
                            indicator.setText2(root.getName());
                            SerializationSession session = (SerializationSession)serializationSession.get();
                            try {
                                moduleMapManager.buildModule(item, isImpatient ? () -> this.reschedule(ImmutableList.of((Object)item), 0) : null, session);
                                indicator.setFraction((double)processedCount.incrementAndGet() / (double)size);
                            }
                            catch (ImpatientDeferredException e) {
                                this.addToPendingCount(1);
                                item.wasDeferred();
                            }
                        }
                    };
                }

                @Override
                @NotNull
                @Nls
                public @NlsContexts.ProgressText String getIndicatorText() {
                    return OCBundle.message("building.module.maps", new Object[0]);
                }
            });
            processedCount.set(0);
            OCSymbolTablesBuildingActivity.processRecursiveTasks(this.project, indicator, center, 0.9, clusterizationMap, (global, read) -> new RecursiveSymbolBuilding<ModuleMapDescriptor>(this.project, global, read, 1){
                private final boolean isImpatient;
                private final ThreadLocal serializationSession;
                {
                    super(x0, x1, x2, x3);
                    this.isImpatient = Registry.is((String)"cidr.modulemaps.building.impatient", (boolean)true);
                    this.serializationSession = ThreadLocal.withInitial(() -> new SerializationSession(projectLocationHash[0]));
                }

                @Override
                @NotNull
                protected RecursiveSymbolBuilding.ReadActionTask createWorkerTask(@NotNull CountedCompleter<?> parent, @NotNull ImmutableList<ModuleMapDescriptor> workset) {
                    return new RecursiveSymbolBuilding.ReadActionTask(parent, workset){

                        protected void computeInReadAction(@NotNull ModuleMapDescriptor item) {
                            HeadersSearchRoot root = item.getHeadersSearchRoot();
                            indicator.setText2(root.getName());
                            SerializationSession session = (SerializationSession)serializationSession.get();
                            try {
                                moduleMapManager.buildDependencies(item, isImpatient ? () -> this.reschedule(ImmutableList.of((Object)item), 0) : null, session);
                                indicator.setFraction((double)processedCount.incrementAndGet() / (double)size);
                            }
                            catch (ImpatientDeferredException e) {
                                this.addToPendingCount(1);
                                item.wasDeferred();
                            }
                        }
                    };
                }

                @Override
                @NotNull
                @Nls
                public @NlsContexts.ProgressText String getIndicatorText() {
                    return OCBundle.message("processing.module.maps", new Object[0]);
                }
            });
        }
    }

    @NotNull
    private static Object getClusterization(@NotNull OCResolveConfiguration configuration) {
        Object cluster = configuration.getCompilerSettings(ModuleMapSymbolBuilder.getPreferredLanguageKind()).getIndexingCluster();
        if (cluster == null) {
            cluster = ObjectUtils.NULL;
        }
        return cluster;
    }

    private void serializeModuleMaps(@NotNull MyProgressIndicator indicator) {
        if (!ModuleMapCache.shouldBuildCache()) {
            return;
        }
        try (CidrEventSpan ignored = new CidrEventSpan("moduleMaps", "serialize", null);){
            indicator.setText(OCBundle.message("saving.module.maps", new Object[0]));
            indicator.startTiming("Saving Module Maps");
            indicator.setInterval(0.9, 1.0);
            ModuleMapSerializationService.getInstance(this.project).serializeModuleMaps((ProgressIndicator)indicator);
            indicator.setText2(null);
            indicator.logTiming();
        }
    }

    public void runSymbolActivity(@NotNull String activityName, final @NotNull Consumer<? super MyProgressIndicator> task2) {
        this.runSymbolActivity(new SymbolBuildingTask(activityName){

            @Override
            protected void process(@NotNull MyProgressIndicator indicator) {
                task2.consume((Object)indicator);
            }
        });
    }

    public void runSymbolActivity(final @NotNull SymbolBuildingTask task2) {
        Application app = ApplicationManager.getApplication();
        if (app.isUnitTestMode() && app.isWriteAccessAllowed()) {
            final Disposable listenerDisposable = Disposer.newDisposable();
            app.addApplicationListener(new ApplicationListener(){
                private final AtomicBoolean isHandled = new AtomicBoolean();

                public void afterWriteActionFinished(@NotNull Object action) {
                    if (!this.isHandled.getAndSet(true)) {
                        Disposer.dispose((Disposable)listenerDisposable);
                        DumbService.getInstance((Project)OCSymbolTablesBuildingActivity.this.project).queueTask((DumbModeTask)task2);
                    }
                }
            }, listenerDisposable);
            return;
        }
        DumbService.getInstance((Project)this.project).queueTask((DumbModeTask)task2);
    }

    private void buildSymbolsForFilesInternal(@NotNull MyProgressIndicator indicator, @NotNull Collection<VirtualFile> sourceFiles) {
        if (!FileSymbolTablesCache.shouldBuildTables()) {
            return;
        }
        OCSymbolTablesBuildingActivity.invokeAndWaitSafely((ProgressIndicator)indicator, () -> {
            if (indicator.isCanceled()) {
                return;
            }
            this.myCache.notifySymbolsUnloaded();
            this.myCache.reparseCachedPsiFiles();
        });
        indicator.checkCanceled();
        OCSymbolTableBuilder builder2 = new OCSymbolTableBuilder(this.project, indicator, sourceFiles, false);
        builder2.processBuildFiles(indicator.getFraction(), 1.0);
        this.notifySymbolsAreLoadedAndReparseCachedFiles(indicator);
    }

    private void buildSymbolsInternal(@NotNull MyProgressIndicator indicator, @NotNull Mode mode) {
        List sourceFilesToIndex;
        if (!FileSymbolTablesCache.shouldBuildTables()) {
            return;
        }
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            OCLog.LOG.error("Symbols building must not be initiated from write action, otherwise deadlock will occur");
            return;
        }
        indicator.checkCanceled();
        indicator.setText(OCBundle.message("symbol.table.activity.building.symbols", new Object[0]));
        indicator.setText2("");
        indicator.setIndeterminate(true);
        indicator.startTiming("Clearing symbols");
        String[] projectLocationHash = new String[1];
        OCSymbolTablesBuildingActivity.invokeAndWaitSafely((ProgressIndicator)indicator, () -> {
            if (indicator.isCanceled()) {
                return;
            }
            this.myCache.notifySymbolsUnloaded();
            this.myCache.clearAllTables();
            this.myCache.reparseCachedPsiFiles();
            this.clearAllSymbolDependentCaches();
            projectLocationHash[0] = this.project.getLocationHash();
        });
        indicator.logTiming();
        indicator.checkCanceled();
        indicator.setIndeterminate(false);
        indicator.setFraction(0.0);
        indicator.startTiming("Loading Header Maps");
        indicator.setText(OCBundle.message("symbol.table.activity.loading.header.maps", new Object[0]));
        OCHeaderMapManager.getInstance(this.project).load(this.getAllHeaderRoots(indicator, false));
        indicator.logTiming();
        ModuleMapCache.getInstance(this.project).reset();
        Set<HeadersSearchRoot> deserializedRoots = this.deserializeModuleMaps(indicator);
        indicator.setText(OCBundle.message("symbol.table.activity.loading.symbols", new Object[0]));
        indicator.startTiming("Loading symbols");
        Collection<VirtualFile> allFiles = this.getFilesToBuildCachesForSafely((ProgressIndicator)indicator);
        List sourceFiles = OCSymbolTablesBuildingActivity.runCancelableReadAction(this.project, (ProgressIndicator)indicator, () -> ContainerUtil.findAll((Collection)allFiles, file2 -> !OCInclusionContextUtil.isNeedToFindRoot(file2, this.project)));
        String allFilesDescription = allFiles.size() + " project files";
        OCLog.LOG.info("Building symbols in " + mode.name() + " mode, " + sourceFiles.size() + " source files from total " + allFilesDescription);
        long loadedFileCount = 0L;
        if (mode != Mode.FULL) {
            loadedFileCount = this.myCache.deserializeTables(projectLocationHash[0], allFiles, (ProgressIndicator)indicator, 0.25);
        }
        double loadedFraction = indicator.getFraction();
        double savingFraction = 1.0 - 0.1 * (double)((long)allFiles.size() - loadedFileCount) / (double)Math.max(1, allFiles.size());
        indicator.logTiming();
        this.buildRemainingModuleMaps(indicator, deserializedRoots);
        this.serializeModuleMaps(indicator);
        ArrayList<VirtualFile> loadedFiles = new ArrayList<VirtualFile>(this.myCache.getCachedFiles());
        OCLog.LOG.info("Loaded " + this.getAllTablesCount() + " tables for " + loadedFiles.size() + " files (" + loadedFileCount + " project files)");
        indicator.checkCanceled();
        indicator.setText(loadedFiles.isEmpty() ? OCBundle.message("symbol.table.activity.building.symbols", new Object[0]) : OCBundle.message("symbol.table.activity.updating.symbols", new Object[0]));
        indicator.startTiming("Building symbols");
        if (mode == Mode.COMPACT) {
            sourceFilesToIndex = sourceFiles;
        } else {
            HashSet<VirtualFile> filesWithOwnTables = new HashSet<VirtualFile>(this.myCache.getFilesWithNonFallbackTables(false));
            sourceFilesToIndex = ContainerUtil.findAll((Collection)sourceFiles, file2 -> !filesWithOwnTables.contains(file2));
        }
        String buildFilesDescription = sourceFilesToIndex.size() + " source files";
        OCLog.LOG.info("Building symbols for " + buildFilesDescription);
        try (CidrEventSpan ignored = new CidrEventSpan("symbols", "processBuildFiles", buildFilesDescription);){
            double sourcePart = sourceFilesToIndex.size();
            double headerWithoutTablesCount = allFiles.size() - sourceFiles.size();
            double headersPart = headerWithoutTablesCount * 0.2;
            double sourceFraction = loadedFraction + (savingFraction - loadedFraction) * (sourcePart / Math.max(sourcePart + headersPart, 1.0));
            OCSymbolTableBuilder builder2 = new OCSymbolTableBuilder(this.project, indicator, sourceFilesToIndex, false);
            builder2.processBuildFiles(loadedFraction, sourceFraction);
        }
        indicator.checkCanceled();
        HashSet<VirtualFile> headersWithoutTables = new HashSet<VirtualFile>(allFiles);
        headersWithoutTables.removeAll(this.myCache.getFilesWithNonFallbackTables(mode == Mode.COMPACT));
        String headerFilesDescription = headersWithoutTables.size() + " unused headers";
        OCLog.LOG.info("Building symbols for " + headerFilesDescription);
        try (CidrEventSpan ignored = new CidrEventSpan("symbols", "processBuildFiles", headerFilesDescription);){
            OCSymbolTableBuilder builder3 = new OCSymbolTableBuilder(this.project, indicator, headersWithoutTables, true);
            builder3.processBuildFiles(indicator.getFraction(), savingFraction);
            indicator.logTiming();
        }
        this.notifySymbolsAreLoadedAndReparseCachedFiles(indicator);
        ignored = new CidrEventSpan("symbols", "processAdditionalActivities", allFilesDescription);
        var20_33 = null;
        try {
            this.processAdditionalActivities(allFiles, indicator);
        }
        catch (Throwable builder3) {
            var20_33 = builder3;
            throw builder3;
        }
        finally {
            if (ignored != null) {
                if (var20_33 != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable builder3) {
                        var20_33.addSuppressed(builder3);
                    }
                } else {
                    ignored.close();
                }
            }
        }
        this.myCache.removeJunkTables(mode == Mode.COMPACT);
        HashSet<VirtualFile> filesWithModifiedTables = new HashSet<VirtualFile>(this.myCache.getFilesWithChangedTables());
        indicator.checkCanceled();
        indicator.setText(TITLE_SAVING_SYMBOLS);
        indicator.startTiming("Saving symbols");
        indicator.setInterval(savingFraction, 1.0);
        this.serializeModuleMaps(indicator);
        String serializeDescription = filesWithModifiedTables.size() + " files (" + this.getAllTablesCount(filesWithModifiedTables) + " tables of total " + this.getAllTablesCount() + ")";
        OCLog.LOG.info("Saving modified symbols for " + serializeDescription);
        try (CidrEventSpan ignored = new CidrEventSpan("symbols", "serializeTables", serializeDescription);){
            this.myCache.serializeTables(projectLocationHash[0], filesWithModifiedTables, (ProgressIndicator)indicator);
            indicator.logTiming();
        }
        FileSymbolTable.reportStats(this.project);
    }

    private int getAllTablesCount() {
        Set<VirtualFile> files = this.myCache.getCachedFiles();
        return this.getAllTablesCount(files);
    }

    private int getAllTablesCount(@NotNull Set<VirtualFile> files) {
        int result2 = 0;
        for (VirtualFile file2 : files) {
            result2 += this.myCache.allTablesForFileCount(file2);
        }
        return result2;
    }

    private void processAdditionalActivities(@NotNull Collection<VirtualFile> allFiles, @NotNull MyProgressIndicator indicator) {
        for (SymbolTableProvider provider2 : SymbolTableProvider.getProviders()) {
            AdditionalTaskProvider<?> taskProvider = provider2.getItemProviderAndWorkerForAdditionalSymbolLoading(this.project, (ProgressIndicator)indicator, allFiles);
            if (taskProvider == null) continue;
            CidrEventSpan ignored = new CidrEventSpan(taskProvider.getTraceCategory(), taskProvider.getTraceTitle(), null);
            Throwable throwable = null;
            try {
                OCSymbolTablesBuildingActivity.processTasks(this.project, indicator, 0.0, 1.0, taskProvider);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ignored == null) continue;
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ignored.close();
            }
        }
    }

    private void notifySymbolsAreLoadedAndReparseCachedFiles(@NotNull MyProgressIndicator indicator) {
        indicator.checkCanceled();
        OCSymbolTablesBuildingActivity.runCancelableReadAction(this.project, (ProgressIndicator)indicator, () -> {
            indicator.checkCanceled();
            this.myCache.compact();
            this.myCache.notifySymbolsLoaded();
        });
        indicator.checkCanceled();
        Runnable runnable = () -> {
            if (this.project.isDisposed() || indicator.isCanceled()) {
                return;
            }
            this.myCache.reparseCachedPsiFiles();
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().invokeAndWait(runnable);
        } else {
            ApplicationManager.getApplication().invokeLater(runnable, this.project.getDisposed());
        }
    }

    private void clearAllSymbolDependentCaches() {
        for (OCResolveConfiguration configuration : OCWorkspace.getInstance(this.project).getConfigurations()) {
            OCInclusionContext.onPrecompiledContextChange(configuration);
            OCInclusionContext.clearSymbolTableConformanceCache(configuration);
            OCImportGraph.invalidateRootHeadersCache(configuration);
        }
        OCInclusionContextUtil.invalidateHeaderRootAndActiveConfigurationForAllExcept(null, this.project);
    }

    @NotNull
    public Collection<VirtualFile> getFilesToBuildCachesForSafely(@NotNull ProgressIndicator indicator) {
        return OCSymbolTablesBuildingActivity.runCancelableReadAction(this.project, indicator, () -> this.myCache.getFilesToBuildTablesFor());
    }

    public static void runCancelableReadAction(@NotNull Project project2, @NotNull ProgressIndicator indicator, @NotNull Runnable runnable) {
        ReadAction.nonBlocking((Runnable)OCSymbolTablesBuildingActivity.withCustomLoopIndicator(runnable)).expireWith((Disposable)project2).wrapProgress(indicator).executeSynchronously();
    }

    public static <T> T runCancelableReadAction(@NotNull Project project2, @NotNull ProgressIndicator indicator, @NotNull Callable<T> callable) {
        return (T)ReadAction.nonBlocking(OCSymbolTablesBuildingActivity.withCustomLoopIndicator(callable)).expireWith((Disposable)project2).wrapProgress(indicator).executeSynchronously();
    }

    private static void invokeAndWaitSafely(@NotNull ProgressIndicator indicator, @NotNull Runnable runnable) {
        Semaphore s = new Semaphore(1);
        GuiUtils.invokeLaterIfNeeded(() -> WriteAction.run(() -> {
            try {
                runnable.run();
            }
            finally {
                s.up();
            }
        }), (ModalityState)ModalityState.defaultModalityState());
        ProgressIndicatorUtils.awaitWithCheckCanceled((Semaphore)s, (ProgressIndicator)indicator);
    }

    public static void processTasks(@NotNull Project project2, @NotNull MyProgressIndicator indicator, double from, double to, @NotNull TaskProvider<?> taskProvider) {
        indicator.setText(taskProvider.getIndicatorText() + "...");
        indicator.startTiming(taskProvider.getIndicatorText());
        indicator.setIndeterminate(false);
        indicator.setInterval(from, to);
        indicator.setFraction(0.0);
        OCSymbolTablesBuildingActivity.processFutures(OCSymbolTablesBuildingActivity.createTasks(taskProvider, (ProgressIndicator)indicator, project2));
        indicator.setText2(null);
        indicator.logTiming();
    }

    private static <T> void processRecursiveTasks(@NotNull Project project2, @NotNull MyProgressIndicator indicator, double from, double to, @NotNull ImmutableListMultimap<Object, T> clusters, @NotNull BiFunction<ProgressIndicator, ProgressIndicator, RecursiveSymbolBuilding<T>> symbolBuildingProvider) {
        OCSymbolTablesBuildingActivity.processWithWriteActionPriority((ProgressIndicator)indicator, project2, (Consumer<? super ProgressIndicator>)((Consumer)localIndicator -> {
            RecursiveSymbolBuilding symbolBuilding = (RecursiveSymbolBuilding)symbolBuildingProvider.apply((ProgressIndicator)indicator, (ProgressIndicator)localIndicator);
            indicator.setText(symbolBuilding.getIndicatorText() + "...");
            indicator.startTiming(symbolBuilding.getIndicatorText());
            indicator.setIndeterminate(false);
            indicator.setInterval(from, to);
            indicator.setFraction(0.0);
            symbolBuilding.process(clusters);
            indicator.setText2(null);
            indicator.logTiming();
        }));
    }

    private static void processFutures(@NotNull Iterable<Future<?>> tasks2) {
        for (Future<?> future : tasks2) {
            ProgressIndicatorUtils.awaitWithCheckCanceled(future);
        }
    }

    @NotNull
    private static <T> List<Future<?>> createTasks(@NotNull TaskProvider<T> taskProvider, @NotNull ProgressIndicator indicator, @NotNull Project project2) {
        int threadCount = FileSymbolTablesCache.getIndexingThreadCount();
        ImmutableList.Builder futures2 = ImmutableList.builderWithExpectedSize((int)threadCount);
        for (int i2 = 0; i2 < threadCount; ++i2) {
            indicator.checkCanceled();
            final Supplier<T> itemProvider = taskProvider.getItemProvider();
            final Consumer<T> taskWorker = taskProvider.getWorker();
            RobustWorker worker = new RobustWorker<T>(){

                @Override
                @Nullable
                protected T nextItem() {
                    return itemProvider.get();
                }

                @Override
                protected void process(@NotNull T item) {
                    taskWorker.consume(item);
                }
            };
            if (!worker.hasNextItem()) continue;
            futures2.add((Object)ReadAction.nonBlocking((Runnable)OCSymbolTablesBuildingActivity.withCustomLoopIndicator(() -> OCSymbolTablesBuildingActivity.runWithSymbolBuildingAllowed(worker))).expireWith((Disposable)project2).wrapProgress(indicator).submit((Executor)AppExecutorUtil.getAppExecutorService()));
        }
        return futures2.build();
    }

    static void runWithSymbolBuildingAllowed(@NotNull Runnable runnable) {
        Thread currentThread = Thread.currentThread();
        assert (!OCSymbolTablesBuildingActivity.isSymbolBuildingThread(currentThread)) : "Dedicated thread should be used for symbols building";
        mySymbolBuildingThreads.add(currentThread);
        try {
            runnable.run();
        }
        finally {
            mySymbolBuildingThreads.remove(currentThread);
        }
    }

    static void processWithWriteActionPriority(@NotNull ProgressIndicator globalIndicator, @NotNull Project project2, @NotNull Consumer<? super ProgressIndicator> runnable) {
        final ProgressIndicator localProgress = OCSymbolTablesBuildingActivity.createCancelableLoopIndicator(globalIndicator);
        ProgressManager.getInstance().runProcess(() -> {
            if (project2.isDisposed()) {
                return;
            }
            ApplicationListener applicationListener = new ApplicationListener(){

                public void beforeWriteActionStart(@NotNull Object action) {
                    localProgress.cancel();
                }

                public void writeActionFinished(@NotNull Object action) {
                    if (localProgress.isRunning()) {
                        localProgress.stop();
                    }
                    localProgress.start();
                }
            };
            Disposable listenerDisposable = Disposer.newDisposable();
            ApplicationManager.getApplication().addApplicationListener(applicationListener, listenerDisposable);
            try {
                runnable.consume((Object)localProgress);
            }
            finally {
                Disposer.dispose((Disposable)listenerDisposable);
            }
        }, localProgress);
    }

    @NotNull
    private static ProgressIndicator createCancelableLoopIndicator(@NotNull ProgressIndicator mainIndicator) {
        return ourIndicatorFactory != null ? (ProgressIndicator)ourIndicatorFactory.produce() : new SensitiveProgressWrapper(mainIndicator){

            protected boolean isReuseable() {
                return true;
            }
        };
    }

    @NotNull
    static Runnable withCustomLoopIndicator(@NotNull Runnable action) {
        NotNullProducer<? extends ProgressIndicator> indicatorFactory = ourIndicatorFactory;
        return indicatorFactory != null ? () -> ProgressManager.getInstance().runProcess(action, (ProgressIndicator)indicatorFactory.produce()) : action;
    }

    @NotNull
    private static <T> Callable<T> withCustomLoopIndicator(@NotNull Callable<T> action) {
        NotNullProducer<? extends ProgressIndicator> indicatorFactory = ourIndicatorFactory;
        return indicatorFactory != null ? () -> {
            Object result2 = ProgressManager.getInstance().runProcess(() -> {
                try {
                    return action.call();
                }
                catch (Exception e) {
                    return e;
                }
            }, (ProgressIndicator)indicatorFactory.produce());
            if (result2 instanceof Exception) {
                throw (Exception)result2;
            }
            return result2;
        } : action;
    }

    public static void logStats(Logger logger) {
        StringBuilder text = new StringBuilder();
        text.append("Total symbol building time: ").append(StringUtil.formatDuration((long)MyProgressIndicator.ourTotalTime.get())).append("\n");
        for (Map.Entry entry : MyProgressIndicator.ourTotalTimePerActivity.entrySet()) {
            text.append("\tTotal ").append((String)entry.getKey()).append(" time: ").append(StringUtil.formatDuration((long)((AtomicLong)entry.getValue()).get())).append("\n");
        }
        logger.info(text.toString());
    }

    static {
        mySymbolBuildingThreads = ContainerUtil.newConcurrentSet();
        ACTIVITY_LOG = NotNullLazyKey.create((String)"SYMBOL ACTIVITY LOG", dom -> new ArrayList());
        EMPTY_TASK_PROVIDER = new AdditionalTaskProvider<Object>(){

            @Override
            @NotNull
            public String getTraceTitle() {
                return "EMPTY_TASK";
            }

            @Override
            @NotNull
            public String getTraceCategory() {
                return "EMPTY_TASK";
            }

            @Override
            @NotNull
            public Supplier<Object> getItemProvider() {
                return () -> null;
            }

            @Override
            @NotNull
            public Consumer<Object> getWorker() {
                return o -> {};
            }

            @Override
            @NotNull
            public String getIndicatorText() {
                return "";
            }
        };
    }

    public static interface AdditionalTaskProvider<T>
    extends TaskProvider<T> {
        @NotNull
        public String getTraceTitle();

        @NotNull
        public String getTraceCategory();
    }

    public static interface TaskProvider<T> {
        @NotNull
        public Supplier<T> getItemProvider();

        @NotNull
        public Consumer<T> getWorker();

        @NotNull
        public String getIndicatorText();
    }

    public static class MyProgressIndicator
    extends DelegatingProgressIndicator {
        private double myFromFraction;
        private double myToFraction = 1.0;
        private static final ConcurrentHashMap<String, AtomicLong> ourTotalTimePerActivity = new ConcurrentHashMap();
        private static final AtomicLong ourTotalTime = new AtomicLong();
        private String lastActivity;
        private long activityStarted;

        MyProgressIndicator(@NotNull ProgressIndicator indicator) {
            super(indicator);
        }

        public void startTiming(@NotNull @NonNls String activity) {
            this.activityStarted = System.currentTimeMillis();
            this.lastActivity = activity;
        }

        public void setText(@Nls @NlsContexts.ProgressText String text) {
            super.setText(text);
        }

        public void logTiming() {
            long now = System.currentTimeMillis();
            long time = now - this.activityStarted;
            AtomicLong totalActivityTime = ourTotalTimePerActivity.computeIfAbsent(this.lastActivity, s -> new AtomicLong(0L));
            totalActivityTime.addAndGet(time);
            ourTotalTime.addAndGet(time);
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                OCLog.LOG.info(this.lastActivity + " finished in " + StringUtil.formatDuration((long)time));
            }
        }

        public void setInterval(double from, double to) {
            this.myFromFraction = from;
            this.myToFraction = to;
        }

        public void setFraction(double fraction) {
            super.setFraction(this.myFromFraction + (this.myToFraction - this.myFromFraction) * fraction);
        }
    }

    private static abstract class RobustWorker<T>
    extends RestartableWorker<T> {
        private RobustWorker() {
        }

        @Override
        protected final void doProcess(@NotNull T item) {
            try {
                this.process(item);
            }
            catch (ProcessCanceledException pce) {
                throw pce;
            }
            catch (Throwable e) {
                OCLog.LOG.error(e);
            }
        }
    }

    private static class OCSymbolTableBuilder {
        @NotNull
        private final MyProgressIndicator myIndicator;
        @NotNull
        private final Project myProject;
        private final MultiMap<OCBuildFileCategory, OCBuildFileDescriptor> myClusterization = new MultiMap();

        OCSymbolTableBuilder(final @NotNull Project project2, @NotNull MyProgressIndicator progressIndicator, @NotNull Collection<VirtualFile> files, final boolean isSurrogate) {
            this.myIndicator = progressIndicator;
            this.myProject = project2;
            final Iterator<VirtualFile> iterator2 = files.iterator();
            if (!iterator2.hasNext()) {
                return;
            }
            progressIndicator.checkCanceled();
            OCSymbolTablesBuildingActivity.runCancelableReadAction(project2, (ProgressIndicator)progressIndicator, new RobustWorker<VirtualFile>(){

                @Override
                @Nullable
                protected VirtualFile nextItem() {
                    return iterator2.hasNext() ? (VirtualFile)iterator2.next() : null;
                }

                @Override
                protected void process(@NotNull VirtualFile virtualFile) {
                    if (!virtualFile.isValid()) {
                        return;
                    }
                    PsiFile file2 = PsiManager.getInstance((Project)project2).findFile(virtualFile);
                    if (!(file2 instanceof OCConfigurationOwner)) {
                        return;
                    }
                    for (OCResolveConfiguration config : OCInclusionContextUtil.getAllBuildConfigurationsForIndexing(virtualFile, project2)) {
                        OCLanguageKind kind = ((OCConfigurationOwner)file2).getRootKind(config);
                        OCBuildFileCategory traits = new OCBuildFileCategory(config.getCompilerSettings(kind, virtualFile).getIndexingCluster(), kind);
                        OCBuildFileDescriptor fileDescriptor = new OCBuildFileDescriptor(config, virtualFile, isSurrogate);
                        myClusterization.putValue((Object)traits, (Object)fileDescriptor);
                    }
                }
            });
        }

        public void processBuildFiles(double from, double to) {
            final int totalFilesCount = this.myClusterization.values().size();
            Set traits = this.myClusterization.keySet();
            final AtomicInteger processedFiles = new AtomicInteger(0);
            final ArrayList<BuildFileProvider> clusterProviders = new ArrayList<BuildFileProvider>();
            HashSet notProcessedFiles = new HashSet();
            for (OCBuildFileCategory t : traits) {
                Collection files = Collections.unmodifiableCollection(this.myClusterization.get((Object)t));
                notProcessedFiles.addAll(files);
                Iterator clusterIterator = files.iterator();
                clusterProviders.add(() -> {
                    while (clusterIterator.hasNext()) {
                        OCBuildFileDescriptor next = (OCBuildFileDescriptor)clusterIterator.next();
                        Set set = notProcessedFiles;
                        synchronized (set) {
                            if (notProcessedFiles.contains(next)) {
                                notProcessedFiles.remove(next);
                                return next;
                            }
                        }
                    }
                    return null;
                });
            }
            final BuildFileProvider remainingProvider = () -> {
                Set set = notProcessedFiles;
                synchronized (set) {
                    if (!notProcessedFiles.isEmpty()) {
                        OCBuildFileDescriptor next = (OCBuildFileDescriptor)notProcessedFiles.iterator().next();
                        notProcessedFiles.remove(next);
                        return next;
                    }
                }
                return null;
            };
            final OCImportGraph importGraph = OCImportGraph.getInstance(this.myProject);
            OCSymbolTablesBuildingActivity.processTasks(this.myProject, this.myIndicator, from, to, new TaskProvider<OCBuildFileDescriptor>(){

                @Override
                @NotNull
                public Supplier<OCBuildFileDescriptor> getItemProvider() {
                    return new PrioritizedBuildFileProvider(clusterProviders, remainingProvider);
                }

                @Override
                @NotNull
                public Consumer<OCBuildFileDescriptor> getWorker() {
                    return descriptor -> {
                        importGraph.buildSymbolAndRootHeaderCache(((OCBuildFileDescriptor)descriptor).myConfiguration, ((OCBuildFileDescriptor)descriptor).myFile, ((OCBuildFileDescriptor)descriptor).myIsSurrogate, (ProgressIndicator)myIndicator);
                        OCAdditionalFileSymbolTableBuilder.buildAllAdditionalTables(myProject, ((OCBuildFileDescriptor)descriptor).myFile);
                        myIndicator.setFraction((double)processedFiles.incrementAndGet() / (double)totalFilesCount);
                    };
                }

                @Override
                @NotNull
                public String getIndicatorText() {
                    return "Updating symbols";
                }
            });
        }

        private static class PrioritizedBuildFileProvider
        implements BuildFileProvider {
            private boolean myUseClusters = true;
            private Supplier<OCBuildFileDescriptor> myCurrentProvider;
            @NotNull
            private final Collection<BuildFileProvider> myProviders;
            @NotNull
            private final BuildFileProvider myBottomProvider;

            private PrioritizedBuildFileProvider(@NotNull Collection<BuildFileProvider> providers, @NotNull BuildFileProvider bottomProvider) {
                this.myProviders = providers;
                this.myBottomProvider = bottomProvider;
            }

            @Override
            @Nullable
            public OCBuildFileDescriptor get() {
                OCBuildFileDescriptor fromCluster = this.nextFromProviders();
                return fromCluster != null ? fromCluster : (OCBuildFileDescriptor)this.myBottomProvider.get();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private OCBuildFileDescriptor nextFromProviders() {
                if (!this.myUseClusters) {
                    return null;
                }
                while (true) {
                    BuildFileProvider provider2;
                    OCBuildFileDescriptor next;
                    if (this.myCurrentProvider != null && (next = this.myCurrentProvider.get()) != null) {
                        return next;
                    }
                    Collection<BuildFileProvider> collection = this.myProviders;
                    synchronized (collection) {
                        Iterator<BuildFileProvider> iterator2 = this.myProviders.iterator();
                        if (!iterator2.hasNext()) {
                            break;
                        }
                        provider2 = iterator2.next();
                        iterator2.remove();
                    }
                    this.myCurrentProvider = provider2;
                }
                this.myUseClusters = false;
                return null;
            }
        }

        @FunctionalInterface
        private static interface BuildFileProvider
        extends Supplier<OCBuildFileDescriptor> {
        }

        private static final class OCBuildFileDescriptor {
            private final VirtualFile myFile;
            private final OCResolveConfiguration myConfiguration;
            private final boolean myIsSurrogate;

            private OCBuildFileDescriptor(OCResolveConfiguration configuration, VirtualFile file2, boolean isSurrogate) {
                this.myConfiguration = configuration;
                this.myFile = file2;
                this.myIsSurrogate = isSurrogate;
            }
        }

        private static final class OCBuildFileCategory {
            private final Object myConfigurationCluster;
            private final OCLanguageKind myKind;

            private OCBuildFileCategory(@Nullable Object configurationCluster, @Nullable OCLanguageKind kind) {
                this.myConfigurationCluster = configurationCluster;
                this.myKind = kind;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                OCBuildFileCategory category = (OCBuildFileCategory)o;
                if (this.myKind != category.myKind) {
                    return false;
                }
                return Objects.equals(this.myConfigurationCluster, category.myConfigurationCluster);
            }

            public int hashCode() {
                int result2 = this.myConfigurationCluster != null ? this.myConfigurationCluster.hashCode() : 0;
                result2 = 31 * result2 + (this.myKind != null ? this.myKind.hashCode() : 0);
                return result2;
            }

            public String toString() {
                return "OCBuildFileCategory{myConfigurationCluster=" + this.myConfigurationCluster + ", myKind=" + this.myKind + '}';
            }
        }
    }

    public abstract class SymbolBuildingTask
    extends DumbModeTask {
        @NotNull
        private final String myActivityName;
        private volatile boolean myShouldCancel;

        protected SymbolBuildingTask(String activityName) {
            super((Object)activityName);
            this.myShouldCancel = true;
            this.myActivityName = activityName;
        }

        private boolean shouldCancel() {
            return this.myShouldCancel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void performInDumbMode(@NotNull ProgressIndicator original) {
            MyProgressIndicator indicator = new MyProgressIndicator(original);
            Disposable cancelOnProjectDispose = () -> {
                if (this.myShouldCancel) {
                    indicator.cancel();
                }
            };
            try {
                List log = (List)ACTIVITY_LOG.getValue((UserDataHolder)OCSymbolTablesBuildingActivity.this.project);
                long start = System.currentTimeMillis();
                List list = log;
                synchronized (list) {
                    log.add(this.myActivityName + " " + start + ": START");
                }
                Disposer.register((Disposable)OCSymbolTablesBuildingActivity.this.project, (Disposable)cancelOnProjectDispose);
                this.process(indicator);
                this.myShouldCancel = false;
                list = log;
                synchronized (list) {
                    log.add(this.myActivityName + " " + start + ": END after " + (System.currentTimeMillis() - start));
                }
            }
            catch (ProcessCanceledException pce) {
                if (indicator.isCanceled()) {
                    throw pce;
                }
                this.reportUnexpectedException(pce);
            }
            catch (Throwable t) {
                this.reportUnexpectedException(t);
            }
            finally {
                Disposer.dispose((Disposable)cancelOnProjectDispose);
            }
        }

        protected abstract void process(@NotNull MyProgressIndicator var1);

        private void reportUnexpectedException(Throwable t) {
            if (OCSymbolTablesBuildingActivity.this.project.isDisposed() || !OCSymbolTablesBuildingActivity.this.project.isOpen()) {
                return;
            }
            OCLog.LOG.error("Unexpected exception during symbol building (" + this.myActivityName + ")", t instanceof ProcessCanceledException ? new RuntimeException(t) : t);
        }
    }

    public static enum Mode {
        FAST,
        COMPACT,
        FULL;

    }
}

