/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.diagnostic.ThreadDumper;
import com.intellij.lang.ASTNode;
import com.intellij.lang.NodeStructure;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.source.tree.ASTStructure;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.CUDALanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.preprocessor.OCPreprocessingLexer;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCLocalBlock;
import com.jetbrains.cidr.lang.psi.impl.OCEagerBlockStatementImpl;
import com.jetbrains.cidr.lang.psi.impl.OCLazyElementBase;
import com.jetbrains.cidr.lang.symbols.BuilderDriverBase;
import com.jetbrains.cidr.lang.symbols.OCBuilderDriver;
import com.jetbrains.cidr.lang.symbols.symtable.ConsumedTokenRange;
import com.jetbrains.cidr.lang.symbols.symtable.ContextSignature;
import com.jetbrains.cidr.lang.symbols.symtable.CountingPsiBuilder;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.OCSymbolTableProcessor;
import com.jetbrains.cidr.lang.symbols.symtable.SymbolTableProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSymbolTableProvider
extends SymbolTableProvider {
    private static final Map<Thread, List<String>> ourDebugSymbolBuildingStack = new HashMap<Thread, List<String>>();
    private static final Logger LOG = Logger.getInstance(OCSymbolTableProvider.class);

    @Override
    public boolean isSource(@NotNull PsiFile file2) {
        return OCLanguageUtils.isSupported(file2);
    }

    @Override
    public boolean isSource(@NotNull Project project2, @NotNull VirtualFile file2, @NotNull OCInclusionContext context2) {
        OCLanguageKind languageKind = context2.getLanguageKind();
        return (languageKind instanceof CLanguageKind || languageKind instanceof CUDALanguageKind) && this.isSource(project2, file2);
    }

    @Override
    public boolean isSource(@NotNull Project project2, @NotNull VirtualFile file2) {
        PsiFile cachedPsi = OCInclusionContextUtil.findCachedPsiFile(file2, project2);
        if (cachedPsi != null && this.isSource(cachedPsi)) {
            return true;
        }
        return OCLanguageUtils.isSupported(file2);
    }

    @Override
    public boolean shouldPreProcess() {
        return true;
    }

    @Override
    public boolean shouldProcessPsiEvents(@NotNull PsiFile file2) {
        return file2 instanceof OCFile;
    }

    @Override
    public boolean isOutOfCodeBlockChange(@NotNull PsiTreeChangeEventImpl event) {
        PsiElement element = event.getParent();
        while (!(element instanceof PsiFile) && !(element instanceof PsiDirectory) && element != null) {
            if (element instanceof OCLocalBlock && !(element instanceof OCEagerBlockStatementImpl)) {
                return false;
            }
            element = element.getParent();
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    @Override
    @NotNull
    public FileSymbolTable calcTable(@NotNull VirtualFile virtualFile, @NotNull OCInclusionContext context) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    private static PsiBuilder createPsiBuilder(ParserDefinition parserDefinition, OCPreprocessingLexer lexer, String text) {
        PsiBuilder baseBuilder = PsiBuilderFactory.getInstance().createBuilder(parserDefinition, (Lexer)lexer, (CharSequence)text);
        if (Registry.is((String)"cidr.debug.show.parser.rollbacks")) {
            return new CountingPsiBuilder(baseBuilder);
        }
        return baseBuilder;
    }

    @Nullable
    private static List<ConsumedTokenRange> getConsumedTokenRanges(@NotNull PsiBuilder b) {
        return b instanceof CountingPsiBuilder ? ((CountingPsiBuilder)b).getConsumedTokenRanges() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startBuildingSymbolTable(@NotNull VirtualFile virtualFile) {
        Thread currentThread = Thread.currentThread();
        Map<Thread, List<String>> map2 = ourDebugSymbolBuildingStack;
        synchronized (map2) {
            List<String> stack = ourDebugSymbolBuildingStack.get(currentThread);
            if (stack == null) {
                stack = new ArrayList<String>();
                ourDebugSymbolBuildingStack.put(currentThread, stack);
            }
            stack.add(virtualFile.getUrl());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void finishBuildingSymbolTable() {
        Thread currentThread = Thread.currentThread();
        Map<Thread, List<String>> map2 = ourDebugSymbolBuildingStack;
        synchronized (map2) {
            List<String> stack = ourDebugSymbolBuildingStack.get(currentThread);
            stack.remove(stack.size() - 1);
            if (stack.isEmpty()) {
                ourDebugSymbolBuildingStack.remove(currentThread);
            }
        }
    }

    @Override
    @NotNull
    public FileSymbolTable calcTableUsingPSI(@NotNull PsiFile file2, @NotNull VirtualFile virtualFile, @NotNull OCInclusionContext context2) {
        FileSymbolTable answer = new FileSymbolTable(virtualFile, new ContextSignature());
        String text = file2.getViewProvider().getContents().toString();
        return OCSymbolTableProvider.buildTable(virtualFile, text, context2, answer, new ASTStructure((ASTNode)file2.getNode()){

            public int getChildren(@NotNull ASTNode astNode, @NotNull Ref<ASTNode[]> into) {
                return astNode instanceof OCLazyElementBase ? 0 : super.getChildren(astNode, into);
            }
        }, BuilderDriverBase.AST_NAMED_NODE_STRUCTURE);
    }

    private static <T> FileSymbolTable buildTable(@NotNull VirtualFile file2, String text, @NotNull OCInclusionContext context2, FileSymbolTable answer, FlyweightCapableTreeStructure<T> structure, NodeStructure<T> nodeStructure) {
        OCInclusionContext buildCtx = context2.deriveButDontCopyTypes(false);
        OCBuilderDriver<Object> driver = new OCBuilderDriver<Object>(file2, buildCtx, text, structure, nodeStructure, new OCSymbolTableProcessor(answer), context2.getProject());
        driver.processDeclarationsList(structure.getRoot());
        answer.sortSymbols();
        return answer;
    }

    public static class DumpCurrentlyBuildingSymbols
    extends DumbAwareAction {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(@NotNull AnActionEvent e) {
            Map map2 = ourDebugSymbolBuildingStack;
            synchronized (map2) {
                StringBuilder res = new StringBuilder(">>>>>>>>>>>>> Currently parsed files\n");
                for (Map.Entry entry : ourDebugSymbolBuildingStack.entrySet()) {
                    List files = (List)entry.getValue();
                    Thread thread = (Thread)entry.getKey();
                    res.append(thread).append(" ").append((Object)thread.getState()).append(" (").append(files.size()).append(")").append("\n");
                    for (String file2 : files) {
                        res.append(file2).append("\n");
                    }
                }
                res.append("<<<<<<<<<<<<<< End currently parsed files");
                LOG.warn(ThreadDumper.dumpThreadsToString());
                LOG.warn(res.toString());
            }
        }
    }
}

