/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.ContextSignature;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCContextSignatureBuilder
implements OCInclusionContext.SignatureBuilder {
    public static final int START_TEMP_CAPACITY = 512;
    private final Set<String> myDefined = new HashSet<String>();
    private final Set<String> myNotDefined = new HashSet<String>();
    private final List<String> myPendingDefined = new ArrayList<String>(512);
    private final List<String> myPendingNotDefined = new ArrayList<String>(512);
    private final Map<String, Integer> myDefinitions = new HashMap<String, Integer>();
    private final List<String> myPendingDefinitions = new ArrayList<String>(512);
    private final IntList myPendingDefinitionHashes = new IntArrayList(512);
    @Nullable
    public final OCLanguageKind languageKind;
    @NotNull
    private final List<String> myNamespace;
    private final boolean myIsSurrogate;
    private boolean myInConformMode;
    @Nullable
    private String myHeaderGuard;
    private boolean myHeaderGuardDefined;

    public OCContextSignatureBuilder(@Nullable OCLanguageKind kind, @NotNull List<String> namespace, boolean isSurrogate) {
        this.languageKind = kind;
        this.myNamespace = namespace;
        this.myIsSurrogate = isSurrogate;
    }

    @Override
    public void setDefined(@NotNull String name, boolean isDefined) {
        if (this.myInConformMode) {
            if (isDefined) {
                this.myPendingDefined.add(name);
            } else {
                this.myPendingNotDefined.add(name);
            }
        } else if (isDefined) {
            this.myDefined.add(name);
        } else {
            this.myNotDefined.add(name);
        }
    }

    @Override
    public void setHeaderGuardDefined(@NotNull String guard, boolean defined) {
        assert (this.myHeaderGuard == null || this.myHeaderGuard.equals(guard) && this.myHeaderGuardDefined == defined);
        this.myHeaderGuard = guard;
        this.myHeaderGuardDefined = defined;
    }

    @Override
    public void setDefinition(@NotNull String name, @NotNull OCMacroSymbol result2) {
        int substHash = result2.getSubstitutionHash();
        if (this.myInConformMode) {
            this.myPendingDefinitions.add(name);
            this.myPendingDefinitionHashes.add(substHash);
        } else {
            this.myDefinitions.put(name, substHash);
        }
    }

    @Override
    public void enterConformanceCheckMode() {
        this.resetPendingDefinitions();
        this.myInConformMode = true;
    }

    @Override
    public void exitConformanceCheckMode(boolean commit2) {
        if (commit2) {
            this.myDefined.addAll(this.myPendingDefined);
            this.myNotDefined.addAll(this.myPendingNotDefined);
            for (int i2 = 0; i2 < this.myPendingDefinitions.size(); ++i2) {
                this.myDefinitions.put(this.myPendingDefinitions.get(i2), this.myPendingDefinitionHashes.getInt(i2));
            }
        }
        this.resetPendingDefinitions();
        this.myInConformMode = false;
    }

    private void resetPendingDefinitions() {
        this.myPendingDefined.clear();
        this.myPendingNotDefined.clear();
        this.myPendingDefinitions.clear();
        this.myPendingDefinitionHashes.clear();
    }

    @NotNull
    public ContextSignature build() {
        for (String d : this.myDefined) {
            if (this.myDefinitions.containsKey(d)) continue;
            this.myDefinitions.put(d, null);
        }
        this.myDefined.clear();
        return new ContextSignature(this.languageKind, this.myDefinitions, this.myNotDefined, this.myNamespace, this.myIsSurrogate, this.myHeaderGuard, this.myHeaderGuardDefined);
    }
}

