/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.google.common.collect.ImmutableList;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.PowerSaveMode;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessor;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Alarm;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.Function;
import com.intellij.util.MathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.cidr.VirtualFileChangeListener;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCLazyBlockStatementElementType;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.DirtyIncludesInvalidator;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTableUpdater;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesPack;
import com.jetbrains.cidr.lang.symbols.symtable.OCFileSymbolTableListener;
import com.jetbrains.cidr.lang.symbols.symtable.OCSymbolTablesBuildingActivity;
import com.jetbrains.cidr.lang.symbols.symtable.ProcessingDependencyGraph;
import com.jetbrains.cidr.lang.symbols.symtable.SymbolTableProvider;
import com.jetbrains.cidr.lang.symbols.symtable.TableBuildingItem;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.SerializationService;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.SerializationSession;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceListener;
import gnu.trove.THashSet;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class FileSymbolTablesCache
implements ProjectComponent {
    public static final Topic<PsiModificationTracker.Listener> OUT_OF_CODE_BLOCK_TOPIC = new Topic(PsiModificationTracker.Listener.class, Topic.BroadcastDirection.TO_PARENT);
    private static final Logger LOG = Logger.getInstance(FileSymbolTablesCache.class);
    private static final boolean USE_PSI_FOR_INVALIDATION = Registry.is((String)"cidr.indexer.invalidateUsingPsi", (boolean)false);
    private static volatile Boolean ourForceSymbolsLoadedInTests = null;
    private static final SymbolsProperties DEFAULT_SYMBOLS_PROPERTIES;
    private static volatile SymbolsProperties ourSymbolsProperties;
    private final ConcurrentMap<VirtualFile, FileSymbolTablesPack> myCache = new ConcurrentHashMap<VirtualFile, FileSymbolTablesPack>();
    private final FileSymbolTableUpdater myTableUpdater;
    private final Project myProject;
    private final Set<VirtualFile> myPendingReparses = new THashSet();
    private final Set<VirtualFile> myPendingPSIResets = new THashSet();
    private final Object mySerializationLock = new Object();
    private final PeriodicSerializationTask mySerializationTask = new PeriodicSerializationTask();
    private final SimpleModificationTracker myOutOfBlockModificationTracker;
    private final AtomicBoolean mySymbolsLoaded = new AtomicBoolean(false);
    private final ProcessingDependencyGraph<TableBuildingItem> myProcessingDependencyGraph = new ProcessingDependencyGraph();
    private final SerializationService mySerializationService;

    @NotNull
    public static FileSymbolTablesCache getInstance(@NotNull Project project2) {
        return (FileSymbolTablesCache)project2.getComponent(FileSymbolTablesCache.class);
    }

    public FileSymbolTablesCache(final @NotNull Project project2) {
        this.myTableUpdater = new FileSymbolTableUpdater(project2);
        this.myProject = project2;
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        final PsiModificationTrackerImpl psiTracker = (PsiModificationTrackerImpl)psiManager.getModificationTracker();
        this.myOutOfBlockModificationTracker = new SimpleModificationTracker(){

            public void incModificationCount() {
                super.incModificationCount();
                psiTracker.incOutOfCodeBlockModificationCounter();
                ((PsiModificationTracker.Listener)project2.getMessageBus().syncPublisher(OUT_OF_CODE_BLOCK_TOPIC)).modificationCountChanged();
            }
        };
        if (psiManager instanceof PsiManagerImpl) {
            ((PsiManagerImpl)psiManager).addTreeChangePreprocessor((PsiTreeChangePreprocessor)new OCCodeBlockModificationListener());
        }
        MessageBusConnection connection = project2.getMessageBus().connect();
        this.listenOCWorkspaceChanges(connection);
        this.listenVFSChanges(connection);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            StartupManager.getInstance((Project)project2).runAfterOpened((Runnable)new TestSymbolReBuilder(project2));
        }
        this.mySerializationService = SerializationService.getService();
    }

    private void listenOCWorkspaceChanges(MessageBusConnection connection) {
        connection.subscribe(OCWorkspaceListener.TOPIC, (Object)new OCWorkspaceListener(){

            @Override
            public void workspaceChanged(@NotNull OCWorkspaceListener.OCWorkspaceEvent event) {
                OCInclusionContextUtil.invalidateHeaderRootAndActiveConfigurationForAllExcept(null, FileSymbolTablesCache.this.myProject);
                if (event.resolveConfigurationsChanged() || event.compilerSettingsChanged()) {
                    OCSymbolTablesBuildingActivity.getInstance(FileSymbolTablesCache.this.myProject).rebuildSymbols();
                }
                FileSymbolTablesCache.this.incModificationCount();
            }

            @Override
            public void selectedResolveConfigurationChanged() {
                OCInclusionContextUtil.invalidateHeaderRootAndActiveConfigurationForAllExcept(null, FileSymbolTablesCache.this.myProject);
                FileSymbolTablesCache.this.scheduleReparseCachedPsiFiles();
            }
        });
    }

    private void listenVFSChanges(MessageBusConnection connection) {
        if (((Boolean)OCLanguage.LANGUAGE_SUPPORT_DISABLED.get((UserDataHolder)this.myProject, (Object)false)).booleanValue()) {
            return;
        }
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new VirtualFileChangeListener(true){
            private ClearTablesAndCollectNamesVisitor visitor;

            @Override
            protected void begin() {
                this.visitor = new ClearTablesAndCollectNamesVisitor();
            }

            @Override
            protected void onFileChange(@NotNull VirtualFile file2, @NotNull VFileEvent event) {
                if (((Boolean)OCLanguage.LANGUAGE_SUPPORT_DISABLED.get((UserDataHolder)FileSymbolTablesCache.this.myProject, (Object)true)).booleanValue()) {
                    return;
                }
                if (event.isFromSave()) {
                    return;
                }
                VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)this.visitor);
            }

            @Override
            protected void done() {
                if (((Boolean)OCLanguage.LANGUAGE_SUPPORT_DISABLED.get((UserDataHolder)FileSymbolTablesCache.this.myProject, (Object)true)).booleanValue()) {
                    return;
                }
                Set<String> toInvalidate = this.visitor.dirtyNames;
                boolean cacheCleared = this.visitor.cacheCleared;
                this.visitor = null;
                boolean includingFilesInvalidated = FileSymbolTablesCache.this.invalidateDirtyIncludes(toInvalidate);
                if (includingFilesInvalidated || cacheCleared) {
                    FileSymbolTablesCache.this.incModificationCount();
                }
            }
        });
    }

    @NotNull
    public ModificationTracker getOutOfBlockModificationTracker() {
        return this.myOutOfBlockModificationTracker;
    }

    public void projectOpened() {
        if (!this.myProject.isDefault() && !ApplicationManager.getApplication().isUnitTestMode()) {
            this.mySerializationTask.schedule(20000);
        }
    }

    public void projectClosed() {
        this.mySerializationTask.cancelAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean shouldBuildTables() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        Class<FileSymbolTablesCache> clazz = FileSymbolTablesCache.class;
        synchronized (FileSymbolTablesCache.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return ourSymbolsProperties == null || ourSymbolsProperties.buildSymbolsKind != SymbolsProperties.SymbolsKind.NO_SYMBOLS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean shouldBuildTablesForAllSystemHeaders() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        Class<FileSymbolTablesCache> clazz = FileSymbolTablesCache.class;
        synchronized (FileSymbolTablesCache.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return ourSymbolsProperties == null || ourSymbolsProperties.buildSymbolsKind == SymbolsProperties.SymbolsKind.ALL_INCLUDING_UNUSED_SYSTEM_HEADERS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isSerializationEnabled() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        Class<FileSymbolTablesCache> clazz = FileSymbolTablesCache.class;
        synchronized (FileSymbolTablesCache.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return ourSymbolsProperties == null || ourSymbolsProperties.serializeSymbolTables;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isDeserializationEnabled() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        Class<FileSymbolTablesCache> clazz = FileSymbolTablesCache.class;
        synchronized (FileSymbolTablesCache.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return ourSymbolsProperties == null || ourSymbolsProperties.deserializeSymbolTables;
        }
    }

    @Nullable
    public static synchronized SymbolsProperties setShouldBuildTablesInTests(@Nullable SymbolsProperties properties) {
        SymbolsProperties prev = ourSymbolsProperties;
        ourSymbolsProperties = properties != null ? properties : DEFAULT_SYMBOLS_PROPERTIES;
        return prev;
    }

    public boolean invalidateDirtyIncludes(@NotNull Set<String> dirtyNames) {
        return this.invalidateDirtyIncludes(dirtyNames, false);
    }

    public boolean invalidateDirtyIncludes(@NotNull Set<String> dirtyNames, boolean isRelativePath) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (dirtyNames.isEmpty()) {
            return false;
        }
        Set<VirtualFile> allCachedFiles = this.getCachedFiles();
        ImmutableList.Builder cachedFilesBuilder = ImmutableList.builderWithExpectedSize((int)allCachedFiles.size());
        for (VirtualFile cachedFile : allCachedFiles) {
            if (!cachedFile.isValid()) continue;
            cachedFilesBuilder.add((Object)cachedFile);
        }
        ImmutableList cachedFiles = cachedFilesBuilder.build();
        DirtyIncludesInvalidator invalidator = new DirtyIncludesInvalidator(this, dirtyNames, isRelativePath, cachedFiles.size());
        Collection<VirtualFile> pendingInvalidation = invalidator.collect((ImmutableList<VirtualFile>)cachedFiles);
        return this.invalidateDirtyIncludeFiles(pendingInvalidation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invalidateDirtyIncludeFiles(@NotNull Collection<VirtualFile> dirtyFiles) {
        boolean result2 = false;
        if (!dirtyFiles.isEmpty()) {
            THashSet processedFiles = new THashSet();
            for (VirtualFile file2 : dirtyFiles) {
                if (!this.invalidate(file2, true, (Set<VirtualFile>)processedFiles, true)) continue;
                result2 = true;
                Set<VirtualFile> set = this.myPendingReparses;
                synchronized (set) {
                    this.myPendingReparses.add(file2);
                }
            }
            if (result2) {
                OCImportGraph.getInstance(this.myProject).invalidateHeaderRootsCache();
                OCInclusionContextUtil.invalidateHeaderRootAndActiveConfigurationForAllExcept(null, this.myProject);
            }
        }
        this.schedulePSIUpdates();
        return result2;
    }

    public void compact() {
        for (FileSymbolTablesPack pack : this.myCache.values()) {
            pack.compactSynchronized();
        }
    }

    @NotNull
    public Set<VirtualFile> getFilesToBuildTablesFor() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Collection<VirtualFile> allSourceFiles = OCSearchScope.getExplicitlySpecifiedProjectSourceFiles(this.myProject);
        Set result2 = (Set)CollectionsKt.filterTo(allSourceFiles, new LinkedHashSet(), virtualFile -> SymbolTableProvider.isSourceFile(this.myProject, virtualFile));
        if (FileSymbolTablesCache.shouldBuildTablesForAllSystemHeaders()) {
            result2.addAll(OCInclusionContextUtil.getHeaderFilesToBuildSymbols(this.myProject));
        }
        return result2;
    }

    public Set<VirtualFile> getCachedFiles() {
        return this.myCache.keySet();
    }

    public void addFileToCache(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return;
        }
        this.myTableUpdater.addFileForUpdate(file2);
    }

    public void addFilesToCache(@NotNull Collection<VirtualFile> files) {
        this.myTableUpdater.addFilesForUpdate(files, false);
    }

    @NotNull
    public @NotNull List<@NotNull VirtualFile> removeFilesFromCache(@NotNull @NotNull Iterable<@NotNull ? extends VirtualFile> files) {
        return CollectionsKt.filter(files, this::clearCache);
    }

    public void removeAllChildrenFromCache(@Nullable VirtualFile root) {
        if (root == null) {
            return;
        }
        for (VirtualFile file2 : this.myCache.keySet()) {
            if (file2 == null || !VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file2, (boolean)false)) continue;
            this.clearCache(file2);
        }
    }

    public FileSymbolTable calcTableUsingPSI(@NotNull PsiFile file2, @NotNull VirtualFile virtualFile, @NotNull OCInclusionContext context2) {
        return SymbolTableProvider.getProvider(file2).calcTableUsingPSI(file2, virtualFile, context2);
    }

    @Nullable
    public FileSymbolTable forFile(@NotNull VirtualFile virtualFile, @NotNull OCInclusionContext context2) {
        return this.forFile(virtualFile, context2, null);
    }

    @Nullable
    public FileSymbolTable forFile(@NotNull VirtualFile virtualFile, @NotNull OCInclusionContext context2, @Nullable SerializationSession serializationSession) {
        Ref outTimeStamp;
        ProgressManager.checkCanceled();
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            LOG.error("deadlock may occur if 'FileSymbolTablesCache.forFile' is called outside of read-action");
        }
        if (!FileSymbolTablesCache.shouldBuildTables() || !virtualFile.isValid()) {
            return null;
        }
        FileSymbolTablesPack pack = this.mutablePackForFile(virtualFile, serializationSession);
        FileSymbolTable table = pack.findConformingTable(context2, 0, (Ref<Integer>)(outTimeStamp = new Ref()));
        if (table != null || context2.getInclusionLevel() >= OCInclusionContext.getMaxInclusionLevel()) {
            return table;
        }
        return this.buildTableForFile(virtualFile, context2, pack, (Ref<Integer>)outTimeStamp);
    }

    /*
     * Exception decompiling
     */
    @NotNull
    private FileSymbolTable buildTableForFile(@NotNull VirtualFile virtualFile, @NotNull OCInclusionContext context, @NotNull FileSymbolTablesPack pack, @NotNull Ref<Integer> outTimeStamp) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK]], but top level block is 34[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void notifyNewTables(@NotNull VirtualFile virtualFile) {
        ((OCFileSymbolTableListener)this.myProject.getMessageBus().syncPublisher(OCFileSymbolTableListener.TOPIC)).onFileHasNewSymbolTableInPack(virtualFile);
    }

    @Nullable
    public FileSymbolTable findForFile(@NotNull VirtualFile file2, @NotNull OCInclusionContext context2) {
        FileSymbolTablesPack pack = this.packForFile(file2);
        return pack != null ? pack.findConformingTable(context2, 0, null) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleReparseFile(OCFile file2) {
        Set<VirtualFile> set = this.myPendingReparses;
        synchronized (set) {
            this.myPendingReparses.add(OCInclusionContextUtil.getVirtualFile(file2));
        }
        this.schedulePSIUpdates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCachedFilesToReparse() {
        Set<VirtualFile> set = this.myPendingReparses;
        synchronized (set) {
            for (PsiFile file2 : PsiManagerEx.getInstanceEx((Project)this.myProject).getFileManager().getAllCachedFiles()) {
                this.myPendingReparses.add(OCInclusionContextUtil.getVirtualFile(file2));
            }
        }
    }

    private void scheduleReparseCachedPsiFiles() {
        this.addCachedFilesToReparse();
        this.schedulePSIUpdates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedulePSIUpdates() {
        Set<VirtualFile> set = this.myPendingReparses;
        synchronized (set) {
            if (!this.myPendingPSIResets.isEmpty() || !this.myPendingReparses.isEmpty()) {
                ApplicationManager.getApplication().invokeLater(() -> this.updateDirtyFilesPSI(), ModalityState.NON_MODAL);
            }
        }
    }

    public void reparseCachedPsiFiles() {
        this.addCachedFilesToReparse();
        this.updateDirtyFilesPSI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDirtyFilesPSI() {
        ArrayList<VirtualFile> toResetPSI;
        if (this.myProject.isDisposed()) {
            return;
        }
        HashSet<VirtualFile> toReparse = new HashSet<VirtualFile>();
        FileManager fileManager = PsiManagerEx.getInstanceEx((Project)this.myProject).getFileManager();
        Set<VirtualFile> set = this.myPendingReparses;
        synchronized (set) {
            this.myPendingPSIResets.removeAll(this.myPendingReparses);
            toResetPSI = new ArrayList<VirtualFile>(this.myPendingPSIResets);
            this.myPendingPSIResets.clear();
            for (VirtualFile virtualFile : this.myPendingReparses) {
                FileViewProvider pp;
                if (!virtualFile.isValid() || (pp = fileManager.findCachedViewProvider(virtualFile)) == null) continue;
                OCLog.LOG.assertTrue(pp instanceof AbstractFileViewProvider, (Object)pp);
                for (PsiFile cached : ((AbstractFileViewProvider)pp).getCachedPsiFiles()) {
                    FileSymbolTablesCache.processDirtyFile(toReparse, cached, virtualFile);
                }
            }
            this.myPendingReparses.clear();
        }
        if (!toResetPSI.isEmpty()) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                for (VirtualFile file2 : toResetPSI) {
                    fileManager.setViewProvider(file2, null);
                }
            });
        }
        if (!toReparse.isEmpty()) {
            FileContentUtilCore.reparseFiles(toReparse);
        }
        if (!toResetPSI.isEmpty() || !toReparse.isEmpty()) {
            DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
        }
    }

    private static void processDirtyFile(@NotNull Set<VirtualFile> dirty, @NotNull PsiFile file2, @NotNull VirtualFile virtualFile) {
        if (SymbolTableProvider.isSourceFile(file2.getProject(), virtualFile) && file2 instanceof PsiFileImpl) {
            FileElement node2 = ((PsiFileImpl)file2).getTreeElement();
            if (node2 != null && node2.isParsed()) {
                dirty.add(virtualFile);
            } else {
                file2.clearCaches();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean invalidate(@Nullable VirtualFile file2, boolean reparse, Set<VirtualFile> processed, boolean withIncludingFiles) {
        if (file2 == null || !processed.add(file2)) {
            return false;
        }
        boolean result2 = this.clearCache(file2);
        if (file2.isValid() && SymbolTableProvider.isSourceFile(this.myProject, file2)) {
            this.myTableUpdater.addFileForUpdate(file2);
        }
        if (withIncludingFiles) {
            Collection<OCResolveConfiguration> configs;
            Set<VirtualFile> dirtySet = reparse ? this.myPendingReparses : this.myPendingPSIResets;
            OCWorkspace workspace = OCWorkspace.getInstance(this.myProject);
            if (!OCInclusionContextUtil.isNeedToFindRoot(file2, this.myProject)) {
                for (OCResolveConfiguration config : workspace.getConfigurations()) {
                    OCImportGraph.invalidateRootHeadersCache(config, file2);
                }
            }
            if (!(configs = OCInclusionContext.getBuildConfigurationByPchFile(file2, this.myProject)).isEmpty()) {
                Runnable runnable = () -> {
                    if (this.myProject.isDisposed()) {
                        return;
                    }
                    for (OCResolveConfiguration config : configs) {
                        OCInclusionContext.onPrecompiledContextChange(config);
                    }
                    Collection<VirtualFile> sourceFiles = OCSearchScope.getExplicitlySpecifiedProjectSourceFiles(this.myProject);
                    List<VirtualFile> clearedFiles = this.myTableUpdater.addFilesForUpdate(sourceFiles, true);
                    if (clearedFiles.isEmpty()) {
                        return;
                    }
                    Set<VirtualFile> set = this.myPendingReparses;
                    synchronized (set) {
                        dirtySet.addAll(clearedFiles);
                    }
                };
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    runnable.run();
                } else {
                    ApplicationManager.getApplication().invokeLater(runnable, ModalityState.NON_MODAL);
                }
            }
            THashSet includingFiles = new THashSet();
            if (USE_PSI_FOR_INVALIDATION) {
                PsiFile psiFile = OCInclusionContextUtil.findCachedPsiFile(file2, this.myProject);
                if (psiFile instanceof OCFile) {
                    Collection<VirtualFile> includingFromPsi = ((OCFile)psiFile).resetIncludingFiles();
                    includingFiles.addAll(includingFromPsi);
                }
            } else {
                Collection<VirtualFile> immediateIncludingFiles = OCImportGraph.getInstance(this.myProject).findImmediateIncludingFiles(file2, false);
                includingFiles.addAll(immediateIncludingFiles);
            }
            for (VirtualFile including : includingFiles) {
                if (!this.invalidate(including, reparse, processed, true)) continue;
                result2 = true;
                Set<VirtualFile> set = this.myPendingReparses;
                synchronized (set) {
                    dirtySet.add(including);
                }
            }
        }
        return result2;
    }

    public void ensurePendingFilesProcessed() {
        this.ensurePendingFilesProcessed(false);
    }

    public void ensurePendingFilesProcessed(boolean rootsOnly) {
        this.myTableUpdater.ensurePendingFilesProcessed(rootsOnly);
    }

    @NotNull
    public @Unmodifiable List<FileSymbolTable> allTablesForFile(OCPsiFile file2) {
        return this.allTablesForFile(OCInclusionContextUtil.getVirtualFile(file2));
    }

    @NotNull
    public @Unmodifiable List<FileSymbolTable> allTablesForFile(@NotNull VirtualFile virtualFile) {
        FileSymbolTablesPack pack = this.packForFile(virtualFile);
        return pack != null ? pack.getTablesSynchronized() : ContainerUtil.emptyList();
    }

    public int allTablesForFileCount(@NotNull VirtualFile virtualFile) {
        FileSymbolTablesPack pack = this.packForFile(virtualFile);
        return pack != null ? pack.getTablesCountSynchronized() : 0;
    }

    @Nullable
    private FileSymbolTablesPack packForFile(@NotNull VirtualFile virtualFile) {
        return (FileSymbolTablesPack)this.myCache.get(virtualFile);
    }

    @NotNull
    private FileSymbolTablesPack mutablePackForFile(@NotNull VirtualFile virtualFile, @Nullable SerializationSession serializationSession) {
        FileSymbolTablesPack pack = (FileSymbolTablesPack)this.myCache.get(virtualFile);
        if (pack != null) {
            return pack;
        }
        FileSymbolTablesPack deserializedPack = this.deserializePackForFile(virtualFile, serializationSession);
        FileSymbolTablesPack newPack = deserializedPack != null ? deserializedPack : new FileSymbolTablesPack();
        return this.addDeserializedPack(virtualFile, newPack);
    }

    @NotNull
    private FileSymbolTablesPack addDeserializedPack(@NotNull VirtualFile virtualFile, @NotNull FileSymbolTablesPack newPack) {
        FileSymbolTablesPack prev = this.myCache.putIfAbsent(virtualFile, newPack);
        if (prev == null) {
            if (newPack.getTablesCountSynchronized() > 0) {
                newPack.onThaw(this.myProject);
                this.notifyNewTables(virtualFile);
            }
            return newPack;
        }
        return prev;
    }

    @Nullable
    private FileSymbolTablesPack deserializePackForFile(@NotNull VirtualFile virtualFile, @Nullable SerializationSession serializationSession) {
        if (serializationSession != null && FileSymbolTablesCache.isDeserializationEnabled() && virtualFile instanceof VirtualFileWithId) {
            return SerializationService.getService().deserializeTables(this.myProject, serializationSession, virtualFile);
        }
        return null;
    }

    public void clearAllTables() {
        ArrayList packs2 = new ArrayList(this.myCache.values());
        this.myCache.clear();
        for (FileSymbolTablesPack pack : packs2) {
            pack.onRemove(this.myProject);
        }
        ((OCFileSymbolTableListener)this.myProject.getMessageBus().syncPublisher(OCFileSymbolTableListener.TOPIC)).onAllSymbolTablesDropped();
    }

    private boolean clearCache(@NotNull VirtualFile file2) {
        FileSymbolTablesPack pack = (FileSymbolTablesPack)this.myCache.remove(file2);
        if (pack != null) {
            pack.onRemove(this.myProject);
            ((OCFileSymbolTableListener)this.myProject.getMessageBus().syncPublisher(OCFileSymbolTableListener.TOPIC)).onFileHasInvalidSymbolTableInPack(file2);
        }
        return pack != null;
    }

    private int fillCache(Map<VirtualFile, FileSymbolTablesPack> packs2) {
        for (FileSymbolTablesPack pack : packs2.values()) {
            pack.onThaw(this.myProject);
        }
        this.myCache.putAll(packs2);
        return packs2.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void serializeTables(@NotNull String projectLocationHash, @NotNull Collection<VirtualFile> files, @NotNull ProgressIndicator indicator) {
        Object object = this.mySerializationLock;
        synchronized (object) {
            if (!FileSymbolTablesCache.isSerializationEnabled()) {
                return;
            }
            HashMap<VirtualFile, FileSymbolTablesPack> tables = new HashMap<VirtualFile, FileSymbolTablesPack>();
            for (VirtualFile file2 : files) {
                FileSymbolTablesPack pack = this.packForFile(file2);
                if (pack == null) continue;
                tables.put(file2, pack);
            }
            this.mySerializationService.serializeTables(this.myProject, projectLocationHash, tables, indicator);
        }
    }

    public static boolean areSymbolsLoaded(@NotNull Project project2) {
        if (ourForceSymbolsLoadedInTests != null) {
            return ourForceSymbolsLoadedInTests;
        }
        FileSymbolTablesCache instance2 = (FileSymbolTablesCache)project2.getComponent(FileSymbolTablesCache.class);
        return instance2 == null || !FileSymbolTablesCache.shouldBuildTables() || instance2.mySymbolsLoaded.get();
    }

    public boolean areSymbolsLoaded() {
        if (ourForceSymbolsLoadedInTests != null) {
            return ourForceSymbolsLoadedInTests;
        }
        return !FileSymbolTablesCache.shouldBuildTables() || this.mySymbolsLoaded.get();
    }

    public boolean isUpToDate() {
        return this.isUpToDate(false);
    }

    public boolean isUpToDate(boolean rootsOnly) {
        return FileSymbolTablesCache.areSymbolsLoaded(this.myProject) && this.myTableUpdater.isUpToDate(rootsOnly);
    }

    public static int getIndexingThreadCount() {
        return FileSymbolTablesCache.getIndexingThreadCount(Registry.intValue((String)"cidr.indexer.thread.count"));
    }

    static int getIndexingThreadCount(int userValue) {
        int cpuCount = Runtime.getRuntime().availableProcessors();
        if (userValue <= 0) {
            userValue = cpuCount + userValue;
        }
        return MathUtil.clamp((int)userValue, (int)1, (int)cpuCount);
    }

    public static void forceSymbolsLoadedInTests(@Nullable Boolean force) {
        ourForceSymbolsLoadedInTests = force;
    }

    public static Boolean getForceSymbolsLoadedInTests() {
        return ourForceSymbolsLoadedInTests;
    }

    void notifySymbolsLoaded() {
        this.mySymbolsLoaded.getAndSet(true);
    }

    void notifySymbolsUnloaded() {
        this.mySymbolsLoaded.getAndSet(false);
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    public void removeJunkTables(boolean includingUnused) {
        for (FileSymbolTablesPack pack : this.myCache.values()) {
            pack.removeJunkTables(this.myProject, includingUnused);
        }
    }

    @NotNull
    public Collection<VirtualFile> getFilesWithChangedTables() {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        for (Map.Entry entry : this.myCache.entrySet()) {
            if (!((FileSymbolTablesPack)entry.getValue()).isChanged()) continue;
            result2.add((VirtualFile)entry.getKey());
        }
        return result2;
    }

    @NotNull
    public Collection<VirtualFile> getFilesWithNonFallbackTables(boolean withUsedTablesOnly) {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        for (Map.Entry entry : this.myCache.entrySet()) {
            FileSymbolTablesPack pack = (FileSymbolTablesPack)entry.getValue();
            if (pack.isFallback() || withUsedTablesOnly && !pack.hasUsedTables()) continue;
            result2.add((VirtualFile)entry.getKey());
        }
        return result2;
    }

    public long deserializeTables(@NotNull String projectLocationHash, @NotNull Collection<VirtualFile> filesToLoad, @NotNull ProgressIndicator indicator, double indicatorScale) {
        if (!FileSymbolTablesCache.isDeserializationEnabled()) {
            return 0L;
        }
        Map<VirtualFile, FileSymbolTablesPack> packs2 = this.mySerializationService.deserializeTables(this.myProject, projectLocationHash, filesToLoad, indicator, indicatorScale);
        return this.fillCache(packs2);
    }

    public void deserializeTables(@NotNull SerializationSession session, @NotNull VirtualFile file2) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (this.myCache.get(file2) != null) {
            return;
        }
        FileSymbolTablesPack pack = this.deserializePackForFile(file2, session);
        if (pack != null) {
            this.addDeserializedPack(file2, pack);
        }
    }

    public void handleOutOfCodeBlockChange(@NotNull PsiFile file2, boolean hasMacro) {
        VirtualFile virtualFile = OCInclusionContextUtil.getVirtualFile(file2);
        if (SymbolTableProvider.isSourceFile(file2.getProject(), virtualFile)) {
            if (this.invalidate(virtualFile, false, (Set<VirtualFile>)new SmartHashSet(), hasMacro)) {
                OCInclusionContextUtil.invalidateHeaderContextsExcept(virtualFile, file2.getProject());
                this.incModificationCount();
            }
            this.schedulePSIUpdates();
        }
        if (hasMacro) {
            OCImportGraph.getInstance(this.myProject).invalidateHeaderRootsCache();
            OCInclusionContextUtil.invalidateHeaderRootAndActiveConfigurationForAllExcept(virtualFile, file2.getProject());
        }
    }

    public void incModificationCount() {
        this.myOutOfBlockModificationTracker.incModificationCount();
    }

    public void dumpStats(@Nullable PrintWriter out) {
        if (out == null) {
            out = new PrintWriter(System.out);
        }
        ArrayList list = new ArrayList(this.myCache.entrySet());
        Collections.sort(list, (o1, o2) -> {
            int c = Comparing.compare((int)((FileSymbolTablesPack)o1.getValue()).getTablesCountSynchronized(), (int)((FileSymbolTablesPack)o2.getValue()).getTablesCountSynchronized());
            if (c != 0) {
                return c;
            }
            List<FileSymbolTable> ts1 = ((FileSymbolTablesPack)o1.getValue()).tablesView();
            List<FileSymbolTable> ts2 = ((FileSymbolTablesPack)o2.getValue()).tablesView();
            if (ts1.size() > 0 && ts2.size() > 0) {
                VirtualFile f1 = ts1.get(0).getContainingFile();
                VirtualFile f2 = ts2.get(0).getContainingFile();
                int fc = Comparing.compare((Comparable)((Object)f1.getName()), (Comparable)((Object)f2.getName()));
                if (fc != 0) {
                    return fc;
                }
                return Comparing.compare((Comparable)((Object)f1.getPath()), (Comparable)((Object)f2.getPath()));
            }
            return Comparing.compare((int)ts1.size(), (int)ts2.size());
        });
        int totalFiles = 0;
        int multiTableFiles = 0;
        int totalSymbols = 0;
        int totalUniqueSymbols = 0;
        int totalContents = 0;
        int totalTables = 0;
        int totalUniqueContents = 0;
        int totalUniqueContentsLen = 0;
        for (Map.Entry entry : list) {
            ++totalFiles;
            VirtualFile file2 = (VirtualFile)entry.getKey();
            FileSymbolTablesPack pack = (FileSymbolTablesPack)entry.getValue();
            List tables = pack.getTablesSynchronized();
            if (tables.size() > 1) {
                ++multiTableFiles;
                Function tablePrinter = table -> Integer.toString(table.getUsageCount());
                int symbolCount = 0;
                int contentsCount = 0;
                THashSet uniqueSymbols = new THashSet(ContainerUtil.identityStrategy());
                THashSet uniqueContents = new THashSet();
                int uniqueContentsLength = 0;
                for (FileSymbolTable table2 : tables) {
                    List<OCSymbol> contents = table2.getContents();
                    symbolCount += contents.size();
                    uniqueSymbols.addAll(contents);
                    ++contentsCount;
                    if (!uniqueContents.add(contents)) continue;
                    uniqueContentsLength += contents.size();
                }
                totalSymbols += symbolCount;
                totalUniqueSymbols += uniqueSymbols.size();
                totalTables += contentsCount;
                totalContents += contentsCount;
                totalUniqueContents += uniqueContents.size();
                totalUniqueContentsLen += uniqueContentsLength;
                double reuseFactor = (double)uniqueSymbols.size() / (double)symbolCount;
                if (reuseFactor == 0.5) {
                    int br_1371 = 0;
                    ++br_1371;
                }
                if (reuseFactor < 0.005) {
                    int br_1379 = 0;
                    ++br_1379;
                }
                String num = String.format("%5d", totalFiles + 1);
                String contentsReuseInfo = "";
                if (uniqueContents.size() != contentsCount) {
                    contentsReuseInfo = ", " + uniqueContents.size() + "/" + contentsCount + " <" + uniqueContentsLength + "/" + symbolCount + ">";
                }
                String tableBaseInfo = file2.getName() + " (" + tables.size() + ") -> : [" + String.format("%.4f", reuseFactor) + contentsReuseInfo + "] ";
                out.println(num + " -- " + tableBaseInfo + StringUtil.join(tables, (Function)tablePrinter, (String)", "));
                tables = ContainerUtil.sorted(tables, (o1, o2) -> Comparing.compare((int)o2.getUsageCount(), (int)o1.getUsageCount()));
                out.println(num + "    " + tableBaseInfo + StringUtil.join((Collection)tables, (Function)tablePrinter, (String)", "));
                continue;
            }
            ++totalTables;
        }
        out.println("============================");
        out.println("multitable files: " + multiTableFiles + " / " + totalFiles + " (" + (double)multiTableFiles / (double)totalFiles + ")");
        out.println("reusedSym/totalSym = " + totalUniqueSymbols + "/" + totalSymbols);
        out.println("uniqueMultiTables/totalMultiTables = " + totalUniqueContents + "/" + totalContents);
        out.println("uniqueTablesSize/totalTablesSize = " + totalUniqueContentsLen + "/" + totalSymbols);
        out.println("uniqueTables/totalTables = " + (totalUniqueContents + totalFiles - multiTableFiles) + "/" + totalTables);
    }

    public void dumpTablePackStats(@NotNull VirtualFile file2, @Nullable PrintWriter out) {
        if (out == null) {
            out = new PrintWriter(System.out);
        }
        out.println(file2.getPath());
        List<FileSymbolTable> tables = this.allTablesForFile(file2);
        out.println("Total: " + tables.size());
        int i2 = 0;
        for (FileSymbolTable table : tables) {
            out.println("=> " + i2 + " -> " + table.getContents().size() + " (valid: " + table.isValid() + ", fallback: " + table.isFallback() + ")");
            table.getSignature().dumpStats(out);
            ++i2;
        }
    }

    static {
        ourSymbolsProperties = DEFAULT_SYMBOLS_PROPERTIES = ApplicationManager.getApplication().isUnitTestMode() ? SymbolsProperties.NO_SYMBOLS : null;
    }

    private static class Delta {
        final int start;
        final int shift;

        private Delta(int start, int shift) {
            this.start = start;
            this.shift = shift;
        }
    }

    class PeriodicSerializationTask
    implements Runnable {
        public static final int IDLE_PERIOD = 20000;
        public static final int POLL_PERIOD = 10000;
        private final Alarm myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);

        PeriodicSerializationTask() {
        }

        @Override
        public void run() {
            if (this.shouldStop()) {
                return;
            }
            if (!this.shouldSerialize()) {
                this.schedule(10000);
                return;
            }
            String projectHash = FileSymbolTablesCache.this.myProject.getLocationHash();
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    this.serializeInBackground(projectHash);
                }
                finally {
                    this.schedule(10000);
                }
            });
        }

        private void serializeInBackground(@NotNull String projectHash) {
            ProgressIndicatorBase indicator = new ProgressIndicatorBase();
            indicator.setIndeterminate(false);
            ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> {
                if (this.shouldStop() || !this.shouldSerialize()) {
                    return;
                }
                ArrayList<VirtualFile> fs = new ArrayList<VirtualFile>();
                for (VirtualFile file2 : FileSymbolTablesCache.this.myCache.keySet()) {
                    ProgressManager.checkCanceled();
                    FileSymbolTablesPack pack = (FileSymbolTablesPack)FileSymbolTablesCache.this.myCache.get(file2);
                    if (pack == null || !pack.shouldSerialize()) continue;
                    fs.add(file2);
                }
                if (!fs.isEmpty()) {
                    FileSymbolTablesCache.this.serializeTables(projectHash, fs, (ProgressIndicator)indicator);
                }
            }, (ProgressIndicator)indicator);
        }

        private boolean shouldStop() {
            return !FileSymbolTablesCache.this.myProject.isOpen() || FileSymbolTablesCache.this.myProject.isDisposed();
        }

        private boolean shouldSerialize() {
            return FileSymbolTablesCache.isSerializationEnabled() && !PowerSaveMode.isEnabled() && !DumbService.isDumb((Project)FileSymbolTablesCache.this.myProject) && ApplicationManager.getApplication().getIdleTime() >= 20000L && FileSymbolTablesCache.this.isUpToDate();
        }

        public void schedule(int delayMillis) {
            this.cancelAll();
            this.myAlarm.addRequest((Runnable)this, delayMillis);
        }

        public void cancelAll() {
            this.myAlarm.cancelAllRequests();
        }
    }

    public static final class SymbolsProperties {
        public static final SymbolsProperties NO_SYMBOLS = new SymbolsProperties(SymbolsKind.NO_SYMBOLS, false, false);
        @NotNull
        private final SymbolsKind buildSymbolsKind;
        private final boolean deserializeSymbolTables;
        private final boolean serializeSymbolTables;

        public SymbolsProperties(@NotNull SymbolsKind buildSymbolKind, boolean deserializeSymbolTables, boolean serializeSymbolTables) {
            this.buildSymbolsKind = buildSymbolKind;
            this.deserializeSymbolTables = deserializeSymbolTables;
            this.serializeSymbolTables = serializeSymbolTables;
        }

        public static enum SymbolsKind {
            NO_SYMBOLS,
            ONLY_USED,
            ALL_INCLUDING_UNUSED_SYSTEM_HEADERS;

        }
    }

    private class OCCodeBlockModificationListener
    implements PsiTreeChangePreprocessor {
        private final Key<String> FILE_PREPROCESSOR_STAMP = Key.create((String)"FILE_PREPROCESSOR_STAMP");

        private OCCodeBlockModificationListener() {
        }

        public void treeChanged(@NotNull PsiTreeChangeEventImpl event) {
            String stamp;
            PsiFile file2 = this.getFile(event);
            if (file2 == null) {
                return;
            }
            SymbolTableProvider provider2 = SymbolTableProvider.findProvider(file2);
            if (provider2 == null) {
                return;
            }
            if (!(event.getParent() instanceof PsiDirectory) && !provider2.shouldProcessPsiEvents(file2)) {
                return;
            }
            boolean shouldCheckDocCreation = ApplicationManager.getApplication().isInternal();
            Document docToCheck = shouldCheckDocCreation ? PsiDocumentManager.getInstance((Project)FileSymbolTablesCache.this.myProject).getCachedDocument(file2) : null;
            Delta delta = this.processChange(event, file2);
            if (delta != null && delta.shift != 0) {
                this.validate(file2, delta.start, delta.shift);
            }
            if (event.isGenericChange() && (stamp = (String)file2.getUserData(this.FILE_PREPROCESSOR_STAMP)) != null) {
                if (!stamp.equals(this.macroStamp(file2))) {
                    FileSymbolTablesCache.this.handleOutOfCodeBlockChange(file2, true);
                }
                file2.putUserData(this.FILE_PREPROCESSOR_STAMP, null);
            }
            if (shouldCheckDocCreation && docToCheck == null && PsiDocumentManager.getInstance((Project)FileSymbolTablesCache.this.myProject).getCachedDocument(file2) != null) {
                LOG.error("documents must not be created during event processing: " + event);
            }
        }

        @Nullable
        private Delta processChange(@NotNull PsiTreeChangeEventImpl event, PsiFile file2) {
            switch (event.getCode()) {
                case BEFORE_CHILDREN_CHANGE: 
                case BEFORE_CHILD_REPLACEMENT: 
                case BEFORE_CHILD_ADDITION: 
                case BEFORE_CHILD_REMOVAL: {
                    this.processBeforeChange(event, file2);
                    return null;
                }
                case BEFORE_CHILD_MOVEMENT: {
                    return null;
                }
                case CHILD_ADDED: 
                case CHILD_REMOVED: 
                case CHILD_REPLACED: 
                case CHILDREN_CHANGED: {
                    return this.processChildChange(event, file2);
                }
                case CHILD_MOVED: 
                case BEFORE_PROPERTY_CHANGE: 
                case PROPERTY_CHANGED: {
                    FileSymbolTablesCache.this.incModificationCount();
                    return null;
                }
            }
            LOG.error("Unknown code:" + event.getCode());
            return null;
        }

        @Nullable
        private PsiFile getFile(@NotNull PsiTreeChangeEventImpl event) {
            PsiFile childFile;
            PsiFile file2 = event.getFile();
            if (file2 != null) {
                return file2;
            }
            PsiElement child = event.getChild();
            PsiFile psiFile = childFile = child != null ? child.getContainingFile() : null;
            if (childFile != null) {
                return childFile;
            }
            PsiElement parent = event.getParent();
            return parent != null ? parent.getContainingFile() : null;
        }

        @Nullable
        private Delta processChildChange(@NotNull PsiTreeChangeEventImpl event, @NotNull PsiFile file2) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (event.isGenericChange()) {
                return null;
            }
            if (this.isOutOfCodeBlockChange(event, file2)) {
                FileSymbolTablesCache.this.handleOutOfCodeBlockChange(file2, false);
                return null;
            }
            PsiElement child = event.getChild();
            PsiElement parent = event.getParent();
            int offset = event.getOffset();
            switch (event.getCode()) {
                case CHILD_ADDED: {
                    assert (child != null);
                    if (this.checkInvalid((PsiTreeChangeEvent)event, child)) {
                        return null;
                    }
                    return new Delta(offset, child.getTextLength());
                }
                case CHILD_REMOVED: {
                    return new Delta(offset, -event.getOldLength());
                }
                case CHILD_REPLACED: {
                    assert (child != null);
                    if (this.checkInvalid((PsiTreeChangeEvent)event, child)) {
                        return null;
                    }
                    return new Delta(offset, child.getTextLength() - event.getOldLength());
                }
                case CHILDREN_CHANGED: {
                    assert (parent != null);
                    return new Delta(offset, parent.getTextLength() - event.getOldLength());
                }
            }
            OCLog.LOG.error("unexpected event code: " + event.getCode());
            return null;
        }

        private boolean checkInvalid(@NotNull PsiTreeChangeEvent event, @NotNull PsiElement psi) {
            if (!psi.isValid()) {
                LOG.warn("Invalid PSI in OCCodeBlockModificationListener.treeChanged: " + psi + ", event: " + event);
                return true;
            }
            return false;
        }

        private void processBeforeChange(@NotNull PsiTreeChangeEventImpl event, PsiFile file2) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (event.getCode() == PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILDREN_CHANGE && event.getParent() instanceof PsiFile) {
                return;
            }
            boolean isFile = event.getChild() instanceof PsiFile;
            if (!isFile && !(file2 instanceof OCCodeFragment) && file2.getUserData(this.FILE_PREPROCESSOR_STAMP) == null) {
                file2.putUserData(this.FILE_PREPROCESSOR_STAMP, (Object)this.macroStamp(file2));
            }
        }

        private boolean isOutOfCodeBlockChange(@NotNull PsiTreeChangeEventImpl event, @Nullable PsiFile file2) {
            if (file2 instanceof OCCodeFragment) {
                return false;
            }
            PsiElement element = event.getParent();
            if (element instanceof PsiFileSystemItem) {
                return true;
            }
            if (element == null || element.getParent() == null) {
                return false;
            }
            return SymbolTableProvider.getProvider(element.getContainingFile()).isOutOfCodeBlockChange(event);
        }

        @NotNull
        private String macroStamp(PsiFile file2) {
            if (!(file2 instanceof OCFile)) {
                return "";
            }
            StringBuilder acc = new StringBuilder();
            this.processASTNodeForMacros((ASTNode)file2.getNode(), acc);
            return acc.toString();
        }

        private void processASTNodeForMacros(@Nullable ASTNode node2, @NotNull StringBuilder acc) {
            if (node2 == null) {
                return;
            }
            IElementType elementType = node2.getElementType();
            if (elementType instanceof OCLazyBlockStatementElementType) {
                return;
            }
            if (OCElementTypes.IMPORTANT_DIRECTIVES.contains(elementType)) {
                acc.append(node2.getText());
            }
            for (ASTNode child = node2.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                this.processASTNodeForMacros(child, acc);
            }
        }

        private void validate(@NotNull PsiFile file2, int start, int lengthShift) {
            FileSymbolTablesPack pack = FileSymbolTablesCache.this.packForFile(OCInclusionContextUtil.getVirtualFile(file2));
            if (pack != null) {
                pack.updateOffsetsSynchronized(start, lengthShift);
            }
        }
    }

    private final class ClearTablesAndCollectNamesVisitor
    extends VirtualFileVisitor<Object> {
        @NotNull
        final Set<String> dirtyNames;
        boolean cacheCleared;

        private ClearTablesAndCollectNamesVisitor() {
            super(new VirtualFileVisitor.Option[0]);
            this.dirtyNames = new SmartHashSet(FileUtil.PATH_HASHING_STRATEGY);
            this.cacheCleared = false;
        }

        @Nullable
        public Collection<VirtualFile> getChildrenIterable(@NotNull VirtualFile file2) {
            return file2.isDirectory() ? ((NewVirtualFile)file2).getCachedChildren() : null;
        }

        public final boolean visitFile(@NotNull VirtualFile file2) {
            if (file2.isDirectory()) {
                return true;
            }
            if (FileSymbolTablesCache.this.clearCache(file2)) {
                this.cacheCleared = true;
                FileSymbolTablesCache.this.addFileToCache(file2);
            }
            this.dirtyNames.add(file2.getName());
            return true;
        }
    }

    private static final class TestSymbolReBuilder
    implements Runnable,
    DumbAware {
        @NotNull
        private final Project myProject;

        private TestSymbolReBuilder(@NotNull Project project2) {
            this.myProject = project2;
        }

        @Override
        public void run() {
            DumbService.getInstance((Project)this.myProject).runWhenSmart(() -> OCSymbolTablesBuildingActivity.getInstance(this.myProject).rebuildSymbols());
        }
    }
}

