/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.expression;

import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSizeofExpressionSymbol
extends OCExpressionSymbol {
    private OCExpressionSymbol myExpressionOperand;
    private OCType myTypeOperand;
    private boolean myVariadic;

    public OCSizeofExpressionSymbol() {
    }

    public OCSizeofExpressionSymbol(@Nullable VirtualFile file2, long offset, @NotNull OCExpressionSymbol expressionOperand, boolean isVariadic) {
        super(file2, offset);
        this.myExpressionOperand = expressionOperand;
        this.myVariadic = isVariadic;
    }

    public OCSizeofExpressionSymbol(@Nullable VirtualFile file2, long offset, @NotNull OCType typeOperand, boolean isVariadic) {
        super(file2, offset);
        this.myTypeOperand = typeOperand;
        this.myVariadic = isVariadic;
    }

    @Nullable
    public OCExpressionSymbol getExpressionOperand() {
        return this.myExpressionOperand;
    }

    @Nullable
    public OCType getTypeOperand() {
        return this.myTypeOperand;
    }

    public boolean isVariadic() {
        return this.myVariadic;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCSizeofExpressionSymbol firstSymbol = (OCSizeofExpressionSymbol)first;
        OCSizeofExpressionSymbol secondSymbol = (OCSizeofExpressionSymbol)second;
        if (!c.equalObjects(firstSymbol.myExpressionOperand, secondSymbol.myExpressionOperand)) {
            return false;
        }
        if (!c.equalObjects(firstSymbol.myTypeOperand, secondSymbol.myTypeOperand)) {
            return false;
        }
        return firstSymbol.myVariadic == secondSymbol.myVariadic;
    }

    @Override
    @Nullable
    public <T> T evaluate(@NotNull OCExpressionEvaluator.CachingEvaluator<T> evaluator) {
        return evaluator.evalSizeof(this);
    }

    @Override
    @NotNull
    public OCType getResolvedType(@NotNull OCResolveContext context2) {
        return OCIntType.SIZE_T;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return "sizeof(" + this.getInnerText() + ")";
    }

    @NotNull
    private String getInnerText() {
        if (this.myExpressionOperand != null) {
            return this.myExpressionOperand.getPresentableName();
        }
        if (this.myTypeOperand != null) {
            return this.myTypeOperand.getName();
        }
        return "";
    }
}

