/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.expression;

import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.psi.impl.OCBinaryExpressionImpl;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCBinaryExpressionSymbol
extends OCExpressionSymbol {
    private OCElementType myOperator;
    private OCExpressionSymbol myLeftOperand;
    private OCExpressionSymbol myRightOperand;

    public OCBinaryExpressionSymbol() {
    }

    public OCBinaryExpressionSymbol(@Nullable VirtualFile file2, long offset, @NotNull OCElementType operator, @NotNull OCExpressionSymbol operand, @NotNull OCExpressionSymbol operand1) {
        super(file2, offset);
        this.myOperator = operator;
        this.myLeftOperand = operand;
        this.myRightOperand = operand1;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCBinaryExpressionSymbol firstSymbol = (OCBinaryExpressionSymbol)first;
        OCBinaryExpressionSymbol secondSymbol = (OCBinaryExpressionSymbol)second;
        if (firstSymbol.myOperator != secondSymbol.myOperator) {
            return false;
        }
        if (!c.equalObjects(firstSymbol.myLeftOperand, secondSymbol.myLeftOperand)) {
            return false;
        }
        return c.equalObjects(firstSymbol.myRightOperand, secondSymbol.myRightOperand);
    }

    @Override
    @Nullable
    public <T> T evaluate(@NotNull OCExpressionEvaluator.CachingEvaluator<T> evaluator) {
        return evaluator.evalBinary(this.myOperator, this.myLeftOperand.evaluate(evaluator), this.myRightOperand.evaluate(evaluator));
    }

    @Override
    @NotNull
    public OCType getResolvedType(@NotNull OCResolveContext context2) {
        Info info = this.getInfo(context2);
        if (info.customReturnType != null) {
            return info.customReturnType;
        }
        if (info.leftType != null && info.rightType != null) {
            return OCBinaryExpressionImpl.getBinaryExprType(this.myOperator, info.leftType, info.rightType, context2);
        }
        return OCUnknownType.INSTANCE;
    }

    @Nullable
    public OCType getCustomReturnType(@NotNull OCResolveContext context2) {
        return this.getInfo((OCResolveContext)context2).customReturnType;
    }

    @NotNull
    private Info getInfo(@NotNull OCResolveContext context2) {
        OCFunctionSymbol symbol;
        OCType leftType = this.myLeftOperand.getResolvedType(context2);
        OCType rightType = this.myRightOperand.getResolvedType(context2);
        OCType customReturnType = null;
        if (leftType != null && rightType != null && (symbol = this.tryResolveOperator(context2, leftType, rightType)) != null) {
            customReturnType = symbol.getType().getReturnType().resolve(context2);
        }
        return new Info(leftType, rightType, customReturnType);
    }

    @Nullable
    public OCFunctionSymbol tryResolveOperator(@NotNull OCResolveContext context2) {
        OCType leftType = this.myLeftOperand.getResolvedType(context2);
        OCType rightType = this.myRightOperand.getResolvedType(context2);
        return this.tryResolveOperator(context2, leftType, rightType);
    }

    @Nullable
    private OCFunctionSymbol tryResolveOperator(@NotNull OCResolveContext context2, @Nullable OCType leftType, @Nullable OCType rightType) {
        if (leftType instanceof OCTypeParameterType) {
            context2.addTypeDependency(((OCTypeParameterType)leftType).getSymbol());
        }
        if (rightType instanceof OCTypeParameterType) {
            context2.addTypeDependency(((OCTypeParameterType)rightType).getSymbol());
        }
        if (leftType != null && rightType != null) {
            return OCOperatorReference.resolveOperator(this.myOperator.getName(), OCOperatorReference.OperatorPlacement.INFIX, Arrays.asList(leftType, rightType), Arrays.asList(this.myLeftOperand, this.myRightOperand), context2);
        }
        return null;
    }

    @NotNull
    public OCElementType getOperator() {
        return this.myOperator;
    }

    @NotNull
    public OCExpressionSymbol getLeftOperand() {
        return this.myLeftOperand;
    }

    @NotNull
    public OCExpressionSymbol getRightOperand() {
        return this.myRightOperand;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return this.myLeftOperand.getPresentableName() + " " + this.myOperator.getName() + " " + this.myRightOperand.getPresentableName();
    }

    private static class Info {
        @Nullable
        public final OCType leftType;
        @Nullable
        public final OCType rightType;
        @Nullable
        public final OCType customReturnType;

        private Info(@Nullable OCType leftType, @Nullable OCType rightType, @Nullable OCType customReturnType) {
            this.leftType = leftType;
            this.rightType = rightType;
            this.customReturnType = customReturnType;
        }
    }
}

