/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.cpp;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCIcons;
import com.jetbrains.cidr.lang.OCTestFrameworks;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCResolveOverloadsUtil;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolAttribute;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbolImpl;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbolImpl;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCUnknownExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFunctionSymbol
extends OCTemplateSymbolImpl {
    public static final String ATTRIBUTE_IMPLICIT_BRIDGING = "ImplicitBridging";
    public static final Set<String> ENTRY_POINTS = ContainerUtil.immutableSet((Object[])new String[]{"main", "wmain", "WinMain", "wWinMain"});
    private OCFunctionType myType;
    @Nullable
    private List<OCTypeArgument> myTemplateSpecialization;
    private OCSymbolKind myKind;
    private int myPropertiesAndAttributes;
    @NotNull
    private OCTypeSubstitution mySubstitution = OCTypeSubstitution.ID;
    private List<Object> myDefaultValues;
    @Nullable
    private OCSymbol myUsingParent;

    public OCFunctionSymbol() {
    }

    public OCFunctionSymbol(@Nullable VirtualFile file2, long offset, @Nullable OCSymbolWithQualifiedName container, @NotNull OCQualifiedName name, @NotNull List<OCTypeParameterSymbol> templateParameters, @Nullable List<OCTypeArgument> templateSpecialization, int functionProperties, int functionAttributes, @NotNull List<String> attributes, @NotNull OCFunctionType type, @NotNull List<Object> defaultValues, OCSymbolKind kind, @Nullable OCVisibility visibility) {
        super(file2, offset, container, name, templateParameters, attributes, visibility);
        this.myType = type;
        this.myTemplateSpecialization = templateSpecialization;
        this.myDefaultValues = defaultValues;
        this.myKind = kind;
        this.myPropertiesAndAttributes = functionProperties | functionAttributes;
    }

    public OCFunctionSymbol(@NotNull OCFunctionSymbol origin) {
        this(origin, origin.getParent());
    }

    public OCFunctionSymbol(@NotNull OCFunctionSymbol origin, @Nullable OCSymbolWithQualifiedName parent) {
        super(origin.getContainingFile(), origin.getComplexOffset(), parent, origin.getQualifiedName(), origin.getTemplateParameters(), origin.getAttributes(), origin.getVisibility());
        this.myType = origin.myType;
        this.myDefaultValues = origin.myDefaultValues;
        this.myTemplateSpecialization = origin.myTemplateSpecialization;
        this.myKind = origin.myKind;
        this.myPropertiesAndAttributes = origin.myPropertiesAndAttributes;
        this.mySubstitution = origin.mySubstitution;
    }

    public OCFunctionSymbol(@NotNull OCFunctionSymbol origin, @NotNull OCTypeSubstitution substitution2, @Nullable OCSymbolWithQualifiedName parent) {
        this(origin, parent);
        this.mySubstitution = substitution2;
    }

    @Override
    public boolean isConst() {
        return this.myType.isConst();
    }

    public boolean isVolatile() {
        return this.myType.isVolatile();
    }

    public boolean isConstexpr() {
        return this.hasAttribute(OCSymbolAttribute.CONSTEXPR);
    }

    public boolean isVirtual() {
        return this.hasAttribute(OCSymbolAttribute.VIRTUAL);
    }

    @Override
    public boolean isStatic() {
        return this.hasAttribute(OCSymbolAttribute.STATIC);
    }

    public boolean isExplicit() {
        return this.hasAttribute(OCSymbolAttribute.EXPLICIT);
    }

    public boolean isDefault() {
        return this.hasAttribute(OCSymbolAttribute.DEFAULT);
    }

    public boolean isDelete() {
        return this.hasAttribute(OCSymbolAttribute.DELETE);
    }

    @Override
    public boolean isFriend() {
        return this.hasAttribute(OCSymbolAttribute.FRIEND);
    }

    public boolean isFinal() {
        return this.hasAttribute(OCSymbolAttribute.FINAL);
    }

    public boolean isOverride() {
        return this.hasAttribute(OCSymbolAttribute.OVERRIDE);
    }

    public boolean isInline() {
        return this.hasAttribute(OCSymbolAttribute.INLINE);
    }

    public boolean isExtern() {
        return this.hasAttribute(OCSymbolAttribute.EXTERN);
    }

    public boolean isNoReturn() {
        return this.hasAttribute(OCSymbolAttribute.NORETURN) || super.hasAttribute("noreturn");
    }

    public boolean isCudaKernel() {
        return this.hasAttribute("global");
    }

    public boolean isPureVirtual() {
        return this.hasProperty(Property.IS_PURE_VIRTUAL);
    }

    public boolean isCppConversionOperator() {
        return this.hasProperty(Property.IS_CONVERSION_OPERATOR);
    }

    @Override
    public boolean isTemplateSymbol() {
        return this.hasProperty(Property.IS_TEMPLATE);
    }

    public boolean isCppOperator() {
        return this.hasProperty(Property.IS_OPERATOR);
    }

    public boolean isUDL() {
        return this.hasProperty(Property.IS_UDL);
    }

    @Override
    public boolean isFromUsing() {
        return this.hasProperty(Property.IS_FROM_USING);
    }

    public boolean isVararg() {
        return this.myType.isVararg();
    }

    public boolean hasAttribute(@NotNull OCSymbolAttribute attr) {
        return (this.myPropertiesAndAttributes & attr.getMask()) != 0;
    }

    public boolean hasProperty(@NotNull Property property) {
        return (this.myPropertiesAndAttributes & property.getMask()) != 0;
    }

    public boolean isCppMemberOperator(@NotNull OCResolveContext context2) {
        return this.isCppOperator() && this.isMember(context2, false);
    }

    public boolean isCppNonMemberOperator(@NotNull OCResolveContext context2) {
        return this.isCppOperator() && !this.isCppMemberOperator(context2);
    }

    public void setType(OCFunctionType type) {
        this.myType = type;
    }

    public void setDefaultValues(@NotNull List<Object> defaultValues) {
        this.myDefaultValues = defaultValues;
    }

    @Nullable
    public OCFunctionDeclaration locateFunctionDefinition(@NotNull Project project2) {
        PsiElement declarator = this.locateDefinition(project2);
        PsiElement parent = declarator != null ? declarator.getParent() : null;
        return parent instanceof OCFunctionDeclaration ? (OCFunctionDeclaration)parent : null;
    }

    @Override
    @Nullable
    public List<OCTypeArgument> getTemplateSpecialization() {
        return this.myTemplateSpecialization != null ? ContainerUtil.immutableList(this.myTemplateSpecialization) : null;
    }

    public boolean isCppConstructor() {
        return this.getKind().isConstructorOrDestructor() && !this.isCppDestructor();
    }

    public boolean isCppDestructor() {
        return this.getName().startsWith("~");
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCFunctionSymbol f = (OCFunctionSymbol)first;
        OCFunctionSymbol s = (OCFunctionSymbol)second;
        if (f.myPropertiesAndAttributes != s.myPropertiesAndAttributes) {
            return false;
        }
        if (!Comparing.equal((Object)((Object)f.myKind), (Object)((Object)s.myKind))) {
            return false;
        }
        if (!Comparing.equal(f.myDefaultValues, s.myDefaultValues)) {
            return false;
        }
        if (!c.equalObjects(f.mySubstitution, s.mySubstitution)) {
            return false;
        }
        if (!c.equalLists(f.myTemplateParameters, s.myTemplateParameters)) {
            return false;
        }
        if (!c.equalLists(f.myTemplateSpecialization, s.myTemplateSpecialization)) {
            return false;
        }
        return c.equalObjects(f.myType, s.myType);
    }

    @Nullable
    public OCFunctionSymbol getDeclarationInParent(@NotNull OCResolveContext context2) {
        if (this.isPredeclaration() && !this.isFriend()) {
            return this;
        }
        OCSymbolWithQualifiedName owner = this.getResolvedOwner(context2);
        Ref result2 = new Ref(null);
        if (owner instanceof OCNamespaceSymbol) {
            OCType resolvedType = this.getResolvedType(context2);
            ((OCNamespaceSymbol)owner).processMembers(this.getName(), (Processor<? super OCSymbol>)((Processor)symbol -> {
                if (symbol instanceof OCFunctionSymbol) {
                    OCType symbolType = symbol.getType().resolve(context2);
                    if (!new OCTypeEqualityVisitor(symbolType, true, context2).equal(resolvedType)) {
                        return true;
                    }
                    result2.set((Object)((OCFunctionSymbol)symbol));
                    return false;
                }
                return true;
            }));
        }
        return (OCFunctionSymbol)result2.get();
    }

    public boolean resolveIsFriendOrStatic(@NotNull OCResolveContext context2) {
        if (this.isFriendOrStatic() || this.getQualifier() == null) {
            return this.isFriendOrStatic();
        }
        OCFunctionSymbol predef = this.getDeclarationInParent(context2);
        return predef != null && predef.isFriendOrStatic();
    }

    public boolean resolveIsStatic(@NotNull OCResolveContext context2) {
        if (this.isStatic() || this.getQualifier() == null) {
            return this.isStatic();
        }
        OCFunctionSymbol predef = this.getDeclarationInParent(context2);
        return predef != null && predef.isStatic();
    }

    @Override
    public void updateOffset(int start, int lengthShift) {
        super.updateOffset(start, lengthShift);
        for (OCTypeParameterSymbol templateParameter : this.myTemplateParameters) {
            templateParameter.updateOffset(start, lengthShift);
        }
    }

    @Override
    public void compact() {
        super.compact();
        this.myType.compact();
        this.myTemplateSpecialization = ContainerUtil.trimToSize(this.myTemplateSpecialization);
        this.myDefaultValues = ContainerUtil.trimToSize(this.myDefaultValues);
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        return this.myKind;
    }

    @Override
    @Nullable
    public Icon getBaseIcon() {
        boolean nonVirtual = this.myParent instanceof OCStructSymbol && !this.isVirtual() && !this.isCppConstructor() && !this.isFriendOrStatic();
        return OCIcons.getFunctionIcon(this.isFriendOrStatic(), this.isPureVirtual(), nonVirtual, this.getVisibility());
    }

    @Override
    public Icon computeFullIconNow(@Nullable PsiElement symbolElement, @NotNull Project project2) {
        Icon result2 = super.computeFullIconNow(symbolElement, project2);
        if (result2 == null) {
            return null;
        }
        if (symbolElement instanceof OCDeclarator) {
            PsiElement parent = symbolElement.getParent();
            symbolElement = parent instanceof OCFunctionDeclaration ? (OCFunctionDeclaration)parent : null;
        }
        return OCTestFrameworks.isTestMethodOrFunction(this, symbolElement, project2) ? OCIcons.getTestIcon(result2) : result2;
    }

    @Override
    public boolean isGlobal() {
        return true;
    }

    @Override
    @NotNull
    public OCTypeSubstitution getSubstitution() {
        return this.mySubstitution;
    }

    @NotNull
    public OCFunctionSymbol clearSubstitution() {
        OCFunctionSymbol result2 = new OCFunctionSymbol(this);
        result2.mySubstitution = OCTypeSubstitution.ID;
        return result2;
    }

    @NotNull
    public OCFunctionSymbol setProperty(Property property) {
        OCFunctionSymbol result2 = new OCFunctionSymbol(this);
        result2.myPropertiesAndAttributes |= property.getMask();
        return result2;
    }

    @NotNull
    public OCFunctionSymbol setVisibility(OCVisibility visibility) {
        this.myVisibility = visibility;
        return this;
    }

    public OCFunctionSymbol setUsingParent(OCSymbol usingParent) {
        this.myUsingParent = usingParent;
        return this;
    }

    @Override
    @Nullable
    public OCSymbol getUsingParent() {
        if (this.isFromUsing()) {
            return this.myUsingParent;
        }
        return null;
    }

    public int getFunctionAttributes() {
        return 0xFFFFFF & this.myPropertiesAndAttributes;
    }

    public int getFunctionProperties() {
        return 0xFF000000 & this.myPropertiesAndAttributes;
    }

    @Override
    @NotNull
    public OCFunctionType getType() {
        return (OCFunctionType)this.mySubstitution.substitute(this.myType);
    }

    @NotNull
    public OCFunctionType getTypeWithoutSubstitution() {
        return this.myType;
    }

    @NotNull
    private List<OCDeclaratorSymbol> buildParameterSymbols() {
        ArrayList<OCDeclaratorSymbol> params = new ArrayList<OCDeclaratorSymbol>();
        List<OCType> parameterTypes = this.myType.getParameterTypes(true);
        List<String> parameterNames = this.myType.getParameterNames();
        for (int i2 = 0; i2 < parameterTypes.size(); ++i2) {
            Object value;
            String name = parameterNames != null && i2 < parameterNames.size() ? parameterNames.get(i2) : "";
            int defaultValueIndex = i2 + this.myDefaultValues.size() - parameterTypes.size();
            OCExpressionSymbol initializer = defaultValueIndex >= 0 ? ((value = this.myDefaultValues.get(defaultValueIndex)) instanceof OCExpressionSymbol ? (OCExpressionSymbol)value : new OCUnknownExpressionSymbol(this.myFile, -1L, value.toString())) : null;
            params.add(new OCDeclaratorSymbolImpl(this.myFile, -1L, (OCSymbolWithQualifiedName)this.dropSubstitutionTransitive(), OCQualifiedName.with(name), Collections.emptyList(), parameterTypes.get(i2), OCSymbolKind.PARAMETER, initializer, Collections.emptyList(), Collections.emptyList(), OCDeclaratorSymbol.Property.IS_ENCODED_PARAM_INDEX.getMask(), i2, null, null));
        }
        return params;
    }

    @NotNull
    public List<OCDeclaratorSymbol> getParameterSymbols() {
        return this.mySubstitution.substitute(this.buildParameterSymbols());
    }

    @NotNull
    public List<OCDeclaratorSymbol> getParameterSymbols(@NotNull OCResolveContext context2) {
        ArrayList<OCDeclaratorSymbol> result2 = new ArrayList<OCDeclaratorSymbol>();
        for (OCDeclaratorSymbol param : this.mySubstitution.substitute(this.buildParameterSymbols(), context2)) {
            OCType paramType = param.getType().getTerminalType();
            if (paramType instanceof OCVariadicType) {
                int expansionsCnt = OCArgumentsList.expandVariadicTypes(Collections.singletonList(paramType), context2).size();
                for (int i2 = 0; i2 < expansionsCnt; ++i2) {
                    result2.add(param);
                }
                continue;
            }
            result2.add(param);
        }
        return result2;
    }

    public List<Object> getDefaultValues() {
        return this.myDefaultValues;
    }

    public int getNonInitializedParametersCount(@Nullable OCResolveContext context2) {
        String name = this.getName();
        if (!(!name.equals("operator++") && !name.equals("operator--") || context2 != null && context2.getElement() instanceof OCReferenceElement && ((OCReferenceElement)context2.getElement()).getName().startsWith("operator"))) {
            return 0;
        }
        return OCTypeUtils.getNonInitializedParametersCount(this.getParameterSymbols(), context2);
    }

    @Override
    @NotNull
    public OCType getEffectiveType(@NotNull Project project2) {
        return this.mySubstitution.substitute(this.myType.getReturnType());
    }

    public OCType getEffectiveType(@NotNull PsiElement context2) {
        return OCTypeUtils.changeTypeReferences(this.getEffectiveType(context2.getProject()), OCSymbolReference.getLocalReference(this.getName(), context2));
    }

    @Override
    @NotNull
    public OCType getEffectiveResolvedType(@NotNull OCResolveContext context2) {
        OCType type = this.getResolvedType(context2);
        OCType result2 = type instanceof OCFunctionType ? ((OCFunctionType)type).getReturnType() : type;
        return this.mySubstitution.substitute(result2);
    }

    public boolean canBeCalledWithoutArguments() {
        return this.getNonInitializedParametersCount(null) == 0;
    }

    public boolean isSpecialConstructor(@NotNull OCResolveContext context2) {
        return this.isCppConstructor() && (OCResolveOverloadsUtil.isCopyOrMoveConstructorOrOperator(this, context2) || this.getNonInitializedParametersCount(context2) == 0);
    }

    public boolean isMainFunction() {
        return ENTRY_POINTS.contains(this.getName()) && this.getQualifierParent() == null && this.getQualifier() == null;
    }

    public boolean isWinMainFunction() {
        return this.isMainFunction() && !"main".equals(this.getName());
    }

    @Override
    @NotNull
    public String getKindUppercase(@NotNull OCCompilationContext context2) {
        return this.isCppDestructor() ? "Destructor" : super.getKindUppercase(context2);
    }

    @Override
    @NotNull
    public String getSignature(@NotNull Project project2) {
        StringBuilder buffer = new StringBuilder();
        String typeText = this.getType().getReturnType().getName();
        buffer.append(typeText);
        if (!typeText.endsWith("*")) {
            buffer.append(" ");
        }
        buffer.append(this.getName());
        buffer.append(this.getParametersSignature(project2));
        this.getType().getCVQualifiers().appendCVQualifiers(buffer);
        return buffer.toString();
    }

    @NotNull
    public String getParametersSignature(@NotNull Project project2) {
        StringBuilder buffer = new StringBuilder();
        if (this.isCudaKernel()) {
            buffer.append("<<<>>>");
        }
        buffer.append('(');
        boolean isFirst = true;
        for (OCDeclaratorSymbol param : this.getParameterSymbols()) {
            if (!isFirst) {
                buffer.append(", ");
            }
            buffer.append(param.getSignature(project2));
            isFirst = false;
        }
        buffer.append(')');
        return buffer.toString();
    }

    public String getNiceAttributes() {
        ArrayList<String> words = new ArrayList<String>();
        for (OCSymbolAttribute oCSymbolAttribute : OCSymbolAttribute.values()) {
            if (!this.hasAttribute(oCSymbolAttribute)) continue;
            words.add(StringUtil.toLowerCase((String)oCSymbolAttribute.name()));
        }
        for (Enum enum_ : Property.values()) {
            if (!this.hasProperty((Property)enum_)) continue;
            words.add(enum_.name().substring(3));
        }
        return "\u300a" + StringUtil.join(words, (String)" ") + "\u300b";
    }

    @Override
    public String toString() {
        return (Object)((Object)this.getKind()) + this.getNiceAttributes() + "[" + this.getName() + "]@" + (this.getContainingFile() != null ? this.getContainingFile().getName() + ":" : "") + this.getOffset();
    }

    @Override
    @NotNull
    public String getPresentableText() {
        return this.getSignatureWithoutParamNames();
    }

    @NotNull
    public String getSignatureWithoutParamNames() {
        return this.getSignatureWithoutParamNamesImpl(false, true, null);
    }

    @NotNull
    public String getSignatureWithoutParamNames(boolean fullyQualifiedName, boolean addReturnType, @NotNull OCResolveContext context2) {
        return this.getSignatureWithoutParamNamesImpl(fullyQualifiedName, addReturnType, context2);
    }

    @NotNull
    private String getSignatureWithoutParamNamesImpl(boolean fullyQualifiedName, boolean addReturnType, @Nullable OCResolveContext context2) {
        StringBuilder buffer = new StringBuilder();
        if (fullyQualifiedName) {
            assert (context2 != null);
            buffer.append(this.getNameWithParent(context2));
        } else {
            buffer.append(this.getName());
        }
        buffer.append(this.getParamsSignatureWithoutNames());
        this.getType().getCVQualifiers().appendCVQualifiers(buffer);
        if (addReturnType && !this.isCppConstructor()) {
            buffer.append(" : ");
            buffer.append(this.getType().getReturnType().getName());
        }
        return buffer.toString();
    }

    @NotNull
    public String getParamsSignatureWithoutNames() {
        StringBuilder buffer = new StringBuilder();
        if (this.isCudaKernel()) {
            buffer.append("<<<>>>");
        }
        buffer.append('(');
        boolean isFirst = true;
        for (OCDeclaratorSymbol param : this.getParameterSymbols()) {
            if (!isFirst) {
                buffer.append(", ");
            }
            buffer.append(param.getType().getName());
            isFirst = false;
        }
        buffer.append(")");
        return buffer.toString();
    }

    public static final class Property
    extends Enum<Property> {
        public static final /* enum */ Property IS_TEMPLATE = new Property();
        public static final /* enum */ Property IS_OPERATOR = new Property();
        public static final /* enum */ Property IS_PURE_VIRTUAL = new Property();
        public static final /* enum */ Property IS_CONVERSION_OPERATOR = new Property();
        public static final /* enum */ Property IS_UDL = new Property();
        public static final /* enum */ Property IS_FROM_USING = new Property();
        public static final int DEFAULT = 0;
        private static final /* synthetic */ Property[] $VALUES;

        public static Property[] values() {
            return (Property[])$VALUES.clone();
        }

        public static Property valueOf(String name) {
            return Enum.valueOf(Property.class, name);
        }

        public int getMask() {
            assert (this.ordinal() < 8);
            return 1 << 31 - this.ordinal();
        }

        static {
            $VALUES = new Property[]{IS_TEMPLATE, IS_OPERATOR, IS_PURE_VIRTUAL, IS_CONVERSION_OPERATOR, IS_UDL, IS_FROM_USING};
        }
    }
}

