/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolBase;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCSymbolImpl
extends OCSymbolBase
implements OCSymbol {
    public OCSymbolImpl(@Nullable VirtualFile file2, long complexOffset) {
        super(file2, complexOffset);
    }

    public OCSymbolImpl() {
    }

    protected String @NotNull [] getAttributeArray() {
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Override
    @NotNull
    public List<String> getAttributes() {
        return Collections.emptyList();
    }

    @NotNull
    public String getNameNoResolve() {
        return this.getName();
    }

    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        return OCSymbolImpl.customEquals((OCSymbolImpl)first, (OCSymbolImpl)second);
    }

    @Contract(value="null -> false", pure=true)
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return OCSymbolImpl.customEquals(this, (OCSymbolImpl)o);
    }

    private static boolean customEquals(@NotNull OCSymbolImpl f, @NotNull OCSymbolImpl s) {
        if (f.myComplexOffset != s.myComplexOffset) {
            return false;
        }
        if (!f.getNameNoResolve().equals(s.getNameNoResolve())) {
            return false;
        }
        if (!Objects.equals(f.myFile, s.myFile)) {
            return false;
        }
        return Arrays.equals(f.getAttributeArray(), s.getAttributeArray());
    }

    @Override
    public int hashCodeExcludingOffset() {
        int result2 = OCSymbolOffsetUtil.getSubstOffset(this.myComplexOffset);
        result2 = 31 * result2 + (this.myFile != null ? this.myFile.hashCode() : 0);
        result2 = 31 * result2 + this.getNameNoResolve().hashCode();
        result2 = 31 * result2 + Arrays.hashCode(this.getAttributeArray());
        return result2;
    }
}

