/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSymbolContext {
    private OCExpectedTypeUtil.Expectable myExpectable;
    private OCSymbolKind mySymbolKind;
    private OCSymbol myParent;

    public OCSymbolContext(@Nullable OCExpectedTypeUtil.Expectable expectable, OCSymbolKind symbolKind, OCSymbol parent) {
        this.myExpectable = expectable;
        this.mySymbolKind = symbolKind;
        this.myParent = parent;
    }

    public OCSymbolContext(OCSymbolKind symbolKind) {
        this(null, symbolKind, null);
    }

    public String getName() {
        return this.mySymbolKind.getNameLowercase();
    }

    @Nullable
    public OCSymbol getParent() {
        return this.myParent;
    }

    public OCExpectedTypeUtil.Expectable getExpectable() {
        return this.myExpectable;
    }

    @Nullable
    public OCType getExpectedType() {
        return this.myExpectable != null ? this.myExpectable.getExpectedType() : null;
    }

    public OCSymbolKind getSymbolKind() {
        return this.mySymbolKind;
    }

    public String getCannotResolveMessagePrefix(@NotNull Project project2) {
        String name = this.getName();
        if (this.myParent != null) {
            return this.myParent.getNameWithKindUppercase(OCCompilationContext.create(this.myParent, project2)) + " doesn't have " + (StringUtil.isVowel((char)name.charAt(0)) ? "an " : "a ") + name;
        }
        return "Can't resolve " + name;
    }

    public static class StructMemberContext
    extends OCSymbolContext {
        private final boolean myStatic;

        public StructMemberContext(@Nullable OCExpectedTypeUtil.Expectable expectable, OCSymbolKind symbolKind, boolean isStatic, OCSymbol parent) {
            super(expectable, symbolKind, parent);
            this.myStatic = isStatic;
        }

        public boolean isStatic() {
            return this.myStatic;
        }

        @Override
        public String getName() {
            String name = super.getName();
            return this.myStatic ? "static " + name : name;
        }
    }
}

