/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.lang.ASTNode;
import com.intellij.lang.NodeStructure;
import com.intellij.lang.PsiBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.ASTStructure;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCInnerIncludeElementType;
import com.jetbrains.cidr.lang.parser.OCKeywordElementType;
import com.jetbrains.cidr.lang.parser.OCPragmaOnceContentElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafType;
import com.jetbrains.cidr.lang.preprocessor.OCSyntheticLeafType;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCastKind;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.symbols.BuilderDriverBase;
import com.jetbrains.cidr.lang.symbols.ComplexTextRange;
import com.jetbrains.cidr.lang.symbols.OCAttributes;
import com.jetbrains.cidr.lang.symbols.OCDelegatingSymbol;
import com.jetbrains.cidr.lang.symbols.OCNamedSymbol;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithArguments;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithDecltype;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolAttribute;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCAliasUsingSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCConceptSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbolImpl;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeductionGuideSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCLocalFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceAliasSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedNameImpl;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbolImpl;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterTypeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterValueSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUndefMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCArgumentListSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCArrayIndexExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCBinaryExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCCallExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCCastExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCCommaExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCConditionalExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCInitializerListExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCInitializerSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCLambdaExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCLiteralExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCNewExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCNoexceptExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCPostfixExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCPrefixExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCQualifiedExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCReferenceExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCSizeofExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCThrowExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCUnaryExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCUnknownExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCVariadicPackExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCCompatibilityAliasSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCGenericParameterSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCGenericParameterSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCModuleImportSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCSynthesizeSymbol;
import com.jetbrains.cidr.lang.symbols.objc.SelectorPartSymbolImpl;
import com.jetbrains.cidr.lang.symbols.symtable.OCNamesInterner;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCExpressionTypeArgument;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCNullability;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCReferenceTypeBuilder;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCStructuredBindingType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeBuilder;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeParentSymbolSetter;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCExceptionSpecificationInfo;
import com.jetbrains.cidr.lang.util.OCStringLiteral;
import com.jetbrains.cidr.lang.util.OCStringLiteralUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCBuilderDriver<T>
extends BuilderDriverBase<T, OCFile> {
    private static final List<String> IMPLICIT_BRIDGING_SINGLETON_LIST = Collections.singletonList("ImplicitBridging");
    protected boolean myImplicitBridgingOn;
    protected boolean myAssumeNonNullOn;
    private final boolean myHasNullabilityFeature;
    private final boolean myHasClassPropertyFeature;
    private long contextOffset = -1L;

    public OCBuilderDriver(@Nullable VirtualFile virtualFile, @NotNull OCInclusionContext context2, @Nullable String text, @NotNull FlyweightCapableTreeStructure<T> structure, @NotNull NodeStructure<T> nodeStructure, @NotNull Processor<OCSymbol> builder2, @NotNull Project project2) {
        super(context2, text, structure, nodeStructure, builder2, (VirtualFile)(OCInclusionContextUtil.isLongLived(virtualFile) ? virtualFile : null), project2);
        this.myHasNullabilityFeature = OCCompilerFeaturesHelper.supportsNullability(context2);
        this.myHasClassPropertyFeature = OCCompilerFeaturesHelper.supportsClassProperty(context2);
    }

    @NotNull
    public static OCBuilderDriver<ASTNode> createForASTNode(@NotNull ASTNode node2, @NotNull OCFile file2, @NotNull OCInclusionContext context2, @NotNull Processor<OCSymbol> builder2) {
        OCBuilderDriver<ASTNode> builderDriver = new OCBuilderDriver<ASTNode>(OCInclusionContextUtil.getVirtualFile(file2), context2, null, (FlyweightCapableTreeStructure<ASTNode>)new ASTStructure(node2), AST_NAMED_NODE_STRUCTURE, builder2, file2.getProject());
        PsiElement fileContext = file2.getContext();
        if (fileContext != null) {
            builderDriver.setContextOffset(OCSymbolOffsetUtil.getComplexRange(file2.getContext()).getEndOffset());
        }
        return builderDriver;
    }

    @NotNull
    public static OCBuilderDriver<ASTNode> createForASTNode(@NotNull ASTNode node2, @NotNull OCFile file2, @NotNull Processor<OCSymbol> builder2) {
        return OCBuilderDriver.createForASTNode(node2, file2, OCInclusionContext.empty(file2.getKind(), file2), builder2);
    }

    @NotNull
    public static OCBuilderDriver<ASTNode> createForASTNode(@NotNull ASTNode node2, @NotNull OCFile file2) {
        return OCBuilderDriver.createForASTNode(node2, file2, (Processor<OCSymbol>)CommonProcessors.alwaysTrue());
    }

    public void setContextOffset(long contextOffset) {
        this.contextOffset = contextOffset;
    }

    public void processDeclarationsList(@NotNull T root) {
        IElementType predefClassType = null;
        boolean hasImplicitExternSpecifier = this.type(root) == OCElementTypes.CPP_LINKAGE_SPECIFICATION;
        for (T child : this.getChildren(root)) {
            IElementType tt = this.type(child);
            if (OCElementTypes.CPP_DECLARATIONS.contains(tt) || tt == OCElementTypes.FUNCTION_KR_DEFINITION) {
                BuilderDriverBase.DeclarationContext context2 = new BuilderDriverBase.DeclarationContext(tt == OCElementTypes.FUNCTION_DEFINITION || tt == OCElementTypes.FUNCTION_KR_DEFINITION ? OCSymbolKind.FUNCTION_DECLARATION : null);
                context2.setAssumeNonNull(this.myAssumeNonNullOn);
                if (hasImplicitExternSpecifier) {
                    context2.addModifier(OCSymbolAttribute.EXTERN);
                }
                this.processDeclaration(child, (Processor<OCSymbol>)this.builder, context2);
            }
            if (tt == OCElementTypes.OBJC_KEYWORD) {
                for (T grChild : this.getChildren(child)) {
                    IElementType grTt = this.type(grChild);
                    if (grTt != OCTokenTypes.CLASS_KEYWORD && grTt != OCTokenTypes.PROTOCOL_KEYWORD) continue;
                    predefClassType = grTt;
                }
            } else if (OCElementTypes.CLASSES.contains(tt) || tt == OCElementTypes.CLASS_PREDEF) {
                this.processClassDeclaration(child, (Processor<OCSymbol>)this.builder, predefClassType);
            } else if (tt == OCElementTypes.COMPATIBILITY_ALIAS) {
                this.processCompatibilityAlias(child, (Processor<OCSymbol>)this.builder, new BuilderDriverBase.DeclarationContext());
            } else if (tt == OCElementTypes.IMPORT_MODULE_STATEMENT) {
                this.processImportModuleStatement(child);
            } else if (tt == OCElementTypes.CLASS_PREDEF_LIST) {
                this.processDeclarationsList(child);
            } else if (tt == OCElementTypes.CPP_NAMESPACE) {
                this.processNamespace(child, (Processor<OCSymbol>)this.builder, new BuilderDriverBase.DeclarationContext(), null, null, null);
            } else if (tt == OCElementTypes.CPP_NAMESPACE_ALIAS) {
                this.processNamespaceAlias(child, (Processor<OCSymbol>)this.builder, new BuilderDriverBase.DeclarationContext());
            } else if (tt == OCElementTypes.CPP_USING_STATEMENT) {
                this.processUsingStatement(child, (Processor<OCSymbol>)this.builder, new BuilderDriverBase.DeclarationContext());
            } else if (tt == OCElementTypes.CPP_CONCEPT) {
                this.processConceptDeclaration(child, (Processor<OCSymbol>)this.builder, new BuilderDriverBase.DeclarationContext());
            } else if (tt == OCElementTypes.CPP_LINKAGE_SPECIFICATION) {
                this.processDeclarationsList(child);
            } else if (tt == OCTokenTypes.LBRACE) {
                hasImplicitExternSpecifier = false;
            }
            this.processDefines(child);
        }
    }

    private void processDefines(@NotNull T root) {
        IElementType tt = this.type(root);
        if (tt == OCElementTypes.MACRO_DEFINITION) {
            this.processDefineDirective(root, true);
        } else if (tt == OCElementTypes.MACRO_UNDEFINITION) {
            this.processDefineDirective(root, false);
        } else if (tt == OCElementTypes.IMPORT_DIRECTIVE) {
            this.processImportDirective(root);
        } else if (tt == OCElementTypes.CPP_PRAGMA) {
            for (T child : this.getChildren(root)) {
                if (this.type(child) != OCTokenTypes.STRING_LITERAL) continue;
                String pragmaKey = this.nodeText(child);
                if ("\"clang arc_cf_code_audited begin\"".equals(pragmaKey)) {
                    this.myImplicitBridgingOn = true;
                    continue;
                }
                if ("\"clang arc_cf_code_audited end\"".equals(pragmaKey)) {
                    this.myImplicitBridgingOn = false;
                    continue;
                }
                if ("\"clang assume_nonnull begin\"".equals(pragmaKey)) {
                    this.myAssumeNonNullOn = true;
                    continue;
                }
                if (!"\"clang assume_nonnull end\"".equals(pragmaKey)) continue;
                this.myAssumeNonNullOn = false;
            }
        } else if (tt == OCElementTypes.PRAGMA) {
            this.processPragma(root);
        } else {
            for (T child : this.getChildren(root)) {
                this.processDefines(child);
            }
        }
    }

    private void processCompatibilityAlias(@NotNull T node2, @NotNull Processor<OCSymbol> builder2, @NotNull BuilderDriverBase.DeclarationContext<T> context2) {
        String name = null;
        long nameOffset = -1L;
        OCType type = null;
        for (T child : this.getChildren(node2)) {
            IElementType tt = this.type(child);
            if (tt == OCTokenTypes.IDENTIFIER) {
                name = this.nodeText(child);
                nameOffset = OCSymbolOffsetUtil.getComplexOffset(this.nodeStructure, child);
                continue;
            }
            if (tt != OCElementTypes.REFERENCE_ELEMENT) continue;
            OCTypeBuilder typeBuilder = this.createTypeBuilder(context2);
            type = this.processTypeElement(child, typeBuilder, builder2, context2);
        }
        if (!StringUtil.isEmptyOrSpaces(name) && type != null) {
            OCCompatibilityAliasSymbol symbol = new OCCompatibilityAliasSymbol(this.myVirtualFile, nameOffset, name, type);
            builder2.process((Object)symbol);
        }
    }

    public void processClassDeclaration(@NotNull T classNode, @NotNull Processor<OCSymbol> builder2, @Nullable IElementType predefClassType) {
        IElementType classType = this.type(classNode);
        String name = null;
        String category = null;
        T superClassRef = null;
        long nameOffset = -1L;
        HashSet<T> assumeNonNullNodes = new HashSet<T>();
        ArrayList<T> optionalMethodNodes = new ArrayList<T>();
        ArrayList<T> requiredMethodNodes = new ArrayList<T>();
        ArrayList<T> optionalPropertyNodes = new ArrayList<T>();
        ArrayList<T> requiredPropertyNodes = new ArrayList<T>();
        ArrayList<T> synthesizeNodes = new ArrayList<T>();
        List<Object> genericParameterNodes = new ArrayList();
        List<String> attList = Collections.emptyList();
        T ivarsNode = null;
        List<String> protocolNames = Collections.emptyList();
        boolean isOptional = false;
        for (T child : this.getChildren(classNode)) {
            IElementType tt = this.type(child);
            if (tt == OCTokenTypes.IDENTIFIER) {
                Iterator<T> id = this.nodeText(child);
                if (name != null) break;
                name = id;
                nameOffset = OCSymbolOffsetUtil.getComplexOffset(this.nodeStructure, child);
                continue;
            }
            if (tt == OCElementTypes.CATEGORY_NAME) {
                category = "";
                for (T grChild : this.getChildren(child)) {
                    if (this.type(grChild) != OCTokenTypes.IDENTIFIER) continue;
                    category = this.nodeText(grChild);
                }
                continue;
            }
            if (tt == OCElementTypes.OBJC_KEYWORD) {
                for (T grChild : this.getChildren(child)) {
                    if (this.type(grChild) == OCTokenTypes.OPTIONAL_KEYWORD) {
                        isOptional = true;
                        continue;
                    }
                    if (this.type(grChild) != OCTokenTypes.REQUIRED_KEYWORD) continue;
                    isOptional = false;
                }
                continue;
            }
            if (tt == OCElementTypes.SYNTHESIZED_PROPERTIES_LIST) {
                synthesizeNodes.add(child);
                continue;
            }
            if (tt == OCElementTypes.METHOD) {
                if (this.myAssumeNonNullOn) {
                    assumeNonNullNodes.add(child);
                }
                if (isOptional) {
                    optionalMethodNodes.add(child);
                    continue;
                }
                requiredMethodNodes.add(child);
                continue;
            }
            if (tt == OCElementTypes.PROPERTY) {
                if (this.myAssumeNonNullOn) {
                    assumeNonNullNodes.add(child);
                }
                if (isOptional) {
                    optionalPropertyNodes.add(child);
                    continue;
                }
                requiredPropertyNodes.add(child);
                continue;
            }
            if (tt == OCElementTypes.INSTANCE_VARIABLES_LIST) {
                ivarsNode = child;
                continue;
            }
            if (tt == OCElementTypes.SUPER_CLASS_REF) {
                List<T> superRefs = this.collectReferences(child);
                if (superRefs.size() <= 0) continue;
                superClassRef = superRefs.get(0);
                continue;
            }
            if (tt == OCElementTypes.ATTRIBUTES) {
                if (attList.isEmpty()) {
                    attList = this.processAttributeList(child);
                    continue;
                }
                attList.addAll(this.processAttributeList(child));
                continue;
            }
            if (tt == OCElementTypes.PROTOCOL_LIST) {
                protocolNames = this.collectReferenceNames(child);
                continue;
            }
            if (OCElementTypes.CPP_DECLARATIONS.contains(tt)) {
                BuilderDriverBase.DeclarationContext context2 = new BuilderDriverBase.DeclarationContext(tt == OCElementTypes.FUNCTION_DEFINITION ? OCSymbolKind.FUNCTION_DECLARATION : OCSymbolKind.GLOBAL_VARIABLE);
                context2.setAssumeNonNull(this.myAssumeNonNullOn);
                this.processDeclaration(child, builder2, context2);
                continue;
            }
            if (tt == OCElementTypes.GENERIC_PARAMETERS_LIST) {
                genericParameterNodes = this.collectGenericParameters(child);
                continue;
            }
            this.processDefines(child);
        }
        if (name != null) {
            OCClassSymbolImpl klass;
            List genericParameters;
            MostlySingularMultiMap members = new MostlySingularMultiMap();
            List list = genericParameters = !genericParameterNodes.isEmpty() ? new ArrayList() : ContainerUtil.emptyList();
            if (classType == OCElementTypes.INTERFACE) {
                klass = new OCInterfaceSymbolImpl(this.myVirtualFile, nameOffset, name, attList, category, (MostlySingularMultiMap<String, OCMemberSymbol>)members, protocolNames, null, genericParameters);
            } else if (classType == OCElementTypes.IMPLEMENTATION) {
                klass = new OCImplementationSymbol(this.myVirtualFile, nameOffset, name, attList, category, (MostlySingularMultiMap<String, OCMemberSymbol>)members, null);
            } else if (classType == OCElementTypes.PROTOCOL) {
                klass = new OCProtocolSymbolImpl(this.myVirtualFile, nameOffset, name, attList, category, (MostlySingularMultiMap<String, OCMemberSymbol>)members, protocolNames, null);
            } else if (classType == OCElementTypes.CLASS_PREDEF) {
                klass = predefClassType == OCTokenTypes.PROTOCOL_KEYWORD ? new OCProtocolSymbolImpl(this.myVirtualFile, nameOffset, name, attList, null, null, Collections.emptyList(), null) : new OCInterfaceSymbolImpl(this.myVirtualFile, nameOffset, name, attList, null, null, Collections.emptyList(), null, genericParameters);
            } else {
                throw new AssertionError((Object)"Unknown class kind");
            }
            this.processSuperClassRef(superClassRef, klass);
            for (Object genericParameterNode : genericParameterNodes) {
                this.processGenericParameter(genericParameterNode, genericParameters, klass);
            }
            if (genericParameters instanceof ArrayList) {
                ((ArrayList)genericParameters).trimToSize();
            }
            for (Object methodNode : requiredMethodNodes) {
                this.processMethod(methodNode, (MostlySingularMultiMap<String, OCMemberSymbol>)members, klass, false, assumeNonNullNodes.contains(methodNode));
            }
            for (Object methodNode : optionalMethodNodes) {
                this.processMethod(methodNode, (MostlySingularMultiMap<String, OCMemberSymbol>)members, klass, true, assumeNonNullNodes.contains(methodNode));
            }
            for (Object propertyNode : requiredPropertyNodes) {
                this.processProperty(propertyNode, (MostlySingularMultiMap<String, OCMemberSymbol>)members, klass, classType, false, assumeNonNullNodes.contains(propertyNode));
            }
            for (Object propertyNode : optionalPropertyNodes) {
                this.processProperty(propertyNode, (MostlySingularMultiMap<String, OCMemberSymbol>)members, klass, classType, true, assumeNonNullNodes.contains(propertyNode));
            }
            for (Object synthesizeNode : synthesizeNodes) {
                this.processSynthesizedProperties(synthesizeNode, (MostlySingularMultiMap<String, OCMemberSymbol>)members, klass);
            }
            if (ivarsNode != null) {
                this.handleInstanceVariables(ivarsNode, (MostlySingularMultiMap<String, OCMemberSymbol>)members, klass, builder2);
            }
            builder2.process((Object)klass);
        }
    }

    private void processSuperClassRef(@Nullable T superClassRef, @NotNull OCClassSymbolImpl klass) {
        if (superClassRef != null) {
            BuilderDriverBase.DeclarationContext<T> declarationContext = this.createDeclarationContext(OCBuilderDriver.withQualifiedNameOrNull(klass));
            OCTypeBuilder typeBuilder = this.createTypeBuilder(declarationContext);
            this.processReference(superClassRef, typeBuilder, (Processor<OCSymbol>)this.builder, declarationContext);
            OCType result2 = typeBuilder.getResult(false);
            if (result2 instanceof OCReferenceType) {
                klass.setSuperType((OCReferenceType)result2);
            } else {
                String className = this.nodeText(superClassRef).trim();
                klass.setSuperType(OCReferenceType.fromText(className));
            }
        } else {
            klass.setSuperType(OCReferenceType.fromText(""));
        }
    }

    public void processGenericParameter(@NotNull T genericParameterNode, @NotNull List<OCGenericParameterSymbol> members, @NotNull OCClassSymbol parent) {
        BuilderDriverBase.DeclarationContext context2 = new BuilderDriverBase.DeclarationContext(null, parent, null, null, null, this.myAssumeNonNullOn);
        OCGenericParameterSymbol symbol = this.processGenericParameter(genericParameterNode, context2);
        if (symbol != null) {
            members.add(symbol);
        }
    }

    @Nullable
    public OCGenericParameterSymbol processGenericParameter(@NotNull T genericParameterNode, @NotNull BuilderDriverBase.DeclarationContext<T> context2) {
        OCGenericParameterSymbol.Covariance covariance = OCGenericParameterSymbol.Covariance.INVARIANT;
        OCType constraintType = null;
        String name = null;
        long offset = -1L;
        for (T child : this.getChildren(genericParameterNode)) {
            IElementType tt = this.type(child);
            if (tt == OCTokenTypes.COVARIANT_KEYWORD) {
                covariance = OCGenericParameterSymbol.Covariance.COVARIANT;
                continue;
            }
            if (tt == OCTokenTypes.CONTRAVARIANT_KEYWORD) {
                covariance = OCGenericParameterSymbol.Covariance.CONTRAVARIANT;
                continue;
            }
            if (tt == OCElementTypes.TYPE_ELEMENT) {
                OCTypeBuilder innerBuilder = this.createTypeBuilder(context2);
                constraintType = this.processTypeElement(child, innerBuilder, (Processor<OCSymbol>)this.builder, context2);
                continue;
            }
            if (tt != OCTokenTypes.IDENTIFIER) continue;
            name = this.nodeText(child);
            offset = this.getComplexOffsetFromNode(genericParameterNode);
        }
        if (name == null || offset == -1L) {
            return null;
        }
        if (constraintType == null) {
            constraintType = OCIdType.pointerToID();
        }
        return new OCGenericParameterSymbolImpl(this.myVirtualFile, offset, name, Collections.emptyList(), covariance, constraintType);
    }

    private void processSynthesizedProperties(@NotNull T propertyNode, @NotNull MostlySingularMultiMap<String, OCMemberSymbol> members, @NotNull OCClassSymbol parent) {
        boolean isSynthesize = false;
        boolean isClass = false;
        for (T child : this.getChildren(propertyNode)) {
            IElementType tt = this.type(child);
            if (tt == OCElementTypes.PROPERTY_ATTRIBUTES_LIST) {
                for (T attr : this.getChildren(child)) {
                    if (this.type(attr) != OCElementTypes.PROPERTY_ATTRIBUTE) continue;
                    for (T attrKid : this.getChildren(attr)) {
                        if (this.type(attrKid) != OCTokenTypes.IDENTIFIER) continue;
                        OCPropertySymbol.PropertyAttribute attribute = OCPropertySymbolImpl.parseAttribute(this.nodeText(attrKid));
                        if (this.myHasClassPropertyFeature || attribute != OCPropertySymbol.PropertyAttribute.CLASS) continue;
                        isClass = true;
                    }
                }
                continue;
            }
            if (tt == OCElementTypes.OBJC_KEYWORD) {
                for (T grChild : this.getChildren(child)) {
                    if (this.type(grChild) != OCTokenTypes.SYNTHESIZE_KEYWORD) continue;
                    isSynthesize = true;
                }
                continue;
            }
            if (tt != OCElementTypes.SYNTHESIZED_PROPERTY) continue;
            T prop = null;
            T ivar = null;
            for (T grChild : this.getChildren(child)) {
                if (this.type(grChild) != OCElementTypes.REFERENCE_ELEMENT) continue;
                if (prop == null) {
                    prop = grChild;
                    continue;
                }
                ivar = grChild;
            }
            if (prop == null) {
                throw new AssertionError((Object)"Property node is null");
            }
            if (ivar == null) {
                ivar = prop;
            }
            String propName = OCNamesInterner.intern(this.nodeText(prop));
            String ivarName = this.nodeText(ivar);
            members.add((Object)propName, (Object)new OCSynthesizeSymbol(parent.getContainingFile(), this.getComplexOffsetFromNode(child), propName, Collections.emptyList(), parent, isSynthesize, isClass, ivar != prop ? ivarName : null));
            if (!isSynthesize) continue;
            members.add((Object)ivarName, (Object)new OCInstanceVariableSymbolImpl(parent.getContainingFile(), this.getComplexOffsetFromNode(ivar), ivarName, Collections.emptyList(), parent, OCUnknownType.INSTANCE, OCVisibility.PRIVATE, propName));
        }
    }

    @NotNull
    private List<T> collectReferences(@NotNull T listNode) {
        List answer = null;
        for (T child : this.getChildren(listNode)) {
            if (this.type(child) != OCElementTypes.REFERENCE_ELEMENT) continue;
            if (answer == null) {
                answer = new ArrayList();
            }
            answer.add(child);
        }
        return answer != null ? answer : Collections.emptyList();
    }

    @NotNull
    private List<String> collectReferenceNames(@NotNull T protocolListNode) {
        return ContainerUtil.map(this.collectReferences(protocolListNode), t -> OCNamesInterner.intern(this.nodeText(t).trim()));
    }

    @NotNull
    private List<T> collectGenericParameters(@NotNull T genericParametersListNode) {
        List answer = null;
        for (T child : this.getChildren(genericParametersListNode)) {
            if (this.type(child) != OCElementTypes.GENERIC_PARAMETER) continue;
            if (answer == null) {
                answer = new ArrayList();
            }
            answer.add(child);
        }
        return answer != null ? answer : Collections.emptyList();
    }

    public void processProperty(@NotNull T propertyNode, @NotNull MostlySingularMultiMap<String, OCMemberSymbol> members, @NotNull OCClassSymbol parent, @NotNull IElementType classType, boolean isOptional, boolean assumeNonNull) {
        EnumSet<OCPropertySymbol.FlagAttribute> attributes = EnumSet.noneOf(OCPropertySymbol.FlagAttribute.class);
        EnumMap<OCPropertySymbol.ValueAttribute, String> stringAttributes = new EnumMap<OCPropertySymbol.ValueAttribute, String>(OCPropertySymbol.ValueAttribute.class);
        for (T child : this.getChildren(propertyNode)) {
            IElementType elementType = this.type(child);
            if (elementType == OCElementTypes.PROPERTY_ATTRIBUTES_LIST) {
                for (T attr : this.getChildren(child)) {
                    if (this.type(attr) != OCElementTypes.PROPERTY_ATTRIBUTE) continue;
                    this.processPropertyAttribute(attr, attributes, stringAttributes);
                }
                continue;
            }
            if (elementType != OCElementTypes.DECLARATION && elementType != OCElementTypes.FUNCTION_DECLARATION) continue;
            this.processDeclaration(child, (Processor<OCSymbol>)((Processor)ocSymbol -> {
                if (!(ocSymbol instanceof OCDeclaratorSymbolImpl)) {
                    return true;
                }
                OCDeclaratorSymbol symbol = (OCDeclaratorSymbol)ocSymbol;
                OCType type = symbol.getType();
                if (attributes.contains(OCPropertySymbol.PropertyAttribute.NULLABLE)) {
                    type = type.cloneWithNullability(OCNullability.NULLABLE);
                } else if (attributes.contains(OCPropertySymbol.PropertyAttribute.NULL_UNSPECIFIED)) {
                    type = type.cloneWithNullability(OCNullability.UNSPECIFIED);
                } else if (attributes.contains(OCPropertySymbol.PropertyAttribute.NONNULL) || this.myAssumeNonNullOn && type.getNullability() == null) {
                    type = type.cloneWithNullability(OCNullability.NONNULL);
                }
                OCPropertySymbolImpl property = new OCPropertySymbolImpl(symbol.getContainingFile(), symbol.getComplexOffset(), symbol.getName(), symbol.getAttributes(), parent, type, isOptional, attributes, stringAttributes);
                members.add((Object)symbol.getName(), (Object)property);
                String methodName = property.getGetterName();
                List<OCMethodSymbol.SelectorPartSymbol> selectors = Collections.singletonList(new SelectorPartSymbolImpl(null, methodName));
                OCMethodSymbolImpl methodSymbol = new OCMethodSymbolImpl(symbol.getContainingFile(), symbol.getComplexOffset(), methodName, symbol.getAttributes(), parent, property.isStatic(), isOptional, false, type, selectors, property);
                members.add((Object)methodName, (Object)methodSymbol);
                if (!property.isReadonly()) {
                    methodName = property.getSetterName();
                    OCDeclaratorSymbolImpl paramSymbol = new OCDeclaratorSymbolImpl(symbol.getContainingFile(), symbol.getComplexOffset(), null, symbol.getName(), symbol.getAttributes(), type, OCSymbolKind.PARAMETER);
                    members.add((Object)methodName, (Object)new OCMethodSymbolImpl(symbol.getContainingFile(), symbol.getComplexOffset(), methodName, symbol.getAttributes(), parent, property.isStatic(), isOptional, false, OCVoidType.instance(), Collections.singletonList(new SelectorPartSymbolImpl(paramSymbol, methodName)), property));
                }
                if (classType == OCElementTypes.INTERFACE && !property.isStatic()) {
                    String ivarName = OCNameSuggester.getClang4ImplicitIvarName(symbol.getName());
                    members.add((Object)ivarName, (Object)new OCInstanceVariableSymbolImpl(symbol.getContainingFile(), Long.MAX_VALUE, ivarName, Collections.emptyList(), parent, type, OCVisibility.PRIVATE, property.getName()));
                }
                return true;
            }), new BuilderDriverBase.DeclarationContext(null, null, OCBuilderDriver.withQualifiedNameOrNull(parent), null, null, assumeNonNull));
        }
    }

    private void processPropertyAttribute(@NotNull T attr, @NotNull EnumSet<OCPropertySymbol.FlagAttribute> attributes, @NotNull EnumMap<OCPropertySymbol.ValueAttribute, String> stringAttributes) {
        T attrName = this.getChildByType(attr, OCTokenTypes.IDENTIFIER);
        if (attrName == null) {
            return;
        }
        OCPropertySymbol.PropertyAttribute attribute = OCPropertySymbolImpl.parseAttribute(this.nodeText(attrName));
        if (attribute == null) {
            return;
        }
        if (attribute.getGroup() == OCPropertySymbol.PropertyAttribute.Group.NULLABILITY && !this.myHasNullabilityFeature || attribute.getGroup() == OCPropertySymbol.PropertyAttribute.Group.STATICNESS && !this.myHasClassPropertyFeature) {
            return;
        }
        if (attribute instanceof OCPropertySymbol.ValueAttribute) {
            List<T> identifiers = this.getChildrenByType(attr, OCTokenTypes.IDENTIFIER);
            if (identifiers.size() != 2) {
                return;
            }
            String attributeValue = this.nodeText(identifiers.get(1));
            String methodName = OCNamesInterner.intern(attributeValue);
            stringAttributes.put((OCPropertySymbol.ValueAttribute)attribute, methodName);
        } else {
            assert (attribute instanceof OCPropertySymbol.FlagAttribute);
            attributes.add((OCPropertySymbol.FlagAttribute)attribute);
        }
    }

    private void processMethod(@NotNull T methodNode, @NotNull MostlySingularMultiMap<String, OCMemberSymbol> members, @NotNull OCClassSymbol parent, boolean isOptional, boolean assumeNonNull) {
        StringBuilder selector = new StringBuilder();
        boolean isStatic = false;
        boolean isVararg = false;
        OCType returnType = null;
        long offset = -1L;
        ArrayList<OCMethodSymbol.SelectorPartSymbol> selectors = new ArrayList<OCMethodSymbol.SelectorPartSymbol>();
        List<String> attributeList = null;
        for (T child : this.getChildren(methodNode)) {
            IElementType tt = this.type(child);
            if (tt == OCElementTypes.METHOD_SELECTOR_PART) {
                Ref startOffsetRef = new Ref();
                OCMethodSymbol.SelectorPartSymbol selectorPartSymbol = this.processSelectorPart(child, selector, null, (Ref<Long>)startOffsetRef, parent, assumeNonNull);
                if (selectorPartSymbol != null) {
                    selectors.add(selectorPartSymbol);
                }
                if (offset != -1L || startOffsetRef.isNull()) continue;
                offset = (Long)startOffsetRef.get();
                continue;
            }
            if (tt == OCElementTypes.PARAMETER_DECLARATION) {
                CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
                BuilderDriverBase.DeclarationContext innerContext = new BuilderDriverBase.DeclarationContext();
                innerContext.setAssumeNonNull(assumeNonNull);
                this.processParameterDeclaration(child, innerContext, (Processor<OCDeclaratorSymbol>)finder);
                SelectorPartSymbolImpl syntheticSelector = new SelectorPartSymbolImpl((OCDeclaratorSymbol)finder.getFoundValue(), null);
                selectors.add(syntheticSelector);
                continue;
            }
            if (tt == OCElementTypes.ATTRIBUTES) {
                if (attributeList != null) {
                    attributeList.addAll(this.processAttributeList(child));
                    continue;
                }
                attributeList = this.processAttributeList(child);
                continue;
            }
            if (tt == OCElementTypes.TYPE_ELEMENT) {
                BuilderDriverBase.DeclarationContext returnContext = new BuilderDriverBase.DeclarationContext(null, null, OCBuilderDriver.withQualifiedNameOrNull(parent), null, null, assumeNonNull);
                returnType = this.processTypeElement(child, this.createTypeBuilder(returnContext), (Processor<OCSymbol>)this.builder, returnContext);
                List<String> attributes = returnContext.getAttributes();
                if (attributeList != null) {
                    if (attributes == null) continue;
                    attributeList.addAll(attributes);
                    continue;
                }
                attributeList = attributes;
                continue;
            }
            if (tt == OCTokenTypes.PLUS) {
                isStatic = true;
                continue;
            }
            if (tt != OCTokenTypes.ELLIPSIS) continue;
            isVararg = true;
        }
        if (attributeList == null) {
            attributeList = Collections.emptyList();
        }
        if (offset == -1L) {
            offset = this.getComplexOffsetFromNode(methodNode);
        }
        if (selector.length() > 0) {
            members.add((Object)selector.toString(), (Object)new OCMethodSymbolImpl(this.myVirtualFile, offset, selector.toString(), attributeList, parent, isStatic, isOptional, isVararg, returnType != null ? returnType : OCIdType.pointerToID(), selectors, null));
        }
    }

    @Nullable
    private static OCSymbolWithQualifiedName withQualifiedNameOrNull(@Nullable OCClassSymbol parent) {
        return parent instanceof OCSymbolWithQualifiedName ? parent : null;
    }

    private void handleInstanceVariables(@NotNull T ivarsNode, @NotNull MostlySingularMultiMap<String, OCMemberSymbol> members, @NotNull OCClassSymbol parent, @NotNull Processor<OCSymbol> ownerBuilder) {
        this.processInstanceVariables(ivarsNode, (Processor<OCSymbol>)((Processor)symbol -> {
            if (symbol instanceof OCInstanceVariableSymbol) {
                members.add((Object)symbol.getName(), (Object)((OCMemberSymbol)symbol));
            } else if (symbol.getKind().isType() || symbol.getKind() == OCSymbolKind.ENUM_CONST) {
                ownerBuilder.process(symbol);
            }
            return true;
        }), parent);
    }

    @Nullable
    public OCMethodSymbol.SelectorPartSymbol processSelectorPart(@NotNull T selectorNode, @NotNull StringBuilder builder2, @Nullable ComplexTextRange scope, @NotNull Ref<Long> startOffset, @Nullable OCClassSymbol parent, boolean assumeNonNull) {
        String selectorName = null;
        String parameterName = null;
        OCType paramType = OCIdType.pointerToID();
        boolean passByReference = false;
        long offset = this.getComplexOffsetFromNode(selectorNode);
        List<String> stringAttributes = null;
        for (T child : this.getChildren(selectorNode)) {
            IElementType tt = this.type(child);
            if (tt == OCTokenTypes.IDENTIFIER) {
                offset = OCSymbolOffsetUtil.getComplexOffset(this.nodeStructure, child);
                if (selectorName == null) {
                    startOffset.set((Object)offset);
                    selectorName = this.nodeText(child);
                    builder2.append(selectorName);
                    continue;
                }
                parameterName = this.nodeText(child);
                continue;
            }
            if (tt == OCTokenTypes.COLON) {
                if (selectorName != null) {
                    selectorName = selectorName + ":";
                } else {
                    offset = OCSymbolOffsetUtil.getComplexOffset(this.nodeStructure, child);
                    startOffset.set((Object)offset);
                    selectorName = ":";
                }
                builder2.append(':');
                continue;
            }
            if (tt == OCElementTypes.TYPE_ELEMENT) {
                BuilderDriverBase.DeclarationContext declarationContext = new BuilderDriverBase.DeclarationContext(null, null, OCBuilderDriver.withQualifiedNameOrNull(parent), null, null, assumeNonNull);
                OCTypeBuilder typeBuilder = this.createTypeBuilder(declarationContext);
                paramType = this.processTypeElement(child, typeBuilder, (Processor<OCSymbol>)this.builder, declarationContext);
                passByReference = typeBuilder.isPassByReference();
                List<String> attributes = declarationContext.getAttributes();
                if (attributes == null) continue;
                if (stringAttributes != null) {
                    stringAttributes.addAll(attributes);
                    continue;
                }
                stringAttributes = attributes;
                continue;
            }
            if (tt != OCElementTypes.ATTRIBUTES) continue;
            if (stringAttributes != null) {
                stringAttributes.addAll(this.processAttributeList(child));
                continue;
            }
            stringAttributes = this.processAttributeList(child);
        }
        if (selectorName != null) {
            OCDeclaratorSymbolImpl parameter = null;
            if (parameterName != null) {
                if (stringAttributes == null) {
                    stringAttributes = Collections.emptyList();
                }
                OCQualifiedName qualifiedName = OCQualifiedName.interned(parameterName);
                int properties = passByReference ? OCDeclaratorSymbol.Property.IS_PASS_BY_REF.getMask() : 0;
                parameter = new OCDeclaratorSymbolImpl(this.myVirtualFile, offset, OCBuilderDriver.withQualifiedNameOrNull(parent), qualifiedName, stringAttributes, paramType, OCSymbolKind.PARAMETER, null, Collections.emptyList(), null, properties, 0, scope, null);
            }
            return new SelectorPartSymbolImpl(parameter, OCNamesInterner.intern(selectorName));
        }
        return null;
    }

    private void processInstanceVariables(@NotNull T parentNode, @NotNull Processor<OCSymbol> builder2, @NotNull OCClassSymbol parent) {
        OCVisibility curScope = OCVisibility.getDefaultObjCVisibility(OCSymbolKind.INSTANCE_VARIABLE);
        for (T child : this.getChildren(parentNode)) {
            IElementType tt = this.type(child);
            if (tt == OCElementTypes.OBJC_KEYWORD) {
                for (T grChild : this.getChildren(child)) {
                    IElementType grTt = this.type(grChild);
                    if (!OCTokenTypes.IVAR_VISIBILITY_KEYWORDS.contains(grTt)) continue;
                    curScope = OCVisibility.getVisibilityFromElementType(grTt);
                }
                continue;
            }
            if (tt != OCElementTypes.DECLARATION) continue;
            this.processDeclaration(child, builder2, new BuilderDriverBase.DeclarationContext(null, parent, null, curScope, null, this.myAssumeNonNullOn));
        }
    }

    public void processNamespaceAlias(@NotNull T alias, @NotNull Processor<OCSymbol> builder2, @NotNull BuilderDriverBase.DeclarationContext<T> context2) {
        long startOffset;
        String name = null;
        OCQualifiedName qualifiedName = null;
        ComplexTextRange scope = this.getScope(alias, context2.getParent());
        long nameOffset = startOffset = this.getComplexOffsetFromNode(alias);
        for (T child : this.getChildren(alias)) {
            IElementType tt = this.type(child);
            if (tt == OCTokenTypes.IDENTIFIER) {
                name = this.nodeText(child);
                nameOffset = this.getComplexOffsetFromNode(child);
                continue;
            }
            if (tt != OCElementTypes.REFERENCE_ELEMENT) continue;
            qualifiedName = this.processQualifiedName(child, qualifiedName, context2);
        }
        if (qualifiedName != null) {
            OCSymbolReference.GlobalReference reference = OCSymbolReference.getGlobalReference(qualifiedName, context2.getParentSymbol(), this.myVirtualFile, startOffset, OCSymbolReference.SymbolKindFilter.ONLY_NAMESPACE);
            context2.addSymbolReference((Pair<OCSymbolReference, Long>)Pair.create((Object)reference, (Object)startOffset));
            OCNamespaceAliasSymbol result2 = new OCNamespaceAliasSymbol(this.myVirtualFile, startOffset, nameOffset, context2.getParentSymbol(), OCQualifiedName.interned(name), reference, scope);
            builder2.process((Object)result2);
        }
    }

    public void processUsingStatement(@NotNull T statement2, @NotNull Processor<OCSymbol> builder2, @NotNull BuilderDriverBase.DeclarationContext<T> context2) {
        OCSymbolKind kind = OCSymbolKind.SYMBOL_USING_SYMBOL;
        OCQualifiedName qualifiedName = null;
        String name = null;
        long nameOffset = 0L;
        ComplexTextRange scope = this.getScope(statement2, context2.getParent());
        for (T child : this.getChildren(statement2)) {
            IElementType tt = this.type(child);
            if (tt == OCElementTypes.CPP_TEMPLATE_PARAMETER_LIST) {
                context2.getTemplateParameters().add(child);
            } else if (tt != OCTokenTypes.USING_CPP_KEYWORD) {
                if (tt == OCTokenTypes.NAMESPACE_CPP_KEYWORD) {
                    kind = OCSymbolKind.NAMESPACE_USING_SYMBOL;
                } else if (tt == OCTokenTypes.IDENTIFIER) {
                    name = this.nodeText(child);
                    nameOffset = OCSymbolOffsetUtil.getComplexOffset(this.nodeStructure, child);
                }
            }
            if (tt == OCTokenTypes.COLON2X && qualifiedName == null) {
                qualifiedName = OCQualifiedName.GLOBAL;
                continue;
            }
            if (tt == OCElementTypes.REFERENCE_ELEMENT) {
                if (name != null) continue;
                qualifiedName = this.processQualifiedName(child, qualifiedName, context2);
                nameOffset = this.getComplexOffsetFromNode(child);
                continue;
            }
            if (tt == OCElementTypes.ATTRIBUTES) {
                List<String> processedAttributes = this.processAttributeList(child);
                context2.addAttributes(processedAttributes);
                continue;
            }
            if (tt == OCElementTypes.TYPE_ELEMENT) {
                this.processAliasUsing(statement2, builder2, context2, name, nameOffset, scope, child);
                return;
            }
            if (tt != OCTokenTypes.COMMA) continue;
            this.processUsingDeclarator(builder2, context2, kind, qualifiedName, nameOffset, scope);
            qualifiedName = null;
            name = null;
            nameOffset = 0L;
        }
        this.processUsingDeclarator(builder2, context2, kind, qualifiedName, nameOffset, scope);
    }

    private void processUsingDeclarator(@NotNull Processor<OCSymbol> builder2, @NotNull BuilderDriverBase.DeclarationContext<T> context2, OCSymbolKind kind, OCQualifiedName qualifiedName, long nameOffset, ComplexTextRange scope) {
        if (qualifiedName == null || qualifiedName.getName() == null) {
            return;
        }
        OCSymbolReference.SymbolFilter filter = OCSymbolReference.SymbolFilter.NONE;
        if (kind == OCSymbolKind.NAMESPACE_USING_SYMBOL) {
            filter = OCSymbolReference.SymbolKindFilter.ONLY_NAMESPACE;
        }
        OCSymbolReference reference = context2.getLocalContext() != null ? OCSymbolReference.getLocalReference(qualifiedName, context2.getLocalContext(), filter) : OCSymbolReference.getGlobalReference(qualifiedName, context2.getParentSymbol(), this.myVirtualFile, nameOffset, filter);
        context2.addSymbolReference((Pair<OCSymbolReference, Long>)Pair.create((Object)reference, (Object)nameOffset));
        OCUsingSymbol usingSymbol = new OCUsingSymbol(this.myVirtualFile, nameOffset, context2.getParentSymbol(), reference, kind, context2.getVisibility(), scope);
        builder2.process((Object)usingSymbol);
    }

    private void processRequirement(@NotNull T requirement, @NotNull Processor<OCSymbol> builder2, @NotNull BuilderDriverBase.DeclarationContext<T> context2) {
        for (T child : this.getChildren(requirement)) {
            IElementType tt = this.type(child);
            if (tt != OCElementTypes.CONCEPT_PLACEHOLDER_TYPE_ELEMENT && tt != OCElementTypes.TYPE_ELEMENT) continue;
            this.processTypeElement(child, this.createTypeBuilder(context2), builder2, context2);
        }
    }

    public void processRequiresClause(@NotNull T requiresClause, @NotNull Processor<OCSymbol> builder2, @NotNull BuilderDriverBase.DeclarationContext<T> context2) {
        for (T child : this.getChildren(requiresClause)) {
            IElementType tt = this.type(child);
            if (tt == OCElementTypes.PARAMETER_LIST) {
                ArrayList<OCType> paramTypes = new ArrayList<OCType>();
                this.processParameterList(child, null, paramTypes, context2, null);
            }
            if (tt != OCElementTypes.EAGER_BLOCK_STATEMENT) continue;
            for (T requirement : this.getChildren(child)) {
                if (this.type(requirement) != OCElementTypes.CPP_REQUIREMENT) continue;
                this.processRequirement(requirement, builder2, context2);
            }
        }
    }

    public void processConceptDeclaration(@NotNull T conceptNode, @NotNull Processor<OCSymbol> builder2, @NotNull BuilderDriverBase.DeclarationContext<T> context2) {
        OCSymbolKind kind = OCSymbolKind.CPP_CONCEPT;
        OCQualifiedName qualifiedName = null;
        String name = null;
        long nameOffset = 0L;
        ComplexTextRange scope = this.getScope(conceptNode, context2.getParent());
        for (T child : this.getChildren(conceptNode)) {
            IElementType tt = this.type(child);
            if (tt == OCElementTypes.CPP_TEMPLATE_PARAMETER_LIST) {
                context2.getTemplateParameters().add(child);
                continue;
            }
            if (tt == OCTokenTypes.IDENTIFIER) {
                name = this.nodeText(child);
                nameOffset = OCSymbolOffsetUtil.getComplexOffset(this.nodeStructure, child);
                continue;
            }
            if (tt == OCTokenTypes.COLON2X && qualifiedName == null) {
                qualifiedName = OCQualifiedName.GLOBAL;
                continue;
            }
            if (tt == OCElementTypes.CPP_REQUIRES_CLAUSE) {
                this.processRequiresClause(child, builder2, context2);
                continue;
            }
            if (tt != OCElementTypes.REFERENCE_ELEMENT || name != null) continue;
            qualifiedName = this.processQualifiedName(child, qualifiedName, context2);
            nameOffset = this.getComplexOffsetFromNode(child);
        }
        if (qualifiedName == null) {
            qualifiedName = OCQualifiedName.with(null, name);
        }
        this.processConcept(builder2, context2, kind, qualifiedName, nameOffset);
    }

    private void processConcept(@NotNull Processor<OCSymbol> builder2, @NotNull BuilderDriverBase.DeclarationContext<T> context2, OCSymbolKind kind, OCQualifiedName qualifiedName, long nameOffset) {
        if (qualifiedName == null || qualifiedName.getName() == null) {
            return;
        }
        OCSymbolReference.SymbolKindFilter filter = OCSymbolReference.SymbolKindFilter.ONLY_CONCEPT;
        OCSymbolReference reference = context2.getLocalContext() != null ? OCSymbolReference.getLocalReference(qualifiedName, context2.getLocalContext(), filter) : OCSymbolReference.getGlobalReference(qualifiedName, context2.getParentSymbol(), this.myVirtualFile, nameOffset, filter);
        context2.addSymbolReference((Pair<OCSymbolReference, Long>)Pair.create((Object)reference, (Object)nameOffset));
        OCConceptSymbol conceptSymbol = new OCConceptSymbol(this.myVirtualFile, nameOffset, context2.getParentSymbol(), qualifiedName, OCVisibility.PUBLIC);
        builder2.process((Object)conceptSymbol);
    }

    private void processAliasUsing(@NotNull T statement2, @NotNull Processor<OCSymbol> builder2, @NotNull BuilderDriverBase.DeclarationContext<T> context2, String name, long nameOffset, ComplexTextRange scope, T child) {
        ArrayList<OCTypeParameterSymbol> templateParameters = context2.getTemplateParameters().isEmpty() ? Collections.emptyList() : new ArrayList<OCTypeParameterSymbol>();
        List<String> attributes = context2.getAttributes() != null ? context2.getAttributes() : Collections.emptyList();
        OCAliasUsingSymbol usingSymbol = new OCAliasUsingSymbol(this.myVirtualFile, nameOffset, name != null ? name : "", context2.getParentSymbol(), templateParameters, attributes, scope);
        for (T params : context2.getTemplateParameters()) {
            this.processTemplateParameterList(params, templateParameters, this.createDeclarationContext(usingSymbol));
            templateParameters.trimToSize();
        }
        BuilderDriverBase.DeclarationContext<T> context1 = this.createDeclarationContext(usingSymbol);
        context1.setLocalContext(context2.getLocalContext());
        OCTypeBuilder innerBuilder = this.createTypeBuilder(context1);
        innerBuilder.setOffset(this.myVirtualFile, this.getComplexOffsetFromNode(statement2));
        OCType type = this.processTypeElement(child, innerBuilder, builder2, context1);
        usingSymbol.setType(type);
        builder2.process((Object)usingSymbol);
    }

    public void processNamespace(@NotNull T namespace, @NotNull Processor<OCSymbol> builder2, @NotNull BuilderDriverBase.DeclarationContext<T> context2, @Nullable String name, @Nullable Processor<OCSymbol> namespaceBuilder, @Nullable OCSymbolWithQualifiedName symbol) {
        long startOffset;
        boolean inline = false;
        boolean declareSymbol = symbol == null;
        boolean isSynthetic = false;
        long nameOffset = startOffset = this.getComplexOffsetFromNode(namespace);
        for (T child : this.getChildren(namespace)) {
            IElementType tt = this.type(child);
            if (tt != OCTokenTypes.NAMESPACE_CPP_KEYWORD && tt != OCTokenTypes.COLON2X) {
                if (tt == OCTokenTypes.INLINE_KEYWORD) {
                    inline = true;
                } else if (tt == OCTokenTypes.IDENTIFIER) {
                    name = this.nodeText(child);
                    nameOffset = this.getComplexOffsetFromNode(child);
                    isSynthetic = this.nodeStructure.getTokenType(child) instanceof OCSyntheticLeafType;
                } else if (OCElementTypes.CPP_DECLARATIONS.contains(tt) || tt == OCElementTypes.CPP_NAMESPACE || tt == OCElementTypes.CPP_NAMESPACE_ALIAS || tt == OCElementTypes.CPP_USING_STATEMENT || tt == OCTokenTypes.LBRACE || tt == OCElementTypes.CPP_LINKAGE_SPECIFICATION) {
                    if (namespaceBuilder == null) {
                        if (name != null) {
                            symbol = new OCNamespaceSymbol(this.myVirtualFile, startOffset, nameOffset, context2.getParentSymbol(), OCQualifiedName.interned(name), Collections.emptyList(), null, null, null, inline, isSynthetic, false);
                            namespaceBuilder = ((OCNamespaceSymbol)symbol).getBuilder();
                        } else {
                            symbol = context2.getParentSymbol();
                            namespaceBuilder = builder2;
                        }
                    }
                    if (OCElementTypes.CPP_DECLARATIONS.contains(tt)) {
                        OCSymbolKind kind = tt == OCElementTypes.FUNCTION_DEFINITION ? OCSymbolKind.FUNCTION_DECLARATION : null;
                        this.processDeclaration(child, namespaceBuilder, new BuilderDriverBase.DeclarationContext(kind, null, symbol, null, null, this.myAssumeNonNullOn));
                    } else if (tt == OCElementTypes.CPP_NAMESPACE) {
                        this.processNamespace(child, namespaceBuilder, this.createDeclarationContext(symbol), null, null, null);
                    } else if (tt == OCElementTypes.CPP_NAMESPACE_ALIAS) {
                        this.processNamespaceAlias(child, namespaceBuilder, this.createDeclarationContext(symbol));
                    } else if (tt == OCElementTypes.CPP_USING_STATEMENT) {
                        this.processUsingStatement(child, namespaceBuilder, this.createDeclarationContext(symbol));
                    } else if (tt == OCElementTypes.CPP_LINKAGE_SPECIFICATION) {
                        this.processNamespace(child, builder2, context2, name, namespaceBuilder, symbol);
                    } else if (tt == OCElementTypes.CPP_CONCEPT) {
                        this.processConceptDeclaration(child, builder2, this.createDeclarationContext(symbol));
                    }
                }
            }
            this.processDefines(child);
        }
        if (declareSymbol && name != null && symbol != null) {
            builder2.process((Object)symbol);
            if (inline) {
                OCSymbolReference.GlobalReference reference = OCSymbolReference.getGlobalReference(OCQualifiedName.interned(name), context2.getParentSymbol(), this.myVirtualFile, this.getComplexOffsetFromNode(namespace));
                context2.addSymbolReference((Pair<OCSymbolReference, Long>)Pair.create((Object)reference, (Object)this.getComplexOffsetFromNode(namespace)));
                builder2.process((Object)new OCUsingSymbol(this.myVirtualFile, symbol.getComplexOffset(), context2.getParentSymbol(), reference, OCSymbolKind.NAMESPACE_USING_SYMBOL, null, null));
            }
        }
    }

    @NotNull
    protected BuilderDriverBase.DeclarationContext<T> createDeclarationContext(OCSymbolWithQualifiedName parentSymbol) {
        return this.createDeclarationContext(null, parentSymbol);
    }

    @NotNull
    protected BuilderDriverBase.DeclarationContext<T> createDeclarationContext(Object parent, OCSymbolWithQualifiedName parentSymbol) {
        return new BuilderDriverBase.DeclarationContext(null, parent, parentSymbol, null, null, this.myAssumeNonNullOn);
    }

    @Nullable
    public OCType processDeclaration(@NotNull T declaration, @NotNull Processor<OCSymbol> builder2, @NotNull BuilderDriverBase.DeclarationContext<T> context2) {
        Object child;
        int i2;
        List children = ContainerUtil.collect(this.getChildren(declaration).iterator());
        boolean wasType = false;
        OCTypeBuilder typeBuilder = this.createTypeBuilder(context2);
        context2.pushDeclaration(declaration);
        OCSymbol declaratorSymbol = null;
        int declaratorIndex = -1;
        if (this.type(declaration) == OCElementTypes.FUNCTION_KR_DEFINITION) {
            for (i2 = children.size() - 1; i2 >= 0; --i2) {
                child = children.get(i2);
                if (this.type(child) != OCElementTypes.PARAMETER_LIST) continue;
                context2.myKRParamterList = child;
            }
        } else if (this.type(declaration) == OCElementTypes.STRUCTURED_BINDING_DECLARATION) {
            context2.setStructuredBindingDeclaration(true);
            context2.setStructuredBindingInitializer(this.findInitializer(declaration));
        } else if (this.type(declaration) == OCElementTypes.DEDUCTION_GUIDE) {
            context2.setDeductionGuide(true);
            for (i2 = children.size() - 1; i2 >= 0; --i2) {
                child = children.get(i2);
                if (this.type(child) != OCElementTypes.TYPE_ELEMENT) continue;
                context2.myDeductionGuideTypeElement = child;
                break;
            }
        }
        for (i2 = 0; i2 < children.size(); ++i2) {
            child = children.get(i2);
            IElementType tt = this.type(child);
            if (tt == OCElementTypes.ATTRIBUTES) {
                List<String> processedAttributes = this.processAttributeList(child);
                context2.addAttributes(processedAttributes);
                typeBuilder.learnAttributes(processedAttributes);
                continue;
            }
            if (tt == OCTokenTypes.TEMPLATE_CPP_KEYWORD) {
                context2.setTemplateSymbol(true);
                continue;
            }
            if (tt == OCElementTypes.CPP_TEMPLATE_PARAMETER_LIST) {
                context2.getTemplateParameters().add(child);
                continue;
            }
            if (tt == OCElementTypes.CPP_CONCEPT) {
                context2.setDeclaratorType(OCSymbolKind.CPP_CONCEPT);
                this.processConceptDeclaration(child, builder2, context2);
                continue;
            }
            if (tt == OCTokenTypes.EXTERN_KEYWORD) {
                context2.setDeclaratorType(OCSymbolKind.GLOBAL_VARIABLE_PREDECLARATION);
                context2.addModifier(OCSymbolAttribute.EXTERN);
                continue;
            }
            if (tt == OCTokenTypes.INLINE_KEYWORD) {
                context2.addModifier(OCSymbolAttribute.INLINE);
                continue;
            }
            if (tt == OCElementTypes.CPP_EXPLICIT_SPECIFIER) {
                context2.addModifier(OCSymbolAttribute.EXPLICIT);
                continue;
            }
            if (tt == OCTokenTypes.STATIC_KEYWORD) {
                context2.addModifier(OCSymbolAttribute.STATIC);
                continue;
            }
            if (tt == OCTokenTypes.REGISTER_KEYWORD) {
                context2.addModifier(OCSymbolAttribute.REGISTER);
                continue;
            }
            if (tt == OCTokenTypes.THREAD_LOCAL_KEYWORD || tt == OCTokenTypes.THREAD_LOCAL_C_KEYWORD) {
                context2.addModifier(OCSymbolAttribute.THREAD_LOCAL);
                continue;
            }
            if (tt == OCTokenTypes.MUTABLE_CPP_KEYWORD) {
                context2.addModifier(OCSymbolAttribute.MUTABLE);
                continue;
            }
            if (tt == OCTokenTypes.VIRTUAL_CPP_KEYWORD) {
                context2.addModifier(OCSymbolAttribute.VIRTUAL);
                continue;
            }
            if (tt == OCTokenTypes.NORETURN_KEYWORD) {
                context2.addModifier(OCSymbolAttribute.NORETURN);
                continue;
            }
            if (tt == OCTokenTypes.CONSTEXPR_CPP_KEYWORD) {
                context2.addModifier(OCSymbolAttribute.CONSTEXPR);
                continue;
            }
            if (tt == OCTokenTypes.FRIEND_CPP_KEYWORD) {
                context2.addModifier(OCSymbolAttribute.FRIEND);
                continue;
            }
            if (tt == OCElementTypes.DECLARATOR) {
                if (!wasType) {
                    context2.setDeclarationWithoutType(true);
                }
                context2.setDeclaratorIndex(++declaratorIndex);
                declaratorSymbol = this.processDeclarator(child, typeBuilder, builder2, context2);
                continue;
            }
            if (tt == OCElementTypes.TYPE_ELEMENT || tt == OCElementTypes.CONCEPT_PLACEHOLDER_TYPE_ELEMENT) {
                wasType = true;
                boolean hasDeclarator = false;
                for (int j = i2 + 1; j < children.size(); ++j) {
                    if (this.type(children.get(j)) != OCElementTypes.DECLARATOR) continue;
                    hasDeclarator = true;
                    break;
                }
                context2.setDeclarationWithoutDeclarators(!hasDeclarator);
                this.processTypeElement(child, typeBuilder, builder2, context2);
                continue;
            }
            if (OCTokenTypes.AUTO_KEYWORDS.contains(tt)) {
                typeBuilder.learn(tt);
                continue;
            }
            if (!OCElementTypes.STATEMENTS.contains(tt) || !(declaratorSymbol instanceof OCFunctionSymbol) || !OCBuilderDriver.isEmptyAutoType(((OCFunctionType)declaratorSymbol.getType()).getReturnType().getTerminalType())) continue;
            ArrayList<OCExpressionSymbol> returnExpressions = new ArrayList<OCExpressionSymbol>();
            ArrayList<OCDeclaratorSymbol> localVarsAndParams = new ArrayList<OCDeclaratorSymbol>();
            List<OCDeclaratorSymbol> parameters = ((OCFunctionSymbol)declaratorSymbol).getParameterSymbols();
            localVarsAndParams.addAll(parameters);
            OCLambdaExpressionSymbol lambda2 = new OCLambdaExpressionSymbol(this.myVirtualFile, 0L, returnExpressions, parameters, localVarsAndParams, null, null);
            lambda2.setFunctionSymbol((OCFunctionSymbol)declaratorSymbol);
            BuilderDriverBase.DeclarationContext lambdaContext = new BuilderDriverBase.DeclarationContext(null, child, (OCSymbolWithQualifiedName)declaratorSymbol, null, null, false);
            lambdaContext.setLambda(lambda2);
            this.collectReturnsAndLocalSymbols(child, lambdaContext, returnExpressions, localVarsAndParams);
            ContainerUtil.sort(localVarsAndParams, OCLambdaExpressionSymbol.variablesComparator);
            returnExpressions.trimToSize();
            localVarsAndParams.trimToSize();
            ((OCAutoType)((OCFunctionSymbol)declaratorSymbol).getType().getReturnType().getTerminalType()).setExpressionSymbol(lambda2);
        }
        if (context2.getDeclaratorType() == OCSymbolKind.CPP_CONCEPT) {
            context2.popDeclaration();
            return null;
        }
        OCType type = typeBuilder.getResult();
        OCBuilderDriver.patchEnumConstants(type);
        context2.popDeclaration();
        return type;
    }

    private T findInitializer(@NotNull T node2) {
        boolean wasEq = false;
        for (T child : this.getChildren(node2)) {
            IElementType tt = this.type(child);
            if (tt == OCTokenTypes.EQ) {
                wasEq = true;
                continue;
            }
            if (tt == OCElementTypes.ARGUMENT_LIST || tt == OCElementTypes.COMPOUND_INITIALIZER) {
                for (T arg : this.getChildren(child)) {
                    IElementType type = this.type(arg);
                    if (!OCElementTypes.EXPRESSIONS.contains(type)) continue;
                    return arg;
                }
                continue;
            }
            if (!wasEq || !OCElementTypes.EXPRESSIONS.contains(tt)) continue;
            return child;
        }
        return null;
    }

    private static void patchEnumConstants(OCType type) {
        if (type instanceof OCStructType && ((OCStructType)type).getKind() == OCSymbolKind.ENUM) {
            for (OCDeclaratorSymbol symbol : ((OCStructType)type).getFields()) {
                ((OCDeclaratorSymbolImpl)symbol).setType(type);
                ((OCDeclaratorSymbolImpl)symbol).addAttributes(((OCStructType)type).getSymbol().getAttributes());
            }
        }
    }

    private static boolean isEmptyAutoType(OCType type) {
        return type instanceof OCAutoType && ((OCAutoType)type).getExpressionSymbol() == null;
    }

    public long getComplexOffsetFromNode(@NotNull T node2) {
        List children = ContainerUtil.collect(this.getChildren(node2).iterator());
        long offset = OCSymbolOffsetUtil.getComplexOffset(this.nodeStructure, node2);
        if (this.contextOffset != -1L) {
            return this.contextOffset;
        }
        if (children.isEmpty()) {
            return offset;
        }
        return OCSymbolOffsetUtil.adjust(offset, this.getComplexOffsetFromNode(children.get(0)));
    }

    public OCType processTypeElement(@NotNull T typeElement, @NotNull OCTypeBuilder typeBuilder, @Nullable Processor<OCSymbol> builder2, @NotNull BuilderDriverBase.DeclarationContext<T> context2) {
        ArrayList<OCType> parameterTypes = null;
        ArrayList<String> parameterNames = null;
        boolean wasTypeOf = false;
        boolean first = true;
        boolean wasParameters = false;
        boolean isConstFun = false;
        boolean isVolatileFun = false;
        boolean isLvalueFun = false;
        boolean isRvalueFun = false;
        for (T child : this.getChildren(typeElement)) {
            IElementType tt = this.type(child);
            if (first && tt == OCTokenTypes.LPAR) {
                first = false;
                continue;
            }
            if (tt == OCElementTypes.STRUCT || tt == OCElementTypes.ENUM || tt == OCElementTypes.UNION) {
                this.processStruct(child, typeBuilder, builder2, context2);
            } else if (tt == OCElementTypes.REFERENCE_ELEMENT) {
                this.processReference(child, typeBuilder, builder2, context2);
            } else if (tt == OCElementTypes.PARAMETER_LIST) {
                wasParameters = true;
                parameterTypes = new ArrayList<OCType>();
                parameterNames = new ArrayList<String>();
                this.processParameterList(child, null, parameterTypes, context2, parameterNames);
            } else if (tt == OCTokenTypes.BLOCK_KEYWORD) {
                context2.addModifier(OCSymbolAttribute.BLOCK_MODIFIABLE);
            } else if (tt == OCElementTypes.ATTRIBUTES) {
                List<String> processedAttributes = this.processAttributeList(child);
                context2.addAttributes(processedAttributes);
                typeBuilder.learnAttributes(processedAttributes);
            } else if (tt == OCTokenTypes.STATIC_KEYWORD) {
                context2.addModifier(OCSymbolAttribute.STATIC);
            } else if (tt == OCTokenTypes.MUTABLE_CPP_KEYWORD) {
                context2.addModifier(OCSymbolAttribute.MUTABLE);
            } else if (tt == OCTokenTypes.CONSTEXPR_CPP_KEYWORD) {
                context2.addModifier(OCSymbolAttribute.CONSTEXPR);
            } else if (tt == OCTokenTypes.FRIEND_CPP_KEYWORD) {
                context2.addModifier(OCSymbolAttribute.FRIEND);
            } else if (tt == OCTokenTypes.NORETURN_KEYWORD) {
                context2.addModifier(OCSymbolAttribute.NORETURN);
            } else if (tt == OCTokenTypes.CONST_KEYWORD) {
                if (wasParameters) {
                    isConstFun = true;
                } else {
                    typeBuilder.learn(tt);
                }
            } else if (tt == OCTokenTypes.VOLATILE_KEYWORD) {
                if (wasParameters) {
                    isVolatileFun = true;
                } else {
                    typeBuilder.learn(tt);
                }
            } else if (tt == OCTokenTypes.AND) {
                if (wasParameters) {
                    isLvalueFun = true;
                } else {
                    typeBuilder.learn(tt);
                }
            } else if (tt == OCTokenTypes.ANDAND) {
                if (wasParameters) {
                    isRvalueFun = true;
                } else {
                    typeBuilder.learn(tt);
                }
            } else if (tt == OCTokenTypes.TYPEOF_KEYWORD || tt == OCTokenTypes.DECLTYPE_CPP_KEYWORD) {
                wasTypeOf = true;
            } else if (tt == OCTokenTypes.IDENTIFIER) {
                typeBuilder.learn(tt, this.nodeText(child), this.myVirtualFile, this.getComplexOffsetFromNode(child));
            } else if (OCElementTypes.EXPRESSIONS.contains(tt) && wasTypeOf) {
                typeBuilder.learnBaseType(this.createAutoType(child, null, context2));
            } else if (OCElementTypes.EXPRESSIONS.contains(tt) && typeBuilder.isInsideBrackets()) {
                typeBuilder.learnArrayLengthSymbol(this.getExpressionSymbol(child, context2));
            } else if (tt == OCElementTypes.CPP_QUALIFIED_POINTER) {
                for (T grChild : this.getChildren(child)) {
                    if (this.type(grChild) != OCElementTypes.CPP_NAMESPACE_QUALIFIER) continue;
                    typeBuilder.setPointerQualifier(this.processQualifiedName(grChild, null, context2), this.myVirtualFile, this.getComplexOffsetFromNode(grChild));
                }
                typeBuilder.learn(OCTokenTypes.MUL);
            } else if (!OCTokenTypes.WHITESPACES.contains(tt) && (!wasTypeOf || tt != OCTokenTypes.LPAR && tt != OCTokenTypes.RPAR)) {
                typeBuilder.learn(tt);
            }
            first = false;
        }
        OCType returnType = typeBuilder.getResult(parameterTypes != null);
        return typeBuilder.createFunction(returnType, parameterTypes, parameterNames, true, isConstFun, isVolatileFun, isLvalueFun, isRvalueFun, OCExceptionSpecificationInfo.createForNone());
    }

    public void processStruct(@NotNull T structNode, @NotNull OCTypeBuilder typeBuilder, @Nullable Processor<OCSymbol> builder2, @NotNull BuilderDriverBase.DeclarationContext<T> context2) {
        T baseClause = null;
        T specialization = null;
        OCSymbolWithQualifiedNameImpl structSymbol = null;
        String name = null;
        OCQualifiedName qualifier = null;
        OCQualifiedName nameWithArguments = null;
        OCSymbolKind kind = OCSymbolKind.STRUCT;
        boolean hasClassKeyword = false;
        OCSymbolKind contextType = OCSymbolKind.STRUCT_FIELD;
        List<String> attributeList = context2.getAttributes();
        boolean isEnumClass = false;
        boolean isFinal = false;
        boolean isFirst = false;
        long startOffset = this.getComplexOffsetFromNode(structNode);
        Object structParent = context2.getParent();
        ComplexTextRange structParentScope = this.getTextRange(structParent);
        OCVisibility curVisibility = null;
        OCVisibility defaultVisibility = null;
        for (T child : this.getChildren(structNode)) {
            ArrayList<OCTypeParameterSymbol> templateParameters;
            IElementType tt = this.type(child);
            if (tt == OCTokenTypes.COLON2X && isFirst) {
                qualifier = OCQualifiedName.GLOBAL;
            } else if (tt == OCElementTypes.CPP_NAMESPACE_QUALIFIER) {
                for (Pair<String, List<OCTypeArgument>> pair : this.processQualifiedName(child, qualifier, context2).flattenWithArguments()) {
                    OCNamespaceSymbol namespaceSymbol = pair.second != null ? new OCStructSymbol(this.myVirtualFile, startOffset, context2.getParentSymbol(), OCQualifiedName.interned((String)pair.first), Collections.emptyList(), kind, Collections.emptyList(), Collections.emptyList(), (List)pair.second, null, null, structParentScope, context2.getVisibility(), OCStructSymbol.Property.IS_QUALIFIED_CONTAINER.getMask(), 0, hasClassKeyword) : new OCNamespaceSymbol(this.myVirtualFile, startOffset, this.getComplexOffsetFromNode(child), context2.getParentSymbol(), OCQualifiedName.interned((String)pair.first), Collections.emptyList(), null, null, null, false, false, true);
                    templateParameters = context2.getTemplateParameters();
                    context2 = this.createDeclarationContext(namespaceSymbol);
                    context2.getTemplateParameters().addAll(templateParameters);
                    if (builder2 != null) {
                        builder2.process((Object)namespaceSymbol);
                    }
                    builder2 = namespaceSymbol.getBuilder();
                }
            } else if (tt == OCTokenTypes.FINAL_CPP_KEYWORD) {
                isFinal = true;
            } else if (tt == OCTokenTypes.LBRACE || tt == OCElementTypes.CPP_USING_STATEMENT || OCElementTypes.CPP_DECLARATIONS.contains(tt)) {
                boolean myAnonymous;
                boolean bl = myAnonymous = context2.isDeclarationWithoutDeclarators && name == null && kind.isStructLike();
                if (structSymbol == null) {
                    ArrayList<Pair<OCType, OCVisibility>> bases = baseClause != null ? new ArrayList<Pair<OCType, OCVisibility>>() : Collections.emptyList();
                    OCQualifiedName ocQualifiedName = OCQualifiedName.interned(qualifier, name);
                    templateParameters = context2.getTemplateParameters().isEmpty() ? Collections.emptyList() : new ArrayList();
                    ArrayList<OCTypeArgument> templateSpecialization = specialization != null ? new ArrayList<OCTypeArgument>() : null;
                    int classProps = isEnumClass ? OCStructSymbol.Property.IS_ENUM_CLASS.getMask() : 0;
                    int classAttrs = isFinal ? OCSymbolAttribute.FINAL.getMask() : 0;
                    structSymbol = new OCStructSymbol(this.myVirtualFile, startOffset, context2.getParentSymbol(), ocQualifiedName, Collections.emptyList(), kind, bases, templateParameters, templateSpecialization, new ArrayList<OCSymbol>(), (MostlySingularMultiMap<String, OCSymbol>)new MostlySingularMultiMap(), structParentScope, context2.getVisibility(), classProps, classAttrs, hasClassKeyword);
                    this.prepareStruct(structNode, (OCStructSymbol)structSymbol, templateParameters, templateSpecialization, context2, specialization, baseClause, defaultVisibility, bases);
                    if (myAnonymous && structSymbol.getParent() != null && builder2 != null) {
                        builder2.process((Object)new OCDeclaratorSymbolImpl(this.myVirtualFile, structSymbol.getComplexOffset(), structSymbol.getParent(), OCQualifiedName.interned(null), Collections.emptyList(), ((OCStructSymbol)structSymbol).getType(), OCSymbolKind.STRUCT_FIELD, null, ((OCStructSymbol)structSymbol).getTemplateParameters(), ((OCStructSymbol)structSymbol).getTemplateSpecialization(), 0, 0, ((OCStructSymbol)structSymbol).getScope(), null));
                    }
                }
                if (tt != OCTokenTypes.LBRACE) {
                    if (tt == OCElementTypes.CPP_USING_STATEMENT) {
                        BuilderDriverBase.DeclarationContext innerContext = new BuilderDriverBase.DeclarationContext(null, null, structSymbol, curVisibility, null, this.myAssumeNonNullOn);
                        this.processUsingStatement(child, ((OCNamespaceSymbol)structSymbol).getBuilder(), innerContext);
                    } else {
                        OCSymbolWithQualifiedNameImpl struct = structSymbol;
                        Processor<OCSymbol> structBuilder = ((OCNamespaceSymbol)structSymbol).getBuilder();
                        OCSymbolKind myKind = kind;
                        boolean myIsEnumClass = isEnumClass;
                        OCSymbolKind memberKind = contextType;
                        if (tt == OCElementTypes.FUNCTION_DEFINITION) {
                            memberKind = OCSymbolKind.FUNCTION_DECLARATION;
                        }
                        BuilderDriverBase.DeclarationContext declarationContext = new BuilderDriverBase.DeclarationContext(memberKind, context2.getParent(), myAnonymous || myKind == OCSymbolKind.ENUM && !myIsEnumClass ? structSymbol.getParent() : structSymbol, curVisibility, context2.getLocalContext(), this.myAssumeNonNullOn);
                        Processor<OCSymbol> finalBuilder = builder2;
                        OCType declarationType = this.processDeclaration(child, (Processor<OCSymbol>)((Processor)arg_0 -> OCBuilderDriver.lambda$processStruct$3(myIsEnumClass, myKind, structBuilder, myAnonymous, (OCStructSymbol)struct, finalBuilder, arg_0)), declarationContext);
                        if (declarationContext.isFriend() && declarationContext.isDeclarationWithoutDeclarators && OCSymbolReference.removeTypeToken((String)declarationType.getName()).typeToken == null) {
                            ((OCStructSymbol)structSymbol).addBefriendedType(declarationType);
                        }
                    }
                }
            } else if (tt == OCTokenTypes.STRUCT_KEYWORD || tt == OCTokenTypes.CLASS_KEYWORD) {
                if (kind != OCSymbolKind.ENUM) {
                    kind = OCSymbolKind.STRUCT;
                    if (tt == OCTokenTypes.CLASS_KEYWORD) {
                        hasClassKeyword = true;
                    }
                    if (curVisibility == null) {
                        defaultVisibility = tt == OCTokenTypes.STRUCT_KEYWORD ? OCVisibility.PUBLIC : OCVisibility.PRIVATE;
                        curVisibility = defaultVisibility;
                    }
                } else {
                    isEnumClass = true;
                }
            } else if (tt == OCTokenTypes.ENUM_KEYWORD) {
                kind = OCSymbolKind.ENUM;
                contextType = OCSymbolKind.ENUM_CONST;
            } else if (tt == OCTokenTypes.UNION_KEYWORD) {
                kind = OCSymbolKind.UNION;
            } else if (tt == OCTokenTypes.IDENTIFIER) {
                name = this.nodeText(child);
                startOffset = this.getComplexOffsetFromNode(child);
            } else if (OCTokenTypes.CPP_VISIBILITY_KEYWORDS.contains(tt)) {
                curVisibility = OCVisibility.getVisibilityFromElementType(tt);
            } else if (tt == OCElementTypes.REFERENCE_ELEMENT) {
                for (T grChild : this.getChildren(child)) {
                    IElementType gtt = this.type(grChild);
                    if (gtt != OCTokenTypes.IDENTIFIER) continue;
                    name = this.nodeText(grChild);
                    startOffset = this.getComplexOffsetFromNode(grChild);
                }
                OCQualifiedName qualifiedName = this.processQualifiedName(child, null, context2);
                qualifier = qualifiedName.getQualifier();
                if (qualifiedName instanceof OCQualifiedNameWithArguments) {
                    nameWithArguments = (OCQualifiedNameWithArguments)qualifiedName;
                    specialization = this.findNodeChild(child, OCElementTypes.TEMPLATE_ARGUMENT_LIST);
                }
            } else if (tt == OCElementTypes.CPP_BASE_CLAUSE_LIST) {
                baseClause = child;
            } else if (tt == OCElementTypes.TEMPLATE_ARGUMENT_LIST) {
                specialization = child;
            } else if (tt == OCElementTypes.ATTRIBUTES) {
                if (attributeList != null) {
                    attributeList.addAll(this.processAttributeList(child));
                } else {
                    attributeList = this.processAttributeList(child);
                }
            }
            isFirst = false;
        }
        if (attributeList == null) {
            attributeList = Collections.emptyList();
        }
        if (structSymbol == null) {
            OCQualifiedName qualifiedName = nameWithArguments != null ? nameWithArguments : OCQualifiedName.interned(qualifier, name);
            ArrayList<Pair<OCType, OCVisibility>> bases = baseClause != null ? new ArrayList<Pair<OCType, OCVisibility>>() : Collections.emptyList();
            ArrayList<OCTypeParameterSymbol> templateParameters = context2.getTemplateParameters().isEmpty() ? Collections.emptyList() : new ArrayList<OCTypeParameterSymbol>();
            ArrayList<OCTypeArgument> templateSpecialization = specialization != null ? new ArrayList<OCTypeArgument>() : null;
            int classProps = isEnumClass ? OCStructSymbol.Property.IS_ENUM_CLASS.getMask() : 0;
            int classAttrs = context2.getModifiers();
            structSymbol = new OCStructSymbol(this.myVirtualFile, startOffset, context2.getParentSymbol(), qualifiedName, attributeList, kind, bases, templateParameters, templateSpecialization, null, null, structParentScope, context2.getVisibility(), classProps, classAttrs, hasClassKeyword);
            this.prepareStruct(structNode, (OCStructSymbol)structSymbol, templateParameters, templateSpecialization, context2, specialization, baseClause, defaultVisibility, bases);
        } else {
            structSymbol.addAttributes(attributeList);
        }
        if (((OCStructSymbol)structSymbol).isPredeclaration()) {
            typeBuilder.setLocalContext(context2);
            typeBuilder.learn(OCTokenTypes.IDENTIFIER, kind.getNameLowercase() + " " + name, this.myVirtualFile, startOffset);
            typeBuilder.learnNamespaceQualifier(qualifier);
            if (nameWithArguments != null) {
                typeBuilder.learnTypeArguments(((OCQualifiedNameWithArguments)nameWithArguments).getArguments());
            }
        } else {
            boolean isConst = typeBuilder.eraseWasConst();
            OCStructType type = new OCStructType(Collections.singletonList(structSymbol), null, isConst, false);
            typeBuilder.learnBaseType(type);
            OCBuilderDriver.patchEnumConstants(type);
        }
        if (name != null && structSymbol != null && builder2 != null) {
            builder2.process((Object)structSymbol);
        }
    }

    @Nullable
    private T findNodeChild(T node2, IElementType elementType) {
        for (T child : this.getChildren(node2)) {
            IElementType tt = this.type(child);
            if (tt != elementType) continue;
            return child;
        }
        return null;
    }

    @Nullable
    private T findNodeChild(T node2, TokenSet types) {
        for (T child : this.getChildren(node2)) {
            IElementType tt = this.type(child);
            if (!types.contains(tt)) continue;
            return child;
        }
        return null;
    }

    @Nullable
    private ComplexTextRange getScope(@NotNull T declarator, Object parent) {
        ComplexTextRange declaratorRange = this.getTextRange(declarator);
        ComplexTextRange parentRange = this.getTextRange(parent);
        if (declaratorRange != null && parentRange != null) {
            return new ComplexTextRange(declaratorRange.getEndOffset(), parentRange.getEndOffset());
        }
        return null;
    }

    private void prepareStruct(@NotNull T structNode, OCStructSymbol structSymbol, List<OCTypeParameterSymbol> templateParameters, List<OCTypeArgument> templateSpecialization, BuilderDriverBase.DeclarationContext<T> context2, T specialization, T baseClause, OCVisibility defaultVisibility, List<Pair<OCType, OCVisibility>> bases) {
        if (specialization != null) {
            BuilderDriverBase.DeclarationContext<T> declarationContext = this.createDeclarationContext(structNode, structSymbol);
            declarationContext.setInsideTemplateArguments(true);
            declarationContext.setSpecialization(true);
            this.processTemplateArgumentList(specialization, templateSpecialization, (Processor<OCSymbol>)this.builder, declarationContext);
        }
        this.processStructBaseClause(baseClause, structSymbol, defaultVisibility, bases, context2);
        for (T params : context2.getTemplateParameters()) {
            this.processTemplateParameterList(params, templateParameters, this.createDeclarationContext(context2.getCurrentDeclaration(), structSymbol));
            ((ArrayList)templateParameters).trimToSize();
        }
    }

    private void processStructBaseClause(@Nullable T baseClause, @Nullable OCStructSymbol structSymbol, @Nullable OCVisibility defaultVisibility, @NotNull List<Pair<OCType, OCVisibility>> bases, @NotNull BuilderDriverBase.DeclarationContext<T> context2) {
        if (baseClause != null) {
            OCVisibility inheritanceVisibility = defaultVisibility;
            for (T child : this.getChildren(baseClause)) {
                for (T grChild : this.getChildren(child)) {
                    IElementType childType = this.type(grChild);
                    if (childType == OCElementTypes.REFERENCE_ELEMENT || childType == OCElementTypes.TYPE_ELEMENT) {
                        BuilderDriverBase.DeclarationContext innerContext = new BuilderDriverBase.DeclarationContext(null, null, structSymbol, null, context2.getLocalContext(), this.myAssumeNonNullOn);
                        OCTypeBuilder innerBuilder = this.createTypeBuilder(innerContext);
                        innerContext.setBaseClause(true);
                        if (childType == OCElementTypes.TYPE_ELEMENT) {
                            this.processTypeElement(grChild, innerBuilder, (Processor<OCSymbol>)this.builder, innerContext);
                        } else {
                            this.processReference(grChild, innerBuilder, (Processor<OCSymbol>)this.builder, innerContext);
                        }
                        bases.add((Pair<OCType, OCVisibility>)Pair.create((Object)innerBuilder.getResult(), (Object)((Object)inheritanceVisibility)));
                        inheritanceVisibility = defaultVisibility;
                        continue;
                    }
                    if (!OCTokenTypes.CPP_VISIBILITY_KEYWORDS.contains(childType)) continue;
                    inheritanceVisibility = OCVisibility.getVisibilityFromElementType(childType);
                }
            }
            ((ArrayList)bases).trimToSize();
        }
    }

    private OCQualifiedName processQualifiedName(@NotNull T node2, @Nullable OCQualifiedName base, @NotNull BuilderDriverBase.DeclarationContext<T> context2) {
        OCQualifiedName result2 = base;
        String name = null;
        List<OCTypeArgument> arguments = null;
        boolean isCppOperator = false;
        boolean wasDecltype = false;
        OCExpressionSymbol decltypeExpression = null;
        for (T child : this.getChildren(node2)) {
            IElementType tt = this.type(child);
            if (isCppOperator) {
                if (OCTokenTypes.OVERLOADED_CPP_OPERATORS_ID_PARTS.contains(tt)) {
                    name = name + this.nodeText(child);
                    continue;
                }
                if (tt != OCElementTypes.TYPE_ELEMENT) continue;
                OCTypeBuilder innerTypeBuilder = this.createTypeBuilder(CLanguageKind.CPP, context2);
                OCType typeElement = this.processTypeElement(child, innerTypeBuilder, (Processor<OCSymbol>)this.builder, context2);
                name = name + " " + typeElement.getName();
                continue;
            }
            if (tt == OCTokenTypes.COLON2X && result2 == null) {
                result2 = OCQualifiedName.GLOBAL;
                continue;
            }
            if (tt == OCElementTypes.CPP_NAMESPACE_QUALIFIER) {
                result2 = this.processQualifiedName(child, result2, context2);
                continue;
            }
            if (tt == OCElementTypes.REFERENCE_ELEMENT) {
                return this.processQualifiedName(child, result2, context2);
            }
            if (tt == OCTokenTypes.IDENTIFIER || tt == OCTokenTypes.THIS_CPP_KEYWORD) {
                name = this.nodeText(child);
                continue;
            }
            if (tt == OCElementTypes.TEMPLATE_ARGUMENT_LIST) {
                arguments = new ArrayList<OCTypeArgument>();
                this.processTemplateArgumentList(child, arguments, (Processor<OCSymbol>)this.builder, context2);
                arguments = ContainerUtil.trimToSize(arguments);
                continue;
            }
            if (tt == OCTokenTypes.OPERATOR_CPP_KEYWORD) {
                isCppOperator = true;
                name = this.nodeText(child);
                continue;
            }
            if (tt == OCTokenTypes.DECLTYPE_CPP_KEYWORD) {
                wasDecltype = true;
                continue;
            }
            if (!OCElementTypes.EXPRESSIONS.contains(tt) || !wasDecltype) continue;
            decltypeExpression = this.processExpression(child, context2);
        }
        result2 = arguments != null ? new OCQualifiedNameWithArguments(result2, OCNamesInterner.intern(name), arguments) : (decltypeExpression != null ? new OCQualifiedNameWithDecltype(result2, decltypeExpression) : OCQualifiedName.interned(result2, name));
        return result2;
    }

    private void processTemplateArgumentList(@NotNull T argumentListNode, @NotNull List<OCTypeArgument> arguments, @Nullable Processor<OCSymbol> builder2, @NotNull BuilderDriverBase.DeclarationContext<T> context2) {
        boolean oldInTemplateArguments = context2.isInsideTemplateArguments();
        context2.setInsideTemplateArguments(true);
        for (T child : this.getChildren(argumentListNode)) {
            if (this.type(child) == OCElementTypes.GENERIC_ARGUMENT) {
                for (T argumentChild : this.getChildren(child)) {
                    OCTypeBuilder innerTypeBuilder;
                    OCType type;
                    if (this.type(argumentChild) != OCElementTypes.TYPE_ELEMENT || (type = this.processTypeElement(argumentChild, innerTypeBuilder = this.createTypeBuilder(CLanguageKind.OBJ_C, context2), builder2, context2)) == null) continue;
                    arguments.add(type);
                }
            }
            if (this.type(child) == OCElementTypes.TYPE_ELEMENT) {
                OCTypeBuilder innerTypeBuilder = this.createTypeBuilder(CLanguageKind.CPP, context2);
                OCType type = this.processTypeElement(child, innerTypeBuilder, builder2, context2);
                if (type == null) continue;
                arguments.add(type);
                continue;
            }
            if (!OCElementTypes.EXPRESSIONS.contains(this.type(child))) continue;
            arguments.add(new OCExpressionTypeArgument(this.getExpressionSymbol(child, context2)));
        }
        context2.setInsideTemplateArguments(oldInTemplateArguments);
    }

    public OCTypeParameterTypeSymbol processTypeParameter(@NotNull T declarator, @NotNull BuilderDriverBase.DeclarationContext<T> context2) {
        long offset = this.getComplexOffsetFromNode(declarator);
        List<String> attributes = Collections.emptyList();
        String name = null;
        OCType defaultValue = null;
        boolean variadic = false;
        boolean spelledWithTypenameKeyword = true;
        for (T child : this.getChildren(declarator)) {
            IElementType tt = this.type(child);
            if (tt == OCTokenTypes.IDENTIFIER) {
                name = this.nodeText(child);
                offset = this.getComplexOffsetFromNode(child);
                continue;
            }
            if (tt == OCElementTypes.TYPE_ELEMENT) {
                OCTypeBuilder innerBuilder = this.createTypeBuilder(context2);
                defaultValue = this.processTypeElement(child, innerBuilder, (Processor<OCSymbol>)this.builder, context2);
                continue;
            }
            if (tt == OCTokenTypes.ELLIPSIS) {
                variadic = true;
                continue;
            }
            if (tt != OCTokenTypes.CLASS_KEYWORD) continue;
            spelledWithTypenameKeyword = false;
        }
        Object parent = context2.getParent();
        ComplexTextRange scope = this.getTextRange(parent);
        return new OCTypeParameterTypeSymbol(this.myVirtualFile, offset, name, defaultValue, attributes, scope, variadic, spelledWithTypenameKeyword, false);
    }

    private void processReference(@NotNull T refNode, @NotNull OCTypeBuilder typeBuilder, @Nullable Processor<OCSymbol> builder2, @NotNull BuilderDriverBase.DeclarationContext<T> context2) {
        OCQualifiedName qualifier = null;
        boolean wasDecltype = false;
        for (T child : this.getChildren(refNode)) {
            IElementType tt = this.type(child);
            if (tt == OCTokenTypes.COLON2X && qualifier == null) {
                qualifier = OCQualifiedName.GLOBAL;
                continue;
            }
            if (tt == OCElementTypes.CPP_NAMESPACE_QUALIFIER) {
                qualifier = this.processQualifiedName(child, qualifier, context2);
                continue;
            }
            if (tt == OCTokenTypes.IDENTIFIER) {
                typeBuilder.learn(tt, this.nodeText(child), this.myVirtualFile, this.getComplexOffsetFromNode(child));
                continue;
            }
            if (tt == OCElementTypes.TEMPLATE_ARGUMENT_LIST || tt == OCElementTypes.GENERIC_ARGUMENTS_LIST) {
                ArrayList<OCTypeArgument> arguments = new ArrayList<OCTypeArgument>();
                this.processTemplateArgumentList(child, arguments, builder2, context2);
                typeBuilder.learnTypeArguments(arguments);
                continue;
            }
            if (tt == OCElementTypes.REFERENCE_ELEMENT) {
                this.processReference(child, typeBuilder, builder2, context2);
                continue;
            }
            if (tt == OCTokenTypes.DECLTYPE_CPP_KEYWORD) {
                wasDecltype = true;
                continue;
            }
            if (OCElementTypes.EXPRESSIONS.contains(tt) && wasDecltype) {
                typeBuilder.learnBaseType(this.createAutoType(child, null, context2));
                continue;
            }
            if (wasDecltype && (tt == OCTokenTypes.LPAR || tt == OCTokenTypes.RPAR)) continue;
            typeBuilder.learn(tt);
        }
        typeBuilder.learnNamespaceQualifier(qualifier);
    }

    /*
     * WARNING - void declaration
     */
    private OCSymbol processDeclarator(@NotNull T declaratorNode, @NotNull OCTypeBuilder typeBuilder, @NotNull Processor<OCSymbol> builder2, @NotNull BuilderDriverBase.DeclarationContext<T> context2) {
        OCTemplateSymbolImpl result2;
        boolean isConstexpr;
        OCSymbolWithQualifiedName container;
        ArrayList parameterNames;
        ArrayList parameterSymbols;
        ArrayList parameterTypes;
        ArrayList<T> parameterLists;
        block123: {
            OCExpressionSymbol initializerSymbol;
            List templateParameters;
            ArrayList<OCTypeArgument> templateSpecialization;
            OCQualifiedName qualifiedName;
            OCVisibility visibility;
            Object parent;
            OCSymbolKind contextDeclType;
            OCType type;
            T specialization;
            Object initializer;
            List<String> attributeList;
            long offset;
            block124: {
                void var59_92;
                block125: {
                    OCType returnType;
                    boolean isDestructorOrConstructor;
                    OCExceptionSpecificationInfo ESI;
                    T trailingReturnType;
                    OCType conversionOperatorType;
                    boolean isUDL;
                    boolean isOverride;
                    boolean isFinal;
                    boolean isRvalueFun;
                    boolean isLvalueFun;
                    boolean isVolatileFun;
                    boolean isConstFun;
                    boolean isCppOperator;
                    boolean isDestructor;
                    Boolean hasPointerLikeModifiers;
                    OCQualifiedName qualifier;
                    String name;
                    block122: {
                        List<OCStructSymbol> structs;
                        OCTypeBuilder originalTypeBuilder = typeBuilder;
                        typeBuilder = typeBuilder.copy();
                        offset = this.getComplexOffsetFromNode(declaratorNode);
                        name = null;
                        qualifier = null;
                        parameterLists = new ArrayList<T>();
                        attributeList = context2.getAttributes();
                        hasPointerLikeModifiers = null;
                        isDestructor = false;
                        isCppOperator = false;
                        Boolean expectRParInOperator = null;
                        boolean wasEq = false;
                        boolean wasParameters = false;
                        boolean wasDeref = false;
                        isConstFun = false;
                        isVolatileFun = false;
                        isLvalueFun = false;
                        isRvalueFun = false;
                        isFinal = false;
                        isOverride = false;
                        isUDL = false;
                        boolean isNameOffsetFixed = false;
                        boolean isFunctionReturningArray = false;
                        String operatorName = "";
                        conversionOperatorType = null;
                        initializer = context2.getForCollection();
                        boolean isForeachStatement = initializer != null;
                        trailingReturnType = null;
                        specialization = null;
                        ESI = OCExceptionSpecificationInfo.createForNone();
                        for (T child : this.getChildren(declaratorNode)) {
                            IElementType tt = this.type(child);
                            if (tt == OCTokenTypes.COLON2X && qualifier == null) {
                                qualifier = OCQualifiedName.GLOBAL;
                            }
                            if (tt == OCElementTypes.CPP_NAMESPACE_QUALIFIER) {
                                qualifier = this.processQualifiedName(child, qualifier, context2);
                                continue;
                            }
                            if (isCppOperator && !wasParameters && (OCTokenTypes.OVERLOADED_CPP_OPERATORS_ID_PARTS.contains(tt) || tt == OCElementTypes.TYPE_ELEMENT && !wasDeref)) {
                                if (OCTokenTypes.POSSIBLE_ID_NAMES.contains(tt) || tt == OCElementTypes.TYPE_ELEMENT || OCTokenTypes.KEYWORDS.contains(tt)) {
                                    if (!isUDL) {
                                        operatorName = operatorName + " ";
                                    }
                                    if (tt == OCElementTypes.TYPE_ELEMENT) {
                                        conversionOperatorType = this.processTypeElement(child, this.createTypeBuilder(CLanguageKind.CPP, context2), builder2, context2);
                                    }
                                } else if (tt == OCTokenTypes.LPAR && expectRParInOperator == null) {
                                    expectRParInOperator = Boolean.TRUE;
                                } else if (tt == OCTokenTypes.RPAR) {
                                    if (!Boolean.TRUE.equals(expectRParInOperator)) continue;
                                    expectRParInOperator = Boolean.FALSE;
                                }
                                if (tt == OCTokenTypes.STRING_LITERAL) {
                                    isUDL = true;
                                    operatorName = operatorName + "\"\"";
                                    continue;
                                }
                                operatorName = operatorName + this.nodeText(child);
                                if (isNameOffsetFixed) continue;
                                offset = OCSymbolOffsetUtil.adjust(offset, this.getComplexOffsetFromNode(child));
                                isNameOffsetFixed = true;
                                continue;
                            }
                            if (!(tt != OCTokenTypes.IDENTIFIER && tt != OCTokenTypes.OPERATOR_CPP_KEYWORD || wasParameters)) {
                                boolean bl = isCppOperator = tt == OCTokenTypes.OPERATOR_CPP_KEYWORD;
                                if (!isCppOperator) {
                                    name = this.nodeText(child);
                                    offset = OCSymbolOffsetUtil.adjust(offset, this.getComplexOffsetFromNode(child));
                                }
                                if (hasPointerLikeModifiers != null) continue;
                                hasPointerLikeModifiers = Boolean.FALSE;
                                continue;
                            }
                            if (tt == OCTokenTypes.TILDE && !wasParameters) {
                                isDestructor = true;
                                continue;
                            }
                            if (tt == OCTokenTypes.DEREF) {
                                wasDeref = true;
                                continue;
                            }
                            if (tt == OCElementTypes.PARAMETER_LIST) {
                                if (isCppOperator) {
                                    name = OCTokenTypes.OPERATOR_CPP_KEYWORD.getName();
                                    name = name + operatorName;
                                }
                                wasParameters = true;
                                if (context2.myKRParamterList != null) {
                                    parameterLists.add(context2.myKRParamterList);
                                    context2.myKRParamterList = null;
                                    continue;
                                }
                                parameterLists.add(child);
                                continue;
                            }
                            if (tt == OCElementTypes.ATTRIBUTES) {
                                List<String> processedAttributes = this.processAttributeList(child);
                                if (attributeList != null) {
                                    attributeList.addAll(processedAttributes);
                                } else {
                                    attributeList = processedAttributes;
                                }
                                typeBuilder.learnAttributes(processedAttributes);
                                continue;
                            }
                            if (tt == OCTokenTypes.BLOCK_KEYWORD) {
                                context2.addModifier(OCSymbolAttribute.BLOCK_MODIFIABLE);
                                continue;
                            }
                            if (tt == OCTokenTypes.EQ) {
                                wasEq = true;
                                continue;
                            }
                            if (OCElementTypes.EXPRESSIONS.contains(tt) && (wasEq || tt == OCElementTypes.COMPOUND_INITIALIZER)) {
                                initializer = child;
                                continue;
                            }
                            if (tt == OCElementTypes.ARGUMENT_LIST) {
                                initializer = child;
                                continue;
                            }
                            if (tt == OCTokenTypes.CONST_KEYWORD) {
                                if (wasParameters) {
                                    isConstFun = true;
                                    continue;
                                }
                                typeBuilder.learn(tt);
                                continue;
                            }
                            if (tt == OCTokenTypes.VOLATILE_KEYWORD) {
                                if (wasParameters) {
                                    isVolatileFun = true;
                                    continue;
                                }
                                typeBuilder.learn(tt);
                                continue;
                            }
                            if (tt == OCTokenTypes.AND) {
                                if (wasParameters) {
                                    isLvalueFun = true;
                                    continue;
                                }
                                typeBuilder.learn(tt);
                                continue;
                            }
                            if (tt == OCTokenTypes.ANDAND) {
                                if (wasParameters) {
                                    isRvalueFun = true;
                                    continue;
                                }
                                typeBuilder.learn(tt);
                                continue;
                            }
                            if (OCElementTypes.EXPRESSIONS.contains(tt) && typeBuilder.isInsideBrackets()) {
                                typeBuilder.learnArrayLengthSymbol(this.getExpressionSymbol(child, context2));
                                continue;
                            }
                            if (tt == OCElementTypes.CPP_QUALIFIED_POINTER) {
                                for (T grChild : this.getChildren(child)) {
                                    if (this.type(grChild) != OCElementTypes.CPP_NAMESPACE_QUALIFIER) continue;
                                    typeBuilder.setPointerQualifier(this.processQualifiedName(grChild, null, context2), this.myVirtualFile, this.getComplexOffsetFromNode(grChild));
                                }
                                if (typeBuilder.isInsideParentheses() && hasPointerLikeModifiers == null) {
                                    hasPointerLikeModifiers = Boolean.TRUE;
                                }
                                typeBuilder.learn(OCTokenTypes.MUL);
                                continue;
                            }
                            if (tt == OCElementTypes.TEMPLATE_ARGUMENT_LIST) {
                                specialization = child;
                                continue;
                            }
                            if (tt == OCElementTypes.TYPE_ELEMENT) {
                                trailingReturnType = child;
                                continue;
                            }
                            if (tt == OCTokenTypes.DEFAULT_KEYWORD) {
                                context2.addModifier(OCSymbolAttribute.DEFAULT);
                                continue;
                            }
                            if (tt == OCElementTypes.CPP_NOEXCEPT_SPECIFIER) {
                                T noexceptExprNode = this.findNodeChild(child, OCElementTypes.EXPRESSIONS);
                                if (noexceptExprNode != null) {
                                    OCExpressionSymbol operand = this.processExpression(noexceptExprNode, context2);
                                    if (operand != null) {
                                        ESI = OCExceptionSpecificationInfo.createForComputedNoexcept(operand);
                                        continue;
                                    }
                                    ESI = OCExceptionSpecificationInfo.createForBasicNoexcept();
                                    continue;
                                }
                                ESI = OCExceptionSpecificationInfo.createForBasicNoexcept();
                                continue;
                            }
                            if (tt == OCElementTypes.CPP_EXPLICIT_SPECIFIER) {
                                T explicitExprNode = this.findNodeChild(child, OCElementTypes.EXPRESSIONS);
                                if (explicitExprNode == null) continue;
                                this.processExpression(explicitExprNode, context2);
                                continue;
                            }
                            if (tt == OCElementTypes.CPP_EXCEPTION_SPECIFICATION) {
                                boolean inParens = false;
                                boolean emptySpec = false;
                                ArrayList<OCType> throwTypes = new ArrayList<OCType>();
                                for (T specToken : this.getChildren(child)) {
                                    IElementType specTokenType = this.type(specToken);
                                    if (inParens) {
                                        if (OCTokenTypes.RPAR == specTokenType) {
                                            emptySpec = throwTypes.isEmpty();
                                            break;
                                        }
                                        if (specTokenType == OCElementTypes.TYPE_ELEMENT) {
                                            OCTypeBuilder throwTypeBuilder = this.createTypeBuilder(context2);
                                            OCType type2 = this.processTypeElement(specToken, throwTypeBuilder, builder2, context2);
                                            throwTypes.add(type2);
                                            continue;
                                        }
                                        if (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(specTokenType) || specTokenType == OCTokenTypes.COMMA) continue;
                                        break;
                                    }
                                    if (OCTokenTypes.LPAR != specTokenType) continue;
                                    inParens = true;
                                }
                                if (emptySpec) {
                                    ESI = OCExceptionSpecificationInfo.createForDynamicNone();
                                    continue;
                                }
                                ESI = OCExceptionSpecificationInfo.createForDynamic(throwTypes);
                                continue;
                            }
                            if (tt == OCTokenTypes.DELETE_CPP_KEYWORD) {
                                context2.addModifier(OCSymbolAttribute.DELETE);
                                continue;
                            }
                            if (tt == OCTokenTypes.FINAL_CPP_KEYWORD) {
                                isFinal = true;
                                continue;
                            }
                            if (tt == OCTokenTypes.OVERRIDE_CPP_KEYWORD) {
                                isOverride = true;
                                continue;
                            }
                            if (OCTokenTypes.FUNCTION_PTR_MODIFIERS.contains(tt) && typeBuilder.isInsideParentheses() && hasPointerLikeModifiers == null) {
                                hasPointerLikeModifiers = Boolean.TRUE;
                            } else if (tt == OCTokenTypes.RBRACKET && !parameterLists.isEmpty()) {
                                isFunctionReturningArray = true;
                            }
                            typeBuilder.learn(tt);
                        }
                        parameterTypes = new ArrayList(parameterLists.size());
                        parameterSymbols = new ArrayList(parameterLists.size());
                        parameterNames = new ArrayList(parameterLists.size());
                        type = typeBuilder.getResult(!parameterLists.isEmpty());
                        if (initializer != null && (this.type(initializer) == OCElementTypes.COMPOUND_INITIALIZER || this.type(initializer) == OCElementTypes.LITERAL_EXPRESSION && type.isCString())) {
                            typeBuilder.updateArrayLength(this.evaluateArrayLengths(initializer, type.isCString()));
                            type = typeBuilder.getResult(!parameterLists.isEmpty());
                        }
                        if (typeBuilder.wasAuto()) {
                            if (context2.isStructuredBindingDeclaration && !isForeachStatement) {
                                initializer = context2.myStructuredBindingInitializer;
                            }
                            if (initializer != null) {
                                type = context2.isStructuredBindingDeclaration ? this.createStructuredBindingType(initializer, typeBuilder.isConst(), typeBuilder.isVolatile(), isForeachStatement, context2) : this.createAutoType(initializer, type, context2);
                            }
                        }
                        for (int i2 = 0; i2 < parameterLists.size(); ++i2) {
                            parameterNames.add(new ArrayList());
                            parameterTypes.add(new ArrayList());
                            parameterSymbols.add(new ArrayList());
                            boolean createPointers = i2 == parameterLists.size() - 1 && !isFunctionReturningArray;
                            type = typeBuilder.createFunction(type, (List)parameterTypes.get(i2), (List)parameterNames.get(i2), createPointers, isConstFun, isVolatileFun, isLvalueFun, isRvalueFun, ESI);
                        }
                        if (context2.getDeclaratorType() == OCSymbolKind.PARAMETER) {
                            if (type instanceof OCReferenceType) {
                                OCReferenceType referenceType = (OCReferenceType)type;
                                referenceType.setFunctionParameterType(true);
                            }
                            type = OCFunctionType.convertArrayParameterType(type);
                        }
                        if (this.myImplicitBridgingOn) {
                            if (attributeList == null) {
                                attributeList = IMPLICIT_BRIDGING_SINGLETON_LIST;
                            } else {
                                attributeList.add("ImplicitBridging");
                            }
                        }
                        if (attributeList == null) {
                            attributeList = Collections.emptyList();
                        }
                        if (typeBuilder.isTypedef() && type instanceof OCStructType && (structs = ((OCStructType)type).getStructs()).size() == 1) {
                            OCStructSymbol structSymbol = structs.get(0);
                            if (structSymbol.isUnnamed()) {
                                type = new OCStructType(structSymbol, name);
                                originalTypeBuilder.learnBaseType(type);
                            }
                            structSymbol.addAttributes(attributeList);
                        }
                        if (isDestructor) {
                            if (name == null) {
                                isDestructor = false;
                            } else {
                                name = "~" + name;
                            }
                        }
                        contextDeclType = context2.getDeclaratorType();
                        parent = context2.getParent();
                        visibility = context2.getVisibility();
                        container = context2.getParentSymbol();
                        isConstexpr = context2.hasModifier(OCSymbolAttribute.CONSTEXPR);
                        if (type instanceof OCFunctionType && context2.getDeclaratorType() == OCSymbolKind.PARAMETER) {
                            type = OCPointerType.to(type);
                        }
                        if (context2.isConstexpr()) {
                            type = type.cloneWithConstModifier(this.project);
                        }
                        if (!(parent instanceof OCClassSymbol) || visibility == null) break block122;
                        OCClassSymbol parentClass = (OCClassSymbol)parent;
                        OCInstanceVariableSymbolImpl result22 = new OCInstanceVariableSymbolImpl(this.myVirtualFile, offset, name, attributeList, parentClass, type, visibility, null);
                        break block123;
                    }
                    qualifiedName = OCQualifiedName.interned(qualifier, name);
                    templateSpecialization = null;
                    templateParameters = !context2.getTemplateParameters().isEmpty() ? new ArrayList() : Collections.emptyList();
                    if (Boolean.TRUE.equals(hasPointerLikeModifiers) || parameterLists.isEmpty() || typeBuilder.isTypedef() || !(type instanceof OCFunctionType)) break block124;
                    int funProps = 0;
                    if (context2.isVirtual() && initializer != null && !context2.hasModifier(OCSymbolAttribute.DEFAULT) && !context2.hasModifier(OCSymbolAttribute.DELETE)) {
                        funProps |= OCFunctionSymbol.Property.IS_PURE_VIRTUAL.getMask();
                    }
                    if (context2.isTemplateSymbol()) {
                        funProps |= OCFunctionSymbol.Property.IS_TEMPLATE.getMask();
                    }
                    if (conversionOperatorType != null) {
                        funProps |= OCFunctionSymbol.Property.IS_CONVERSION_OPERATOR.getMask();
                    }
                    if (isCppOperator) {
                        funProps |= OCFunctionSymbol.Property.IS_OPERATOR.getMask();
                    }
                    if (isUDL) {
                        funProps |= OCFunctionSymbol.Property.IS_UDL.getMask();
                    }
                    int funAttrs = context2.getModifiers();
                    if (isFinal) {
                        funAttrs |= OCSymbolAttribute.FINAL.getMask();
                    }
                    if (isOverride) {
                        funAttrs |= OCSymbolAttribute.OVERRIDE.getMask();
                    }
                    boolean bl = isDestructorOrConstructor = isDestructor || qualifier != null && name != null && name.equals(qualifier.getName()) || container instanceof OCStructSymbol && name != null && name.equals(container.getName()) || container instanceof OCStructSymbol && context2.isDeclarationWithoutType && !isCppOperator && conversionOperatorType == null;
                    OCSymbolKind kind = isDestructorOrConstructor ? (contextDeclType == OCSymbolKind.FUNCTION_DECLARATION ? OCSymbolKind.CPP_CONSTRUCTOR_DECLARATION : OCSymbolKind.CPP_CONSTRUCTOR_PREDECLARATION) : (contextDeclType == OCSymbolKind.FUNCTION_DECLARATION ? contextDeclType : OCSymbolKind.FUNCTION_PREDECLARATION);
                    ComplexTextRange scope = this.getTextRange(parent);
                    List firstParamSymbols = (List)parameterSymbols.get(0);
                    List firstParamTypes = (List)parameterTypes.get(0);
                    List firstParamNames = (List)parameterNames.get(0);
                    List<Object> defaultValues = OCTypeUtils.getDefaultValues(isConstexpr, firstParamSymbols);
                    if (specialization != null) {
                        templateSpecialization = new ArrayList();
                    }
                    if (parent instanceof OCElement && PsiTreeUtil.getContextOfType((PsiElement)((OCElement)parent), (Class[])new Class[]{OCCallable.class}) != null) {
                        result2 = new OCLocalFunctionSymbol(this.myVirtualFile, offset, container, qualifiedName, templateParameters, templateSpecialization, funProps, funAttrs, attributeList, (OCFunctionType)type, defaultValues, kind, scope);
                    } else if (context2.isTemplateValueParameter()) {
                        OCExpressionSymbol initializerSymbol2 = initializer != null ? this.processExpression(initializer, context2) : null;
                        result2 = new OCTypeParameterValueSymbol(this.myVirtualFile, offset, container, qualifiedName, initializerSymbol2, Collections.emptyList(), type, OCSymbolKind.TEMPLATE_VALUE_PARAMETER, templateParameters, templateSpecialization, 0, funAttrs, scope, visibility);
                    } else {
                        result2 = context2.isDeductionGuide ? new OCDeductionGuideSymbol(this.myVirtualFile, offset, container, name, templateParameters, firstParamSymbols) : new OCFunctionSymbol(this.myVirtualFile, offset, container, qualifiedName, templateParameters, templateSpecialization, funProps, funAttrs, attributeList, (OCFunctionType)type, defaultValues, kind, visibility);
                    }
                    if (specialization != null) {
                        BuilderDriverBase.DeclarationContext<T> declarationContext = this.createDeclarationContext(context2.getCurrentDeclaration(), result2);
                        declarationContext.setInsideTemplateArguments(true);
                        declarationContext.setSpecialization(true);
                        this.processTemplateArgumentList(specialization, templateSpecialization, builder2, declarationContext);
                    }
                    BuilderDriverBase.DeclarationContext<T> innerContext = this.createDeclarationContext(context2.getCurrentDeclaration(), result2);
                    innerContext.setLocalContext(context2.getLocalContext());
                    for (T t : context2.getTemplateParameters()) {
                        this.processTemplateParameterList(t, templateParameters, innerContext);
                        ((ArrayList)templateParameters).trimToSize();
                    }
                    typeBuilder.setLocalContext(innerContext);
                    for (Pair pair : context2.getReferencesInDeclaration()) {
                        if (!(pair.first instanceof OCSymbolReference.GlobalReference)) continue;
                        ((OCSymbolReference.GlobalReference)pair.first).setSymbolContext(result2, (Long)pair.second);
                    }
                    if (trailingReturnType != null) {
                        this.processTypeElement(trailingReturnType, typeBuilder, builder2, innerContext);
                    }
                    if (result2 instanceof OCDeductionGuideSymbol && context2.myDeductionGuideTypeElement != null) {
                        this.processTypeElement(context2.myDeductionGuideTypeElement, typeBuilder, builder2, innerContext);
                        ((OCDeductionGuideSymbol)result2).setGuidedType(typeBuilder.getResult());
                    }
                    if (templateParameters.isEmpty()) {
                        returnType = typeBuilder.getResult();
                    } else {
                        OCTypeParentSymbolSetter oCTypeParentSymbolSetter = new OCTypeParentSymbolSetter(result2);
                        returnType = typeBuilder.getResult().accept(oCTypeParentSymbolSetter);
                        if (conversionOperatorType != null) {
                            conversionOperatorType = conversionOperatorType.accept(oCTypeParentSymbolSetter);
                        }
                        ((OCSymbolWithQualifiedNameImpl)result2).setQualifier(oCTypeParentSymbolSetter.replaceQualifiedName(qualifier));
                    }
                    if (result2 instanceof OCFunctionSymbol && context2.isConstexpr() && !(returnType instanceof OCAutoType)) {
                        returnType = new OCAutoType(null, null, returnType, true, false);
                    }
                    OCFunctionType oCFunctionType = (OCFunctionType)typeBuilder.createFunction(returnType, firstParamTypes, firstParamNames, false, isConstFun, isVolatileFun, isLvalueFun, isRvalueFun, ESI);
                    if (isDestructorOrConstructor) {
                        if (isDestructor) {
                            OCFunctionType oCFunctionType2 = new OCFunctionType(OCVoidType.instance(), firstParamTypes, firstParamNames, ESI);
                        } else if (container instanceof OCStructSymbol && name != null && name.equals(container.getName())) {
                            OCFunctionType oCFunctionType3 = new OCFunctionType(new OCStructType((OCStructSymbol)container), firstParamTypes, firstParamNames, ESI);
                        } else {
                            OCReferenceType referenceType = new OCReferenceTypeBuilder(qualifier, container, this.myVirtualFile, this.getComplexOffsetFromNode(declaratorNode), false, false, false).build();
                            context2.addSymbolReference((Pair<OCSymbolReference, Long>)Pair.create((Object)referenceType.getReference(this.myLanguageKind.isObjC()), (Object)this.getComplexOffsetFromNode(declaratorNode)));
                            OCFunctionType oCFunctionType4 = new OCFunctionType(referenceType, firstParamTypes, firstParamNames, ESI);
                        }
                    }
                    if (conversionOperatorType != null) {
                        OCFunctionType oCFunctionType5 = new OCFunctionType(conversionOperatorType, firstParamTypes, firstParamNames, isConstFun, isVolatileFun, isLvalueFun, isRvalueFun, ESI);
                    }
                    if (!(result2 instanceof OCFunctionSymbol)) break block125;
                    ((OCFunctionSymbol)result2).setType((OCFunctionType)var59_92);
                    break block123;
                }
                if (!(result2 instanceof OCDeclaratorSymbolImpl)) break block123;
                ((OCDeclaratorSymbolImpl)result2).setType((OCFunctionType)var59_92);
                break block123;
            }
            OCSymbolKind declType = null;
            if (typeBuilder.isTypedef()) {
                declType = OCSymbolKind.TYPEDEF;
            } else if (contextDeclType != null) {
                switch (contextDeclType) {
                    case ENUM_CONST: 
                    case STRUCT_FIELD: 
                    case PARAMETER: 
                    case CATCH_EXCEPTION_VARIABLE: 
                    case GLOBAL_VARIABLE_PREDECLARATION: 
                    case TEMPLATE_VALUE_PARAMETER: {
                        declType = contextDeclType;
                        break;
                    }
                }
            }
            if (declType == null) {
                declType = parent != null ? OCSymbolKind.LOCAL_VARIABLE : (initializer != null || context2.isStructuredBindingDeclaration ? OCSymbolKind.GLOBAL_VARIABLE : OCSymbolKind.GLOBAL_VARIABLE_PREDECLARATION);
            }
            ComplexTextRange scope = this.getTextRange(parent);
            for (T params : context2.getTemplateParameters()) {
                this.processTemplateParameterList(params, templateParameters, context2);
                ((ArrayList)templateParameters).trimToSize();
            }
            if (specialization != null) {
                templateSpecialization = new ArrayList<OCTypeArgument>();
            }
            int props = 0;
            int attrs = context2.getModifiers();
            if (typeBuilder.isConst()) {
                attrs |= OCSymbolAttribute.CONST.getMask();
            }
            if (context2.isLambdaInitCapture()) {
                props |= OCDeclaratorSymbol.Property.IS_DECLARED_IN_LAMBDA_CAPTURE.getMask();
            }
            boolean isArrayInitializer = context2.isArrayInitializer();
            context2.setArrayInitializer(type instanceof OCArrayType);
            if (context2.isTemplateValueParameter()) {
                initializerSymbol = initializer != null ? this.processExpression(initializer, context2) : null;
                result2 = new OCTypeParameterValueSymbol(this.myVirtualFile, offset, container, qualifiedName, initializerSymbol, Collections.emptyList(), type, OCSymbolKind.TEMPLATE_VALUE_PARAMETER, templateParameters, templateSpecialization, props, attrs, scope, visibility);
            } else {
                OCInitializerSymbol oCInitializerSymbol = initializerSymbol = initializer != null ? this.processInitializer(initializer, context2) : null;
                if (context2.getParameterIndex() != -1) {
                    props = OCDeclaratorSymbol.Property.IS_ENCODED_PARAM_INDEX.getMask();
                    attrs = context2.getParameterIndex();
                }
                result2 = new OCDeclaratorSymbolImpl(this.myVirtualFile, offset, container, qualifiedName, attributeList, type, declType, initializerSymbol, templateParameters, templateSpecialization, props, attrs, scope, visibility);
            }
            context2.setArrayInitializer(isArrayInitializer);
            if (specialization != null) {
                BuilderDriverBase.DeclarationContext<T> declarationContext = this.createDeclarationContext(result2);
                declarationContext.setInsideTemplateArguments(true);
                declarationContext.setSpecialization(true);
                this.processTemplateArgumentList(specialization, templateSpecialization, builder2, declarationContext);
            }
            if (!templateParameters.isEmpty()) {
                OCTypeParentSymbolSetter setter = new OCTypeParentSymbolSetter(result2);
                type = type.accept(setter);
                ((OCDeclaratorSymbolImpl)result2).setType(type);
            }
            if (result2.getKind() == OCSymbolKind.TYPEDEF) {
                for (Pair<OCSymbolReference, Long> pair : context2.getReferencesInDeclaration()) {
                    if (!(pair.first instanceof OCSymbolReference.GlobalReference) || !(((OCSymbolReference.GlobalReference)pair.first).getSymbolContext() instanceof OCStructSymbol)) continue;
                    ((OCSymbolReference.GlobalReference)pair.first).setSymbolContext(result2, (Long)pair.second);
                }
            }
        }
        for (int i3 = 0; i3 < parameterLists.size(); ++i3) {
            ArrayList symbols = (ArrayList)parameterSymbols.get(i3);
            ArrayList types = (ArrayList)parameterTypes.get(i3);
            List names = (List)parameterNames.get(i3);
            Object node2 = parameterLists.get(parameterLists.size() - i3 - 1);
            BuilderDriverBase.DeclarationContext innerContext = new BuilderDriverBase.DeclarationContext();
            innerContext.setAssumeNonNull(context2.isAssumeNonNull());
            innerContext.parent = node2;
            innerContext.myParentSymbol = result2 instanceof OCSymbolWithQualifiedName ? (OCSymbolWithQualifiedName)result2 : container;
            this.processParameterList(node2, symbols, types, innerContext, names);
            symbols.trimToSize();
            types.trimToSize();
        }
        if (result2 instanceof OCFunctionSymbol) {
            List<Object> defaultValues = OCTypeUtils.getDefaultValues(isConstexpr, (List)parameterSymbols.get(0));
            ((OCFunctionSymbol)result2).setDefaultValues(defaultValues);
        }
        builder2.process((Object)result2);
        return result2;
    }

    private ComplexTextRange getTextRange(Object parent) {
        if (parent instanceof OCElement) {
            return OCSymbolOffsetUtil.getComplexRange((OCElement)parent);
        }
        if (parent instanceof CompositeElement) {
            return OCSymbolOffsetUtil.getComplexRange(((CompositeElement)parent).getTextRange());
        }
        if (parent instanceof PsiBuilder.Marker) {
            return OCSymbolOffsetUtil.getComplexRange(this.nodeStructure, parent);
        }
        return null;
    }

    @NotNull
    private OCStructuredBindingType createStructuredBindingType(@NotNull T initializer, boolean isConst, boolean isVolatile, boolean inForeachStatement, @NotNull BuilderDriverBase.DeclarationContext<T> context2) {
        OCExpressionSymbol initializerSymbol = this.getExpressionSymbol(initializer, context2);
        OCExpression initializerElement = this.getExpressionElement(initializer);
        int declaratorIndex = context2.myDeclaratorIndex;
        return new OCStructuredBindingType(initializerSymbol, initializerElement, declaratorIndex, isConst, isVolatile, inForeachStatement);
    }

    @NotNull
    private OCAutoType createAutoType(@NotNull T initializer, @Nullable OCType type, @NotNull BuilderDriverBase.DeclarationContext<T> context2) {
        OCExpressionSymbol initializerSymbol = this.getExpressionSymbol(initializer, context2);
        OCExpression initializerElement = this.getExpressionElement(initializer);
        return new OCAutoType(initializerSymbol, initializerElement, type, false, false);
    }

    private int evaluateArrayLengths(@NotNull T initializer, boolean isCharArray) {
        int length = 0;
        if (isCharArray && this.type(initializer) == OCElementTypes.LITERAL_EXPRESSION) {
            return this.getStringLiteralLength(initializer);
        }
        for (T child : this.getChildren(initializer)) {
            T subexpression;
            while (isCharArray && this.type(child) == OCElementTypes.PAREN_EXPRESSION && (subexpression = this.getParenSubexpression(child)) != null) {
                child = subexpression;
            }
            IElementType tt = this.type(child);
            if (isCharArray && tt == OCElementTypes.LITERAL_EXPRESSION) {
                int stringLiteralLength = this.getStringLiteralLength(child);
                if (stringLiteralLength > 0) {
                    return stringLiteralLength;
                }
            } else if (tt == OCElementTypes.DESIGNATED_INITIALIZER) {
                return -1;
            }
            if (!OCElementTypes.EXPRESSIONS.contains(tt)) continue;
            ++length;
        }
        return length;
    }

    private int getStringLiteralLength(T literalExpression) {
        OCLog.LOG.assertTrue(this.type(literalExpression) == OCElementTypes.LITERAL_EXPRESSION);
        int len = 0;
        boolean isPresent = false;
        for (T grChild : this.getChildren(literalExpression)) {
            IElementType childType = this.type(grChild);
            if (!OCTokenTypes.ALL_STRINGS.contains(childType)) continue;
            OCStringLiteral literal = OCStringLiteralUtil.parseStringLiteral(this.nodeText(grChild));
            len += literal.getContentLengthInCharacters();
            isPresent = true;
        }
        return len + (isPresent ? 1 : 0);
    }

    @NotNull
    public List<String> processAttributeList(@NotNull T node2) {
        ArrayList<String> answer = new ArrayList<String>();
        for (T child : this.getChildren(node2)) {
            IElementType tt = this.type(child);
            if (tt != OCElementTypes.ATTRIBUTE) continue;
            String attributeName = "";
            for (T grChild : this.getChildren(child)) {
                if (this.type(grChild) == OCTokenTypes.IDENTIFIER) {
                    attributeName = this.nodeText(grChild);
                    answer.add(OCNamesInterner.intern(attributeName));
                }
                if (this.type(grChild) == OCElementTypes.ATTRIBUTE_PARAMETERS) {
                    answer.add(OCNamesInterner.intern(OCAttributes.attributeParameterPrefix(attributeName) + this.nodeText(grChild)));
                }
                if (!OCTokenTypes.CUDA_KEYWORDS.contains(this.type(grChild))) continue;
                attributeName = this.nodeText(grChild);
                answer.add(OCNamesInterner.intern(attributeName));
            }
        }
        return answer;
    }

    @Nullable
    private Object getIntegerConstValue(@NotNull T exprNode) {
        for (T child : this.getChildren(exprNode)) {
            IElementType tt = this.type(child);
            if (!OCTokenTypes.LITERALS.contains(tt) && !OCTokenTypes.CPP_LITERALS.contains(tt)) continue;
            return OCElementUtil.getConstValue(tt, this.nodeText(child), null, this.context, this.project);
        }
        return null;
    }

    @Nullable
    private T getParenSubexpression(@NotNull T parenExpr) {
        if (this.type(parenExpr) == OCElementTypes.PAREN_EXPRESSION) {
            for (T child : this.getChildren(parenExpr)) {
                if (!OCElementTypes.EXPRESSIONS.contains(this.type(child))) continue;
                return child;
            }
        }
        return null;
    }

    @Nullable
    private OCExpression getExpressionElement(@NotNull T child) {
        PsiElement element;
        if (child instanceof CompositeElement && (element = ((CompositeElement)child).getPsi()) instanceof OCExpression) {
            return (OCExpression)element;
        }
        return null;
    }

    @NotNull
    public OCExpressionSymbol getExpressionSymbol(@NotNull T child, @NotNull BuilderDriverBase.DeclarationContext<T> context2) {
        OCExpressionSymbol symbol = this.processExpression(child, context2);
        return symbol != null ? symbol : new OCUnknownExpressionSymbol(this.myVirtualFile, this.getComplexOffsetFromNode(child));
    }

    @Nullable
    private OCInitializerSymbol processInitializer(@NotNull T expr, @NotNull BuilderDriverBase.DeclarationContext<T> context2) {
        if (this.type(expr) == OCElementTypes.ARGUMENT_LIST) {
            ArrayList<OCExpressionSymbol> arguments = new ArrayList<OCExpressionSymbol>();
            this.collectExpressionsFromChildren(expr, context2, arguments);
            return new OCArgumentListSymbol(this.myVirtualFile, this.getComplexOffsetFromNode(expr), arguments);
        }
        return this.processExpression(expr, context2);
    }

    @Nullable
    private OCExpressionSymbol processExpression(@NotNull T expr, @NotNull BuilderDriverBase.DeclarationContext<T> context2) {
        block63: {
            IElementType tt;
            block76: {
                block75: {
                    block74: {
                        block73: {
                            block72: {
                                block71: {
                                    block70: {
                                        block69: {
                                            block68: {
                                                block67: {
                                                    block66: {
                                                        OCExpressionSymbol rightSymbol;
                                                        block65: {
                                                            block64: {
                                                                OCExpressionSymbol operandSymbol;
                                                                block62: {
                                                                    OCExpressionSymbol rightSymbol2;
                                                                    tt = this.type(expr);
                                                                    if (tt != OCElementTypes.BINARY_EXPRESSION) break block62;
                                                                    T left = null;
                                                                    T right = null;
                                                                    OCElementType operator = null;
                                                                    for (T child2 : this.getChildren(expr)) {
                                                                        IElementType childType = this.type(child2);
                                                                        if (OCElementTypes.EXPRESSIONS.contains(childType)) {
                                                                            if (left == null) {
                                                                                left = child2;
                                                                                continue;
                                                                            }
                                                                            right = child2;
                                                                            continue;
                                                                        }
                                                                        if (!OCTokenTypes.BINARY_OPERATIONS.contains(childType)) continue;
                                                                        operator = (OCElementType)childType;
                                                                    }
                                                                    OCExpressionSymbol leftSymbol = left != null ? this.processExpression(left, context2) : null;
                                                                    OCExpressionSymbol oCExpressionSymbol = rightSymbol2 = right != null ? this.processExpression(right, context2) : null;
                                                                    if (operator != null && leftSymbol != null && rightSymbol2 != null) {
                                                                        return new OCBinaryExpressionSymbol(this.myVirtualFile, this.getComplexOffsetFromNode(expr), operator, leftSymbol, rightSymbol2);
                                                                    }
                                                                    break block63;
                                                                }
                                                                if (tt != OCElementTypes.UNARY_EXPRESSION && tt != OCElementTypes.CPP_UDL_EXPRESSION) break block64;
                                                                T operand = null;
                                                                OCElementType operator = null;
                                                                for (T child3 : this.getChildren(expr)) {
                                                                    IElementType childType = this.type(child3);
                                                                    if (OCElementTypes.EXPRESSIONS.contains(childType)) {
                                                                        if (operand != null) continue;
                                                                        operand = child3;
                                                                        continue;
                                                                    }
                                                                    if (!OCTokenTypes.UNARY_OPERATIONS.contains(childType)) continue;
                                                                    operator = (OCElementType)childType;
                                                                }
                                                                OCExpressionSymbol oCExpressionSymbol = operandSymbol = operand != null ? this.processExpression(operand, context2) : null;
                                                                if (operator != null && operandSymbol != null) {
                                                                    return new OCUnaryExpressionSymbol(this.myVirtualFile, this.getComplexOffsetFromNode(expr), operator, operandSymbol);
                                                                }
                                                                break block63;
                                                            }
                                                            if (tt != OCElementTypes.PREFIX_EXPRESSION && tt != OCElementTypes.POSTFIX_EXPRESSION) break block65;
                                                            T operand = null;
                                                            OCElementType operator = null;
                                                            Iterator<T> operandSymbol = this.getChildren(expr).iterator();
                                                            while (operandSymbol.hasNext()) {
                                                                T child4 = operandSymbol.next();
                                                                IElementType childType = this.type(child4);
                                                                if (OCElementTypes.EXPRESSIONS.contains(childType)) {
                                                                    if (operand != null) continue;
                                                                    operand = child4;
                                                                    continue;
                                                                }
                                                                if (!OCTokenTypes.ARITHMETIC_OPERATIONS.contains(childType)) continue;
                                                                operator = (OCElementType)childType;
                                                            }
                                                            Iterator<T> iterator2 = operandSymbol = operand != null ? this.processExpression(operand, context2) : null;
                                                            if (operator != null && operandSymbol != null) {
                                                                return tt == OCElementTypes.PREFIX_EXPRESSION ? new OCPrefixExpressionSymbol(this.myVirtualFile, this.getComplexOffsetFromNode(expr), operator, (OCExpressionSymbol)((Object)operandSymbol)) : new OCPostfixExpressionSymbol(this.myVirtualFile, this.getComplexOffsetFromNode(expr), operator, (OCExpressionSymbol)((Object)operandSymbol));
                                                            }
                                                            break block63;
                                                        }
                                                        if (tt != OCElementTypes.CONDITIONAL_EXPRESSION) break block66;
                                                        T cond = null;
                                                        T left = null;
                                                        T right = null;
                                                        for (T child5 : this.getChildren(expr)) {
                                                            IElementType childType = this.type(child5);
                                                            if (!OCElementTypes.EXPRESSIONS.contains(childType)) continue;
                                                            if (cond == null) {
                                                                cond = child5;
                                                                continue;
                                                            }
                                                            if (left == null) {
                                                                left = child5;
                                                                continue;
                                                            }
                                                            right = child5;
                                                        }
                                                        OCExpressionSymbol condSymbol = cond != null ? this.processExpression(cond, context2) : null;
                                                        OCExpressionSymbol leftSymbol = left != null ? this.processExpression(left, context2) : null;
                                                        OCExpressionSymbol oCExpressionSymbol = rightSymbol = right != null ? this.processExpression(right, context2) : null;
                                                        if (condSymbol != null && leftSymbol != null && rightSymbol != null) {
                                                            return new OCConditionalExpressionSymbol(this.myVirtualFile, this.getComplexOffsetFromNode(expr), condSymbol, leftSymbol, rightSymbol);
                                                        }
                                                        break block63;
                                                    }
                                                    if (tt != OCElementTypes.LITERAL_EXPRESSION) break block67;
                                                    Object value = this.getIntegerConstValue(expr);
                                                    if (value != null) {
                                                        ArrayList<String> literals = new ArrayList<String>();
                                                        IElementType firstChildType = this.type(this.getChildren(expr).iterator().next());
                                                        this.getChildren(expr).iterator().forEachRemaining(child -> {
                                                            IElementType type = this.type(child);
                                                            if (OCTokenTypes.LITERALS.contains(type) || OCTokenTypes.CPP_LITERALS.contains(type)) {
                                                                literals.add(this.nodeText(child));
                                                            }
                                                        });
                                                        literals.trimToSize();
                                                        if (!literals.isEmpty()) {
                                                            return new OCLiteralExpressionSymbol(value, firstChildType, literals);
                                                        }
                                                    }
                                                    break block63;
                                                }
                                                if (tt == OCElementTypes.REFERENCE_EXPRESSION) {
                                                    OCSymbolReference reference;
                                                    OCQualifiedName name = this.processQualifiedName(expr, null, context2);
                                                    OCSymbolReference oCSymbolReference = reference = context2.getLocalContext() != null ? OCSymbolReference.getLocalReference(name, context2.getLocalContext()) : OCSymbolReference.getGlobalReference(name, context2.getParentSymbol(), this.myVirtualFile, this.getComplexOffsetFromNode(expr));
                                                    if (context2.getLambda() != null) {
                                                        reference = OCSymbolReference.getLambdaLocalReference(name, this.getComplexOffsetFromNode(expr), context2.getLambda(), reference);
                                                    }
                                                    context2.addSymbolReference((Pair<OCSymbolReference, Long>)Pair.create((Object)reference, (Object)this.getComplexOffsetFromNode(expr)));
                                                    return new OCReferenceExpressionSymbol(this.myVirtualFile, this.getComplexOffsetFromNode(expr), reference);
                                                }
                                                if (tt != OCElementTypes.QUALIFIED_EXPRESSION) break block68;
                                                OCExpressionSymbol qualifier = null;
                                                String name = null;
                                                List<OCTypeArgument> typeArguments = Collections.emptyList();
                                                boolean isDeref = false;
                                                for (T child6 : this.getChildren(expr)) {
                                                    IElementType childType = this.type(child6);
                                                    if (OCElementTypes.EXPRESSIONS.contains(childType)) {
                                                        qualifier = this.processExpression(child6, context2);
                                                    }
                                                    if (childType == OCTokenTypes.TILDE) {
                                                        name = "~";
                                                        continue;
                                                    }
                                                    if (childType == OCTokenTypes.IDENTIFIER) {
                                                        name = (name != null ? name : "") + this.nodeText(child6);
                                                        continue;
                                                    }
                                                    if (childType == OCElementTypes.QUALIFIED_EXPRESSION_ACCESSOR) {
                                                        for (T grChild : this.getChildren(child6)) {
                                                            if (this.type(grChild) != OCTokenTypes.DEREF) continue;
                                                            isDeref = true;
                                                        }
                                                        continue;
                                                    }
                                                    if (childType != OCElementTypes.TEMPLATE_ARGUMENT_LIST) continue;
                                                    typeArguments = new ArrayList<OCTypeArgument>();
                                                    this.processTemplateArgumentList(child6, typeArguments, (Processor<OCSymbol>)this.builder, context2);
                                                }
                                                if (qualifier != null && name != null) {
                                                    return new OCQualifiedExpressionSymbol(this.myVirtualFile, this.getComplexOffsetFromNode(expr), qualifier, name, isDeref, typeArguments);
                                                }
                                                break block63;
                                            }
                                            if (tt != OCElementTypes.SIZEOF_EXPRESSION) break block69;
                                            boolean isVariadic = false;
                                            for (T child7 : this.getChildren(expr)) {
                                                IElementType childType = this.type(child7);
                                                if (OCElementTypes.EXPRESSIONS.contains(childType)) {
                                                    OCExpressionSymbol operand = this.processExpression(child7, context2);
                                                    return operand != null ? new OCSizeofExpressionSymbol(this.myVirtualFile, this.getComplexOffsetFromNode(expr), operand, isVariadic) : null;
                                                }
                                                if (OCElementTypes.TYPE_ELEMENT == childType) {
                                                    OCType type = this.processTypeElement(child7, this.createTypeBuilder(context2), null, context2);
                                                    return new OCSizeofExpressionSymbol(this.myVirtualFile, this.getComplexOffsetFromNode(expr), type, isVariadic);
                                                }
                                                if (childType != OCTokenTypes.ELLIPSIS) continue;
                                                isVariadic = true;
                                            }
                                            break block63;
                                        }
                                        if (tt != OCElementTypes.NOEXCEPT_EXPRESSION) break block70;
                                        for (T child8 : this.getChildren(expr)) {
                                            IElementType childType = this.type(child8);
                                            if (!OCElementTypes.EXPRESSIONS.contains(childType)) continue;
                                            OCExpressionSymbol operand = this.processExpression(child8, context2);
                                            return operand != null ? new OCNoexceptExpressionSymbol(this.myVirtualFile, this.getComplexOffsetFromNode(expr), operand) : null;
                                        }
                                        break block63;
                                    }
                                    if (tt == OCElementTypes.THROW_EXPRESSION) {
                                        OCExpressionSymbol operand = null;
                                        boolean isCppStatement = true;
                                        for (T child9 : this.getChildren(expr)) {
                                            IElementType childType = this.type(child9);
                                            if (OCElementTypes.OBJC_KEYWORD == childType) {
                                                isCppStatement = false;
                                                continue;
                                            }
                                            if (!OCElementTypes.EXPRESSIONS.contains(childType)) continue;
                                            operand = this.processExpression(child9, context2);
                                            break;
                                        }
                                        return new OCThrowExpressionSymbol(this.myVirtualFile, this.getComplexOffsetFromNode(expr), operand, isCppStatement);
                                    }
                                    if (tt != OCElementTypes.CALL_EXPRESSION) break block71;
                                    OCExpressionSymbol calleeSymbol = null;
                                    ArrayList<OCExpressionSymbol> arguments = new ArrayList<OCExpressionSymbol>();
                                    for (T child10 : this.getChildren(expr)) {
                                        IElementType childType = this.type(child10);
                                        if (OCElementTypes.EXPRESSIONS.contains(childType)) {
                                            calleeSymbol = this.processExpression(child10, context2);
                                            continue;
                                        }
                                        if (OCElementTypes.ARGUMENT_LIST != childType) continue;
                                        this.collectExpressionsFromChildren(child10, context2, arguments);
                                    }
                                    if (calleeSymbol != null) {
                                        OCCallExpressionSymbol callSymbol = new OCCallExpressionSymbol(this.myVirtualFile, this.getComplexOffsetFromNode(expr), calleeSymbol, arguments);
                                        if (calleeSymbol instanceof OCReferenceExpressionSymbol) {
                                            ((OCReferenceExpressionSymbol)calleeSymbol).setParent(callSymbol);
                                        } else if (calleeSymbol instanceof OCQualifiedExpressionSymbol) {
                                            ((OCQualifiedExpressionSymbol)calleeSymbol).setParent(callSymbol);
                                        }
                                        return callSymbol;
                                    }
                                    break block63;
                                }
                                if (tt != OCElementTypes.ARRAY_INDEX_EXPRESSION) break block72;
                                OCExpressionSymbol arraySymbol = null;
                                OCExpressionSymbol indexSymbol = null;
                                for (T child11 : this.getChildren(expr)) {
                                    IElementType childType = this.type(child11);
                                    if (!OCElementTypes.EXPRESSIONS.contains(childType)) continue;
                                    if (arraySymbol == null) {
                                        arraySymbol = this.processExpression(child11, context2);
                                        continue;
                                    }
                                    indexSymbol = this.processExpression(child11, context2);
                                }
                                if (arraySymbol != null && indexSymbol != null) {
                                    return new OCArrayIndexExpressionSymbol(this.myVirtualFile, this.getComplexOffsetFromNode(expr), arraySymbol, indexSymbol);
                                }
                                break block63;
                            }
                            if (tt != OCElementTypes.PAREN_EXPRESSION) break block73;
                            T subexpression = this.getParenSubexpression(expr);
                            if (subexpression != null) {
                                return this.processExpression(subexpression, context2);
                            }
                            break block63;
                        }
                        if (tt != OCElementTypes.CAST_EXPRESSION) break block74;
                        OCExpressionSymbol operandSymbol = null;
                        OCType type = null;
                        OCCastKind castKind = OCCastKind.C_STYLE_CAST;
                        for (T child12 : this.getChildren(expr)) {
                            IElementType childType = this.type(child12);
                            if (OCElementTypes.EXPRESSIONS.contains(childType)) {
                                operandSymbol = this.processExpression(child12, context2);
                                continue;
                            }
                            if (OCElementTypes.TYPE_ELEMENT == childType) {
                                type = this.processTypeElement(child12, this.createTypeBuilder(context2), null, context2);
                                continue;
                            }
                            if (OCElementTypes.ARGUMENT_LIST == childType) {
                                for (T grChild : this.getChildren(child12)) {
                                    IElementType grChildType = this.type(grChild);
                                    if (!OCElementTypes.EXPRESSIONS.contains(grChildType)) continue;
                                    operandSymbol = this.processExpression(grChild, context2);
                                }
                                continue;
                            }
                            if (!OCTokenTypes.CPP_CAST_OPERATIONS.contains(childType)) continue;
                            castKind = OCCastKind.fromToken((OCKeywordElementType)childType, castKind);
                        }
                        if (type != null) {
                            return new OCCastExpressionSymbol(this.myVirtualFile, this.getComplexOffsetFromNode(expr), operandSymbol, type, castKind);
                        }
                        break block63;
                    }
                    if (tt == OCElementTypes.COMPOUND_INITIALIZER) {
                        return this.processCompoundInitializer(expr, context2);
                    }
                    if (tt != OCElementTypes.COMMA_EXPRESSION) break block75;
                    ArrayList<OCExpressionSymbol> expressions = new ArrayList<OCExpressionSymbol>();
                    for (T child13 : this.getChildren(expr)) {
                        IElementType argType = this.type(child13);
                        if (!OCElementTypes.EXPRESSIONS.contains(argType)) continue;
                        expressions.add(this.getExpressionSymbol(child13, context2));
                    }
                    if (expressions.size() == 2) {
                        return new OCCommaExpressionSymbol(this.myVirtualFile, this.getComplexOffsetFromNode(expr), (OCExpressionSymbol)expressions.get(0), (OCExpressionSymbol)expressions.get(1));
                    }
                    break block63;
                }
                if (tt == OCElementTypes.CPP_LAMBDA_EXPRESSION) {
                    List<OCType> parameterTypes = Collections.emptyList();
                    OCType returnType = null;
                    OCLambdaExpressionSymbol result2 = null;
                    ArrayList<OCDeclaratorSymbol> localVarsAndParams = new ArrayList<OCDeclaratorSymbol>();
                    ArrayList<OCDeclaratorSymbol> parameters = new ArrayList<OCDeclaratorSymbol>();
                    for (T child14 : this.getChildren(expr)) {
                        IElementType childType = this.type(child14);
                        if (childType == OCElementTypes.PARAMETER_LIST) {
                            parameterTypes = new ArrayList();
                            this.processParameterList(child14, parameters, parameterTypes, context2, null);
                            localVarsAndParams.addAll(parameters);
                            continue;
                        }
                        if (childType == OCElementTypes.TYPE_ELEMENT) {
                            returnType = this.processTypeElement(child14, this.createTypeBuilder(context2), null, context2);
                            continue;
                        }
                        if (!OCElementTypes.STATEMENTS.contains(childType) || returnType != null && !OCBuilderDriver.isEmptyAutoType(returnType)) continue;
                        ArrayList<OCExpressionSymbol> returnExpressions = new ArrayList<OCExpressionSymbol>();
                        result2 = new OCLambdaExpressionSymbol(this.myVirtualFile, this.getComplexOffsetFromNode(expr), returnExpressions, parameters, localVarsAndParams, parameterTypes, null);
                        BuilderDriverBase.DeclarationContext lambdaContext = new BuilderDriverBase.DeclarationContext(null, child14, context2.getParentSymbol(), null, context2.getLocalContext(), false);
                        lambdaContext.setLambda(result2);
                        this.collectReturnsAndLocalSymbols(child14, lambdaContext, returnExpressions, localVarsAndParams);
                        ContainerUtil.sort(localVarsAndParams, OCLambdaExpressionSymbol.variablesComparator);
                        returnExpressions.trimToSize();
                        localVarsAndParams.trimToSize();
                    }
                    if (result2 == null) {
                        result2 = new OCLambdaExpressionSymbol(this.myVirtualFile, this.getComplexOffsetFromNode(expr), Collections.emptyList(), parameters, Collections.emptyList(), parameterTypes, returnType);
                    }
                    return result2;
                }
                if (tt != OCElementTypes.CPP_NEW_EXPRESSION) break block76;
                ArrayList<OCExpressionSymbol> arguments = new ArrayList<OCExpressionSymbol>();
                boolean isListInitializaton = false;
                OCType type = null;
                int arrayLengths = 0;
                for (T child15 : this.getChildren(expr)) {
                    IElementType childType = this.type(child15);
                    if (OCElementTypes.TYPE_ELEMENT == childType) {
                        type = this.processTypeElement(child15, this.createTypeBuilder(context2), null, context2);
                        for (T grChild : this.getChildren(child15)) {
                            if (this.type(grChild) != OCTokenTypes.LBRACKET) continue;
                            ++arrayLengths;
                        }
                        continue;
                    }
                    if (OCElementTypes.ARGUMENT_LIST == childType) {
                        this.collectExpressionsFromChildren(child15, context2, arguments);
                        continue;
                    }
                    if (OCElementTypes.COMPOUND_INITIALIZER != childType) continue;
                    arguments.add(this.processCompoundInitializer(child15, context2));
                    isListInitializaton = true;
                }
                if (type != null) {
                    return new OCNewExpressionSymbol(this.myVirtualFile, this.getComplexOffsetFromNode(expr), type, arrayLengths, arguments, isListInitializaton);
                }
                break block63;
            }
            if (tt != OCElementTypes.CPP_VARIADIC_PACK_EXPRESSION) break block63;
            for (T child16 : this.getChildren(expr)) {
                OCExpressionSymbol expression;
                if (!OCElementTypes.EXPRESSIONS.contains(this.type(child16)) || (expression = this.processExpression(child16, context2)) == null) continue;
                return new OCVariadicPackExpressionSymbol(this.myVirtualFile, this.getComplexOffsetFromNode(expr), expression);
            }
        }
        return null;
    }

    @NotNull
    private OCExpressionSymbol processCompoundInitializer(@NotNull T expr, @NotNull BuilderDriverBase.DeclarationContext<T> context2) {
        ArrayList<OCExpressionSymbol> initializers = new ArrayList<OCExpressionSymbol>();
        for (T child : this.getChildren(expr)) {
            IElementType argType = this.type(child);
            if (!OCElementTypes.EXPRESSIONS.contains(argType)) continue;
            initializers.add(this.getExpressionSymbol(child, context2));
        }
        if (context2.isArrayInitializer()) {
            initializers = initializers.isEmpty() ? initializers : Collections.singletonList(initializers.get(0));
        }
        return new OCInitializerListExpressionSymbol(this.myVirtualFile, this.getComplexOffsetFromNode(expr), initializers);
    }

    private void collectExpressionsFromChildren(@NotNull T expr, @NotNull BuilderDriverBase.DeclarationContext<T> context2, @NotNull List<OCExpressionSymbol> expressions) {
        for (T child : this.getChildren(expr)) {
            OCExpressionSymbol expressionSymbol;
            if (!OCElementTypes.EXPRESSIONS.contains(this.type(child)) || (expressionSymbol = this.processExpression(child, context2)) == null) continue;
            expressions.add(expressionSymbol);
        }
    }

    private void collectReturnsAndLocalSymbols(@NotNull T statement2, @NotNull BuilderDriverBase.DeclarationContext<T> context2, @NotNull List<OCExpressionSymbol> returnExpressions, @NotNull List<OCDeclaratorSymbol> localVariables) {
        for (T child : this.getChildren(statement2)) {
            IElementType tt = this.type(child);
            if (tt == OCElementTypes.RETURN_STATEMENT) {
                this.collectExpressionsFromChildren(child, context2, returnExpressions);
                continue;
            }
            if (tt == OCElementTypes.DECLARATION || tt == OCElementTypes.STRUCTURED_BINDING_DECLARATION) {
                this.processDeclaration(child, (Processor<OCSymbol>)((Processor)symbol -> {
                    if (symbol instanceof OCDeclaratorSymbolImpl) {
                        localVariables.add((OCDeclaratorSymbol)symbol);
                    }
                    return true;
                }), context2);
                continue;
            }
            if (OCElementTypes.BLOCK_STATEMENTS.contains(tt)) {
                BuilderDriverBase.DeclarationContext newContext = new BuilderDriverBase.DeclarationContext(null, child, context2.getParentSymbol(), null, null, false);
                newContext.setLambda(context2.getLambda());
                this.collectReturnsAndLocalSymbols(child, newContext, returnExpressions, localVariables);
                continue;
            }
            this.collectReturnsAndLocalSymbols(child, context2, returnExpressions, localVariables);
        }
    }

    private void processTemplateParameterList(@NotNull T parameterListNode, @NotNull List<OCTypeParameterSymbol> collector, @NotNull BuilderDriverBase.DeclarationContext<T> context2) {
        context2 = this.createDeclarationContext(context2.getParent(), context2.getParentSymbol());
        context2.setTemplateValueParameter(true);
        for (T child : this.getChildren(parameterListNode)) {
            if (this.type(child) == OCElementTypes.CPP_TYPE_PARAMETER_DECLARATION) {
                collector.add(this.processTypeParameter(child, context2));
                continue;
            }
            if (this.type(child) != OCElementTypes.PARAMETER_DECLARATION) continue;
            this.processDeclaration(child, (Processor<OCSymbol>)((Processor)symbol -> {
                if (symbol instanceof OCTypeParameterValueSymbol) {
                    collector.add((OCTypeParameterSymbol)symbol);
                }
                return true;
            }), context2);
        }
    }

    private void processParameterList(@NotNull T parameterListNode, @Nullable List<OCDeclaratorSymbol> parameterSymbols, @NotNull List<OCType> parameterTypes, @NotNull BuilderDriverBase.DeclarationContext<T> context2, @Nullable List<String> parameterNames) {
        int paramIndex = 0;
        int oldParameterIndex = context2.getParameterIndex();
        for (T child : this.getChildren(parameterListNode)) {
            if (this.type(child) != OCElementTypes.PARAMETER_DECLARATION) continue;
            context2.setParameterIndex(paramIndex++);
            this.processParameterDeclaration(child, context2, (Processor<OCDeclaratorSymbol>)((Processor)symbol -> {
                if (parameterSymbols != null) {
                    parameterSymbols.add((OCDeclaratorSymbol)symbol);
                }
                if (parameterNames != null) {
                    parameterNames.add(symbol.getName());
                }
                parameterTypes.add(symbol.getType());
                return true;
            }));
        }
        context2.setParameterIndex(oldParameterIndex);
    }

    private void processParameterDeclaration(@NotNull T declarationNode, @NotNull BuilderDriverBase.DeclarationContext<T> context2, @NotNull Processor<OCDeclaratorSymbol> processor2) {
        BuilderDriverBase.DeclarationContext innerContext = new BuilderDriverBase.DeclarationContext(OCSymbolKind.PARAMETER);
        innerContext.setAssumeNonNull(context2.isAssumeNonNull());
        innerContext.myParentSymbol = context2.myParentSymbol;
        innerContext.parent = context2.parent;
        innerContext.setParameterIndex(context2.getParameterIndex());
        innerContext.setLocalContext(context2.getLocalContext());
        this.processDeclaration(declarationNode, (Processor<OCSymbol>)((Processor)symbol -> {
            if (symbol instanceof OCDeclaratorSymbolImpl) {
                processor2.process((Object)((OCDeclaratorSymbol)symbol));
            }
            return true;
        }), innerContext);
    }

    public void processImportModuleStatement(@NotNull T node2) {
        ArrayList<String> moduleNameParts = new ArrayList<String>();
        for (T child : this.getChildren(node2)) {
            if (this.type(child) != OCTokenTypes.IDENTIFIER) continue;
            moduleNameParts.add(this.nodeText(child));
        }
        long offset = this.getComplexOffsetFromNode(node2);
        int offsetAfter = this.nodeStructure.getEndOffset(node2);
        this.builder.process((Object)new OCModuleImportSymbol(this.myVirtualFile, offset, StringUtil.join(moduleNameParts, (String)"."), offsetAfter));
    }

    public void processImportDirective(@NotNull T directiveNode) {
        boolean next = false;
        boolean importOnce = false;
        boolean isSymTableUsed = true;
        String content = null;
        IElementType type = null;
        List<String> namespace = null;
        for (T child : this.getChildren(directiveNode)) {
            IElementType elementType = this.type(child);
            if (elementType == OCTokenTypes.IMPORT_DIRECTIVE) {
                importOnce = true;
                continue;
            }
            if (elementType == OCTokenTypes.INCLUDE_NEXT_DIRECTIVE) {
                next = true;
                continue;
            }
            if (elementType == OCTokenTypes.INCLUDE_DIRECTIVE_CONTENT) {
                OCLog.LOG.warn("Raw import in processing: " + this.nodeText(child));
                break;
            }
            if (elementType == OCTokenTypes.HEADER_PATH_LITERAL) {
                content = this.nodeText(child);
                type = this.nodeStructure.getTokenType(child);
                continue;
            }
            if (elementType == OCTokenTypes.HEADER_INLINED_PATH_LITERAL) {
                content = null;
                continue;
            }
            if (elementType == OCTokenTypes.HEADER_TOO_LONG_INLINED_PATH_LITERAL) {
                isSymTableUsed = false;
                continue;
            }
            if (elementType != OCTokenTypes.INCLUDE_DIRECTIVE_OUTER_NAMESPACE) continue;
            Object tt = child instanceof ForeignLeafPsiElement ? ((ForeignLeafPsiElement)child).getForeignType() : this.nodeStructure.getTokenType(child);
            OCLog.LOG.assertTrue(tt instanceof OCInnerIncludeElementType, tt);
            namespace = ((OCInnerIncludeElementType)((Object)tt)).getNamespace();
        }
        if (content != null) {
            OCIncludeSymbol.IncludePath anchorPath;
            VirtualFile anchorFile;
            String pathWithPrefixPunctuator;
            OCIncludeSymbol.IncludePath relativePath = OCInclusionContext.extractPath(content, true);
            VirtualFile anchor = this.myVirtualFile;
            if (anchor != null && type instanceof OCMacroForeignLeafType && (pathWithPrefixPunctuator = ((OCMacroForeignLeafType)type).getMacroName()) != null && (anchorFile = this.context.resolvePath(anchorPath = OCInclusionContext.extractPath(pathWithPrefixPunctuator, true), anchor, false)) != null && anchorFile.isValid()) {
                anchor = anchorFile;
            }
            VirtualFile include = anchor == null ? null : this.context.resolvePath(relativePath, anchor, next);
            long offset = this.getComplexOffsetFromNode(directiveNode);
            int offsetAfter = this.nodeStructure.getEndOffset(directiveNode);
            OCIncludeSymbol symbol = new OCIncludeSymbol(this.myVirtualFile, offset, include, relativePath, importOnce, next, offsetAfter, namespace, isSymTableUsed);
            this.builder.process((Object)symbol);
            if (include == null && LOG_UNRESOLVED_SYMBOLS) {
                OCLog.LOG.warn("Can't resolve: " + content);
            }
        }
    }

    public void processDefineDirective(@NotNull T directiveNode, boolean define) {
        List children = ContainerUtil.collect(this.getChildren(directiveNode).iterator());
        for (int i2 = 0; i2 < children.size(); ++i2) {
            OCNamedSymbol macro;
            String definition;
            Object child = children.get(i2);
            IElementType tt = this.type(child);
            if (tt != OCTokenTypes.IDENTIFIER && !OCTokenTypes.KEYWORDS.contains(tt) && tt != OCElementTypes.MACRO_REF) continue;
            int identOffset = this.nodeStructure.getStartOffset(child);
            IElementType type = this.nodeStructure.getTokenType(child);
            if (type instanceof OCMacroForeignLeafType) {
                StringBuilder definitionBuilder = new StringBuilder();
                for (int k = i2; k < children.size(); ++k) {
                    Object innerChild = children.get(k);
                    IElementType typeC = this.type(innerChild);
                    if (typeC == OCTokenTypes.EOL_ESCAPE) continue;
                    if (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET_WITHOUT_EOL_ESCAPE.contains(typeC)) {
                        definitionBuilder.append(' ');
                        continue;
                    }
                    definitionBuilder.append(this.nodeText(innerChild, null, true));
                }
                definition = definitionBuilder.toString();
            } else {
                definition = this.text.substring(identOffset, this.nodeStructure.getEndOffset(directiveNode));
            }
            if (define) {
                macro = OCMacroSymbol.parseFromDirectiveContent(definition, this.myVirtualFile, this.getComplexOffsetFromNode(child));
                if (macro == null) break;
                this.context.define((OCMacroSymbol)macro);
                this.builder.process((Object)macro);
                break;
            }
            macro = OCUndefMacroSymbol.parseFromDirectiveContent(definition, this.myVirtualFile, this.getComplexOffsetFromNode(child));
            if (macro == null) break;
            this.context.undef(macro.getName());
            this.builder.process((Object)macro);
            break;
        }
    }

    private void processPragma(@NotNull T root) {
        for (T child : this.getChildren(root)) {
            IElementType type = this.type(child);
            if (!(type instanceof OCPragmaOnceContentElementType)) continue;
            VirtualFile onceFile = ((OCPragmaOnceContentElementType)type).getFile();
            if (onceFile == null) break;
            String pragmaOnceId = OCInclusionContextUtil.pragmaOnceId(onceFile);
            this.builder.process((Object)OCMacroSymbol.inclusionGuard(pragmaOnceId));
            break;
        }
    }

    @NotNull
    public OCTypeBuilder createTypeBuilder(@NotNull BuilderDriverBase.DeclarationContext context2) {
        return this.createTypeBuilder(this.myLanguageKind, context2);
    }

    @NotNull
    public OCTypeBuilder createTypeBuilder(@NotNull OCLanguageKind languageKind, @NotNull BuilderDriverBase.DeclarationContext context2) {
        return new OCTypeBuilder(languageKind, this.context, context2, this.project);
    }

    private static /* synthetic */ boolean lambda$processStruct$3(boolean myIsEnumClass, OCSymbolKind myKind, Processor structBuilder, boolean myAnonymous, OCStructSymbol struct, Processor finalBuilder, OCSymbol symbol) {
        boolean addToParent = false;
        if (symbol instanceof OCDeclaratorSymbolImpl) {
            OCDeclaratorSymbol dcl = (OCDeclaratorSymbol)symbol;
            addToParent = !myIsEnumClass && myKind == OCSymbolKind.ENUM && dcl.getKind() == OCSymbolKind.ENUM_CONST;
        } else {
            OCSymbol delegate = symbol.getDelegate();
            if (delegate instanceof OCFunctionSymbol && ((OCFunctionSymbol)delegate).isFriend()) {
                addToParent = true;
            }
        }
        structBuilder.process((Object)symbol);
        if ((addToParent || myAnonymous && struct.getParent() instanceof OCStructSymbol) && finalBuilder != null) {
            finalBuilder.process((Object)new OCDelegatingSymbol(symbol.getDelegate()));
        }
        return true;
    }
}

