/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.settings;

import com.intellij.lang.Language;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import org.jetbrains.annotations.NotNull;

public abstract class OCBaseLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    protected final Language myLanguage;

    protected OCBaseLanguageCodeStyleSettingsProvider(@NotNull Language language) {
        this.myLanguage = language;
    }

    @NotNull
    public Language getLanguage() {
        return this.myLanguage;
    }

    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        String fileName = OCBaseLanguageCodeStyleSettingsProvider.getCodeSampleFileName(settingsType);
        return this.getCodeSampleContent(fileName);
    }

    @NotNull
    public static String getCodeSampleFileName(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        String fileName;
        switch (settingsType) {
            default: {
                fileName = "General";
                break;
            }
            case SPACING_SETTINGS: {
                fileName = "Spaces";
                break;
            }
            case BLANK_LINES_SETTINGS: {
                fileName = "BlankLines";
                break;
            }
            case INDENT_SETTINGS: {
                fileName = "Indents";
            }
        }
        return fileName;
    }

    @NotNull
    protected abstract String getCodeSampleContent(@NotNull String var1);
}

