/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCLocalizedString;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import org.jetbrains.annotations.NotNull;

public class OCLocalizedStringReferencesSearch
implements QueryExecutor<PsiReference, ReferencesSearch.SearchParameters> {
    public boolean execute(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer) {
        return (Boolean)ReadAction.compute(() -> OCLocalizedStringReferencesSearch.doExecute(queryParameters, consumer));
    }

    private static Boolean doExecute(ReferencesSearch.SearchParameters queryParameters, Processor<? super PsiReference> consumer) {
        PsiElement string = queryParameters.getElementToSearch();
        if (!(string instanceof OCLocalizedString)) {
            return true;
        }
        PsiSearchHelper helper = PsiSearchHelper.getInstance((Project)string.getProject());
        String text = ((OCLocalizedString)string).getName();
        if (text == null || text.isEmpty()) {
            return true;
        }
        return helper.processElementsWithWord((element, offsetInElement) -> {
            PsiReference[] references = PsiReference.EMPTY_ARRAY;
            if (element instanceof OCLiteralExpression) {
                references = element.getReferences();
            } else if (element instanceof OCMacroCall) {
                references = new PsiReference[]{element.findReferenceAt(offsetInElement)};
            }
            for (PsiReference reference : references) {
                if (reference == null || !reference.isReferenceTo(string) || consumer.process((Object)reference)) continue;
                return false;
            }
            return true;
        }, queryParameters.getEffectiveSearchScope(), text, (short)4, true);
    }
}

