/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve.v2;

import com.jetbrains.cidr.lang.resolve.v2.ImplicitConversionKind;
import com.jetbrains.cidr.lang.resolve.v2.ImplicitConversionRank;
import com.jetbrains.cidr.lang.resolve.v2.TypeProperties;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import org.jetbrains.annotations.NotNull;

class StandardConversionSequence {
    ImplicitConversionKind First;
    ImplicitConversionKind Second;
    ImplicitConversionKind Third;
    boolean DeprecatedStringLiteralToCharPtr = false;
    boolean QualificationIncludesObjCLifetime = false;
    boolean IncompatibleObjC;
    boolean ReferenceBinding = false;
    boolean DirectBinding = false;
    boolean IsLvalueReference = true;
    boolean BindsToFunctionLvalue = false;
    boolean BindsToRvalue = false;
    boolean BindsImplicitObjectArgumentWithoutRefQualifier = false;
    boolean ObjCLifetimeConversionBinding = false;
    OCType FromTypePtr;
    OCType[] ToTypePtrs = new OCType[3];
    OCFunctionSymbol CopyConstructor = null;
    private static final ImplicitConversionRank[] Rank = new ImplicitConversionRank[]{ImplicitConversionRank.ICR_Exact_Match, ImplicitConversionRank.ICR_Exact_Match, ImplicitConversionRank.ICR_Exact_Match, ImplicitConversionRank.ICR_Exact_Match, ImplicitConversionRank.ICR_Exact_Match, ImplicitConversionRank.ICR_Exact_Match, ImplicitConversionRank.ICR_Promotion, ImplicitConversionRank.ICR_Promotion, ImplicitConversionRank.ICR_Promotion, ImplicitConversionRank.ICR_Conversion, ImplicitConversionRank.ICR_Conversion, ImplicitConversionRank.ICR_Conversion, ImplicitConversionRank.ICR_Conversion, ImplicitConversionRank.ICR_Conversion, ImplicitConversionRank.ICR_Conversion, ImplicitConversionRank.ICR_Conversion, ImplicitConversionRank.ICR_Conversion, ImplicitConversionRank.ICR_Conversion, ImplicitConversionRank.ICR_Conversion, ImplicitConversionRank.ICR_Conversion, ImplicitConversionRank.ICR_Complex_Real_Conversion, ImplicitConversionRank.ICR_Conversion, ImplicitConversionRank.ICR_Conversion, ImplicitConversionRank.ICR_Writeback_Conversion, ImplicitConversionRank.ICR_Exact_Match, ImplicitConversionRank.ICR_C_Conversion};

    void setFromType(OCType T) {
        this.FromTypePtr = T;
    }

    void setToType(int Idx, OCType T) {
        assert (Idx < 3) : "To type index is out of range";
        this.ToTypePtrs[Idx] = T;
    }

    void setAllToTypes(OCType T) {
        this.ToTypePtrs[0] = T;
        this.ToTypePtrs[1] = this.ToTypePtrs[0];
        this.ToTypePtrs[2] = this.ToTypePtrs[0];
    }

    OCType getFromType() {
        return this.FromTypePtr;
    }

    OCType getToType(int Idx) {
        assert (Idx < 3) : "To type index is out of range";
        return this.ToTypePtrs[Idx];
    }

    StandardConversionSequence() {
        this.First = ImplicitConversionKind.ICK_Identity;
        this.Second = ImplicitConversionKind.ICK_Identity;
        this.Third = ImplicitConversionKind.ICK_Identity;
        this.FromTypePtr = OCUnknownType.INSTANCE;
        this.setAllToTypes(OCUnknownType.INSTANCE);
    }

    public void setAsIdentityConversion() {
        this.First = ImplicitConversionKind.ICK_Identity;
        this.Second = ImplicitConversionKind.ICK_Identity;
        this.Third = ImplicitConversionKind.ICK_Identity;
        this.DeprecatedStringLiteralToCharPtr = false;
        this.QualificationIncludesObjCLifetime = false;
        this.ReferenceBinding = false;
        this.DirectBinding = false;
        this.IsLvalueReference = true;
        this.BindsToFunctionLvalue = false;
        this.BindsToRvalue = false;
        this.BindsImplicitObjectArgumentWithoutRefQualifier = false;
        this.ObjCLifetimeConversionBinding = false;
        this.CopyConstructor = null;
    }

    boolean isIdentityConversion() {
        return this.Second == ImplicitConversionKind.ICK_Identity && this.Third == ImplicitConversionKind.ICK_Identity;
    }

    private static ImplicitConversionRank GetConversionRank(ImplicitConversionKind Kind2) {
        return Rank[Kind2.ordinal()];
    }

    ImplicitConversionRank getRank() {
        ImplicitConversionRank Rank = ImplicitConversionRank.ICR_Exact_Match;
        if (StandardConversionSequence.GetConversionRank(this.First).compareTo(Rank) > 0) {
            Rank = StandardConversionSequence.GetConversionRank(this.First);
        }
        if (StandardConversionSequence.GetConversionRank(this.Second).compareTo(Rank) > 0) {
            Rank = StandardConversionSequence.GetConversionRank(this.Second);
        }
        if (StandardConversionSequence.GetConversionRank(this.Third).compareTo(Rank) > 0) {
            Rank = StandardConversionSequence.GetConversionRank(this.Third);
        }
        return Rank;
    }

    boolean isPointerConversionToBool(@NotNull OCResolveContext context2) {
        return OCIntType.isBool(this.getToType(1), context2) && (this.getFromType() instanceof OCPointerType || this.First == ImplicitConversionKind.ICK_Array_To_Pointer || this.First == ImplicitConversionKind.ICK_Function_To_Pointer);
    }

    public boolean isPointerConversionToVoidPointer(@NotNull OCResolveContext context2) {
        OCType FromType = this.getFromType();
        OCType ToType = this.getToType(1);
        if (this.First == ImplicitConversionKind.ICK_Array_To_Pointer) {
            FromType = TypeProperties.getArrayDecayedType((OCArrayType)FromType, context2);
        }
        if (this.Second == ImplicitConversionKind.ICK_Pointer_Conversion && FromType instanceof OCPointerType && ToType instanceof OCPointerType) {
            return ((OCPointerType)ToType).getRefType().isVoid();
        }
        return false;
    }
}

