/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve.references;

import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.resolve.references.OCCompositeResourceReference;
import com.jetbrains.cidr.lang.resolve.references.OCResourceCompletionProvider;
import com.jetbrains.cidr.lang.resolve.references.OCResourceReference;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeResourceCompletionProvider
extends OCResourceCompletionProvider {
    private static final Function<OCResourceCompletionProvider, String> CLASS_NAME = provider2 -> provider2.getClassName();
    private static final Function<OCResourceCompletionProvider, String> SELECTOR = provider2 -> provider2.getArgumentSelector();
    private final OCResourceCompletionProvider @NotNull [] myProviders;

    public CompositeResourceCompletionProvider(OCResourceCompletionProvider ... providers) {
        super(CompositeResourceCompletionProvider.className(providers), CompositeResourceCompletionProvider.argumentSelector(providers));
        this.myProviders = providers;
    }

    private static String argumentSelector(OCResourceCompletionProvider @NotNull [] providers) {
        return CompositeResourceCompletionProvider.assertSameValue(Arrays.asList(providers), SELECTOR);
    }

    private static String className(OCResourceCompletionProvider @NotNull [] providers) {
        return CompositeResourceCompletionProvider.assertSameValue(Arrays.asList(providers), CLASS_NAME);
    }

    public static <T, V> V assertSameValue(@NotNull Iterable<? extends T> items, Function<? super T, ? extends V> property) {
        OCLog.LOG.assertTrue(items.iterator().hasNext());
        Object result2 = null;
        for (T item : items) {
            Object value = property.fun(item);
            OCLog.LOG.assertTrue(result2 == null || result2.equals(value));
            result2 = value;
        }
        return (V)result2;
    }

    @Override
    @Nullable
    protected OCResourceReference createReference(OCExpression expression, @Nullable PsiElement referenceElement) {
        ArrayList<OCResourceReference> references = new ArrayList<OCResourceReference>();
        for (OCResourceCompletionProvider provider2 : this.myProviders) {
            references.add(provider2.createReference(expression, referenceElement));
        }
        return new OCCompositeResourceReference(references);
    }
}

