/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCVariadicPackExpression;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCVariadicPackExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCExpansionPackType;
import com.jetbrains.cidr.lang.types.OCExpressionTypeArgument;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.visitors.OCBooleanTypeVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCNonPrimitiveTypeCloneVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCSimpleTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCArgumentsList<E extends OCTypeOwner> {
    @NotNull
    private List<OCType> types;
    @Nullable
    private List<E> exprs;
    private boolean nonExpandedVariadics;

    public OCArgumentsList(@NotNull List<OCType> types, @Nullable List<E> exprs, boolean nonExpandedVariadics) {
        this.types = Collections.unmodifiableList(types);
        this.exprs = exprs != null ? Collections.unmodifiableList(exprs) : null;
        this.nonExpandedVariadics = nonExpandedVariadics;
    }

    public OCArgumentsList(@NotNull List<OCType> types, @Nullable List<E> exprs) {
        this(types, exprs, false);
    }

    public OCArgumentsList() {
        this(Collections.emptyList(), Collections.emptyList(), false);
    }

    @NotNull
    public static OCArgumentsList<OCExpression> getArgumentList(@NotNull List<OCExpression> expressionsList) {
        return OCArgumentsList.getArgumentList(expressionsList, null);
    }

    @NotNull
    public static OCArgumentsList<OCExpression> getArgumentList(@NotNull List<OCExpression> expressionsList, @Nullable OCResolveContext context2) {
        ArrayList<OCType> types = new ArrayList<OCType>();
        boolean nonExpandedVariadics = false;
        ArrayList<OCExpression> expressions = new ArrayList<OCExpression>();
        for (OCExpression expression : expressionsList) {
            if (expression instanceof OCVariadicPackExpression) {
                nonExpandedVariadics = true;
                continue;
            }
            if (expression == null) continue;
            expressions.add(expression);
            types.add(expression.getResolvedType(context2 != null ? context2 : OCResolveContext.forPsi(expression)));
        }
        return new OCArgumentsList<OCExpression>(types, expressions, nonExpandedVariadics);
    }

    @NotNull
    public static OCArgumentsList<OCExpressionSymbol> expandVariadicExpressions(@NotNull List<OCExpressionSymbol> expressionsList, @NotNull OCResolveContext context2) {
        ArrayList<OCType> expandedTypes = new ArrayList<OCType>();
        ArrayList<OCExpressionSymbol> expandedExprs = new ArrayList<OCExpressionSymbol>();
        boolean nonExpandedVariadics = false;
        for (OCExpressionSymbol expression : expressionsList) {
            if (expression instanceof OCVariadicPackExpressionSymbol) {
                List<OCType> expansions = ((OCVariadicPackExpressionSymbol)expression).getExpandedResolvedTypes(context2);
                if (expansions != null) {
                    for (OCType type : expansions) {
                        expandedExprs.add(((OCVariadicPackExpressionSymbol)expression).getExpression());
                        expandedTypes.add(type);
                    }
                    continue;
                }
                nonExpandedVariadics = true;
                continue;
            }
            expandedExprs.add(expression);
            expandedTypes.add(expression.getResolvedType(context2));
        }
        return new OCArgumentsList<OCExpressionSymbol>(expandedTypes, expandedExprs, nonExpandedVariadics);
    }

    @NotNull
    public static <T extends OCTypeArgument> List<T> expandVariadicTypes(@NotNull List<T> types, @NotNull OCResolveContext context2) {
        ArrayList<OCTypeArgument> result2 = new ArrayList<OCTypeArgument>();
        if (context2.isDontExpandVariadics()) {
            return types;
        }
        for (OCTypeArgument type : types) {
            List<OCTypeArgument> expandedTypes = null;
            if (type instanceof OCVariadicType) {
                OCType underlyingType = ((OCVariadicType)type).getUnderlyingType();
                expandedTypes = OCArgumentsList.expandExpansionPacks(underlyingType, context2);
                if (expandedTypes == null) {
                    expandedTypes = OCArgumentsList.expandVariadicType(underlyingType, context2);
                }
            } else if (type.isVariadic() && type instanceof OCExpressionTypeArgument) {
                expandedTypes = OCArgumentsList.expandVariadicPackExpression((OCVariadicPackExpressionSymbol)((OCExpressionTypeArgument)type).getSymbol(), context2);
            }
            if (expandedTypes != null) {
                result2.addAll(expandedTypes);
                continue;
            }
            result2.add(type);
        }
        return result2;
    }

    @Nullable
    private static List<? extends OCTypeArgument> expandExpansionPacks(@NotNull OCType type, final @NotNull OCResolveContext context2) {
        final Ref expansionsCnt = new Ref();
        final HashMap<OCTypeParameterSymbol, OCExpansionPackType> expansionSubstitutions = new HashMap<OCTypeParameterSymbol, OCExpansionPackType>();
        type.accept(new OCBooleanTypeVisitor(){

            @Override
            public Boolean visitExpansionPackType(OCExpansionPackType type) {
                if (expansionsCnt.isNull() || (Integer)expansionsCnt.get() < type.getExpansionsCnt()) {
                    expansionsCnt.set((Object)type.getExpansionsCnt());
                }
                return true;
            }

            private boolean processSubstitution(@NotNull OCTypeSubstitution substitution2, @NotNull Object reference) {
                boolean prev = context2.dontUseSymbolContextsInDepends();
                context2.setDontUseSymbolContextsInDepends(true);
                substitution2.getMinimalDependentSubstitution(reference, context2).processSubstitutions((Processor<Map.Entry<OCTypeParameterSymbol, OCTypeArgument>>)((Processor)e -> {
                    OCTypeArgument value = (OCTypeArgument)e.getValue();
                    if (value instanceof OCExpansionPackType) {
                        expansionSubstitutions.put(e.getKey(), (OCExpansionPackType)value);
                    }
                    if (value instanceof OCType) {
                        ((OCType)value).accept(this);
                    }
                    return true;
                }));
                context2.setDontUseSymbolContextsInDepends(prev);
                return true;
            }

            @Override
            public Boolean visitReferenceType(OCReferenceType type) {
                return this.processSubstitution(type.getSubstitution(), type);
            }

            @Override
            public Boolean visitArrayType(OCArrayType type) {
                return this.processSubstitution(type.getSubstitution(), type);
            }
        });
        if (!expansionsCnt.isNull()) {
            ArrayList<OCType> expandedTypes = new ArrayList<OCType>();
            for (int i2 = 0; i2 < (Integer)expansionsCnt.get(); ++i2) {
                final int expansionIndex = i2;
                OCType resolvedType = type;
                if (!expansionSubstitutions.isEmpty()) {
                    HashMap<OCTypeParameterSymbol, OCTypeArgument> map2 = new HashMap<OCTypeParameterSymbol, OCTypeArgument>();
                    expansionSubstitutions.forEach((param, pack) -> {
                        if (expansionIndex < pack.getExpansionsCnt()) {
                            map2.put((OCTypeParameterSymbol)param, pack.getExpansions().get(expansionIndex));
                        }
                    });
                    OCSimpleTypeSubstitution substitution2 = OCSimpleTypeSubstitution.create(map2);
                    resolvedType = substitution2.substitute(type, true, context2).resolve(context2);
                    if (resolvedType instanceof OCVariadicType) {
                        resolvedType = new OCVariadicType(substitution2.substitute(((OCVariadicType)resolvedType).getUnderlyingType(), context2));
                    }
                }
                expandedTypes.add(resolvedType.accept(new OCNonPrimitiveTypeCloneVisitor(){

                    @Override
                    public OCType visitExpansionPackType(OCExpansionPackType type) {
                        OCTypeArgument argument;
                        if (expansionIndex < type.getExpansionsCnt() && (argument = type.getExpansions().get(expansionIndex)) instanceof OCType) {
                            return (OCType)argument;
                        }
                        return OCUnknownType.INSTANCE;
                    }
                }));
            }
            return expandedTypes;
        }
        return null;
    }

    @Nullable
    private static List<? extends OCTypeArgument> expandVariadicPackExpression(@NotNull OCVariadicPackExpressionSymbol expressionSymbol, @NotNull OCResolveContext context2) {
        final OCExpressionSymbol symbol = expressionSymbol.getExpression();
        return OCArgumentsList.getExpandedResolvedTypes(context1 -> symbol.evaluateToTypeArgument((OCResolveContext)context1), new OCTypeOwner(){

            @Override
            @NotNull
            public OCType getResolvedType(@NotNull OCResolveContext context2) {
                return symbol.getResolvedType(context2);
            }
        }, context2);
    }

    @Nullable
    private static List<? extends OCTypeArgument> expandVariadicType(final @NotNull OCType underlyingType, @NotNull OCResolveContext context3) {
        return OCArgumentsList.getExpandedResolvedTypes(context2 -> context2.getSubstitution().substitute(underlyingType, (OCResolveContext)context2), new OCTypeOwner(){

            @Override
            @NotNull
            public OCType getResolvedType(@NotNull OCResolveContext context2) {
                return underlyingType.resolve(context2);
            }
        }, context3);
    }

    @Nullable
    public static List<OCType> getExpandedResolvedTypes(@NotNull OCTypeOwner operand, @NotNull OCTypeOwner dependency, @NotNull OCResolveContext context2) {
        return OCArgumentsList.getExpandedResolvedTypes(context1 -> operand.getResolvedType((OCResolveContext)context1), dependency, context2);
    }

    @Nullable
    public static <T extends OCTypeArgument> List<T> getExpandedResolvedTypes(@NotNull Function<OCResolveContext, T> operand, @NotNull OCTypeOwner dependency, @NotNull OCResolveContext context2) {
        while (context2.isVariadicExpansionMode()) {
            context2 = context2.getOriginalContext();
        }
        Set<OCTypeParameterSymbol> dependencies = OCArgumentsList.getTypeParameterDependencies(dependency, context2);
        List<Pair<OCTypeParameterSymbol, OCExpansionPackType>> expansions = OCArgumentsList.getExpansions(dependencies, context2);
        if (expansions == null || expansions.isEmpty()) {
            return null;
        }
        ArrayList<OCTypeArgument> result2 = new ArrayList<OCTypeArgument>();
        for (int i2 = 0; i2 < ((OCExpansionPackType)expansions.get((int)0).second).getExpansionsCnt(); ++i2) {
            Map<OCTypeParameterSymbol, OCTypeArgument> map2 = OCTypeUtils.newTypeParameterMap();
            for (Pair<OCTypeParameterSymbol, OCExpansionPackType> expansion : expansions) {
                map2.put((OCTypeParameterSymbol)expansion.first, ((OCExpansionPackType)expansion.second).getExpansions().get(i2));
            }
            OCResolveContext resolveContext = context2.substitute(OCSimpleTypeSubstitution.create(map2), true, false);
            resolveContext.setVariadicExpansionMode(true);
            OCTypeArgument argument = (OCTypeArgument)operand.fun((Object)resolveContext);
            if (argument == null) {
                return null;
            }
            result2.add(argument);
        }
        return result2;
    }

    @Nullable
    private static List<Pair<OCTypeParameterSymbol, OCExpansionPackType>> getExpansions(@NotNull Set<OCTypeParameterSymbol> dependencies, @NotNull OCResolveContext context2) {
        HashSet processed = new HashSet();
        ArrayList<Pair<OCTypeParameterSymbol, OCExpansionPackType>> pairs = new ArrayList<Pair<OCTypeParameterSymbol, OCExpansionPackType>>();
        if (!context2.getSubstitution().processSubstitutions((Processor<Map.Entry<OCTypeParameterSymbol, OCTypeArgument>>)((Processor)entry -> {
            OCTypeParameterSymbol parameter = (OCTypeParameterSymbol)entry.getKey();
            OCTypeArgument argument = (OCTypeArgument)entry.getValue();
            if (dependencies.contains(parameter) && !processed.contains(parameter) && argument instanceof OCExpansionPackType) {
                processed.add(parameter);
                if (!pairs.isEmpty() && ((OCExpansionPackType)((Pair)pairs.get((int)0)).second).getExpansionsCnt() != ((OCExpansionPackType)argument).getExpansionsCnt()) {
                    return false;
                }
                pairs.add(Pair.create((Object)parameter, (Object)((OCExpansionPackType)argument)));
            }
            return true;
        }))) {
            return null;
        }
        return pairs;
    }

    @NotNull
    private static Set<OCTypeParameterSymbol> getTypeParameterDependencies(@NotNull OCTypeOwner dependency, @NotNull OCResolveContext context2) {
        OCResolveContext contextWithoutSubstitutions = context2.clearSubstitution();
        contextWithoutSubstitutions.setDontExpandVariadics(true);
        OCType resolvedDependency = dependency.getResolvedType(contextWithoutSubstitutions);
        return contextWithoutSubstitutions.getTypeDependencies(resolvedDependency);
    }

    @NotNull
    public List<OCType> getTypes() {
        return this.types;
    }

    @Nullable
    public List<E> getExprs() {
        return this.exprs;
    }

    public int getCount() {
        return this.types.size();
    }

    public boolean hasNonExpandedVariadics() {
        return this.nonExpandedVariadics;
    }
}

