/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.unwrap;

import com.intellij.codeInsight.unwrap.AbstractUnwrapper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCEmptyStatement;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCUnwrapper
extends AbstractUnwrapper<Context> {
    public OCUnwrapper(String description2) {
        super(description2);
    }

    protected Context createContext() {
        return new Context();
    }

    protected static boolean isInArgList(@NotNull PsiElement e) {
        return e.getParent() instanceof OCArgumentList;
    }

    protected static boolean isElseBlock(@Nullable PsiElement element) {
        if (!(element instanceof OCStatement)) {
            return false;
        }
        PsiElement parent = element.getParent();
        return parent instanceof OCIfStatement && element == ((OCIfStatement)parent).getElseBranch();
    }

    protected static class Context
    extends AbstractUnwrapper.AbstractContext {
        protected Context() {
        }

        protected boolean isWhiteSpace(PsiElement element) {
            return element instanceof PsiWhiteSpace;
        }

        public void addSemicolonBefore(PsiElement anchor) {
            if (this.myIsEffective) {
                PsiElement semicolon = OCElementFactory.create(OCTokenTypes.SEMICOLON, anchor);
                anchor.getParent().addBefore(semicolon, anchor);
            }
        }

        public void addNewLineBefore(PsiElement anchor) {
            if (this.myIsEffective) {
                PsiElement newLine = OCElementFactory.newlineFromText(anchor);
                anchor.getParent().addBefore(newLine, anchor);
            }
        }

        public void extractWhitespace(PsiElement ws, PsiElement from) {
            assert (this.isWhiteSpace(ws));
            PsiElement toExtract = ws;
            if (this.myIsEffective) {
                toExtract = from.getParent().addBefore(ws, from);
            }
            this.addElementToExtract(toExtract);
        }

        public void setElseBranch(OCIfStatement ifStatement, OCStatement elseBranch) throws IncorrectOperationException {
            assert (ifStatement.getElseBranch() != elseBranch) : "Why setting 'else' branch which already belongs to 'if' statement?";
            OCStatement toExtract = elseBranch;
            if (this.myIsEffective) {
                ifStatement.setElse(elseBranch);
                toExtract = ifStatement.getElseBranch();
            }
            this.addElementToExtract(toExtract);
        }

        public void extractFromBlockOrSingleStatement(@Nullable OCStatement block, PsiElement from) throws IncorrectOperationException {
            if (block instanceof OCBlockStatement) {
                this.extractFromCodeBlock((OCBlockStatement)block, from);
            } else if (block != null && !(block instanceof OCEmptyStatement)) {
                this.extract(block, block, from);
            }
        }

        public void extractFromCodeBlock(@Nullable OCBlockStatement block, PsiElement from) throws IncorrectOperationException {
            if (block == null || block.getStatements().isEmpty()) {
                return;
            }
            this.extract(this.getFirstBodyElement(block), this.getLastBodyElement(block), from);
        }

        protected PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, @NotNull PsiElement parent, @NotNull PsiElement anchor) {
            PsiElement firstExtracted = OCChangeUtil.addBefore(parent, first, anchor);
            while (first != null && first != last) {
                first = first.getNextSibling();
                OCChangeUtil.addBefore(parent, first, anchor);
            }
            return firstExtracted;
        }

        public void delete(PsiElement e) throws IncorrectOperationException {
            if (this.myIsEffective) {
                if (e instanceof OCStatement) {
                    OCChangeUtil.safeDeleteStatement((OCStatement)e);
                } else {
                    OCChangeUtil.delete(e);
                }
            }
        }

        public void deleteExactly(PsiElement e) throws IncorrectOperationException {
            if (this.myIsEffective) {
                OCChangeUtil.deleteExactly(e);
            }
        }

        private PsiElement getFirstBodyElement(@NotNull OCBlockStatement block) {
            PsiElement lBrace = block.getOpeningBrace();
            if (lBrace == null) {
                return null;
            }
            PsiElement nextSibling = lBrace.getNextSibling();
            return nextSibling == block.getClosingBrace() ? null : nextSibling;
        }

        private PsiElement getLastBodyElement(@NotNull OCBlockStatement block) {
            PsiElement rBrace = block.getClosingBrace();
            if (rBrace != null) {
                PsiElement prevSibling = rBrace.getPrevSibling();
                return prevSibling == block.getOpeningBrace() ? null : prevSibling;
            }
            return block.getLastChild();
        }
    }
}

