/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.rename;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.usageView.UsageInfo;
import com.jetbrains.cidr.lang.preprocessor.OCHeaderGuardInfo;
import com.jetbrains.cidr.lang.preprocessor.OCHeaderGuardUtil;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.refactoring.OCRenameProcessorExtension;
import com.jetbrains.cidr.lang.refactoring.rename.OCRenameFileProcessor;
import com.jetbrains.cidr.lang.refactoring.rename.OCRenameUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class OCHeaderGuardRenameProcessor
extends RenamePsiElementProcessor
implements OCRenameProcessorExtension {
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element instanceof OCFile) {
            return true;
        }
        OCSymbol symbolToRename = OCRenameUtil.getSymbolToRename(element);
        return symbolToRename != null && (symbolToRename instanceof OCStructSymbol || symbolToRename.getKind().isConstructorOrDestructor()) && OCRenameUtil.symbolHasSameNameWithFile(symbolToRename.getName(), symbolToRename.getKind(), element.getContainingFile()) && OCRenameUtil.shouldRenameSameClassOrFileEntity(element);
    }

    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames) {
        PsiFile file2;
        if (element instanceof OCFile) {
            OCHeaderGuardRenameProcessor.doPrepareRenaming((OCFile)element, allRenames, element.getProject());
            return;
        }
        OCSymbol symbolToRename = OCRenameUtil.getSymbolToRename(element);
        if (symbolToRename != null && (symbolToRename instanceof OCStructSymbol || symbolToRename.getKind().isConstructorOrDestructor()) && (file2 = element.getContainingFile()) instanceof OCFile) {
            OCHeaderGuardRenameProcessor.doPrepareRenaming((OCFile)file2, allRenames, element.getProject());
        }
    }

    @Override
    public boolean skipNonCodeUsage(@NotNull PsiNamedElement elementToRename, @NotNull UsageInfo usageInfo) {
        PsiFile file2;
        PsiElement usageInfoElement = usageInfo.getElement();
        PsiFile psiFile = file2 = usageInfoElement != null ? usageInfoElement.getContainingFile() : null;
        if (file2 == null) {
            return false;
        }
        OCHeaderGuardInfo headerGuardInfo = OCHeaderGuardUtil.findCachedHeaderGuard(file2, false);
        return headerGuardInfo != null && usageInfoElement instanceof PsiComment && headerGuardInfo.getHeaderGuardName().equals(OCElementUtil.getCommentText((PsiComment)usageInfoElement).trim()) && headerGuardInfo.getEndifDirective() != null && PsiTreeUtil.isAncestor((PsiElement)headerGuardInfo.getEndifDirective(), (PsiElement)usageInfoElement, (boolean)true);
    }

    @Override
    public void findExtraVariants(@NotNull PsiFileSystemItem variant, @NotNull String newRootName, @NotNull OCRenameFileProcessor.VariantProcessor variantProcessor) {
    }

    private static void doPrepareRenaming(@NotNull OCFile file2, @NotNull Map<PsiElement, String> allRenames, @NotNull Project project2) {
        String newFilePath;
        OCFile headerFile;
        OCFile oCFile = headerFile = file2.isHeader() ? file2 : file2.getAssociatedFileWithSameName();
        if (headerFile == null) {
            return;
        }
        OCHeaderGuardInfo headerGuardInfo = OCHeaderGuardUtil.findCachedHeaderGuard(headerFile, true);
        if (headerGuardInfo == null) {
            return;
        }
        String newHeaderName = allRenames.get(headerFile);
        if (newHeaderName == null) {
            return;
        }
        VirtualFile virtualFile = headerFile.getVirtualFile();
        String oldFilePath = virtualFile != null ? virtualFile.getPath() : file2.getName();
        String string = newFilePath = virtualFile != null && virtualFile.getParent() != null ? FileUtil.join((String[])new String[]{virtualFile.getParent().getPath(), newHeaderName}) : newHeaderName;
        if (StringUtil.isEmpty((String)oldFilePath) || StringUtil.isEmpty((String)newFilePath)) {
            return;
        }
        if (!OCHeaderGuardUtil.headerGuardMatchesPattern(headerGuardInfo.getHeaderGuardName(), oldFilePath, project2)) {
            return;
        }
        String newHeaderGuardName = OCHeaderGuardUtil.buildHeaderGuardName(newFilePath, project2);
        allRenames.put(headerGuardInfo.getDefineDirective(), newHeaderGuardName);
    }
}

