/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.move.ui;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.classMembers.UsedByDependencyMemberInfoModel;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.actions.newFile.OCNewClassAction;
import com.jetbrains.cidr.lang.actions.newFile.OCNewCppClassAction;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.actions.newFile.OCNewProtocolAction;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.refactoring.move.OCCppTargetClass;
import com.jetbrains.cidr.lang.refactoring.move.OCMemberInfo;
import com.jetbrains.cidr.lang.refactoring.move.OCMoveCppProcessor;
import com.jetbrains.cidr.lang.refactoring.move.OCMoveObjCProcessor;
import com.jetbrains.cidr.lang.refactoring.move.OCMoveProcessor;
import com.jetbrains.cidr.lang.refactoring.move.OCObjcTargetClass;
import com.jetbrains.cidr.lang.refactoring.move.ui.OCAbstractExtractDialog;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCExtractSubClassDialog
extends OCAbstractExtractDialog {
    public OCExtractSubClassDialog(@NotNull OCSymbolDeclarator clazz, OCSymbol classSymbol, Condition<PsiElement> selectedCondition) {
        super(clazz, classSymbol, selectedCondition, clazz.getProject());
        this.myMemberInfos = this.myStorage.getClassMemberInfos(clazz);
        this.setMembersChecked();
        this.setTitle(OCBundle.message("extract.subclass.dialog.title", new Object[0]));
        this.init();
    }

    @Nullable
    protected String getHelpId() {
        return "refactoring.extract.subclass.dialog";
    }

    @Override
    @NotNull
    protected String getClassType() {
        return "Subclass";
    }

    @Override
    protected MemberInfoModel<OCSymbolHolderVirtualPsiElement, OCMemberInfo> createModel() {
        return new UsedByDependencyMemberInfoModel<OCSymbolHolderVirtualPsiElement, OCSymbolDeclarator, OCMemberInfo>(this.mySourceClass){

            public boolean isMemberEnabled(OCMemberInfo member) {
                return OCExtractSubClassDialog.this.isMemberEnabled(member);
            }
        };
    }

    @Override
    protected String getConflictMessage(OCMemberInfo info, OCSymbol symbol) {
        return "Extracted code will be inaccessible from the " + symbol.getNameWithKindLowercase(OCCompilationContext.create(symbol, this.myProject));
    }

    @Override
    protected OCMoveProcessor createProcessor() {
        if (this.mySourceClass instanceof OCClassDeclaration) {
            return new OCMoveObjCProcessor((OCClassDeclaration)this.mySourceClass, this.getSelectedMemberInfos(), this.getClassName(), Collections.emptyList()){

                @Override
                @Nullable
                protected OCNewFileActionBase getNewClassAction() {
                    if (this.mySourceClass.getElement() instanceof OCProtocol) {
                        return new OCNewProtocolAction();
                    }
                    return new OCNewClassAction();
                }

                @Override
                public void addSuperClasses() {
                    OCReferenceElement superClassElement;
                    OCClassDeclaration element = (OCClassDeclaration)this.mySourceClass.getElement();
                    OCReferenceElement oCReferenceElement = superClassElement = element != null ? element.getSuperClassRef().getReferenceElement() : null;
                    if (superClassElement != null) {
                        this.myMover.setSuperClass((OCClassDeclaration)((OCObjcTargetClass)this.myTargetClasses.get(0)).getPsi(), ((OCClassSymbol)this.mySourceClassSymbol).getName());
                    }
                }

                @NotNull
                protected String getCommandName() {
                    return OCExtractSubClassDialog.this.getTitle();
                }

                @Override
                protected boolean importSourceFromTarget() {
                    return true;
                }
            };
        }
        if (this.mySourceClass instanceof OCStruct) {
            return new OCMoveCppProcessor((OCStruct)this.mySourceClass, this.getSelectedMemberInfos(), this.getClassName(), Collections.emptyList()){

                @Override
                protected OCNewFileActionBase getNewClassAction() {
                    OCStruct element = (OCStruct)this.mySourceClass.getElement();
                    OCStructSymbol symbol = element != null ? (OCStructSymbol)element.getSymbol() : null;
                    OCQualifiedName qualifiedName = symbol != null ? symbol.getResolvedQualifiedName(OCResolveContext.forPsi(element)) : null;
                    return new OCNewCppClassAction(qualifiedName != null ? qualifiedName.getQualifier() : null);
                }

                @Override
                protected void addSuperClasses() {
                    this.myMover.addBaseClass((OCStruct)((OCCppTargetClass)this.myTargetClasses.get(0)).getPsi(), (OCStructSymbol)this.mySourceClassSymbol, OCVisibility.PUBLIC, true);
                }

                @NotNull
                protected String getCommandName() {
                    return OCExtractSubClassDialog.this.getTitle();
                }

                @Override
                protected boolean importSourceFromTarget() {
                    return true;
                }
            };
        }
        assert (false) : this.mySourceClass;
        return null;
    }
}

