/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.move;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.classMembers.AbstractUsesDependencyMemberInfoModel;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.classMembers.UsedByDependencyMemberInfoModel;
import com.jetbrains.cidr.lang.refactoring.move.OCMemberInfo;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTopLevelModel
extends UsedByDependencyMemberInfoModel<OCSymbolHolderVirtualPsiElement, PsiElement, OCMemberInfo> {
    private boolean myImportTargetFromSource;
    private boolean myImportSourceFromTarget;
    private VirtualFile mySourceFile;
    private Supplier<Boolean> myWrapMode;
    private Supplier<OCNamespaceSymbol> myTargetNamespace;
    private Project myProject;
    private final MyModel myUsesModel;

    public OCTopLevelModel(@Nullable PsiElement source, @NotNull Supplier<Boolean> wrapMode, @NotNull Supplier<OCNamespaceSymbol> targetNamespace, @NotNull Project project2) {
        super(source);
        this.mySourceFile = source != null ? source.getContainingFile().getVirtualFile() : null;
        this.myUsesModel = new MyModel(source);
        this.myWrapMode = wrapMode;
        this.myTargetNamespace = targetNamespace;
        this.myProject = project2;
    }

    public boolean importTargetFromSource() {
        return this.myImportTargetFromSource;
    }

    public boolean importSourceFromTarget() {
        return this.myImportSourceFromTarget && !this.myImportTargetFromSource;
    }

    protected boolean insertImports() {
        return true;
    }

    @Nullable
    public String getConflictMessage(@NotNull OCMemberInfo memberInfo, @NotNull OCSymbol symbol, @NotNull Project project2) {
        OCResolveContext context2 = OCResolveContext.forSymbol(symbol, project2);
        OCSymbol owner = OCTopLevelModel.ownerInDifferentFile(memberInfo.getSymbol(), context2);
        if (this.myWrapMode.get().booleanValue() && memberInfo.isChecked() && owner != null) {
            String message = "Can't move members of " + owner.getNameWithKindLowercase(context2);
            VirtualFile file2 = owner.getContainingFile();
            if (file2 != null) {
                message = message + " from file '" + file2.getName() + "'";
            }
            message = message + " to different namespace";
            return message;
        }
        if (super.checkForProblems((MemberInfoBase)memberInfo) != 0) {
            OCSymbolHolderVirtualPsiElement s;
            if (symbol instanceof OCSymbolWithQualifiedName && (owner = ((OCSymbolWithQualifiedName)symbol).getResolvedOwner(context2)) instanceof OCStructSymbol && this.myUsesModel.getDependenciesOf(s = new OCSymbolHolderVirtualPsiElement(owner, project2)).contains(s)) {
                return null;
            }
            return symbol.getNameWithKindUppercase(context2) + " will not be able to access the moved code";
        }
        if (this.myUsesModel.checkForProblems(memberInfo) != 0) {
            OCSymbol separatedMember = this.findSeparatedMember(symbol, context2);
            if (separatedMember != null) {
                return separatedMember.getNameWithKindUppercase(context2) + " must be in the same namespace as " + symbol.getNameWithKindLowercase(context2);
            }
            return symbol.getNameWithKindUppercase(context2) + " will be inaccessible in the moved code";
        }
        return "";
    }

    private OCSymbol findSeparatedMember(@NotNull OCSymbol symbol, @NotNull OCResolveContext context2) {
        if ((this.myWrapMode.get().booleanValue() || this.myTargetNamespace.get() != null && !this.myTargetNamespace.get().isGlobalNamespace()) && symbol instanceof OCStructSymbol) {
            for (OCSymbolHolderVirtualPsiElement oCSymbolHolderVirtualPsiElement : this.myUsesModel.getDependenciesOf(new OCSymbolHolderVirtualPsiElement(symbol, context2.getProject()))) {
                if (!(oCSymbolHolderVirtualPsiElement.getSymbol() instanceof OCSymbolWithQualifiedName) || ((OCSymbolWithQualifiedName)oCSymbolHolderVirtualPsiElement.getSymbol()).getResolvedOwner(context2) != symbol) continue;
                return oCSymbolHolderVirtualPsiElement.getSymbol();
            }
        }
        return null;
    }

    @Nullable
    private static OCSymbol ownerInDifferentFile(@NotNull OCSymbol symbol, @NotNull OCResolveContext context2) {
        OCSymbolWithQualifiedName owner;
        if (symbol instanceof OCSymbolWithQualifiedName && (owner = ((OCSymbolWithQualifiedName)symbol).getResolvedOwner(context2)) != null && !Comparing.equal((Object)owner.getContainingFile(), (Object)symbol.getContainingFile())) {
            return owner;
        }
        return null;
    }

    public int checkForProblems(@NotNull OCMemberInfo memberInfo) {
        OCResolveContext context2 = OCResolveContext.forSymbol(memberInfo.getSymbol(), this.myProject);
        if (this.myWrapMode.get().booleanValue() && memberInfo.isChecked() && OCTopLevelModel.ownerInDifferentFile(memberInfo.getSymbol(), context2) != null) {
            return 2;
        }
        if (this.myUsesModel.checkForProblems(memberInfo) != 0) {
            this.myImportSourceFromTarget = true;
            return this.findSeparatedMember(memberInfo.getSymbol(), context2) != null ? 2 : 1;
        }
        if (super.checkForProblems((MemberInfoBase)memberInfo) != 0) {
            this.myImportTargetFromSource = this.mySourceFile != null && this.mySourceFile.equals(memberInfo.getSymbol().getContainingFile());
            return 1;
        }
        return 0;
    }

    public void memberInfoChanged(@NotNull MemberInfoChange<OCSymbolHolderVirtualPsiElement, OCMemberInfo> event) {
        this.myImportTargetFromSource = false;
        this.myImportSourceFromTarget = false;
        super.memberInfoChanged(event);
        this.myUsesModel.memberInfoChanged(event);
    }

    private static class MyModel
    extends AbstractUsesDependencyMemberInfoModel<OCSymbolHolderVirtualPsiElement, PsiElement, OCMemberInfo> {
        private MyModel(PsiElement source) {
            super(source, null, false);
        }

        protected int doCheck(@NotNull OCMemberInfo memberInfo, int problem) {
            return problem;
        }

        public Set<? extends OCSymbolHolderVirtualPsiElement> getDependenciesOf(OCSymbolHolderVirtualPsiElement element) {
            return this.myMemberDependencyGraph.getDependenciesOf((PsiElement)element);
        }
    }
}

