/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.introduce;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.introduce.OCBaseInplaceIntroducer;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTypedefInplaceIntroducer
extends OCBaseInplaceIntroducer<OCDeclarator, PsiElement> {
    public OCTypedefInplaceIntroducer(Project project2, Editor editor, PsiElement expression, List<PsiElement> occurrences, String refactoringName) {
        super(project2, editor, expression, occurrences, OCDeclarator.class, PsiElement.class, refactoringName);
    }

    @Override
    protected String checkExpression(PsiElement expression) {
        if (expression instanceof OCDeclaration) {
            String message = OCTypedefInplaceIntroducer.checkTypeElement(((OCDeclaration)expression).getTypeElement());
            if (message != null) {
                return message;
            }
            if (((OCDeclaration)expression).getDeclarators().size() != 1) {
                return "Declaration must have one declarator to introduce the type";
            }
        } else {
            if (expression instanceof OCTypeElement) {
                return OCTypedefInplaceIntroducer.checkTypeElement((OCTypeElement)expression);
            }
            if (expression instanceof OCCppNamespaceQualifier && OCTypedefInplaceIntroducer.getTypeFromNamespaceQualifier((OCCppNamespaceQualifier)expression) == null) {
                return "Namespace qualifier should be resolved to the class";
            }
        }
        return null;
    }

    @Nullable
    private static OCType getTypeFromNamespaceQualifier(OCCppNamespaceQualifier qualifier) {
        for (OCSymbol symbol : qualifier.resolveToSymbols()) {
            if (!(symbol instanceof OCStructSymbol)) continue;
            return symbol.getType();
        }
        return null;
    }

    private static String checkTypeElement(OCTypeElement typeElement) {
        if (typeElement == null || OCElementUtil.isElementEmpty(typeElement)) {
            return "The type is empty";
        }
        OCType type = typeElement.getType();
        if (type instanceof OCStructType && !((OCStructType)type).isPredeclaration()) {
            return "Can't extract type of " + ((OCStructType)type).getKind().getNameLowercase() + " definition";
        }
        return null;
    }

    @Override
    public PsiElement evaluateAnchor() {
        OCElement parent = (OCElement)PsiTreeUtil.getContextOfType((PsiElement)this.getCommonContext(), (boolean)false, (Class[])new Class[]{OCCppNamespace.class, OCFile.class});
        return parent != null ? this.findAnchor(parent) : null;
    }

    protected String[] suggestNames(boolean replaceAll, @Nullable OCDeclarator variable) {
        String[] stringArray;
        if (this.myUsageName != null) {
            return new String[]{this.myUsageName};
        }
        OCType type = this.myExpr instanceof OCDeclaration ? ((OCDeclaration)this.myExpr).getDeclarators().get(0).getType() : (this.myExpr instanceof OCTypeElement ? ((OCTypeElement)this.myExpr).getType() : OCTypedefInplaceIntroducer.getTypeFromNamespaceQualifier((OCCppNamespaceQualifier)this.myExpr));
        assert (type != null);
        OCResolveContext context2 = OCResolveContext.forPsi(this.myExpr);
        Collection<String> names = OCNameSuggester.suggestForType(type = type.resolve(context2), this.myExpr, Collections.emptyList(), context2);
        if (names.isEmpty()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "x";
        } else {
            stringArray = ArrayUtilRt.toStringArray(names);
        }
        return stringArray;
    }

    private OCDeclaration doIntroduce(String name, boolean isPreview) {
        OCDeclaration declarationInFile;
        OCType type;
        boolean modifyAnchor;
        Object mainExpression = this.getMainExpression();
        PsiElement anchor = this.getAnchor();
        boolean bl = modifyAnchor = anchor == mainExpression;
        if (mainExpression instanceof OCTypeElement) {
            type = ((OCTypeElement)mainExpression).getType();
        } else if (mainExpression instanceof OCCppNamespaceQualifier) {
            type = OCTypedefInplaceIntroducer.getTypeFromNamespaceQualifier((OCCppNamespaceQualifier)mainExpression);
        } else {
            OCDeclaration declaration = (OCDeclaration)mainExpression;
            OCDeclarator declarator = declaration.getDeclarators().get(0);
            String oldDeclaratorName = declarator.getName();
            type = declarator.getType();
            String oldDeclarationText = name + " " + oldDeclaratorName;
            if (declaration.isTypedef()) {
                oldDeclarationText = "typedef " + oldDeclarationText;
            }
            if (declarator.getInitializer() != null) {
                oldDeclarationText = oldDeclarationText + " = " + declarator.getInitializer().getTextWithMacros();
            }
            declaration = declaration instanceof OCParameterDeclaration ? OCElementFactory.paramDeclarationFromText(oldDeclarationText, anchor) : OCElementFactory.declarationFromText(oldDeclarationText, anchor);
            declaration = (OCDeclaration)OCChangeUtil.replaceHandlingMacros(mainExpression, declaration);
            if (modifyAnchor) {
                anchor = declaration;
            }
            this.myOccurrences[0] = declaration.getTypeElement();
        }
        if (type instanceof OCFunctionType) {
            type = OCPointerType.to(type);
        }
        Object context2 = mainExpression;
        if (anchor != null && anchor.getPrevSibling() != null) {
            context2 = anchor.getPrevSibling();
        }
        OCDeclaration declarationInFragment = OCElementFactory.declaration("typedef", name, type, context2);
        PsiElement parent = this.getAnchorParent(anchor, isPreview);
        if (mainExpression instanceof OCCppNamespaceQualifier) {
            anchor = PsiTreeUtil.isAncestor((PsiElement)parent, (PsiElement)anchor, (boolean)false) ? anchor : null;
            declarationInFile = (OCDeclaration)OCChangeUtil.addHandlingMacros(parent, declarationInFragment, anchor, OCChangeUtil.PostponedFormatAction.Format, true);
        } else {
            declarationInFile = OCChangeUtil.addBefore(parent, declarationInFragment, anchor);
        }
        OCChangeUtil.addNewLineIfNeed(declarationInFile, true);
        if (isPreview) {
            this.setVariable((PsiNameIdentifierOwner)declarationInFile.getDeclarators().get(0));
        }
        return declarationInFile;
    }

    @Override
    protected void introduceForPreview(String name) {
        this.doIntroduce(name, true);
    }

    @Override
    protected void introduceForReal(String name) {
        OCDeclaration declaration = this.doIntroduce(name, false);
        OCImportSymbolFix.fixAllSymbolsRecursively(declaration);
        for (PsiElement expression : this.myOccurrences) {
            if (expression instanceof OCTypeElement) {
                String typeText = name;
                if (expression.getParent() instanceof OCDeclaration && ((OCDeclaration)expression.getParent()).isTypedef()) {
                    typeText = "typedef " + typeText;
                }
                OCChangeUtil.replaceHandlingMacros(expression, OCElementFactory.typeElementFromText(typeText, expression));
                continue;
            }
            if (expression instanceof OCCppNamespaceQualifier) {
                OCCppNamespaceQualifier qualifier = OCElementFactory.declarationFromText("int " + name + "::x;", expression).getDeclarators().get(0).getNamespaceQualifier();
                OCChangeUtil.replaceHandlingMacros(expression, qualifier);
                continue;
            }
            String declaratorName = ((OCDeclaration)expression).getDeclarators().get(0).getName();
            OCChangeUtil.replaceHandlingMacros(expression, OCElementFactory.declarationFromText(name + " " + declaratorName, expression));
        }
    }

    @Override
    @NotNull
    protected String getFeatureID() {
        return "refactoring.introduceTypedef";
    }

    @Override
    public PsiElement getPreviewElement(OCDeclarator element) {
        return element.getParent();
    }
}

