/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.introduce;

import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCMacroCallArgument;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.introduce.OCBaseInplaceIntroducer;
import com.jetbrains.cidr.lang.refactoring.introduce.OCBaseLocalConvertibleHandler;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.resolve.OCExprValueCategory;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCBaseExpressionInplaceIntroducer<V extends PsiNameIdentifierOwner, E extends PsiElement>
extends OCBaseInplaceIntroducer<V, E> {
    protected boolean myIsUnresolvedReference;

    public OCBaseExpressionInplaceIntroducer(Project project2, Editor editor, E expression, List<E> occurrences, Class<V> variableClass, Class<E> expressionClass, String refactoringName) {
        super(project2, editor, expression, occurrences, variableClass, expressionClass, refactoringName);
        if (this.myExpr instanceof OCExpression) {
            OCType expectedType;
            OCResolveContext context2 = OCResolveContext.forPsi(this.myExpr);
            this.myExprType = ((OCExpression)this.myExpr).getResolvedType(context2).getGuessedType();
            if (this.myExpr instanceof OCLiteralExpression && ((OCLiteralExpression)this.myExpr).isStringLiteral() && this.myExprType instanceof OCArrayType) {
                this.myExprType = OCPointerType.to(((OCArrayType)this.myExprType).getRefType());
            }
            if ((this.myExprType.isPointerToID() || this.myExprType.isUnknown()) && (expectedType = OCExpectedTypeUtil.getExpectedType((OCExpression)this.myExpr, true, context2)) != OCUnknownType.INSTANCE) {
                this.myExprType = expectedType.resolve(context2);
            }
        } else if (OCBaseLocalConvertibleHandler.isDeclaratorIdentifier(this.myExpr)) {
            this.myExprType = ((OCDeclarator)this.myExpr.getParent()).getResolvedType();
        }
    }

    protected abstract OCSymbolKind getDeclaratorKind();

    @Nullable
    protected String checkType() {
        if (this.myExpr instanceof OCExpression) {
            this.myExprType = OCExpectedTypeUtil.getExpressionType((OCExpression)this.myExpr, this.myExprType, true);
        }
        if (this.myExprType instanceof OCStructType && ((OCStructType)this.myExprType).isUnnamed() && ((OCStructType)this.myExprType).getTypedefName() == null) {
            this.myExprType = OCIntType.INT;
        } else {
            if (this.myExprType == OCUnknownType.INSTANCE) {
                return "Cannot determine type of the selected expression";
            }
            if (this.myExprType != null && this.myExprType.isVoid()) {
                return "Cannot perform refactoring. Selected expression has void type.";
            }
        }
        return null;
    }

    @Override
    protected String checkExpression(E expression) {
        OCExpression initializer;
        if (this.myExpr instanceof OCReferenceExpression && ((OCReferenceExpression)this.myExpr).resolveToSymbol() == null) {
            this.myIsUnresolvedReference = true;
        }
        if (this.myParentSymbol == null && PsiTreeUtil.getContextOfType((PsiElement)this.myExpr, (boolean)false, (Class[])new Class[]{OCBlockStatement.class}) == null) {
            return "Selected expression should be inside a block statement";
        }
        if (expression instanceof OCCompoundInitializer && !OCCompilerFeaturesHelper.supportsInitializerLists(((OCCompoundInitializer)expression).getContainingOCFile())) {
            return "Can't refactor the compound initializer";
        }
        if (OCBaseLocalConvertibleHandler.isDeclaratorIdentifier(this.getMainExpression()) && (initializer = ((OCDeclarator)this.getMainExpression().getParent()).getInitializer()) instanceof OCCompoundInitializer && !OCCompilerFeaturesHelper.supportsInitializerLists(initializer.getContainingOCFile())) {
            return "Can't refactor the compound initializer";
        }
        return this.checkType();
    }

    @Override
    protected boolean isCreateFromUsageMode() {
        return super.isCreateFromUsageMode() || this.myIsUnresolvedReference;
    }

    @Override
    public PsiElement evaluateAnchor() {
        PsiElement statement2 = PsiTreeUtil.getContextOfType((PsiElement)this.getCommonContext(), (boolean)false, (Class[])new Class[]{OCStatement.class});
        if (!OCChangeUtil.canBeReplacedToBlockStatement(statement2)) {
            statement2 = PsiTreeUtil.getContextOfType((PsiElement)statement2.getParent(), (boolean)false, (Class[])new Class[]{OCStatement.class});
        }
        if (!(statement2 instanceof OCBlockStatement)) {
            statement2 = statement2.getParent();
        }
        return statement2 != null ? this.findAnchor(statement2) : null;
    }

    protected PsiElement ensureParentIsBlockStatement(PsiElement anchor) {
        if (!(anchor instanceof OCStatement) || anchor.getParent() instanceof OCMacroCallArgument) {
            return anchor;
        }
        TextRange oldRange = anchor.getTextRange();
        ArrayList<OCBaseInplaceIntroducer.MyPsiPointer> occurPtrs = new ArrayList<OCBaseInplaceIntroducer.MyPsiPointer>();
        OCBaseInplaceIntroducer.MyPsiPointer exprPtr = new OCBaseInplaceIntroducer.MyPsiPointer(this.myExpr);
        for (PsiElement occurrence : this.myOccurrences) {
            occurPtrs.add(new OCBaseInplaceIntroducer.MyPsiPointer(occurrence));
        }
        TextRange newRange = (anchor = OCChangeUtil.ensureParentIsBlockStatement((OCStatement)anchor)).getTextRange();
        if (!oldRange.equals((Object)newRange)) {
            for (int i2 = 0; i2 < this.myOccurrences.length; ++i2) {
                this.myOccurrences[i2] = this.shiftElement(this.myOccurrences[i2], (OCBaseInplaceIntroducer.MyPsiPointer)occurPtrs.get(i2), oldRange, newRange);
            }
            this.myOccurrenceMarkers = null;
            this.initOccurrencesMarkers();
            this.myExpr = this.shiftElement(this.myExpr, exprPtr, oldRange, newRange);
            this.myExprMarker = this.createMarker(this.myExpr);
        }
        return anchor;
    }

    private E shiftElement(E element, OCBaseInplaceIntroducer.MyPsiPointer elementPtr, TextRange oldRange, TextRange newRange) {
        if (oldRange.contains(elementPtr.range)) {
            int shift = newRange.getStartOffset() - oldRange.getStartOffset();
            elementPtr.range = new TextRange(elementPtr.range.getStartOffset() + shift, elementPtr.range.getEndOffset() + shift);
            PsiElement newElement = elementPtr.getElement();
            assert (newElement != null);
            return (E)newElement;
        }
        return element;
    }

    protected String[] suggestNames(boolean replaceAll, @Nullable V variable) {
        if (this.myUsageName != null) {
            return new String[]{this.myUsageName};
        }
        if (this.myExpr instanceof OCExpression) {
            String[] stringArray;
            Collection<String> names = OCNameSuggester.suggestForExpression(this.getDeclaratorKind(), (OCExpression)this.myExpr);
            if (names.isEmpty()) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "x";
            } else {
                stringArray = ArrayUtilRt.toStringArray(names);
            }
            return stringArray;
        }
        if (this.myExpr instanceof OCReferenceElement) {
            return new String[]{((OCReferenceElement)this.myExpr).getName()};
        }
        if (OCBaseLocalConvertibleHandler.isDeclaratorIdentifier(this.myExpr)) {
            return new String[]{((OCDeclarator)this.myExpr.getParent()).getName()};
        }
        assert (false) : this.myExpr.getClass();
        return null;
    }

    protected boolean isAutoAvailable() {
        return OCCompilerFeaturesHelper.supportsCxxAutoType(this.myExpr.getContainingFile());
    }

    protected boolean isConstAvailable() {
        if (this.isCreateFromUsageMode() && this.myExpr.getParent() instanceof OCUnaryExpression) {
            OCUnaryExpression expr = (OCUnaryExpression)this.myExpr.getParent();
            OCType type = OCExpectedTypeUtil.getExpectedType((OCExpression)expr, OCResolveContext.forPsi(expr));
            if (expr.isGetAddress() && type instanceof OCPointerType && !((OCPointerType)type).isPointerToConst()) {
                return false;
            }
        }
        if (!OCCodeInsightUtil.isInPlainOldC(this.myExpr) && this.myExprType instanceof OCStructType && this.myExpr instanceof OCExpression && !OCExprValueCategory.classify((OCExpression)this.myExpr).isLValue()) {
            return false;
        }
        return !this.hasNonConstUsages();
    }

    protected OCDeclarator rebuildDeclarator(OCDeclarator declarator, Rebuilder rebuilder) {
        TemplateState templateState = TemplateManagerImpl.getTemplateState((Editor)this.myEditor);
        this.myCaretRangeMarker.setGreedyToLeft(false);
        this.myCaretRangeMarker.setGreedyToRight(false);
        if (templateState != null) {
            templateState.setSegmentsGreedy(false);
            templateState.setTabStopHighlightersGreedy(false);
        }
        declarator = rebuilder.rebuild(declarator);
        if (templateState != null) {
            templateState.setSegmentsGreedy(true);
            templateState.setTabStopHighlightersGreedy(true);
        }
        this.myCaretRangeMarker.setGreedyToLeft(true);
        this.myCaretRangeMarker.setGreedyToRight(true);
        return declarator;
    }

    @NotNull
    protected OCType getType(PsiElement initializer, boolean isAuto, boolean isConst) {
        if (isAuto) {
            return OCReferenceType.fromText("auto").cloneWithCVQualifiers(CVQualifiers.get(isConst, false), this.myProject);
        }
        OCType type = this.myExprType;
        if (initializer != null) {
            type = OCTypeUtils.getExtractExpressionType(type, initializer, false);
        }
        if (type instanceof OCCppReferenceType) {
            OCType refType = ((OCCppReferenceType)type).getRefType();
            return OCCppReferenceType.to(refType.cloneWithCVQualifiers(CVQualifiers.get(isConst |= initializer instanceof OCExpression && !OCExprValueCategory.classify((OCExpression)initializer).isLValue(), refType.isVolatile()), this.myProject));
        }
        return this.myExprType.cloneWithCVQualifiers(CVQualifiers.get(isConst, this.myExprType.isVolatile()), this.myProject);
    }

    protected static interface Rebuilder {
        public OCDeclarator rebuild(OCDeclarator var1);
    }
}

