/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.changeSignature;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.changeSignature.ParameterInfo;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCParameterInfo
implements ParameterInfo,
Cloneable {
    private final int myOldIndex;
    private String mySelector = "";
    private String myName = "";
    private OCType myType;
    private String myTypeText;
    private boolean myEllipsisType;
    private boolean mySelfParameter;
    private Collection<PsiReference> myUsages;
    private boolean myReferenceMode;
    @NotNull
    private final PsiElement myTypeContext;
    @Nullable
    private OCExpression myInitializer;
    @Nullable
    private String myDefaultValue;

    public OCParameterInfo(String selector, String name, OCType type, int oldIndex, @NotNull PsiElement context2) {
        this(selector, name, type, OCParameterInfo.getTextFromType(type, context2), oldIndex, context2);
    }

    public OCParameterInfo(String selector, String name, OCType type, String typeText, int oldIndex, @NotNull PsiElement context2) {
        this.myTypeContext = context2;
        this.mySelector = selector.endsWith(":") ? selector.substring(0, selector.length() - 1) : selector;
        this.myName = name != null ? name : "";
        this.myType = type;
        this.myTypeText = typeText;
        this.myOldIndex = oldIndex;
    }

    @NotNull
    private static String getTextFromType(OCType type, @NotNull PsiElement typeContext) {
        OCPointerType pointerType;
        if (type == null) {
            return "";
        }
        if (type.getClass().equals(OCPointerType.class) && (pointerType = (OCPointerType)type).isArrayLikeParameter()) {
            type = OCArrayType.to(pointerType.getRefType(), pointerType.getLengthInBrackets(), pointerType.getARCAttribute());
        }
        return type.getName(typeContext);
    }

    public void setSelfParameter(boolean selfParameter) {
        this.mySelfParameter = selfParameter;
    }

    public void setEllipsisType(boolean ellipsisType) {
        this.myEllipsisType = ellipsisType;
    }

    public void setReferenceMode(boolean referenceMode) {
        this.myReferenceMode = referenceMode;
    }

    public String getSelector() {
        return this.mySelector;
    }

    public String getName() {
        return this.myName;
    }

    public int getOldIndex() {
        return this.myOldIndex;
    }

    @Nullable
    public String getDefaultValue() {
        return this.myDefaultValue;
    }

    public void setDefaultValue(@Nullable String defaultValue) {
        this.myDefaultValue = defaultValue;
    }

    public void setName(String name) {
        this.myName = name != null ? name : "";
    }

    public void setSelector(String selector) {
        this.mySelector = selector;
    }

    @Nullable
    public OCType getType() {
        return this.myType != null ? (this.myReferenceMode ? OCPointerType.to(this.myType) : this.myType) : null;
    }

    public String getTypeText() {
        if (this.myReferenceMode) {
            return this.myTypeText + "*";
        }
        return this.myTypeText;
    }

    public void setType(OCType type) {
        this.myType = type;
        this.myTypeText = OCParameterInfo.getTextFromType(this.myType, this.myTypeContext);
    }

    public void setTypeText(String typeText) {
        this.myTypeText = typeText;
    }

    public void setInitializer(@Nullable OCExpression initializer) {
        this.myInitializer = initializer;
    }

    @Nullable
    public OCExpression getInitializer() {
        return this.myInitializer;
    }

    public boolean isEllipsisType() {
        return this.myEllipsisType;
    }

    public boolean isSelfParameter() {
        return this.mySelfParameter;
    }

    public String getParameterStubText(boolean appendSelectors, boolean isSelfSuperCall, @Nullable PsiElement usageContext) {
        StringBuilder result2 = new StringBuilder();
        if (appendSelectors) {
            result2.append(this.mySelector);
            if (this.myName.isEmpty()) {
                return result2.toString();
            }
            result2.append(':');
        }
        if (isSelfSuperCall) {
            result2.append(this.myName);
        } else if (this.isSelfParameter()) {
            result2.append("self");
        } else if (StringUtil.isNotEmpty((String)this.myDefaultValue)) {
            result2.append(this.myDefaultValue);
        } else if (this.myType instanceof OCStructType) {
            result2.append(this.myType.getDefaultValue(OCResolveContext.forPsi(usageContext != null ? usageContext : this.myTypeContext)));
        } else if (this.myType != null) {
            result2.append(this.myType.getDefaultValue(OCResolveContext.forPsi(this.myTypeContext)));
        }
        if (result2.length() == 0) {
            result2.append("0");
        }
        return result2.toString();
    }

    public boolean isTypeChanged(String oldTypeText) {
        return !oldTypeText.replaceAll(" ", "").equals(this.myTypeText.replaceAll(" ", ""));
    }

    public boolean isUseAnySingleVariable() {
        return false;
    }

    public void setUseAnySingleVariable(boolean b) {
        throw new UnsupportedOperationException();
    }

    public void setUsages(Collection<PsiReference> usages) {
        this.myUsages = usages;
    }

    public Collection<PsiReference> getUsages() {
        return this.myUsages;
    }

    public boolean isReferenceMode() {
        return this.myReferenceMode;
    }

    public OCParameterInfo clone() {
        try {
            return (OCParameterInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

