/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.changeSignature;

import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;

public final class OCCallableKind
extends Enum<OCCallableKind> {
    public static final /* enum */ OCCallableKind METHOD = new OCCallableKind();
    public static final /* enum */ OCCallableKind FUNCTION = new OCCallableKind();
    public static final /* enum */ OCCallableKind BLOCK = new OCCallableKind();
    public static final /* enum */ OCCallableKind LAMBDA = new OCCallableKind();
    private static final /* synthetic */ OCCallableKind[] $VALUES;

    public static OCCallableKind[] values() {
        return (OCCallableKind[])$VALUES.clone();
    }

    public static OCCallableKind valueOf(String name) {
        return Enum.valueOf(OCCallableKind.class, name);
    }

    public String toString() {
        switch (this) {
            case METHOD: {
                return "Method";
            }
            case FUNCTION: {
                return "Function";
            }
            case BLOCK: {
                return "Block";
            }
            case LAMBDA: {
                return "Lambda";
            }
        }
        return null;
    }

    public String toStringLowercase() {
        return StringUtil.decapitalize((String)this.toString());
    }

    public OCSymbolKind getSymbolKind() {
        switch (this) {
            case METHOD: {
                return OCSymbolKind.METHOD;
            }
            case FUNCTION: {
                return OCSymbolKind.FUNCTION_DECLARATION;
            }
            case BLOCK: {
                return OCSymbolKind.BLOCK;
            }
            case LAMBDA: {
                return OCSymbolKind.LAMBDA;
            }
        }
        return null;
    }

    public static OCCallableKind parse(String value) {
        for (OCCallableKind kind : OCCallableKind.values()) {
            if (!kind.toString().equals(value)) continue;
            return kind;
        }
        assert (false) : "Unknown callable kind: " + value;
        return null;
    }

    static {
        $VALUES = new OCCallableKind[]{METHOD, FUNCTION, BLOCK, LAMBDA};
    }
}

