/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.settings.NamingConventionRule;
import com.jetbrains.cidr.lang.settings.NamingConventionStyle;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import java.util.Collection;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNamingConventionUtil {
    private static final NamingConventionRule EMPTY_RULE = new NamingConventionRule(EnumSet.of(NamingConventionRule.EntityKind.ANY), EnumSet.of(NamingConventionRule.Visibility.ANY), EnumSet.of(NamingConventionRule.Specifier.ANY), "", NamingConventionStyle.NONE, "");

    public static boolean shouldIgnoreNamingConventionForSymbol(@Nullable OCSymbol symbol) {
        if (symbol instanceof OCFunctionSymbol) {
            OCFunctionSymbol functionSymbol = (OCFunctionSymbol)symbol;
            return functionSymbol.isUDL() || functionSymbol.isCppOperator() || functionSymbol.isMainFunction();
        }
        return false;
    }

    public static String applyNamingConvention(@NotNull String name, @Nullable OCSymbolKind symbolKind, @NotNull Project project2) {
        return OCNamingConventionUtil.applyNamingConvention(name, symbolKind, null, null, project2);
    }

    public static String applyNamingConvention(@NotNull String name, @Nullable OCSymbolKind symbolKind, @Nullable OCSymbol symbol, @Nullable OCResolveContext context2, @NotNull Project project2) {
        return OCNamingConventionUtil.getNamingConventionRuleForSymbol(symbolKind, symbol, context2, project2).apply(name);
    }

    public static Collection<String> applyNamingConvention(@NotNull Collection<String> names, @Nullable OCSymbolKind symbolKind, @NotNull Project project2) {
        return OCNamingConventionUtil.applyNamingConvention(names, symbolKind, null, null, project2);
    }

    public static Collection<String> applyNamingConvention(@NotNull Collection<String> names, @Nullable OCSymbolKind symbolKind, @Nullable OCSymbol symbol, @Nullable OCResolveContext context2, @NotNull Project project2) {
        NamingConventionRule rule2 = OCNamingConventionUtil.getNamingConventionRuleForSymbol(symbolKind, symbol, context2, project2);
        return ContainerUtil.map(names, name -> rule2.apply((String)name));
    }

    public static boolean matchesToNamingConvention(@NotNull String name, @NotNull OCSymbolKind symbolKind, @NotNull Project project2) {
        return OCNamingConventionUtil.matchesToNamingConvention(name, symbolKind, null, null, project2);
    }

    public static boolean matchesToNamingConvention(@NotNull String name, @NotNull OCSymbolKind symbolKind, @Nullable OCSymbol symbol, @Nullable OCResolveContext context2, @NotNull Project project2) {
        return OCNamingConventionUtil.getNamingConventionRuleForSymbol(symbolKind, symbol, context2, project2).match(name);
    }

    static NamingConventionRule getNamingConventionRuleForSymbol(@Nullable OCSymbolKind symbolKind, @Nullable OCSymbol symbol, @Nullable OCResolveContext context2, @NotNull Project project2) {
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getSettings((Project)project2).getCustomSettings(OCCodeStyleSettings.class);
        for (int i2 = settings.NAMING_CONVENTION_RULES.size() - 1; i2 >= 0; --i2) {
            NamingConventionRule rule2 = settings.NAMING_CONVENTION_RULES.get(i2);
            if (!rule2.canApply(symbolKind, symbol, context2, project2)) continue;
            return rule2;
        }
        return EMPTY_RULE;
    }
}

