/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.OCGetSymbolVisitor;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.psi.OCInstanceVariablesList;
import com.jetbrains.cidr.lang.psi.OCMessageArgument;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.refactoring.OCNamingConventionUtil;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.settings.NamingConventionRule;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCNamesValidator;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNameSuggester {
    private static final Logger LOG = Logger.getInstance(OCNameSuggester.class);
    public static final String BOOLEAN_SHORT_NAME = "b";
    public static final String INT_SHORT_NAME = "i";
    public static final String DOUBLE_SHORT_NAME = "d";
    public static final String STRING_SHORT_NAME = "string";
    public static final String AUTO_SHORT_NAME = "item";
    public static final String POINTER_SHORT_NAME = "ptr";
    public static final String OBJECT_SHORT_NAME = "o";
    public static final String UDL_SHORT_NAME = "_op";
    public static final String VOID_SHORT_NAME = "v";
    public static final String BOOLEAN_LONG_NAME = "boolean";
    public static final String INT_LONG_NAME = "int";
    public static final String DOUBLE_LONG_NAME = "double";
    public static final String OBJECT_LONG_NAME = "object";
    public static final String FUNCTION_LONG_NAME = "function";
    public static final String VOID_LONG_NAME = "void";
    private static final String[] GARBAGE_SUFFIXES = new String[]{"Impl", "IMPL", "Ref", "REF", "_t"};
    private static final String[] SHORT_NAMES = new String[]{"b", "i", "d", "string", "ptr", "o", "_op", "v", "item"};
    private static final String EMPTY_PREFIX = "";

    private OCNameSuggester() {
    }

    public static Collection<String> suggestForDeclaration(OCDeclarator declarator, boolean unique, @NotNull Collection<String> predefinedNames) {
        HashSet<String> whiteList = new HashSet<String>(predefinedNames);
        HashSet<String> blackList = new HashSet<String>();
        Ref symbolKindRef = new Ref();
        Collection<String> candidates = OCNameSuggester.doSuggestForDeclaration(declarator, (Ref<OCSymbolKind>)symbolKindRef, whiteList, blackList);
        OCSymbol symbol = declarator.getSymbol();
        if (symbolKindRef.isNull()) {
            symbolKindRef.set((Object)(symbol != null ? symbol.getKind() : null));
        }
        Project project2 = declarator.getProject();
        if (!OCNamingConventionUtil.shouldIgnoreNamingConventionForSymbol(symbol)) {
            candidates = OCNamingConventionUtil.applyNamingConvention(candidates, (OCSymbolKind)((Object)symbolKindRef.get()), symbol, OCResolveContext.forPsi(declarator), project2);
        }
        HashSet<String> result2 = new HashSet<String>(candidates);
        if (unique) {
            blackList.removeAll(whiteList);
            result2.retainAll(whiteList);
            HashSet<String> toProcess = new HashSet<String>(candidates);
            toProcess.removeAll(whiteList);
            result2.addAll(OCNameSuggester.convertToUniqueNames((OCSymbolKind)((Object)symbolKindRef.get()), toProcess, declarator, blackList));
        }
        return result2;
    }

    private static Collection<String> doSuggestForDeclaration(@NotNull OCDeclarator subj, Ref<OCSymbolKind> symbolKindRef, Collection<String> whiteList, Collection<String> blackList) {
        OCSymbol subjSymbol;
        Object classSymbol;
        PsiElement ifs;
        if (subj.getParent() instanceof OCDeclaration && ((OCDeclaration)subj.getParent()).isTypedef()) {
            return Collections.emptyList();
        }
        OCResolveContext context2 = OCResolveContext.forPsi(subj);
        OCExpression initializer = subj.getInitializer();
        if (initializer != null) {
            ArrayList<String> names = new ArrayList<String>(OCNameSuggester.doSuggestForDeclarationName(subj, context2));
            names.addAll(OCNameSuggester.doSuggestForExpression(initializer, context2));
            return names;
        }
        PsiElement declContext = subj.getContext();
        if (declContext != null && (declContext = declContext.getContext()) instanceof OCDeclarationStatement) {
            declContext = declContext.getContext();
        }
        if (declContext instanceof OCForeachStatement) {
            OCExpression collectionExpression = ((OCForeachStatement)declContext).getCollectionExpression();
            LinkedHashSet<String> candidates = new LinkedHashSet<String>();
            for (String collectionSuggestion : OCNameSuggester.doSuggestionForContext(collectionExpression)) {
                String unplured = StringUtil.unpluralize((String)collectionSuggestion);
                candidates.add(unplured != null ? unplured : collectionSuggestion);
            }
            candidates.addAll(OCNameSuggester.doSuggestForType(subj.getType(), EMPTY_PREFIX, context2));
            ArrayList<String> names = new ArrayList<String>(OCNameSuggester.doSuggestForDeclarationName(subj, context2));
            names.addAll(candidates);
            return names;
        }
        if (declContext instanceof OCProperty) {
            ifs = declContext.getParent();
            if (ifs instanceof OCSymbolDeclarator && (classSymbol = ((OCSymbolDeclarator)ifs).getSymbol()) instanceof OCClassSymbol) {
                symbolKindRef.set((Object)OCSymbolKind.PROPERTY);
                return OCNameSuggester.suggestForProperty(subj, (OCClassSymbol)classSymbol, whiteList, blackList, context2);
            }
        } else if (declContext instanceof OCInstanceVariablesList && (ifs = declContext.getParent()) instanceof OCSymbolDeclarator && (classSymbol = ((OCSymbolDeclarator)ifs).getSymbol()) instanceof OCClassSymbol) {
            symbolKindRef.set((Object)OCSymbolKind.INSTANCE_VARIABLE);
            return OCNameSuggester.suggestForIvar(subj, (OCClassSymbol)classSymbol, blackList, context2);
        }
        if ((subjSymbol = subj.getSymbol()) instanceof OCFunctionSymbol && ((OCFunctionSymbol)subjSymbol).isUDL()) {
            return OCNameSuggester.doSuggestForSimpleType(UDL_SHORT_NAME, UDL_SHORT_NAME, EMPTY_PREFIX);
        }
        ArrayList<String> names = new ArrayList<String>(OCNameSuggester.doSuggestForDeclarationName(subj, context2));
        names.addAll(OCNameSuggester.doSuggestForType(subj.getType(), EMPTY_PREFIX, context2));
        return names;
    }

    @NotNull
    private static List<String> doSuggestForDeclarationName(@NotNull OCDeclarator declarator, @NotNull OCResolveContext context2) {
        String declaratorName = declarator.getName();
        OCSymbol symbol = declarator.getSymbol();
        if (symbol == null) {
            return ContainerUtil.emptyList();
        }
        if (!OCNamesValidator.isIdentifier(declaratorName) || declaratorName.contains("CIDR_RULE_ZZZ")) {
            return ContainerUtil.emptyList();
        }
        OCSymbolKind symbolKind = symbol.getKind();
        String suggestedName = OCNamingConventionUtil.applyNamingConvention(declaratorName, symbolKind, symbol, context2, declarator.getProject());
        return suggestedName.equals(declaratorName) ? ContainerUtil.emptyList() : ContainerUtil.newArrayList((Object[])new String[]{suggestedName});
    }

    private static Collection<String> suggestForIvar(OCDeclarator declarator, OCClassSymbol classSymbol, Collection<String> forbiddenNames, @NotNull OCResolveContext context2) {
        THashSet names = new THashSet();
        Project project2 = context2.getProject();
        OCInterfaceSymbol mi = classSymbol.getMainInterface(project2);
        String auxCategoryName = classSymbol instanceof OCInterfaceSymbol ? classSymbol.getCategoryName() : EMPTY_PREFIX;
        OCClassSymbol mainInterface = mi == null ? classSymbol : mi;
        Processor propertyProcessor = arg_0 -> OCNameSuggester.lambda$suggestForIvar$0(project2, declarator, context2, (Set)names, arg_0);
        Processor<OCSymbol> iVarProcessor = OCNameSuggester.namesCollectProcessor(forbiddenNames, declarator);
        mainInterface.processCategories((Processor<? super OCClassSymbol>)((Processor)ifs -> {
            if (StringUtil.compare((String)ifs.getCategoryName(), (String)auxCategoryName, (boolean)false) == 0 || ifs == mainInterface) {
                ifs.processMembers(OCPropertySymbol.class, propertyProcessor);
                ifs.processMembers(OCInstanceVariableSymbol.class, iVarProcessor);
            }
            return true;
        }), true, null, project2);
        for (String name : OCNameSuggester.doSuggestForType(declarator.getType(), EMPTY_PREFIX, context2)) {
            names.add(OCNameSuggester.getNonCollidingName(name, OCSymbolKind.PROPERTY, true, declarator.getProject()));
        }
        return names;
    }

    private static Collection<String> suggestForProperty(@NotNull OCDeclarator declarator, @NotNull OCClassSymbol interfaceSymbol, Collection<String> whiteList, Collection<String> forbiddenNames, @NotNull OCResolveContext context2) {
        OCImplementationSymbol implementation;
        THashSet names = new THashSet();
        Processor ivarProcessor = arg_0 -> OCNameSuggester.lambda$suggestForProperty$2(declarator, context2, (Set)names, whiteList, arg_0);
        Processor<OCSymbol> propertyProcessor = OCNameSuggester.namesCollectProcessor(forbiddenNames, declarator);
        interfaceSymbol.processCategories((Processor<? super OCClassSymbol>)((Processor)interfaceSymbol1 -> {
            String category = interfaceSymbol1.getCategoryName();
            if (category == null || category.isEmpty()) {
                interfaceSymbol1.processMembers(OCInstanceVariableSymbol.class, ivarProcessor);
                interfaceSymbol1.processMembers(OCPropertySymbol.class, propertyProcessor);
            }
            return true;
        }), true, null, context2.getProject());
        String categoryName = interfaceSymbol.getCategoryName();
        if ((categoryName == null || categoryName.isEmpty()) && (implementation = interfaceSymbol.getMainImplementation(declarator.getProject())) != null) {
            implementation.processMembers(OCInstanceVariableSymbol.class, ivarProcessor);
        }
        names.addAll(OCNameSuggester.doSuggestForType(declarator.getType(), EMPTY_PREFIX, context2));
        return names;
    }

    private static Processor<OCSymbol> namesCollectProcessor(Collection<String> names, @NotNull OCElement excludedElement) {
        return symbol -> {
            PsiElement ivarDecl = symbol.locateDefinition(excludedElement.getProject());
            if (ivarDecl != null && ivarDecl.getTextOffset() != excludedElement.getTextOffset()) {
                names.add(symbol.getName());
            }
            return true;
        };
    }

    public static Collection<String> suggestForExpression(@Nullable OCSymbolKind symbolKind, @NotNull OCExpression expr) {
        return OCNameSuggester.suggestForExpression(symbolKind, expr, true);
    }

    public static Collection<String> suggestForExpression(@Nullable OCSymbolKind symbolKind, @NotNull OCExpression expr, boolean convertToUniqueNames) {
        Project project2 = expr.getProject();
        Collection<String> names = OCNamingConventionUtil.applyNamingConvention(OCNameSuggester.doSuggestForExpression(expr, OCResolveContext.forPsi(expr)), symbolKind, project2);
        if (!convertToUniqueNames) {
            return names;
        }
        final ArrayList<String> forbiddenNames = new ArrayList<String>();
        expr.accept(new OCRecursiveVisitor(){

            @Override
            public void visitReferenceElement(OCReferenceElement referenceElement) {
                if (referenceElement.resolveToSymbol() != null) {
                    forbiddenNames.add(referenceElement.getName());
                }
            }
        });
        return OCNameSuggester.convertToUniqueNames(symbolKind, names, expr, forbiddenNames);
    }

    private static Collection<String> doSuggestForExpression(OCExpression expr, @NotNull OCResolveContext context2) {
        LinkedHashSet<String> answer = new LinkedHashSet<String>();
        OCExpression topmost = OCParenthesesUtils.topmostParenthesized(expr);
        answer.addAll(OCNameSuggester.doSuggestForExpressionContext(topmost, topmost.getParent()));
        answer.addAll(OCNameSuggester.doSuggestForType(expr.getResolvedType().getGuessedType(), EMPTY_PREFIX, context2));
        answer.addAll(OCNameSuggester.doSuggestionForContext(OCParenthesesUtils.diveIntoParentheses(expr)));
        return answer;
    }

    private static List<String> doSuggestForExpressionContext(OCExpression expr, PsiElement context2) {
        List<OCDeclaratorSymbol> symbols;
        OCSymbol fun;
        int index;
        PsiElement arglistParent;
        if (context2 instanceof OCMessageArgument) {
            OCMethodSymbol.SelectorPartSymbol selector;
            OCDeclaratorSymbol parameter;
            List<OCMethodSymbol.SelectorPartSymbol> selectors;
            OCMethodSymbol responder;
            OCSendMessageExpression call = (OCSendMessageExpression)context2.getParent();
            int index2 = call.getArguments().indexOf(context2);
            if (index2 >= 0 && (responder = call.getProbableResponders().getKnownResponder()) != null && index2 < (selectors = responder.getSelectors()).size() && (parameter = (selector = selectors.get(index2)).getParameter()) != null) {
                return OCNameSuggester.doGetSuggestionsByName(parameter.getName(), EMPTY_PREFIX);
            }
        } else if (context2 instanceof OCArgumentList && (arglistParent = context2.getParent()) instanceof OCCallExpression && (index = ((OCCallExpression)arglistParent).getArguments().indexOf(expr)) >= 0 && (fun = OCGetSymbolVisitor.getSymbol(((OCCallExpression)arglistParent).getFunctionReferenceExpression())) instanceof OCFunctionSymbol && index < (symbols = ((OCFunctionSymbol)fun).getParameterSymbols()).size()) {
            return OCNameSuggester.doGetSuggestionsByName(symbols.get(index).getName(), EMPTY_PREFIX);
        }
        return Collections.emptyList();
    }

    private static List<String> doSuggestionForContext(@Nullable OCExpression expr) {
        if (expr instanceof OCReferenceExpression && ((OCReferenceExpression)expr).getSelfSuperToken() == null) {
            return OCNameSuggester.doGetSuggestionsByName(expr.getTextWithMacros(), EMPTY_PREFIX);
        }
        if (expr instanceof OCQualifiedExpression) {
            return OCNameSuggester.doGetSuggestionsByName(((OCQualifiedExpression)expr).getName(), EMPTY_PREFIX);
        }
        if (expr instanceof OCSendMessageExpression) {
            return OCNameSuggester.doGetSuggestionsByName(((OCSendMessageExpression)expr).getMessageSelector(), EMPTY_PREFIX);
        }
        if (expr instanceof OCCallExpression) {
            return OCNameSuggester.doGetSuggestionsByName(((OCCallExpression)expr).getFunctionReferenceExpression().getTextWithMacros(), EMPTY_PREFIX);
        }
        return Collections.emptyList();
    }

    public static Collection<String> suggestForType(OCType type, @Nullable PsiElement scope, Collection<String> forbiddenNames, @NotNull OCResolveContext context2) {
        Collection<String> names = OCNameSuggester.doSuggestForType(type, EMPTY_PREFIX, context2);
        return OCNameSuggester.convertToUniqueNames(null, names, scope, forbiddenNames);
    }

    public static Collection<String> suggestForType(OCType type, @Nullable PsiElement scope, String prefix, @NotNull OCResolveContext context2) {
        Collection<String> names = OCNameSuggester.doSuggestForType(type, prefix, context2);
        return OCNameSuggester.convertToUniqueNames(null, names, scope, Collections.emptyList());
    }

    public static Collection<String> suggestForType(OCSymbolKind symbolKind, OCType type, @Nullable PsiElement scope, String prefix, @NotNull Collection<String> forbiddenNames, @NotNull OCResolveContext context2) {
        Collection<String> names = OCNamingConventionUtil.applyNamingConvention(OCNameSuggester.doSuggestForType(type, prefix, context2), symbolKind, context2.getProject());
        return OCNameSuggester.convertToUniqueNames(symbolKind, names, scope, forbiddenNames);
    }

    private static Collection<String> doSuggestForType(OCType type, String prefix, @NotNull OCResolveContext context2) {
        if (type == null) {
            return Collections.emptyList();
        }
        if (OCIntType.isBool(type, context2)) {
            return OCNameSuggester.doSuggestForSimpleType(BOOLEAN_SHORT_NAME, BOOLEAN_LONG_NAME, prefix);
        }
        if (type instanceof OCIntType) {
            return OCNameSuggester.doSuggestForSimpleType(INT_SHORT_NAME, INT_LONG_NAME, prefix);
        }
        if (type instanceof OCRealType) {
            return OCNameSuggester.doSuggestForSimpleType(DOUBLE_SHORT_NAME, DOUBLE_LONG_NAME, prefix);
        }
        if (type.isCString()) {
            return OCNameSuggester.doGetSuggestionsByName(STRING_SHORT_NAME, prefix);
        }
        if (type instanceof OCPointerType) {
            OCType ref = ((OCPointerType)type).getRefType();
            Collection<String> raw = OCNameSuggester.doSuggestForType(ref, !prefix.isEmpty() || ref instanceof OCObjectType || ref instanceof OCReferenceType ? prefix : "p", context2);
            return raw.isEmpty() ? Collections.singleton(POINTER_SHORT_NAME) : raw;
        }
        if (type instanceof OCObjectType) {
            OCClassSymbol smb = ((OCObjectType)type).getClassSymbol();
            if (smb == null) {
                return OCNameSuggester.doSuggestForSimpleType(OBJECT_SHORT_NAME, OBJECT_LONG_NAME, prefix);
            }
            return OCNameSuggester.doSuggestionsByTypeName(smb.getName(), prefix);
        }
        if (type instanceof OCFunctionType) {
            if (StringUtil.isNotEmpty((String)prefix)) {
                return Collections.singleton(prefix + StringUtil.capitalize((String)FUNCTION_LONG_NAME));
            }
        } else {
            if (type instanceof OCVoidType) {
                return OCNameSuggester.doSuggestForSimpleType(VOID_SHORT_NAME, VOID_LONG_NAME, prefix);
            }
            if (type instanceof OCAutoType) {
                return OCNameSuggester.doSuggestForSimpleType(AUTO_SHORT_NAME, AUTO_SHORT_NAME, prefix);
            }
            if (type instanceof OCReferenceType) {
                return OCNameSuggester.doSuggestionsByTypeName(type.getName(), prefix);
            }
            if (type instanceof OCStructType) {
                return OCNameSuggester.doSuggestionsByTypeName(((OCStructType)type).getSymbol().getName(), prefix);
            }
            if (type instanceof OCCppReferenceType) {
                return OCNameSuggester.doSuggestForType(((OCCppReferenceType)type).getRefType(), prefix, context2);
            }
            if (type instanceof OCVariadicType) {
                return OCNameSuggester.doSuggestForType(((OCVariadicType)type).getUnderlyingType(), prefix, context2);
            }
            if (type instanceof OCMagicType) {
                return OCNameSuggester.doSuggestionsByTypeName(type.getName(), prefix);
            }
        }
        return Collections.emptyList();
    }

    private static Collection<String> doSuggestionsByTypeName(String typeName, String prefix) {
        int pos = typeName.indexOf(60);
        if (pos != -1) {
            typeName = typeName.substring(0, pos);
        }
        if (typeName.equals("id")) {
            return OCNameSuggester.doSuggestForSimpleType(OBJECT_SHORT_NAME, OBJECT_LONG_NAME, prefix);
        }
        if (typeName.equals("BOOL")) {
            return OCNameSuggester.doSuggestForSimpleType(BOOLEAN_SHORT_NAME, BOOLEAN_LONG_NAME, prefix);
        }
        typeName = StringUtil.trimStart((String)typeName, (String)"NS");
        return OCNameSuggester.doGetSuggestionsByName(StringUtil.trimStart((String)OCNameSuggester.stripSuffixes(typeName), (String)"const"), prefix);
    }

    private static Collection<String> doSuggestForSimpleType(String shortName, String longName, String prefix) {
        return Collections.singleton(!prefix.isEmpty() ? prefix + StringUtil.capitalize((String)longName) : shortName);
    }

    private static String stripSuffixes(String suggestion) {
        for (String suff : GARBAGE_SUFFIXES) {
            if (!StringUtil.endsWith((CharSequence)suggestion, (CharSequence)suff)) continue;
            return OCNameSuggester.stripSuffixes(suggestion.substring(0, suggestion.length() - suff.length()));
        }
        return suggestion;
    }

    private static List<String> doGetSuggestionsByName(String name, String prefix) {
        return OCNameSuggester.doGetSuggestionsByName(StringUtil.trimStart((String)name, (String)"get"), false, prefix, EMPTY_PREFIX);
    }

    private static List<String> doGetSuggestionsByName(String name, boolean uppercaseStyle, String prefix, String suffix) {
        List raw = NameUtil.getSuggestionsByName((String)name, (String)prefix, (String)suffix, (boolean)uppercaseStyle, (boolean)false, (boolean)false);
        ArrayList<String> answer = new ArrayList<String>();
        for (String suggestion : raw) {
            String s = OCNameSuggester.changeIfNotIdentifier(suggestion);
            if (!OCNamesValidator.isIdentifier(s) || OCNamesValidator.isKeyword(s)) continue;
            answer.add(s);
        }
        return answer;
    }

    @NonNls
    private static String changeIfNotIdentifier(String name) {
        if (!OCNamesValidator.isIdentifier(name = StringUtil.trimEnd((String)name, (String)":"))) {
            return StringUtil.fixVariableNameDerivedFromPropertyName((String)name);
        }
        return name;
    }

    public static String suggestUniqueName(OCSymbol symbol, @Nullable PsiElement scope, @NotNull Project project2) {
        return OCNameSuggester.suggestUniqueName(symbol.getKind(), symbol.getName(), scope, project2);
    }

    public static String suggestUniqueName(@Nullable OCSymbolKind symbolKind, String baseName, @Nullable PsiElement scope, @NotNull Project project2) {
        return OCNameSuggester.suggestUniqueName(symbolKind, baseName, scope, Collections.emptyList(), project2);
    }

    public static String suggestUniqueName(@Nullable OCSymbolKind symbolKind, String baseName, @Nullable PsiElement scope, Collection<String> forbiddenNames, @NotNull Project project2) {
        List<PsiElement> scopes = scope != null ? Collections.singletonList(scope) : Collections.emptyList();
        String nameCandidate = OCNamingConventionUtil.applyNamingConvention(baseName, symbolKind, project2);
        nameCandidate = OCNameSuggester.suggestUniqueName(symbolKind, nameCandidate, scopes, forbiddenNames);
        nameCandidate = OCNamingConventionUtil.applyNamingConvention(nameCandidate, symbolKind, project2);
        return nameCandidate;
    }

    public static String suggestUniqueName(@Nullable OCSymbolKind symbolKind, @Nullable OCSymbol symbol, @Nullable OCResolveContext resolveContext, String baseName, @Nullable PsiElement scope, Collection<String> forbiddenNames, @NotNull Project project2) {
        List<PsiElement> scopes = scope != null ? Collections.singletonList(scope) : Collections.emptyList();
        String nameCandidate = OCNamingConventionUtil.applyNamingConvention(baseName, symbolKind, symbol, resolveContext, project2);
        nameCandidate = OCNameSuggester.suggestUniqueName(symbolKind, nameCandidate, scopes, forbiddenNames);
        nameCandidate = OCNamingConventionUtil.applyNamingConvention(nameCandidate, symbolKind, symbol, resolveContext, project2);
        return nameCandidate;
    }

    private static String suggestUniqueName(@Nullable OCSymbolKind symbolKind, String baseName, List<PsiElement> scopes, Collection<String> forbiddenNames) {
        int count = 0;
        int MAX_ITERATIONS = 5000;
        do {
            String candidate = count > 0 ? baseName + count : baseName;
            boolean isUnique = true;
            if (forbiddenNames.contains(candidate)) {
                isUnique = false;
            }
            for (PsiElement scope : scopes) {
                if (scope == null || OCCodeInsightUtil.isUniqueInScope(symbolKind, candidate, scope, scope.getProject())) continue;
                isUnique = false;
                break;
            }
            if (!isUnique) continue;
            return candidate;
        } while (++count < 5000);
        LOG.warn("Cannot suggest unique name for " + StringUtil.wrapWithDoubleQuote((String)baseName));
        return baseName;
    }

    private static Collection<String> convertToUniqueNames(@Nullable OCSymbolKind symbolKind, Collection<String> candidates, @Nullable PsiElement scope, Collection<String> forbiddenNames) {
        LinkedHashSet<String> answer = new LinkedHashSet<String>();
        LinkedHashSet<String> augmented = new LinkedHashSet<String>();
        List<PsiElement> scopes = scope != null ? Collections.singletonList(scope) : Collections.emptyList();
        for (String candidate : candidates) {
            String unique = OCNameSuggester.suggestUniqueName(symbolKind, candidate, scopes, forbiddenNames);
            if (Objects.equals(unique, candidate)) {
                answer.add(unique);
                continue;
            }
            augmented.add(unique);
        }
        answer.addAll(augmented);
        return answer;
    }

    public static String removeVariablePrefixes(String name) {
        if (name.startsWith("an")) {
            name = StringUtil.decapitalize((String)name.substring(2));
        } else if (name.startsWith("a") || name.startsWith("_")) {
            name = StringUtil.decapitalize((String)name.substring(1));
        }
        return name;
    }

    public static String removeSelectorPrefixes(String selectorPart) {
        if (selectorPart.startsWith("and")) {
            selectorPart = StringUtil.decapitalize((String)selectorPart.substring(3));
        }
        return selectorPart;
    }

    public static String suggestForParameter(Collection<String> prevParamNames, boolean isFirstSelector, String selector, OCType type, @Nullable OCMethodSymbol method, @Nullable OCExpression expression, @NotNull OCResolveContext context2) {
        String paramName = isFirstSelector || selector.equals(":") ? OCNameSuggester.suggestForParameter(prevParamNames, type, expression, context2) : (selector.endsWith(":") ? StringUtil.decapitalize((String)OCNameSuggester.getLastSubword(selector.substring(0, selector.length() - 1))) : "param");
        ArrayList<PsiElement> contexts = new ArrayList<PsiElement>();
        if (method != null) {
            Project project2 = context2.getProject();
            method.processSameSymbols((Processor<OCSymbol>)((Processor)symbol -> {
                PsiElement definition = symbol.locateDefinition(project2);
                if (definition != null) {
                    contexts.add(definition);
                }
                return true;
            }), project2);
        }
        String uniqueName = OCNameSuggester.suggestUniqueName(OCSymbolKind.PARAMETER, paramName, contexts, prevParamNames);
        return OCNamingConventionUtil.applyNamingConvention(uniqueName, OCSymbolKind.PARAMETER, context2.getProject());
    }

    public static String suggestForParameter(Collection<String> forbiddenNames, OCType type, @Nullable OCExpression expression, @NotNull OCResolveContext context2) {
        Project project2 = context2.getProject();
        ArrayList<String> names = new ArrayList<String>(OCNameSuggester.doSuggestForType(type, EMPTY_PREFIX, context2));
        names.addAll(OCNameSuggester.doSuggestionForContext(expression));
        for (String name : names) {
            if (ArrayUtil.contains((String)name, (String[])SHORT_NAMES)) continue;
            return OCNameSuggester.suggestUniqueName(OCSymbolKind.PARAMETER, null, context2, name, null, forbiddenNames, project2);
        }
        return OCNameSuggester.suggestUniqueName(OCSymbolKind.PARAMETER, null, context2, names.isEmpty() ? "param" : (String)names.iterator().next(), null, forbiddenNames, project2);
    }

    @NotNull
    public static String getLastSubword(@NotNull String word) {
        String[] subwords = NameUtil.nameToWords((String)word);
        String result2 = EMPTY_PREFIX;
        for (int i2 = subwords.length - 1; i2 >= 0; --i2) {
            result2 = subwords[i2] + result2;
            if (!StringUtil.isJavaIdentifier((String)result2)) continue;
            return result2;
        }
        return word;
    }

    public static String getSelectorNameWithoutParameter(String firstSelector, @Nullable String paramName) {
        if (paramName == null) {
            return firstSelector;
        }
        if (firstSelector.endsWith(StringUtil.capitalize((String)(paramName = OCNameSuggester.removeVariablePrefixes(paramName))))) {
            firstSelector = firstSelector.substring(0, firstSelector.length() - paramName.length());
        }
        return firstSelector;
    }

    public static String getNonCollidingName(OCSymbol symbol, @NotNull Project project2) {
        return OCNameSuggester.getNonCollidingName(symbol, false, project2);
    }

    public static String getNonCollidingName(OCSymbol symbol, boolean allowCollision, @NotNull Project project2) {
        return OCNameSuggester.getNonCollidingName(symbol.getName(), symbol.getKind(), allowCollision, project2);
    }

    public static String getNonCollidingName(String name, OCSymbolKind symbolKind, boolean allowCollision, Project project2) {
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getSettings((Project)project2).getCustomSettings(OCCodeStyleSettings.class);
        String prefix = settings.IVARS_PREFIX;
        String suffix = settings.IVARS_SUFFIX;
        if (symbolKind == OCSymbolKind.INSTANCE_VARIABLE) {
            String newName = OCNameSuggester.getNameWithoutPrefixAndSuffix(name, prefix, suffix);
            if (newName.equals(name) && !allowCollision) {
                return StringUtil.fixVariableNameDerivedFromPropertyName((String)name);
            }
            return newName;
        }
        if (symbolKind == OCSymbolKind.PROPERTY) {
            return OCNameSuggester.getNameWithPrefixAndSuffix(name, prefix, suffix);
        }
        if (!allowCollision) {
            return StringUtil.fixVariableNameDerivedFromPropertyName((String)name);
        }
        return name;
    }

    private static String getNameWithPrefixAndSuffix(String name, String prefix, String suffix) {
        boolean isLetterPrefix;
        boolean bl = isLetterPrefix = !prefix.isEmpty() && Character.isLetter(prefix.charAt(prefix.length() - 1));
        if (isLetterPrefix) {
            return prefix + StringUtil.capitalize((String)name) + suffix;
        }
        return prefix + name + suffix;
    }

    private static String getNameWithoutPrefixAndSuffix(String name, String prefix, String suffix) {
        String result2 = name;
        if (result2.length() > prefix.length() && result2.startsWith(prefix)) {
            result2 = result2.substring(prefix.length());
        }
        if (result2.length() > suffix.length() && result2.endsWith(suffix)) {
            result2 = result2.substring(0, result2.length() - suffix.length());
        }
        return OCNamesValidator.isKeyword(result2) ? StringUtil.fixVariableNameDerivedFromPropertyName((String)result2) : result2;
    }

    @NotNull
    public static String getClang4ImplicitIvarName(String propertyName) {
        return "_" + propertyName;
    }

    @Nullable
    public static String getClang4PropertyName(String implicitIvarName) {
        return implicitIvarName.startsWith("_") ? implicitIvarName.substring(1) : null;
    }

    public static String getCppFieldNameWithoutPrefixAndSuffix(OCDeclaratorSymbol fieldSymbol, @NotNull Project project2) {
        OCResolveContext resolveContext = OCResolveContext.forSymbol(fieldSymbol, project2);
        NamingConventionRule rule2 = OCNamingConventionUtil.getNamingConventionRuleForSymbol(fieldSymbol.getKind(), fieldSymbol, resolveContext, project2);
        return OCNameSuggester.getNameWithoutPrefixAndSuffix(fieldSymbol.getName(), rule2.getCustomPrefix(), rule2.getCustomSuffix());
    }

    public static String getCppGetterName(OCDeclaratorSymbol field, @NotNull Project project2) {
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getSettings((Project)project2).getCustomSettings(OCCodeStyleSettings.class);
        String getterPrefix = settings.ADD_GETTER_PREFIX ? "get" : EMPTY_PREFIX;
        String name = OCNameSuggester.getCppFieldNameWithoutPrefixAndSuffix(field, project2);
        OCResolveContext resolveContext = OCResolveContext.forSymbol(field, project2);
        boolean isBoolField = OCIntType.isBool(field.getResolvedType(resolveContext), resolveContext);
        if (settings.ADD_GETTER_PREFIX && isBoolField) {
            getterPrefix = "is";
            if (OCElementUtil.startsWithWord(StringUtil.decapitalize((String)name), "is")) {
                getterPrefix = EMPTY_PREFIX;
            }
        }
        String baseGetterName = getterPrefix.isEmpty() ? name : getterPrefix + StringUtil.capitalize((String)name);
        return OCNamingConventionUtil.applyNamingConvention(baseGetterName, OCSymbolKind.FUNCTION_DECLARATION, (OCSymbol)field, resolveContext, project2);
    }

    public static String getUniqueCppGetterName(@NotNull OCDeclaratorSymbol field, @Nullable PsiElement scopeContext, @NotNull Project project2) {
        String baseCppGetterName = OCNameSuggester.getCppGetterName(field, project2);
        List<PsiElement> scopes = scopeContext != null ? Collections.singletonList(scopeContext) : Collections.emptyList();
        return OCNameSuggester.suggestUniqueName(OCSymbolKind.FUNCTION_DECLARATION, baseCppGetterName, scopes, Collections.emptyList());
    }

    public static String getCppSetterName(OCDeclaratorSymbol field, @NotNull Project project2) {
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getSettings((Project)project2).getCustomSettings(OCCodeStyleSettings.class);
        String setterPrefix = settings.ADD_SETTER_PREFIX ? "set" : EMPTY_PREFIX;
        String name = OCNameSuggester.getCppFieldNameWithoutPrefixAndSuffix(field, project2);
        String baseSetterName = setterPrefix.isEmpty() ? name : setterPrefix + StringUtil.capitalize((String)name);
        OCResolveContext resolveContext = OCResolveContext.forSymbol(field, project2);
        return OCNamingConventionUtil.applyNamingConvention(baseSetterName, OCSymbolKind.FUNCTION_DECLARATION, (OCSymbol)field, resolveContext, project2);
    }

    public static String getUniqueCppSetterName(@NotNull OCDeclaratorSymbol field, @Nullable PsiElement scopeContext, @NotNull Project project2) {
        String baseCppSetterName = OCNameSuggester.getCppSetterName(field, project2);
        List<PsiElement> scopes = scopeContext != null ? Collections.singletonList(scopeContext) : Collections.emptyList();
        return OCNameSuggester.suggestUniqueName(OCSymbolKind.FUNCTION_DECLARATION, baseCppSetterName, scopes, Collections.emptyList());
    }

    public static boolean isObjCGetter(String name) {
        return !name.endsWith(":");
    }

    public static boolean isObjCSetter(String name) {
        return name.indexOf(58) == name.length() - 1;
    }

    public static String getObjCSetterFromGetter(String getter) {
        return "set" + StringUtil.capitalize((String)getter) + ":";
    }

    @Nullable
    public static String getObjCGetterFromSetter(String setter) {
        if (OCElementUtil.startsWithWord(setter, "set") && setter.length() > 4 && OCNameSuggester.isObjCSetter(setter)) {
            return StringUtil.decapitalize((String)setter.substring(3, setter.length() - 1));
        }
        return null;
    }

    private static /* synthetic */ boolean lambda$suggestForProperty$2(OCDeclarator declarator, OCResolveContext context2, Set names, Collection whiteList, OCInstanceVariableSymbol ivar) {
        if (!OCResolveUtil.isDisabledSymbol(ivar, declarator.getContainingFile()) && ivar.getAssociatedProperty(context2.getProject()) == null && declarator.getType().isCompatible(ivar.getType(), context2)) {
            String name = OCNameSuggester.getNonCollidingName(ivar, true, context2.getProject());
            names.add(name);
            whiteList.add(name);
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$suggestForIvar$0(Project project2, OCDeclarator declarator, OCResolveContext context2, Set names, OCPropertySymbol propertySymbol) {
        OCInstanceVariableSymbol ivar = propertySymbol.getAssociatedIvar(project2);
        if (propertySymbol.getType().isCompatible(declarator.getType(), context2) && (ivar == null || ivar.getGeneratedFromProperty() != null)) {
            names.add(OCNameSuggester.getNonCollidingName(propertySymbol, true, project2));
        }
        return true;
    }
}

