/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.actions.newFile.OCNewStringsFileAction;
import com.jetbrains.cidr.lang.intentions.OCLocalizeStringIntentionAction;
import com.jetbrains.cidr.lang.psi.OCStringsFile;
import com.jetbrains.cidr.lang.quickfixes.OCQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.resolve.references.OCStringResourceReference;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class OCProvideStringLocalizationsIntentionAction
extends OCQuickFix {
    private final OCStringResourceReference myReference;

    public OCProvideStringLocalizationsIntentionAction(OCStringResourceReference reference) {
        this.myReference = reference;
    }

    @Override
    protected String getTextInternal() {
        return "Provide localizations for \"" + this.myReference.getCanonicalText() + "\"";
    }

    @NotNull
    public String getFamilyName() {
        return OCBundle.message("intentions.provide.localization", new Object[0]);
    }

    @Override
    public boolean isAvailable() {
        return OCSearchScope.isInProjectSources(this.myReference.getElement()) && this.myReference.getTableFileName() != null;
    }

    @Override
    protected void invoke(PsiFile file2, @NotNull Project project2) {
        if (this.checkFilesForWrite()) {
            this.invokeBool(file2);
        }
    }

    public boolean checkFilesForWrite() {
        final String key = this.myReference.getCanonicalText();
        CommonProcessors.CollectProcessor<OCStringsFile> collector = new CommonProcessors.CollectProcessor<OCStringsFile>(){

            protected boolean accept(OCStringsFile file2) {
                return file2.findStringPair(key) == null;
            }
        };
        this.myReference.processStringFiles((Processor<OCStringsFile>)collector);
        return FileModificationService.getInstance().preparePsiElementsForWrite(collector.getResults().toArray(PsiElement.EMPTY_ARRAY));
    }

    public boolean invokeBool(PsiFile file2) {
        String key = this.myReference.getCanonicalText();
        String contents = "\n\"" + OCLocalizeStringIntentionAction.getKeyString(key) + "\" = \"" + key + "\";";
        ArrayList files = new ArrayList();
        Ref wasFile = Ref.create((Object)false);
        this.myReference.processStringFiles((Processor<OCStringsFile>)((Processor)file1 -> {
            if (file1.findStringPair(key) == null) {
                files.add(file1);
            }
            wasFile.set((Object)true);
            return true;
        }));
        if (!((Boolean)wasFile.get()).booleanValue() && !ApplicationManager.getApplication().isUnitTestMode()) {
            String tableName = FileUtilRt.getNameWithoutExtension((String)this.myReference.getTableFileName());
            OCNewStringsFileAction action = new OCNewStringsFileAction(tableName, contents){

                @Override
                protected boolean isNameFieldEnabled() {
                    return false;
                }

                @Override
                protected void openCreatedFiles(PsiFile @NotNull [] createdElements) {
                }
            };
            return action.performAction(file2.getProject(), file2.getParent(), file2, tableName) != null;
        }
        WriteAction.run(() -> {
            for (OCStringsFile stringsFile : files) {
                OCChangeUtil.changeText(stringsFile.getProject(), stringsFile, stringsFile.getTextLength(), 0, contents, true);
            }
        });
        return true;
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }
}

