/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import org.jetbrains.annotations.NotNull;

public class OCChangeMethodStaticnessIntentionAction
extends OCSymbolQuickFix<OCMethodSymbol> {
    private boolean myMakeStatic;

    public OCChangeMethodStaticnessIntentionAction(@NotNull OCMethodSymbol methodSymbol, boolean makeStatic, @NotNull Project project2) {
        super(project2, methodSymbol);
        this.myMakeStatic = makeStatic;
    }

    @Override
    protected String getTextInternal() {
        return "Make '" + ((OCMethodSymbol)this.mySymbol).getPresentableName() + (this.myMakeStatic ? "' a class method" : "' an instance method");
    }

    @NotNull
    public String getFamilyName() {
        return OCBundle.message("change.method.staticness.action", new Object[0]);
    }

    @Override
    protected void invoke(@NotNull Project project2, Editor editor) {
        this.processMethod((OCMethodSymbol)this.mySymbol, project2);
        this.processMethod(((OCMethodSymbol)this.mySymbol).getAssociatedSymbol(project2), project2);
    }

    private void processMethod(OCMethodSymbol symbol, @NotNull Project project2) {
        if (symbol == null) {
            return;
        }
        PsiElement element = symbol.locateDefinition(project2);
        if (element instanceof OCMethod && FileModificationService.getInstance().prepareFileForWrite(element.getContainingFile())) {
            OCMethod method = (OCMethod)element;
            method.setStatic(this.myMakeStatic);
        }
    }
}

