/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureActionHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandler;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCChangeMethodSignatureIntentionAction
extends OCSymbolQuickFix<OCMethodSymbol> {
    private final String myText;
    private List<OCType> myNewParamTypes;
    private List<String> myNewSelectors;
    private List<OCExpression> myNewExpressions;

    public OCChangeMethodSignatureIntentionAction(@NotNull OCMethodSymbol methodSymbol, List<OCType> newParamTypes, List<String> newSelectors, List<OCExpression> newExpressions, @NotNull OCCompilationContext context2) {
        super(context2.getProject(), methodSymbol);
        this.myNewParamTypes = newParamTypes;
        this.myNewSelectors = newSelectors;
        this.myNewExpressions = newExpressions;
        this.myText = "Add parameters to " + ((OCMethodSymbol)this.mySymbol).getNameWithKindLowercase(context2);
    }

    @Override
    protected String getTextInternal() {
        return this.myText;
    }

    @NotNull
    public String getFamilyName() {
        return OCBundle.message("change.method.signature.add.parameters", new Object[0]);
    }

    @Override
    protected void invoke(@NotNull Project project2, Editor editor) {
        int i2;
        PsiElement method = ((OCMethodSymbol)this.mySymbol).locateDefinition(project2);
        if (!(method instanceof OCMethod)) {
            return;
        }
        OCChangeSignatureHandler handler = OCChangeSignatureActionHandler.getHandler((OCMethod)method, method, true);
        int oldSelectorsCnt = OCNameSuggester.isObjCGetter(((OCMethodSymbol)this.mySymbol).getName()) ? 0 : ((OCMethodSymbol)this.mySymbol).getSelectors().size();
        HashSet<String> prevParamNames = new HashSet<String>();
        for (i2 = 0; i2 < oldSelectorsCnt; ++i2) {
            OCDeclaratorSymbol parameter = ((OCMethodSymbol)this.mySymbol).getSelectors().get(i2).getParameter();
            if (parameter == null) continue;
            prevParamNames.add(parameter.getName());
        }
        for (i2 = oldSelectorsCnt; i2 < this.myNewSelectors.size(); ++i2) {
            String selector = this.myNewSelectors.get(i2);
            OCExpression expression = this.myNewExpressions.get(i2);
            String paramName = OCNameSuggester.suggestForParameter(prevParamNames, i2 == 0, selector, this.myNewParamTypes.get(i2), (OCMethodSymbol)this.mySymbol, expression, OCResolveContext.forPsi(method));
            prevParamNames.add(paramName);
            handler.addParameter(selector, paramName, this.myNewParamTypes.get(i2), -1, false);
        }
        handler.invokeSynchronously();
    }
}

