/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.psi.impl.OCIncludeDirectiveImpl;
import com.jetbrains.cidr.lang.resolve.references.OCImportModuleReference;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class OCImportModuleStatementImpl
extends OCIncludeDirectiveImpl {
    public OCImportModuleStatementImpl(@NotNull ASTNode node2) {
        super(node2);
    }

    @Override
    @NotNull
    public PsiElement getHeaderToken() {
        PsiElement importKeyword = this.findChildByType(OCTokenTypes.IMPORT_MODULE_KEYWORD);
        return importKeyword == null ? super.getHeaderToken() : importKeyword;
    }

    @NotNull
    private String getModuleName() {
        ArrayList<String> parts = new ArrayList<String>();
        for (ASTNode node2 = this.getNode().getFirstChildNode(); node2 != null; node2 = node2.getTreeNext()) {
            IElementType tt = node2.getElementType();
            if (tt != OCTokenTypes.IDENTIFIER) continue;
            parts.add(node2.getText());
        }
        return StringUtil.join(parts, (String)".");
    }

    @Override
    @NotNull
    public OCIncludeDirective.Delimiters getDelimiters() {
        return OCIncludeDirective.Delimiters.NONE;
    }

    @Override
    public boolean isAngleBrackets() {
        return true;
    }

    @Override
    public PsiReference @NotNull [] getReferences() {
        return new PsiReference[]{new OCImportModuleReference(this)};
    }

    @Override
    @NotNull
    public String getReferenceText() {
        return this.getModuleName();
    }

    @Override
    public boolean isValidDirective() {
        PsiReference[] references;
        for (PsiReference reference : references = this.getReferences()) {
            if (!(reference instanceof OCImportModuleReference) || ((OCImportModuleReference)reference).isValid()) continue;
            return false;
        }
        return references.length > 0;
    }
}

