/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.Language;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiElement;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.psi.OCFragmentVirtualFile;
import org.jetbrains.annotations.NotNull;

public class OCFragmentVirtualFileImpl
extends LightVirtualFile
implements OCFragmentVirtualFile,
VirtualFileWithId {
    private int myParentOffset;
    private CharSequence myParentFileContent = "";
    private VirtualFile myParent;

    public OCFragmentVirtualFileImpl(@NotNull String name) {
        super(name);
    }

    public OCFragmentVirtualFileImpl(@NotNull String name, @NotNull Language language, @NotNull CharSequence text) {
        super(name, language, text);
    }

    @Override
    public CharSequence getParentFileContent() {
        return this.myParentFileContent;
    }

    @Override
    public int getParentOffset() {
        return this.myParentOffset;
    }

    @Override
    public void initWithContext(@NotNull PsiElement context2) {
        this.myParent = context2.getContainingFile().getVirtualFile();
        this.myParentOffset = context2.getTextOffset();
        this.myParentFileContent = context2.getContainingFile().getViewProvider().getContents();
    }

    public VirtualFile getParent() {
        return this.myParent;
    }

    @NotNull
    public String getUrl() {
        return VirtualFileManager.constructUrl((String)"file", (String)this.getPath());
    }

    @NotNull
    public String getPath() {
        VirtualFile parent = this.getParent();
        if (parent == null || parent.isDirectory()) {
            return super.getPath();
        }
        VirtualFile dirOfParent = parent.getParent();
        if (dirOfParent == null) {
            OCLog.LOG.warn("Why file doesn't have any parent?");
            return super.getPath();
        }
        String fakeDirName = parent.getName() + "_dir";
        return dirOfParent.getPath() + "/" + fakeDirName + "/" + this.getName();
    }

    public int getId() {
        return 0;
    }
}

