/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCCastKind;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCastExpressionImpl
extends OCExpressionBase
implements OCCastExpression {
    public OCCastExpressionImpl(@NotNull ASTNode node2) {
        super(node2);
    }

    @Override
    @Nullable
    public OCExpression getOperand() {
        return (OCExpression)this.findChildByType(OCElementTypes.EXPRESSIONS);
    }

    @Override
    @Nullable
    public OCArgumentList getArgumentList() {
        return (OCArgumentList)this.findChildByType(OCElementTypes.ARGUMENT_LIST);
    }

    @Override
    @Nullable
    public OCCompoundInitializer getCompoundInitializer() {
        return (OCCompoundInitializer)this.findChildByType(OCElementTypes.COMPOUND_INITIALIZER);
    }

    @Override
    @NotNull
    public OCType getCastType() {
        OCTypeElement typeElement = this.getTypeElement();
        return typeElement != null ? typeElement.getType() : OCUnknownType.INSTANCE;
    }

    @Override
    @NotNull
    public OCCastKind getCastKind() {
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            IElementType elementType = OCElementUtil.getElementType(child);
            if (elementType == OCTokenTypes.STATIC_CAST_CPP_KEYWORD) {
                return OCCastKind.STATIC_CAST;
            }
            if (elementType == OCTokenTypes.CONST_CAST_CPP_KEYWORD) {
                return OCCastKind.CONST_CAST;
            }
            if (elementType == OCTokenTypes.DYNAMIC_CAST_CPP_KEYWORD) {
                return OCCastKind.DYNAMIC_CAST;
            }
            if (elementType != OCTokenTypes.REINTERPRET_CAST_CPP_KEYWORD) continue;
            return OCCastKind.REINTERPRET_CAST;
        }
        return OCCastKind.C_STYLE_CAST;
    }

    @Override
    public PsiElement getBridgeCastModifier() {
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            IElementType elementType = OCElementUtil.getElementType(child);
            if (!OCTokenTypes.BRIDGE_CAST_KEYWORDS.contains(elementType)) continue;
            return child;
        }
        return null;
    }

    @Override
    @Nullable
    public OCTypeElement getTypeElement() {
        return (OCTypeElement)this.findChildByType(OCElementTypes.TYPE_ELEMENT);
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitCastExpression(this);
    }

    @Override
    @NotNull
    public OCType getResolvedType(@NotNull OCResolveContext context2) {
        OCCompoundInitializer compoundInitializer = this.getCompoundInitializer();
        OCType unresolvedType = this.getCastType();
        OCType resolvedType = unresolvedType.resolve(context2);
        if (compoundInitializer != null && resolvedType instanceof OCStructType) {
            OCArgumentsList<OCExpression> arguments = OCArgumentsList.getArgumentList(Collections.singletonList(compoundInitializer));
            return OCTypeUtils.deduceClassTemplateArguments((OCStructType)resolvedType, unresolvedType, arguments, true, context2, this.getContainingFile().getVirtualFile(), this.getComplexOffset());
        }
        return resolvedType;
    }

    @Override
    @NotNull
    protected OCType getType(@NotNull OCResolveContext context2) {
        return this.getCastType();
    }
}

